/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.TransactionWriteOperationsDetails;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class TransactionConcurrencySemaphoreInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(TransactionConcurrencySemaphoreInterceptor.class);
    private static final String HELD_SEMAPHORES = TransactionConcurrencySemaphoreInterceptor.class.getName() + "_HELD_SEMAPHORES";
    private final Cache<String, Semaphore> mySemaphoreCache;
    private final MemoryCacheService myMemoryCacheService;
    private boolean myLogWaits;
    private final Semaphore myLockingSemaphore = new Semaphore(1);

    public TransactionConcurrencySemaphoreInterceptor(MemoryCacheService theMemoryCacheService) {
        this.myMemoryCacheService = theMemoryCacheService;
        this.mySemaphoreCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    }

    public boolean isLogWaits() {
        return this.myLogWaits;
    }

    public void setLogWaits(boolean theLogWaits) {
        this.myLogWaits = theLogWaits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hook(value=Pointcut.STORAGE_TRANSACTION_WRITE_OPERATIONS_PRE)
    public void pre(TransactionDetails theTransactionDetails, TransactionWriteOperationsDetails theWriteOperationsDetails) {
        ArrayList<Semaphore> heldSemaphores = new ArrayList<Semaphore>();
        HashMap<String, Semaphore> pendingAndHeldSemaphores = new HashMap<String, Semaphore>();
        AtomicBoolean locked = new AtomicBoolean(false);
        try {
            this.acquireSemaphoresForUrlList(locked, heldSemaphores, pendingAndHeldSemaphores, theWriteOperationsDetails.getUpdateRequestUrls(), false);
            this.acquireSemaphoresForUrlList(locked, heldSemaphores, pendingAndHeldSemaphores, theWriteOperationsDetails.getConditionalCreateRequestUrls(), true);
            pendingAndHeldSemaphores.keySet().removeIf(k -> pendingAndHeldSemaphores.get(k) == null);
            if (!pendingAndHeldSemaphores.isEmpty()) {
                if (this.isLogWaits()) {
                    ourLog.info("Waiting to acquire write semaphore for URLs:{}{}", (Object)(pendingAndHeldSemaphores.size() > 1 ? "\n * " : ""), (Object)pendingAndHeldSemaphores.keySet().stream().sorted().collect(Collectors.joining("\n * ")));
                }
                for (Map.Entry nextEntry : pendingAndHeldSemaphores.entrySet()) {
                    Semaphore nextSemaphore = (Semaphore)nextEntry.getValue();
                    try {
                        if (nextSemaphore.tryAcquire(10L, TimeUnit.SECONDS)) {
                            ourLog.trace("Acquired semaphore {} on request URL: {}", (Object)nextSemaphore, nextEntry.getKey());
                            heldSemaphores.add(nextSemaphore);
                            continue;
                        }
                        ourLog.warn("Timed out waiting for semaphore {} on request URL: {}", (Object)nextSemaphore, nextEntry.getKey());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
            }
            theTransactionDetails.putUserData(HELD_SEMAPHORES, heldSemaphores);
        }
        finally {
            if (locked.get()) {
                this.myLockingSemaphore.release();
            }
        }
    }

    private void acquireSemaphoresForUrlList(AtomicBoolean theLocked, List<Semaphore> theHeldSemaphores, Map<String, Semaphore> thePendingAndHeldSemaphores, List<String> urls, boolean isConditionalCreates) {
        for (String nextUrl : urls) {
            if (isConditionalCreates && this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.MATCH_URL, (Object)nextUrl) != null) continue;
            Semaphore semaphore = (Semaphore)this.mySemaphoreCache.get((Object)nextUrl, t -> new Semaphore(1));
            if (thePendingAndHeldSemaphores.containsKey(nextUrl)) continue;
            if (!theLocked.get()) {
                this.myLockingSemaphore.acquireUninterruptibly();
                theLocked.set(true);
            }
            assert (semaphore != null);
            if (semaphore.tryAcquire()) {
                ourLog.trace("Acquired semaphore {} on request URL: {}", (Object)semaphore, (Object)nextUrl);
                theHeldSemaphores.add(semaphore);
                thePendingAndHeldSemaphores.put(nextUrl, null);
                continue;
            }
            thePendingAndHeldSemaphores.put(nextUrl, semaphore);
        }
    }

    @Hook(value=Pointcut.STORAGE_TRANSACTION_WRITE_OPERATIONS_POST)
    public void post(TransactionDetails theTransactionDetails) {
        List heldSemaphores = (List)theTransactionDetails.getUserData(HELD_SEMAPHORES);
        for (Semaphore next : heldSemaphores) {
            ourLog.trace("Releasing semaphore {}", (Object)next);
            next.release();
        }
    }

    public void clearSemaphores() {
        this.mySemaphoreCache.invalidateAll();
    }

    public long countSemaphores() {
        return this.mySemaphoreCache.estimatedSize();
    }
}

