/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Schema(description="Represents an NPM package installation response")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PackageInstallOutcomeJson {
    @JsonProperty(value="messages")
    private List<String> myMessage;
    @JsonProperty(value="resourcesInstalled")
    private Map<String, Integer> myResourcesInstalled;

    public List<String> getMessage() {
        if (this.myMessage == null) {
            this.myMessage = new ArrayList<String>();
        }
        return this.myMessage;
    }

    public Map<String, Integer> getResourcesInstalled() {
        if (this.myResourcesInstalled == null) {
            this.myResourcesInstalled = new HashMap<String, Integer>();
        }
        return this.myResourcesInstalled;
    }

    public void incrementResourcesInstalled(String theResourceType) {
        Integer existing = this.getResourcesInstalled().get(theResourceType);
        if (existing == null) {
            this.getResourcesInstalled().put(theResourceType, 1);
        } else {
            this.getResourcesInstalled().put(theResourceType, existing + 1);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("message", this.myMessage).append("resourcesInstalled", this.myResourcesInstalled).toString();
    }
}

