/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.dao.data.INpmPackageVersionDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import ca.uhn.fhir.jpa.packages.IHapiPackageCacheManager;
import ca.uhn.fhir.jpa.packages.IPackageInstallerSvc;
import ca.uhn.fhir.jpa.packages.ImplementationGuideInstallationException;
import ca.uhn.fhir.jpa.packages.JpaPackageCache;
import ca.uhn.fhir.jpa.packages.PackageInstallOutcomeJson;
import ca.uhn.fhir.jpa.packages.PackageInstallationSpec;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.registry.ISearchParamRegistryController;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.SearchParameterUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class PackageInstallerSvcImpl
implements IPackageInstallerSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(PackageInstallerSvcImpl.class);
    public static List<String> DEFAULT_INSTALL_TYPES = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"NamingSystem", "CodeSystem", "ValueSet", "StructureDefinition", "ConceptMap", "SearchParameter", "Subscription"}));
    boolean enabled = true;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IValidationSupport validationSupport;
    @Autowired
    private IHapiPackageCacheManager myPackageCacheManager;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private INpmPackageVersionDao myPackageVersionDao;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private ISearchParamRegistryController mySearchParamRegistryController;
    @Autowired
    private PartitionSettings myPartitionSettings;

    @PostConstruct
    public void initialize() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R5: 
            case R4: 
            case DSTU3: {
                break;
            }
            default: {
                ourLog.info("IG installation not supported for version: {}", (Object)this.myFhirContext.getVersion().getVersion());
                this.enabled = false;
            }
        }
    }

    @Override
    public PackageInstallOutcomeJson install(PackageInstallationSpec theInstallationSpec) throws ImplementationGuideInstallationException {
        PackageInstallOutcomeJson retVal = new PackageInstallOutcomeJson();
        if (this.enabled) {
            try {
                NpmPackage npmPackage;
                boolean exists = (Boolean)new TransactionTemplate(this.myTxManager).execute(tx -> {
                    Optional<NpmPackageVersionEntity> existing = this.myPackageVersionDao.findByPackageIdAndVersion(theInstallationSpec.getName(), theInstallationSpec.getVersion());
                    return existing.isPresent();
                });
                if (exists) {
                    ourLog.info("Package {}#{} is already installed", (Object)theInstallationSpec.getName(), (Object)theInstallationSpec.getVersion());
                }
                if ((npmPackage = this.myPackageCacheManager.installPackage(theInstallationSpec)) == null) {
                    throw new IOException(Msg.code((int)1284) + "Package not found");
                }
                retVal.getMessage().addAll(JpaPackageCache.getProcessingMessages(npmPackage));
                if (theInstallationSpec.isFetchDependencies()) {
                    this.fetchAndInstallDependencies(npmPackage, theInstallationSpec, retVal);
                }
                if (theInstallationSpec.getInstallMode() == PackageInstallationSpec.InstallModeEnum.STORE_AND_INSTALL) {
                    this.install(npmPackage, theInstallationSpec, retVal);
                    this.mySearchParamRegistryController.refreshCacheIfNecessary();
                }
            }
            catch (IOException e) {
                throw new ImplementationGuideInstallationException(Msg.code((int)1285) + "Could not load NPM package " + theInstallationSpec.getName() + "#" + theInstallationSpec.getVersion(), e);
            }
        }
        return retVal;
    }

    private void install(NpmPackage npmPackage, PackageInstallationSpec theInstallationSpec, PackageInstallOutcomeJson theOutcome) throws ImplementationGuideInstallationException {
        int i;
        String name = npmPackage.getNpm().get("name").getAsString();
        String version = npmPackage.getNpm().get("version").getAsString();
        String fhirVersion = npmPackage.fhirVersion();
        String currentFhirVersion = this.myFhirContext.getVersion().getVersion().getFhirVersionString();
        this.assertFhirVersionsAreCompatible(fhirVersion, currentFhirVersion);
        List<String> installTypes = !theInstallationSpec.getInstallResourceTypes().isEmpty() ? theInstallationSpec.getInstallResourceTypes() : DEFAULT_INSTALL_TYPES;
        ourLog.info("Installing package: {}#{}", (Object)name, (Object)version);
        int[] count = new int[installTypes.size()];
        for (i = 0; i < installTypes.size(); ++i) {
            List<IBaseResource> resources = this.parseResourcesOfType(installTypes.get(i), npmPackage);
            count[i] = resources.size();
            for (IBaseResource next : resources) {
                try {
                    next = this.isStructureDefinitionWithoutSnapshot(next) ? this.generateSnapshot(next) : next;
                    this.create(next, theOutcome);
                }
                catch (Exception e) {
                    ourLog.warn("Failed to upload resource of type {} with ID {} - Error: {}", new Object[]{this.myFhirContext.getResourceType(next), next.getIdElement().getValue(), e.toString()});
                    throw new ImplementationGuideInstallationException(Msg.code((int)1286) + String.format("Error installing IG %s#%s: %s", name, version, e), e);
                }
            }
        }
        ourLog.info(String.format("Finished installation of package %s#%s:", name, version));
        for (i = 0; i < count.length; ++i) {
            ourLog.info(String.format("-- Created or updated %s resources of type %s", count[i], installTypes.get(i)));
        }
    }

    private void fetchAndInstallDependencies(NpmPackage npmPackage, PackageInstallationSpec theInstallationSpec, PackageInstallOutcomeJson theOutcome) throws ImplementationGuideInstallationException {
        if (npmPackage.getNpm().has("dependencies")) {
            JsonElement dependenciesElement = npmPackage.getNpm().get("dependencies");
            Map dependencies = (Map)new Gson().fromJson(dependenciesElement, HashMap.class);
            for (Map.Entry d : dependencies.entrySet()) {
                String id = (String)d.getKey();
                String ver = (String)d.getValue();
                try {
                    theOutcome.getMessage().add("Package " + npmPackage.id() + "#" + npmPackage.version() + " depends on package " + id + "#" + ver);
                    boolean skip = false;
                    for (String next : theInstallationSpec.getDependencyExcludes()) {
                        if (!id.matches(next)) continue;
                        theOutcome.getMessage().add("Not installing dependency " + id + " because it matches exclude criteria: " + next);
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    NpmPackage dependency = this.myPackageCacheManager.loadPackage(id, ver);
                    this.fetchAndInstallDependencies(dependency, theInstallationSpec, theOutcome);
                    if (theInstallationSpec.getInstallMode() != PackageInstallationSpec.InstallModeEnum.STORE_AND_INSTALL) continue;
                    this.install(dependency, theInstallationSpec, theOutcome);
                }
                catch (IOException e) {
                    throw new ImplementationGuideInstallationException(Msg.code((int)1287) + String.format("Cannot resolve dependency %s#%s", id, ver), e);
                }
            }
        }
    }

    private void assertFhirVersionsAreCompatible(String fhirVersion, String currentFhirVersion) throws ImplementationGuideInstallationException {
        FhirVersionEnum fhirVersionEnum = FhirVersionEnum.forVersionString((String)fhirVersion);
        FhirVersionEnum currentFhirVersionEnum = FhirVersionEnum.forVersionString((String)currentFhirVersion);
        Validate.notNull((Object)fhirVersionEnum, (String)"Invalid FHIR version string: %s", (Object[])new Object[]{fhirVersion});
        Validate.notNull((Object)currentFhirVersionEnum, (String)"Invalid FHIR version string: %s", (Object[])new Object[]{currentFhirVersion});
        boolean compatible = fhirVersionEnum.equals((Object)currentFhirVersionEnum);
        if (!compatible) {
            throw new ImplementationGuideInstallationException(Msg.code((int)1288) + String.format("Cannot install implementation guide: FHIR versions mismatch (expected <=%s, package uses %s)", currentFhirVersion, fhirVersion));
        }
    }

    private List<IBaseResource> parseResourcesOfType(String type, NpmPackage pkg) {
        if (!pkg.getFolders().containsKey("package")) {
            return Collections.emptyList();
        }
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        List filesForType = (List)((NpmPackage.NpmPackageFolder)pkg.getFolders().get("package")).getTypes().get(type);
        if (filesForType != null) {
            for (String file : filesForType) {
                try {
                    byte[] content = ((NpmPackage.NpmPackageFolder)pkg.getFolders().get("package")).fetchFile(file);
                    resources.add(this.myFhirContext.newJsonParser().parseResource(new String(content)));
                }
                catch (IOException e) {
                    throw new InternalErrorException(Msg.code((int)1289) + "Cannot install resource of type " + type + ": Could not fetch file " + file, (Throwable)e);
                }
            }
        }
        return resources;
    }

    private void create(IBaseResource theResource, PackageInstallOutcomeJson theOutcome) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResource.getClass());
        SearchParameterMap map = this.createSearchParameterMapFor(theResource);
        IBundleProvider searchResult = this.searchResource(dao, map);
        if (this.validForUpload(theResource)) {
            if (searchResult.isEmpty()) {
                ourLog.info("Creating new resource matching {}", (Object)map.toNormalizedQueryString(this.myFhirContext));
                theOutcome.incrementResourcesInstalled(this.myFhirContext.getResourceType(theResource));
                IIdType id = theResource.getIdElement();
                if (id.isEmpty()) {
                    this.createResource(dao, theResource);
                    ourLog.info("Created resource with new id");
                } else {
                    if (id.isIdPartValidLong()) {
                        String newIdPart = "npm-" + id.getIdPart();
                        id.setParts(id.getBaseUrl(), id.getResourceType(), newIdPart, id.getVersionIdPart());
                    }
                    this.updateResource(dao, theResource);
                    ourLog.info("Created resource with existing id");
                }
            } else {
                ourLog.info("Updating existing resource matching {}", (Object)map.toNormalizedQueryString(this.myFhirContext));
                theResource.setId(((IBaseResource)searchResult.getResources(0, 1).get(0)).getIdElement().toUnqualifiedVersionless());
                DaoMethodOutcome outcome = this.updateResource(dao, theResource);
                if (!outcome.isNop()) {
                    theOutcome.incrementResourcesInstalled(this.myFhirContext.getResourceType(theResource));
                }
            }
        } else {
            ourLog.warn("Failed to upload resource of type {} with ID {} - Error: Resource failed validation", (Object)theResource.fhirType(), (Object)theResource.getIdElement().getValue());
        }
    }

    private IBundleProvider searchResource(IFhirResourceDao theDao, SearchParameterMap theMap) {
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            SystemRequestDetails requestDetails = this.newSystemRequestDetails();
            return theDao.search(theMap, (RequestDetails)requestDetails);
        }
        return theDao.search(theMap);
    }

    @Nonnull
    private SystemRequestDetails newSystemRequestDetails() {
        return new SystemRequestDetails().setRequestPartitionId(RequestPartitionId.defaultPartition());
    }

    private void createResource(IFhirResourceDao theDao, IBaseResource theResource) {
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            SystemRequestDetails requestDetails = this.newSystemRequestDetails();
            theDao.create(theResource, (RequestDetails)requestDetails);
        } else {
            theDao.create(theResource);
        }
    }

    private DaoMethodOutcome updateResource(IFhirResourceDao theDao, IBaseResource theResource) {
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            SystemRequestDetails requestDetails = this.newSystemRequestDetails();
            return theDao.update(theResource, (RequestDetails)requestDetails);
        }
        return theDao.update(theResource);
    }

    boolean validForUpload(IBaseResource theResource) {
        String resourceType = this.myFhirContext.getResourceType(theResource);
        if ("SearchParameter".equals(resourceType)) {
            String code = SearchParameterUtil.getCode((FhirContext)this.myFhirContext, (IBaseResource)theResource);
            if (StringUtils.defaultString((String)code).startsWith("_")) {
                ourLog.warn("Failed to validate resource of type {} with url {} - Error: Resource code starts with \"_\"", (Object)theResource.fhirType(), (Object)SearchParameterUtil.getURL((FhirContext)this.myFhirContext, (IBaseResource)theResource));
                return false;
            }
            String expression = SearchParameterUtil.getExpression((FhirContext)this.myFhirContext, (IBaseResource)theResource);
            if (StringUtils.isBlank((CharSequence)expression)) {
                ourLog.warn("Failed to validate resource of type {} with url {} - Error: Resource expression is blank", (Object)theResource.fhirType(), (Object)SearchParameterUtil.getURL((FhirContext)this.myFhirContext, (IBaseResource)theResource));
                return false;
            }
            if (SearchParameterUtil.getBaseAsStrings((FhirContext)this.myFhirContext, (IBaseResource)theResource).isEmpty()) {
                ourLog.warn("Failed to validate resource of type {} with url {} - Error: Resource base is empty", (Object)theResource.fhirType(), (Object)SearchParameterUtil.getURL((FhirContext)this.myFhirContext, (IBaseResource)theResource));
                return false;
            }
        }
        if (!this.isValidResourceStatusForPackageUpload(theResource)) {
            ourLog.warn("Failed to validate resource of type {} with ID {} - Error: Resource status not accepted value.", (Object)theResource.fhirType(), (Object)theResource.getIdElement().getValue());
            return false;
        }
        return true;
    }

    private boolean isValidResourceStatusForPackageUpload(IBaseResource theResource) {
        List statusTypes = this.myFhirContext.newFhirPath().evaluate((IBase)theResource, "status", IPrimitiveType.class);
        if (statusTypes.isEmpty()) {
            return true;
        }
        if (((IPrimitiveType)statusTypes.get(0)).getValue() == null) {
            return false;
        }
        switch (theResource.fhirType()) {
            case "Subscription": {
                return ((IPrimitiveType)statusTypes.get(0)).getValueAsString().equals("requested");
            }
            case "DocumentReference": 
            case "Communication": {
                return !((IPrimitiveType)statusTypes.get(0)).getValueAsString().equals("?");
            }
        }
        return ((IPrimitiveType)statusTypes.get(0)).getValueAsString().equals("active");
    }

    private boolean isStructureDefinitionWithoutSnapshot(IBaseResource r) {
        Optional kind;
        boolean retVal = false;
        FhirTerser terser = this.myFhirContext.newTerser();
        if (r.getClass().getSimpleName().equals("StructureDefinition") && (kind = terser.getSinglePrimitiveValue((IBase)r, "kind")).isPresent() && !((String)kind.get()).equals("logical")) {
            retVal = terser.getSingleValueOrNull((IBase)r, "snapshot") == null;
        }
        return retVal;
    }

    private IBaseResource generateSnapshot(IBaseResource sd) {
        try {
            return this.validationSupport.generateSnapshot(new ValidationSupportContext(this.validationSupport), sd, null, null, null);
        }
        catch (Exception e) {
            throw new ImplementationGuideInstallationException(Msg.code((int)1290) + String.format("Failure when generating snapshot of StructureDefinition: %s", sd.getIdElement()), e);
        }
    }

    private SearchParameterMap createSearchParameterMapFor(IBaseResource resource) {
        if (resource.getClass().getSimpleName().equals("NamingSystem")) {
            String uniqueId = this.extractUniqeIdFromNamingSystem(resource);
            return SearchParameterMap.newSynchronous().add("value", (IQueryParameterType)new StringParam(uniqueId).setExact(true));
        }
        if (resource.getClass().getSimpleName().equals("Subscription")) {
            String id = this.extractIdFromSubscription(resource);
            return SearchParameterMap.newSynchronous().add("_id", (IQueryParameterType)new TokenParam(id));
        }
        if (this.resourceHasUrlElement(resource)) {
            String url = this.extractUniqueUrlFromMetadataResource(resource);
            return SearchParameterMap.newSynchronous().add("url", (IQueryParameterType)new UriParam(url));
        }
        TokenParam identifierToken = this.extractIdentifierFromOtherResourceTypes(resource);
        return SearchParameterMap.newSynchronous().add("identifier", (IQueryParameterType)identifierToken);
    }

    private String extractUniqeIdFromNamingSystem(IBaseResource resource) {
        FhirTerser terser = this.myFhirContext.newTerser();
        IBase uniqueIdComponent = (IBase)terser.getSingleValueOrNull((IBase)resource, "uniqueId");
        if (uniqueIdComponent == null) {
            throw new ImplementationGuideInstallationException(Msg.code((int)1291) + "NamingSystem does not have uniqueId component.");
        }
        IPrimitiveType asPrimitiveType = (IPrimitiveType)terser.getSingleValueOrNull(uniqueIdComponent, "value");
        return (String)asPrimitiveType.getValue();
    }

    private String extractIdFromSubscription(IBaseResource resource) {
        FhirTerser terser = this.myFhirContext.newTerser();
        IPrimitiveType asPrimitiveType = (IPrimitiveType)terser.getSingleValueOrNull((IBase)resource, "id");
        return (String)asPrimitiveType.getValue();
    }

    private String extractUniqueUrlFromMetadataResource(IBaseResource resource) {
        FhirTerser terser = this.myFhirContext.newTerser();
        IPrimitiveType asPrimitiveType = (IPrimitiveType)terser.getSingleValueOrNull((IBase)resource, "url");
        return (String)asPrimitiveType.getValue();
    }

    private TokenParam extractIdentifierFromOtherResourceTypes(IBaseResource resource) {
        FhirTerser terser = this.myFhirContext.newTerser();
        Identifier identifier = (Identifier)terser.getSingleValueOrNull((IBase)resource, "identifier");
        if (identifier != null) {
            return new TokenParam(identifier.getSystem(), identifier.getValue());
        }
        throw new UnsupportedOperationException(Msg.code((int)1292) + "Resources in a package must have a url or identifier to be loaded by the package installer.");
    }

    private boolean resourceHasUrlElement(IBaseResource resource) {
        BaseRuntimeElementDefinition def = this.myFhirContext.getElementDefinition(resource.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            throw new IllegalArgumentException(Msg.code((int)1293) + "Resource is not a composite type: " + resource.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition currentDef = (BaseRuntimeElementCompositeDefinition)def;
        BaseRuntimeChildDefinition nextDef = currentDef.getChildByName("url");
        return nextDef != null;
    }

    @VisibleForTesting
    void setFhirContextForUnitTest(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }
}

