/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.provider.JpaResourceProviderDstu2;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.resource.Parameters;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.ParametersUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class BaseJpaResourceProviderValueSetDstu2
extends JpaResourceProviderDstu2<ValueSet> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$expand", idempotent=true)
    public ValueSet expand(HttpServletRequest theServletRequest, @IdParam(optional=true) IdDt theId, @OperationParam(name="valueSet", min=0, max=1) ValueSet theValueSet, @OperationParam(name="identifier", min=0, max=1) UriDt theIdentifier, @OperationParam(name="filter", min=0, max=1) StringDt theFilter, RequestDetails theRequestDetails) {
        boolean haveValueSet;
        boolean haveId = theId != null && theId.hasIdPart();
        boolean haveIdentifier = theIdentifier != null && StringUtils.isNotBlank((CharSequence)((CharSequence)theIdentifier.getValue()));
        boolean bl = haveValueSet = theValueSet != null && !theValueSet.isEmpty();
        if (!(haveId || haveIdentifier || haveValueSet)) {
            throw new InvalidRequestException(Msg.code((int)1130) + "$expand operation at the type level (no ID specified) requires an identifier or a valueSet as a part of the request");
        }
        if (BaseJpaResourceProviderValueSetDstu2.moreThanOneTrue(haveId, haveIdentifier, haveValueSet)) {
            throw new InvalidRequestException(Msg.code((int)1131) + "$expand must EITHER be invoked at the type level, or have an identifier specified, or have a ValueSet specified. Can not combine these options.");
        }
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoValueSet dao = (IFhirResourceDaoValueSet)this.getDao();
            if (haveId) {
                ValueSet valueSet = (ValueSet)dao.expand((IIdType)theId, this.toFilterString(theFilter), theRequestDetails);
                return valueSet;
            }
            if (haveIdentifier) {
                ValueSet valueSet = (ValueSet)dao.expandByIdentifier((String)theIdentifier.getValue(), this.toFilterString(theFilter));
                return valueSet;
            }
            ValueSet valueSet = (ValueSet)dao.expand((IBaseResource)theValueSet, this.toFilterString(theFilter));
            return valueSet;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    private ValueSetExpansionOptions toFilterString(StringDt theFilter) {
        if (theFilter != null) {
            return ValueSetExpansionOptions.forOffsetAndCount((int)0, (int)1000).setFilter((String)theFilter.getValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$lookup", idempotent=true, returnParameters={@OperationParam(name="name", type=StringDt.class, min=1), @OperationParam(name="version", type=StringDt.class, min=0), @OperationParam(name="display", type=StringDt.class, min=1), @OperationParam(name="abstract", type=BooleanDt.class, min=1)})
    public Parameters lookup(HttpServletRequest theServletRequest, @OperationParam(name="code", min=0, max=1) CodeDt theCode, @OperationParam(name="system", min=0, max=1) UriDt theSystem, @OperationParam(name="coding", min=0, max=1) CodingDt theCoding, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            IValidationSupport.LookupCodeResult result = dao.lookupCode((IPrimitiveType)theCode, (IPrimitiveType)theSystem, (Object)theCoding, null, theRequestDetails);
            if (!result.isFound()) {
                throw new ResourceNotFoundException(Msg.code((int)1132) + "Unable to find code[" + result.getSearchedForCode() + "] in system[" + result.getSearchedForSystem() + "]");
            }
            Parameters retVal = new Parameters();
            retVal.addParameter().setName("name").setValue((IDatatype)new StringDt(result.getCodeSystemDisplayName()));
            if (StringUtils.isNotBlank((CharSequence)result.getCodeSystemVersion())) {
                retVal.addParameter().setName("version").setValue((IDatatype)new StringDt(result.getCodeSystemVersion()));
            }
            retVal.addParameter().setName("display").setValue((IDatatype)new StringDt(result.getCodeDisplay()));
            retVal.addParameter().setName("abstract").setValue((IDatatype)new BooleanDt(result.isCodeIsAbstract()));
            Parameters parameters = retVal;
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$validate-code", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanDt.class, min=1), @OperationParam(name="message", type=StringDt.class), @OperationParam(name="display", type=StringDt.class)})
    public Parameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IdDt theId, @OperationParam(name="identifier", min=0, max=1) UriDt theValueSetIdentifier, @OperationParam(name="code", min=0, max=1) CodeDt theCode, @OperationParam(name="system", min=0, max=1) UriDt theSystem, @OperationParam(name="display", min=0, max=1) StringDt theDisplay, @OperationParam(name="coding", min=0, max=1) CodingDt theCoding, @OperationParam(name="codeableConcept", min=0, max=1) CodeableConceptDt theCodeableConcept, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoValueSet dao = (IFhirResourceDaoValueSet)this.getDao();
            IValidationSupport.CodeValidationResult result = dao.validateCode((IPrimitiveType)theValueSetIdentifier, (IIdType)theId, (IPrimitiveType)theCode, (IPrimitiveType)theSystem, (IPrimitiveType)theDisplay, (Object)theCoding, (Object)theCodeableConcept, theRequestDetails);
            Parameters parameters = (Parameters)BaseJpaResourceProviderValueSetDstu2.toValidateCodeResult(this.getContext(), result);
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    public static IBaseParameters toValidateCodeResult(FhirContext theContext, IValidationSupport.CodeValidationResult theResult) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)theContext);
        ParametersUtil.addParameterToParametersBoolean((FhirContext)theContext, (IBaseParameters)retVal, (String)"result", (boolean)theResult.isOk());
        if (StringUtils.isNotBlank((CharSequence)theResult.getMessage())) {
            ParametersUtil.addParameterToParametersString((FhirContext)theContext, (IBaseParameters)retVal, (String)"message", (String)theResult.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)theResult.getDisplay())) {
            ParametersUtil.addParameterToParametersString((FhirContext)theContext, (IBaseParameters)retVal, (String)"display", (String)theResult.getDisplay());
        }
        return retVal;
    }

    private static boolean moreThanOneTrue(boolean ... theBooleans) {
        boolean haveOne = false;
        for (boolean next : theBooleans) {
            if (!next) continue;
            if (haveOne) {
                return true;
            }
            haveOne = true;
        }
        return false;
    }
}

