/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.provider.BaseStorageSystemProvider;
import ca.uhn.fhir.jpa.provider.IJpaSystemProvider;
import ca.uhn.fhir.jpa.search.reindex.IResourceReindexingSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.term.api.ReindexTerminologyResult;
import ca.uhn.fhir.rest.annotation.At;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.Since;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.StopWatch;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseJpaSystemProvider<T, MT>
extends BaseStorageSystemProvider<T, MT>
implements IJpaSystemProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseJpaSystemProvider.class);
    public static final String RESP_PARAM_SUCCESS = "success";
    @Deprecated
    public static final String MARK_ALL_RESOURCES_FOR_REINDEXING = "$mark-all-resources-for-reindexing";
    @Deprecated
    public static final String PERFORM_REINDEXING_PASS = "$perform-reindexing-pass";
    @Autowired
    private IResourceReindexingSvc myResourceReindexingSvc;
    @Autowired
    private ITermReadSvc myTermReadSvc;
    public static final String NL = System.getProperty("line.separator");

    protected IResourceReindexingSvc getResourceReindexingSvc() {
        return this.myResourceReindexingSvc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @History
    public IBundleProvider historyServer(HttpServletRequest theRequest, @Offset Integer theOffset, @Since Date theDate, @At DateRangeParam theAt, RequestDetails theRequestDetails) {
        this.startRequest(theRequest);
        try {
            DateRangeParam range = super.processSinceOrAt(theDate, theAt);
            IBundleProvider iBundleProvider = this.myDao.history(range.getLowerBoundAsInstant(), range.getUpperBoundAsInstant(), theOffset, theRequestDetails);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theRequest);
        }
    }

    @Operation(name="$reindex-terminology", idempotent=false)
    public IBaseParameters reindexTerminology(RequestDetails theRequestDetails) {
        ReindexTerminologyResult result;
        StopWatch sw = new StopWatch();
        try {
            result = this.myTermReadSvc.reindexTerminology();
        }
        catch (Exception theE) {
            throw new InternalErrorException(Msg.code((int)2072) + "Re-creating terminology freetext indexes failed with exception: " + theE.getMessage() + NL + "With trace:" + NL + ExceptionUtils.getStackTrace((Throwable)theE));
        }
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        if (!result.equals((Object)ReindexTerminologyResult.SUCCESS)) {
            ParametersUtil.addParameterToParametersBoolean((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)RESP_PARAM_SUCCESS, (boolean)false);
            String msg = result.equals((Object)ReindexTerminologyResult.SEARCH_SVC_DISABLED) ? "Freetext service is not configured. Operation didn't run." : "Operation was cancelled because other terminology background tasks are currently running. Try again in a few minutes.";
            ParametersUtil.addParameterToParametersString((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"message", (String)msg);
            return retVal;
        }
        ParametersUtil.addParameterToParametersBoolean((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)RESP_PARAM_SUCCESS, (boolean)true);
        ourLog.info("Re-creating terminology freetext indexes took {}", (Object)sw);
        return retVal;
    }
}

