/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.provider.BaseJpaSystemProvider;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseJpaSystemProviderDstu2Plus<T, MT>
extends BaseJpaSystemProvider<T, MT> {
    @Description(value="Marks all currently existing resources of a given type, or all resources of all types, for reindexing.")
    @Operation(name="$mark-all-resources-for-reindexing", idempotent=false, returnParameters={@OperationParam(name="status")})
    @Deprecated
    public IBaseResource markAllResourcesForReindexing(@OperationParam(name="type", min=0, max=1, typeName="code") IPrimitiveType<String> theType) {
        if (theType != null && StringUtils.isNotBlank((CharSequence)theType.getValueAsString())) {
            this.getResourceReindexingSvc().markAllResourcesForReindexing(theType.getValueAsString());
        } else {
            this.getResourceReindexingSvc().markAllResourcesForReindexing();
        }
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        IPrimitiveType string = ParametersUtil.createString((FhirContext)this.getContext(), (String)"Marked resources");
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"status", (Object)string);
        return retVal;
    }

    @Description(value="Forces a single pass of the resource reindexing processor")
    @Operation(name="$perform-reindexing-pass", idempotent=false, returnParameters={@OperationParam(name="status")})
    @Deprecated
    public IBaseResource performReindexingPass() {
        Integer count = this.getResourceReindexingSvc().runReindexingPass();
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        IPrimitiveType string = count == null ? ParametersUtil.createString((FhirContext)this.getContext(), (String)"Index pass already proceeding") : ParametersUtil.createString((FhirContext)this.getContext(), (String)("Indexed " + count + " resources"));
        ParametersUtil.addParameterToParameters((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"status", (Object)string);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Description(value="Accept a FHIR Message Bundle for processing")
    @Operation(name="$process-message", idempotent=false)
    public IBaseBundle processMessage(HttpServletRequest theServletRequest, RequestDetails theRequestDetails, @OperationParam(name="content", min=1, max=1, typeName="Bundle") @Description(formalDefinition="The message to process (or, if using asynchronous messaging, it may be a response message to accept)") IBaseBundle theMessageToProcess) {
        this.startRequest(theServletRequest);
        try {
            IBaseBundle iBaseBundle = this.getDao().processMessage(theRequestDetails, theMessageToProcess);
            return iBaseBundle;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

