/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.provider.ServerCapabilityStatementProvider;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.FhirTerser;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.Meta;

public class JpaCapabilityStatementProvider
extends ServerCapabilityStatementProvider {
    private final FhirContext myContext;
    private DaoConfig myDaoConfig;
    private String myImplementationDescription;
    private boolean myIncludeResourceCounts;
    private IFhirSystemDao<?, ?> mySystemDao;

    public JpaCapabilityStatementProvider(@Nonnull RestfulServer theRestfulServer, @Nonnull IFhirSystemDao<?, ?> theSystemDao, @Nonnull DaoConfig theDaoConfig, @Nonnull ISearchParamRegistry theSearchParamRegistry, IValidationSupport theValidationSupport) {
        super(theRestfulServer, theSearchParamRegistry, theValidationSupport);
        Validate.notNull((Object)theRestfulServer);
        Validate.notNull(theSystemDao);
        Validate.notNull((Object)theDaoConfig);
        Validate.notNull((Object)theSearchParamRegistry);
        this.myContext = theRestfulServer.getFhirContext();
        this.mySystemDao = theSystemDao;
        this.myDaoConfig = theDaoConfig;
        this.setIncludeResourceCounts(true);
    }

    protected void postProcess(FhirTerser theTerser, IBaseConformance theCapabilityStatement) {
        super.postProcess(theTerser, theCapabilityStatement);
        if (StringUtils.isNotBlank((CharSequence)this.myImplementationDescription)) {
            theTerser.setElement((IBase)theCapabilityStatement, "implementation.description", this.myImplementationDescription);
        }
        theTerser.addElement((IBase)theCapabilityStatement, "patchFormat", "application/fhir+json");
        theTerser.addElement((IBase)theCapabilityStatement, "patchFormat", "application/fhir+xml");
        theTerser.addElement((IBase)theCapabilityStatement, "patchFormat", "application/json-patch+json");
        theTerser.addElement((IBase)theCapabilityStatement, "patchFormat", "application/xml-patch+xml");
    }

    protected void postProcessRest(FhirTerser theTerser, IBase theRest) {
        super.postProcessRest(theTerser, theRest);
        if (this.myDaoConfig.getSupportedSubscriptionTypes().contains(Subscription.SubscriptionChannelType.WEBSOCKET) && StringUtils.isNotBlank((CharSequence)this.myDaoConfig.getWebsocketContextPath())) {
            ExtensionUtil.setExtension((FhirContext)this.myContext, (IBase)theRest, (String)"http://hl7.org/fhir/StructureDefinition/capabilitystatement-websocket", (String)"uri", (Object)this.myDaoConfig.getWebsocketContextPath());
        }
    }

    protected void postProcessRestResource(FhirTerser theTerser, IBase theResource, String theResourceName) {
        Long count;
        Map counts;
        super.postProcessRestResource(theTerser, theResource, theResourceName);
        theTerser.addElement(theResource, "versioning", CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE.toCode());
        if (this.myDaoConfig.isAllowMultipleDelete()) {
            theTerser.addElement(theResource, "conditionalDelete", CapabilityStatement.ConditionalDeleteStatus.MULTIPLE.toCode());
        } else {
            theTerser.addElement(theResource, "conditionalDelete", CapabilityStatement.ConditionalDeleteStatus.SINGLE.toCode());
        }
        if (this.myIncludeResourceCounts && (counts = this.mySystemDao.getResourceCountsFromCache()) != null && (count = (Long)counts.get(theResourceName)) != null) {
            ExtensionUtil.setExtension((FhirContext)this.myContext, (IBase)theResource, (String)"http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount", (String)"decimal", (Object)Long.toString(count));
        }
    }

    public boolean isIncludeResourceCounts() {
        return this.myIncludeResourceCounts;
    }

    public void setIncludeResourceCounts(boolean theIncludeResourceCounts) {
        this.myIncludeResourceCounts = theIncludeResourceCounts;
    }

    public void setDaoConfig(DaoConfig myDaoConfig) {
        this.myDaoConfig = myDaoConfig;
    }

    @CoverageIgnore
    public void setImplementationDescription(String theImplDesc) {
        this.myImplementationDescription = theImplDesc;
    }

    @CoverageIgnore
    public void setSystemDao(IFhirSystemDao<Bundle, Meta> mySystemDao) {
        this.mySystemDao = mySystemDao;
    }

    protected boolean searchParamEnabled(String theSearchParam) {
        return !"_filter".equals(theSearchParam) || this.myDaoConfig.isFilterParameterEnabled();
    }
}

