/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProviderValueSetDstu2;
import ca.uhn.fhir.jpa.search.autocomplete.ValueSetAutocompleteOptions;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.ParametersUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ValueSetOperationProvider
extends BaseJpaProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(ValueSetOperationProvider.class);
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private ITermReadSvc myTermReadSvc;
    @Autowired
    @Qualifier(value="myJpaValidationSupportChain")
    private ValidationSupportChain myValidationSupportChain;
    @Autowired
    private IValidationSupport myValidationSupport;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearch;

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    public void setDaoConfig(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    public void setDaoRegistry(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    public void setTermReadSvc(ITermReadSvc theTermReadSvc) {
        this.myTermReadSvc = theTermReadSvc;
    }

    public void setValidationSupportChain(ValidationSupportChain theValidationSupportChain) {
        this.myValidationSupportChain = theValidationSupportChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$expand", idempotent=true, typeName="ValueSet")
    public IBaseResource expand(HttpServletRequest theServletRequest, @IdParam(optional=true) IIdType theId, @OperationParam(name="valueSet", min=0, max=1) IBaseResource theValueSet, @OperationParam(name="url", min=0, max=1, typeName="uri") IPrimitiveType<String> theUrl, @OperationParam(name="valueSetVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theValueSetVersion, @OperationParam(name="filter", min=0, max=1, typeName="string") IPrimitiveType<String> theFilter, @OperationParam(name="context", min=0, max=1, typeName="string") IPrimitiveType<String> theContext, @OperationParam(name="contextDirection", min=0, max=1, typeName="string") IPrimitiveType<String> theContextDirection, @OperationParam(name="offset", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theOffset, @OperationParam(name="count", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theCount, @OperationParam(name="displayLanguage", min=0, max=1, typeName="code") IPrimitiveType<String> theDisplayLanguage, @OperationParam(name="includeHierarchy", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theIncludeHierarchy, RequestDetails theRequestDetails) {
        boolean isAutocompleteExtension;
        boolean haveId = theId != null && theId.hasIdPart();
        boolean haveIdentifier = theUrl != null && StringUtils.isNotBlank((CharSequence)((CharSequence)theUrl.getValue()));
        boolean haveValueSet = theValueSet != null && !theValueSet.isEmpty();
        boolean haveValueSetVersion = theValueSetVersion != null && !theValueSetVersion.isEmpty();
        boolean haveContextDirection = theContextDirection != null && !theContextDirection.isEmpty();
        boolean haveContext = theContext != null && !theContext.isEmpty();
        boolean bl = isAutocompleteExtension = haveContext && haveContextDirection && "existing".equals(theContextDirection.getValue());
        if (isAutocompleteExtension) {
            ValueSetAutocompleteOptions options = ValueSetAutocompleteOptions.validateAndParseOptions(this.myDaoConfig, theContext, theFilter, theCount, theId, theUrl, theValueSet);
            this.startRequest(theServletRequest);
            try {
                if (this.myFulltextSearch == null || this.myFulltextSearch.isDisabled()) {
                    throw new InvalidRequestException(Msg.code((int)2083) + " Autocomplete is not supported on this server, as the fulltext search service is not configured.");
                }
                IBaseResource iBaseResource = this.myFulltextSearch.tokenAutocompleteValueSetSearch(options);
                return iBaseResource;
            }
            finally {
                this.endRequest(theServletRequest);
            }
        }
        if (!(haveId || haveIdentifier || haveValueSet)) {
            throw new InvalidRequestException(Msg.code((int)1133) + "$expand operation at the type level (no ID specified) requires a url or a valueSet as a part of the request.");
        }
        if (ValueSetOperationProvider.moreThanOneTrue(haveId, haveIdentifier, haveValueSet)) {
            throw new InvalidRequestException(Msg.code((int)1134) + "$expand must EITHER be invoked at the instance level, or have a url specified, or have a ValueSet specified. Can not combine these options.");
        }
        ValueSetExpansionOptions options = ValueSetOperationProvider.createValueSetExpansionOptions(this.myDaoConfig, theOffset, theCount, theIncludeHierarchy, theFilter, theDisplayLanguage);
        this.startRequest(theServletRequest);
        try {
            IValidationSupport.ValueSetExpansionOutcome outcome;
            IFhirResourceDaoValueSet<IBaseResource, ICompositeType, ICompositeType> dao = this.getDao();
            if (haveId) {
                IBaseResource valueSet = dao.read(theId, theRequestDetails);
                outcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), options, valueSet);
            } else if (haveIdentifier) {
                Object url = haveValueSetVersion ? (String)theUrl.getValue() + "|" + (String)theValueSetVersion.getValue() : (String)theUrl.getValue();
                outcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), options, (String)url);
            } else {
                outcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), options, theValueSet);
            }
            if (outcome == null) {
                throw new InternalErrorException(Msg.code((int)2028) + "No validation support module was able to expand the given valueset");
            }
            if (outcome.getError() != null) {
                throw new PreconditionFailedException(Msg.code((int)2029) + outcome.getError());
            }
            IBaseResource iBaseResource = outcome.getValueSet();
            return iBaseResource;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    private IFhirResourceDaoValueSet<IBaseResource, ICompositeType, ICompositeType> getDao() {
        return (IFhirResourceDaoValueSet)this.myDaoRegistry.getResourceDao("ValueSet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$validate-code", idempotent=true, typeName="ValueSet", returnParameters={@OperationParam(name="result", typeName="boolean", min=1), @OperationParam(name="message", typeName="string"), @OperationParam(name="display", typeName="string")})
    public IBaseParameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IIdType theId, @OperationParam(name="url", min=0, max=1, typeName="uri") IPrimitiveType<String> theValueSetUrl, @OperationParam(name="valueSetVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theValueSetVersion, @OperationParam(name="code", min=0, max=1) IPrimitiveType<String> theCode, @OperationParam(name="system", min=0, max=1, typeName="uri") IPrimitiveType<String> theSystem, @OperationParam(name="systemVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theSystemVersion, @OperationParam(name="display", min=0, max=1, typeName="string") IPrimitiveType<String> theDisplay, @OperationParam(name="coding", min=0, max=1, typeName="Coding") ICompositeType theCoding, @OperationParam(name="codeableConcept", min=0, max=1, typeName="CodeableConcept") ICompositeType theCodeableConcept, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IValidationSupport.CodeValidationResult result;
            if (this.myValidationSupportChain != null && this.myValidationSupportChain.isRemoteTerminologyServiceConfigured()) {
                String theSystemString = theSystem != null && theSystem.hasValue() ? theSystem.getValueAsString() : null;
                String theCodeString = theCode != null && theCode.hasValue() ? theCode.getValueAsString() : null;
                String theDisplayString = theDisplay != null && theDisplay.hasValue() ? theDisplay.getValueAsString() : null;
                String theValueSetUrlString = theValueSetUrl != null && theValueSetUrl.hasValue() ? theValueSetUrl.getValueAsString() : null;
                result = this.myValidationSupportChain.validateCode(new ValidationSupportContext((IValidationSupport)this.myValidationSupportChain), new ConceptValidationOptions(), theSystemString, theCodeString, theDisplayString, theValueSetUrlString);
            } else {
                IPrimitiveType codeSystemIdentifier;
                IPrimitiveType valueSetIdentifier;
                IFhirResourceDaoValueSet<IBaseResource, ICompositeType, ICompositeType> dao = this.getDao();
                if (theValueSetUrl != null && theValueSetVersion != null) {
                    valueSetIdentifier = (IPrimitiveType)this.getContext().getElementDefinition("uri").newInstance();
                    valueSetIdentifier.setValue((Object)((String)theValueSetUrl.getValue() + "|" + theValueSetVersion));
                } else {
                    valueSetIdentifier = theValueSetUrl;
                }
                if (theSystem != null && theSystemVersion != null) {
                    codeSystemIdentifier = (IPrimitiveType)this.getContext().getElementDefinition("uri").newInstance();
                    codeSystemIdentifier.setValue((Object)((String)theSystem.getValue() + "|" + theSystemVersion));
                } else {
                    codeSystemIdentifier = theSystem;
                }
                result = dao.validateCode(valueSetIdentifier, theId, theCode, codeSystemIdentifier, theDisplay, (Object)theCoding, (Object)theCodeableConcept, theRequestDetails);
            }
            IBaseParameters iBaseParameters = BaseJpaResourceProviderValueSetDstu2.toValidateCodeResult(this.getContext(), result);
            return iBaseParameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$invalidate-expansion", idempotent=false, typeName="ValueSet", returnParameters={@OperationParam(name="message", typeName="string", min=1, max=1)})
    public IBaseParameters invalidateValueSetExpansion(@IdParam IIdType theValueSetId, RequestDetails theRequestDetails, HttpServletRequest theServletRequest) {
        this.startRequest(theServletRequest);
        try {
            String outcome = this.myTermReadSvc.invalidatePreCalculatedExpansion(theValueSetId, theRequestDetails);
            IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
            ParametersUtil.addParameterToParametersString((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)"message", (String)outcome);
            IBaseParameters iBaseParameters = retVal;
            return iBaseParameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    public static ValueSetExpansionOptions createValueSetExpansionOptions(DaoConfig theDaoConfig, IPrimitiveType<Integer> theOffset, IPrimitiveType<Integer> theCount, IPrimitiveType<Boolean> theIncludeHierarchy, IPrimitiveType<String> theFilter, IPrimitiveType<String> theDisplayLanguage) {
        int countMax;
        int offset = theDaoConfig.getPreExpandValueSetsDefaultOffset();
        if (theOffset != null && theOffset.hasValue()) {
            if ((Integer)theOffset.getValue() >= 0) {
                offset = (Integer)theOffset.getValue();
            } else {
                throw new InvalidRequestException(Msg.code((int)1135) + "offset parameter for $expand operation must be >= 0 when specified. offset: " + theOffset.getValue());
            }
        }
        int count = theDaoConfig.getPreExpandValueSetsDefaultCount();
        if (theCount != null && theCount.hasValue()) {
            if ((Integer)theCount.getValue() >= 0) {
                count = (Integer)theCount.getValue();
            } else {
                throw new InvalidRequestException(Msg.code((int)1136) + "count parameter for $expand operation must be >= 0 when specified. count: " + theCount.getValue());
            }
        }
        if (count > (countMax = theDaoConfig.getPreExpandValueSetsMaxCount())) {
            ourLog.warn("count parameter for $expand operation of {} exceeds maximum value of {}; using maximum value.", (Object)count, (Object)countMax);
            count = countMax;
        }
        ValueSetExpansionOptions options = ValueSetExpansionOptions.forOffsetAndCount((int)offset, (int)count);
        if (theIncludeHierarchy != null && Boolean.TRUE.equals(theIncludeHierarchy.getValue())) {
            options.setIncludeHierarchy(true);
        }
        if (theFilter != null) {
            options.setFilter((String)theFilter.getValue());
        }
        if (theDisplayLanguage != null) {
            options.setTheDisplayLanguage((String)theDisplayLanguage.getValue());
        }
        return options;
    }

    private static boolean moreThanOneTrue(boolean ... theBooleans) {
        boolean haveOne = false;
        for (boolean next : theBooleans) {
            if (!next) continue;
            if (haveOne) {
                return true;
            }
            haveOne = true;
        }
        return false;
    }
}

