/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.dstu3;

import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoConceptMap;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.provider.dstu3.JpaResourceProviderDstu3;
import ca.uhn.fhir.jpa.term.TermConceptMappingSvcImpl;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;

public class BaseJpaResourceProviderConceptMapDstu3
extends JpaResourceProviderDstu3<ConceptMap> {
    @Operation(name="$translate", idempotent=true, returnParameters={@OperationParam(name="result", type=org.hl7.fhir.dstu3.model.BooleanType.class, min=1, max=1), @OperationParam(name="message", type=org.hl7.fhir.dstu3.model.StringType.class, min=0, max=1)})
    public Parameters translate(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) UriType theUrl, @OperationParam(name="conceptMapVersion", min=0, max=1) org.hl7.fhir.dstu3.model.StringType theConceptMapVersion, @OperationParam(name="code", min=0, max=1) org.hl7.fhir.dstu3.model.CodeType theSourceCode, @OperationParam(name="system", min=0, max=1) UriType theSourceCodeSystem, @OperationParam(name="version", min=0, max=1) org.hl7.fhir.dstu3.model.StringType theSourceCodeSystemVersion, @OperationParam(name="source", min=0, max=1) UriType theSourceValueSet, @OperationParam(name="coding", min=0, max=1) org.hl7.fhir.dstu3.model.Coding theSourceCoding, @OperationParam(name="codeableConcept", min=0, max=1) org.hl7.fhir.dstu3.model.CodeableConcept theSourceCodeableConcept, @OperationParam(name="target", min=0, max=1) UriType theTargetValueSet, @OperationParam(name="targetsystem", min=0, max=1) UriType theTargetCodeSystem, @OperationParam(name="reverse", min=0, max=1) org.hl7.fhir.dstu3.model.BooleanType theReverse, RequestDetails theRequestDetails) {
        boolean haveId;
        boolean haveUrl = theUrl != null && theUrl.hasValue();
        boolean haveConceptMapVersion = theConceptMapVersion != null && theConceptMapVersion.hasValue();
        boolean haveSourceCode = theSourceCode != null && theSourceCode.hasValue();
        boolean haveSourceCodeSystem = theSourceCodeSystem != null && theSourceCodeSystem.hasValue();
        boolean haveSourceCodeSystemVersion = theSourceCodeSystemVersion != null && theSourceCodeSystemVersion.hasValue();
        boolean haveSourceValueSet = theSourceValueSet != null && theSourceValueSet.hasValue();
        boolean haveSourceCoding = theSourceCoding != null && theSourceCoding.hasCode();
        boolean haveSourceCodeableConcept = theSourceCodeableConcept != null && theSourceCodeableConcept.hasCoding() && theSourceCodeableConcept.getCodingFirstRep().hasCode();
        boolean haveTargetValueSet = theTargetValueSet != null && theTargetValueSet.hasValue();
        boolean haveTargetCodeSystem = theTargetCodeSystem != null && theTargetCodeSystem.hasValue();
        boolean haveReverse = theReverse != null;
        boolean bl = haveId = theId != null && theId.hasIdPart();
        if (!haveSourceCode && !haveSourceCoding && !haveSourceCodeableConcept || BaseJpaResourceProviderConceptMapDstu3.moreThanOneTrue(haveSourceCode, haveSourceCoding, haveSourceCodeableConcept)) {
            throw new InvalidRequestException(Msg.code((int)1149) + "One (and only one) of the in parameters (code, coding, codeableConcept) must be provided, to identify the code that is to be translated.");
        }
        TranslationRequest translationRequest = new TranslationRequest();
        try {
            if (haveUrl) {
                translationRequest.setUrl((org.hl7.fhir.r4.model.UriType)VersionConvertorFactory_30_40.convertType((Type)theUrl, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            }
            if (haveConceptMapVersion) {
                translationRequest.setConceptMapVersion((StringType)VersionConvertorFactory_30_40.convertType((Type)theConceptMapVersion, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            }
            if (haveSourceCode) {
                translationRequest.getCodeableConcept().addCoding().setCodeElement((CodeType)VersionConvertorFactory_30_40.convertType((Type)theSourceCode, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
                if (haveSourceCodeSystem) {
                    translationRequest.getCodeableConcept().getCodingFirstRep().setSystemElement((org.hl7.fhir.r4.model.UriType)VersionConvertorFactory_30_40.convertType((Type)theSourceCodeSystem, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
                }
                if (haveSourceCodeSystemVersion) {
                    translationRequest.getCodeableConcept().getCodingFirstRep().setVersionElement((StringType)VersionConvertorFactory_30_40.convertType((Type)theSourceCodeSystemVersion, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
                }
            } else if (haveSourceCoding) {
                translationRequest.getCodeableConcept().addCoding((Coding)VersionConvertorFactory_30_40.convertType((Type)theSourceCoding, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            } else {
                translationRequest.setCodeableConcept((CodeableConcept)VersionConvertorFactory_30_40.convertType((Type)theSourceCodeableConcept, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            }
            if (haveSourceValueSet) {
                translationRequest.setSource((org.hl7.fhir.r4.model.UriType)VersionConvertorFactory_30_40.convertType((Type)theSourceValueSet, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            }
            if (haveTargetValueSet) {
                translationRequest.setTarget((org.hl7.fhir.r4.model.UriType)VersionConvertorFactory_30_40.convertType((Type)theTargetValueSet, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            }
            if (haveTargetCodeSystem) {
                translationRequest.setTargetSystem((org.hl7.fhir.r4.model.UriType)VersionConvertorFactory_30_40.convertType((Type)theTargetCodeSystem, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            }
            if (haveReverse) {
                translationRequest.setReverse((BooleanType)VersionConvertorFactory_30_40.convertType((Type)theReverse, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))));
            }
            if (haveId) {
                translationRequest.setResourceId(theId.getIdPartAsLong());
            }
        }
        catch (FHIRException fe) {
            throw new InternalErrorException(Msg.code((int)1150) + fe);
        }
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoConceptMap dao = (IFhirResourceDaoConceptMap)this.getDao();
            TranslateConceptResults result = dao.translate(translationRequest, theRequestDetails);
            Parameters parameters = (Parameters)VersionConvertorFactory_30_40.convertResource((Resource)TermConceptMappingSvcImpl.toParameters(result), (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
            return parameters;
        }
        catch (FHIRException fe) {
            throw new InternalErrorException(Msg.code((int)1151) + fe);
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    private static boolean moreThanOneTrue(boolean ... theBooleans) {
        boolean haveOne = false;
        for (boolean next : theBooleans) {
            if (!next) continue;
            if (haveOne) {
                return true;
            }
            haveOne = true;
        }
        return false;
    }
}

