/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.dstu3;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerConfiguration;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.CoverageIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2.model.Subscription;
import org.hl7.fhir.dstu3.hapi.rest.server.ServerCapabilityStatementProvider;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.DecimalType;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IBaseDatatype;

public class JpaConformanceProviderDstu3
extends ServerCapabilityStatementProvider {
    private volatile CapabilityStatement myCachedValue;
    private DaoConfig myDaoConfig;
    private ISearchParamRegistry mySearchParamRegistry;
    private String myImplementationDescription;
    private boolean myIncludeResourceCounts;
    private RestfulServer myRestfulServer;
    private IFhirSystemDao<Bundle, Meta> mySystemDao;
    private RestfulServerConfiguration myServerConfiguration;

    @CoverageIgnore
    public JpaConformanceProviderDstu3() {
        super.setCache(false);
        this.setIncludeResourceCounts(true);
    }

    public JpaConformanceProviderDstu3(RestfulServer theRestfulServer, IFhirSystemDao<Bundle, Meta> theSystemDao, DaoConfig theDaoConfig, ISearchParamRegistry theSearchParamRegistry) {
        super(theRestfulServer);
        this.myRestfulServer = theRestfulServer;
        this.mySystemDao = theSystemDao;
        this.myDaoConfig = theDaoConfig;
        this.myServerConfiguration = theRestfulServer.createConfiguration();
        super.setCache(false);
        this.setSearchParamRegistry(theSearchParamRegistry);
        this.setIncludeResourceCounts(true);
    }

    public void setSearchParamRegistry(ISearchParamRegistry theSearchParamRegistry) {
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    public CapabilityStatement getServerConformance(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
        CapabilityStatement retVal = this.myCachedValue;
        Map counts = null;
        if (this.myIncludeResourceCounts) {
            counts = this.mySystemDao.getResourceCountsFromCache();
        }
        counts = (Map)ObjectUtils.defaultIfNull(counts, Collections.emptyMap());
        retVal = super.getServerConformance(theRequest, theRequestDetails);
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : retVal.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextResource : nextRest.getResource()) {
                Long count;
                nextResource.setVersioning(CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE);
                CapabilityStatement.ConditionalDeleteStatus conditionalDelete = nextResource.getConditionalDelete();
                if (conditionalDelete == CapabilityStatement.ConditionalDeleteStatus.MULTIPLE && !this.myDaoConfig.isAllowMultipleDelete()) {
                    nextResource.setConditionalDelete(CapabilityStatement.ConditionalDeleteStatus.SINGLE);
                }
                if ((count = (Long)counts.get(nextResource.getTypeElement().getValueAsString())) != null) {
                    nextResource.addExtension(new Extension("http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount", (IBaseDatatype)new DecimalType(count.longValue())));
                }
                nextResource.getSearchParam().clear();
                String resourceName = nextResource.getType();
                ResourceSearchParams searchParams = this.constructCompleteSearchParamList(resourceName);
                for (RuntimeSearchParam runtimeSp : searchParams.values()) {
                    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent confSp = nextResource.addSearchParam();
                    confSp.setName(runtimeSp.getName());
                    confSp.setDocumentation(runtimeSp.getDescription());
                    confSp.setDefinition(runtimeSp.getUri());
                    switch (runtimeSp.getParamType()) {
                        case COMPOSITE: {
                            confSp.setType(Enumerations.SearchParamType.COMPOSITE);
                            break;
                        }
                        case DATE: {
                            confSp.setType(Enumerations.SearchParamType.DATE);
                            break;
                        }
                        case NUMBER: {
                            confSp.setType(Enumerations.SearchParamType.NUMBER);
                            break;
                        }
                        case QUANTITY: {
                            confSp.setType(Enumerations.SearchParamType.QUANTITY);
                            break;
                        }
                        case REFERENCE: {
                            confSp.setType(Enumerations.SearchParamType.REFERENCE);
                            break;
                        }
                        case STRING: {
                            confSp.setType(Enumerations.SearchParamType.STRING);
                            break;
                        }
                        case TOKEN: {
                            confSp.setType(Enumerations.SearchParamType.TOKEN);
                            break;
                        }
                        case URI: {
                            confSp.setType(Enumerations.SearchParamType.URI);
                            break;
                        }
                    }
                }
                this.updateIncludesList(nextResource, searchParams);
                this.updateRevIncludesList(nextResource, searchParams);
            }
        }
        this.massage(retVal);
        if (this.myDaoConfig.getSupportedSubscriptionTypes().contains(Subscription.SubscriptionChannelType.WEBSOCKET) && StringUtils.isNotBlank((CharSequence)this.myDaoConfig.getWebsocketContextPath())) {
            Extension websocketExtension = new Extension();
            websocketExtension.setUrl("http://hl7.org/fhir/StructureDefinition/capabilitystatement-websocket");
            websocketExtension.setValue((Type)new UriType(this.myDaoConfig.getWebsocketContextPath()));
            retVal.getRestFirstRep().addExtension(websocketExtension);
        }
        retVal.getImplementation().setDescription(this.myImplementationDescription);
        this.myCachedValue = retVal;
        return retVal;
    }

    private ResourceSearchParams constructCompleteSearchParamList(String theResourceName) {
        ResourceSearchParams searchParams;
        ResourceSearchParams serverConfigurationActiveSearchParams = this.myServerConfiguration.getActiveSearchParams(theResourceName);
        if (this.mySearchParamRegistry != null) {
            searchParams = this.mySearchParamRegistry.getActiveSearchParams(theResourceName).makeCopy();
            if (searchParams == null) {
                return ResourceSearchParams.empty((String)theResourceName);
            }
            for (String nextBuiltInSpName : serverConfigurationActiveSearchParams.getSearchParamNames()) {
                if (!nextBuiltInSpName.startsWith("_") || searchParams.containsParamName(nextBuiltInSpName) || !this.searchParamEnabled(nextBuiltInSpName)) continue;
                searchParams.put(nextBuiltInSpName, serverConfigurationActiveSearchParams.get(nextBuiltInSpName));
            }
        } else {
            searchParams = serverConfigurationActiveSearchParams;
        }
        return searchParams;
    }

    protected boolean searchParamEnabled(String theSearchParam) {
        return !"_filter".equals(theSearchParam) || this.myDaoConfig.isFilterParameterEnabled();
    }

    private void updateRevIncludesList(CapabilityStatement.CapabilityStatementRestResourceComponent theNextResource, ResourceSearchParams theSearchParams) {
        if (theNextResource.getSearchRevInclude().isEmpty()) {
            String resourcename = theNextResource.getType();
            Set allResourceTypes = this.myServerConfiguration.collectMethodBindings().keySet();
            for (String otherResourceType : allResourceTypes) {
                if (StringUtils.isBlank((CharSequence)otherResourceType)) continue;
                ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(otherResourceType);
                activeSearchParams.values().stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getName())).filter(t -> t.getTargets().contains(resourcename)).forEach(t -> theNextResource.addSearchRevInclude(otherResourceType + ":" + t.getName()));
            }
        }
    }

    private void updateIncludesList(CapabilityStatement.CapabilityStatementRestResourceComponent theResource, ResourceSearchParams theSearchParams) {
        String resourceName = theResource.getType();
        if (theResource.getSearchInclude().isEmpty()) {
            List includes = theSearchParams.values().stream().filter(t -> t.getParamType() == RestSearchParameterTypeEnum.REFERENCE).map(t -> resourceName + ":" + t.getName()).sorted().collect(Collectors.toList());
            theResource.addSearchInclude("*");
            for (String nextInclude : includes) {
                theResource.addSearchInclude(nextInclude);
            }
        }
    }

    public boolean isIncludeResourceCounts() {
        return this.myIncludeResourceCounts;
    }

    public void setIncludeResourceCounts(boolean theIncludeResourceCounts) {
        this.myIncludeResourceCounts = theIncludeResourceCounts;
    }

    protected void massage(CapabilityStatement theStatement) {
    }

    public void setDaoConfig(DaoConfig myDaoConfig) {
        this.myDaoConfig = myDaoConfig;
    }

    @CoverageIgnore
    public void setImplementationDescription(String theImplDesc) {
        this.myImplementationDescription = theImplDesc;
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
        this.myRestfulServer = theRestfulServer;
        super.setRestfulServer(theRestfulServer);
    }

    @CoverageIgnore
    public void setSystemDao(IFhirSystemDao<Bundle, Meta> mySystemDao) {
        this.mySystemDao = mySystemDao;
    }
}

