/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r4;

import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProviderValueSetDstu2;
import ca.uhn.fhir.jpa.provider.r4.JpaResourceProviderR4;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcR4;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BaseJpaResourceProviderCodeSystemR4
extends JpaResourceProviderR4<CodeSystem> {
    @Autowired
    @Qualifier(value="myJpaValidationSupportChain")
    private ValidationSupportChain myValidationSupportChain;
    @Autowired
    protected ITermReadSvcR4 myTermSvc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$lookup", idempotent=true, returnParameters={@OperationParam(name="name", type=StringType.class, min=1), @OperationParam(name="version", type=StringType.class, min=0), @OperationParam(name="display", type=StringType.class, min=1), @OperationParam(name="abstract", type=BooleanType.class, min=1)})
    public Parameters lookup(HttpServletRequest theServletRequest, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="coding", min=0, max=1) Coding theCoding, @OperationParam(name="version", min=0, max=1) StringType theVersion, @OperationParam(name="displayLanguage", min=0, max=1) CodeType theDisplayLanguage, @OperationParam(name="property", min=0, max=-1) List<CodeType> theProperties, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            IValidationSupport.LookupCodeResult result = theVersion != null ? dao.lookupCode((IPrimitiveType)theCode, (IPrimitiveType)new UriType((String)theSystem.getValue() + "|" + theVersion), (Object)theCoding, (IPrimitiveType)theDisplayLanguage, theRequestDetails) : dao.lookupCode((IPrimitiveType)theCode, (IPrimitiveType)theSystem, (Object)theCoding, (IPrimitiveType)theDisplayLanguage, theRequestDetails);
            result.throwNotFoundIfAppropriate();
            Parameters parameters = (Parameters)result.toParameters(theRequestDetails.getFhirContext(), theProperties);
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$subsumes", idempotent=true, returnParameters={@OperationParam(name="outcome", type=CodeType.class, min=1)})
    public Parameters subsumes(HttpServletRequest theServletRequest, @OperationParam(name="codeA", min=0, max=1) CodeType theCodeA, @OperationParam(name="codeB", min=0, max=1) CodeType theCodeB, @OperationParam(name="system", min=0, max=1) UriType theSystem, @OperationParam(name="codingA", min=0, max=1) Coding theCodingA, @OperationParam(name="codingB", min=0, max=1) Coding theCodingB, @OperationParam(name="version", min=0, max=1) StringType theVersion, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
            if (theVersion != null) {
                theSystem = new UriType(theSystem.asStringValue() + "|" + theVersion.toString());
            }
            IFhirResourceDaoCodeSystem.SubsumesResult result = dao.subsumes((IPrimitiveType)theCodeA, (IPrimitiveType)theCodeB, (IPrimitiveType)theSystem, (Object)theCodingA, (Object)theCodingB, theRequestDetails);
            Parameters parameters = (Parameters)result.toParameters(theRequestDetails.getFhirContext());
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$validate-code", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanType.class, min=1), @OperationParam(name="message", type=StringType.class), @OperationParam(name="display", type=StringType.class)})
    public Parameters validateCode(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) UriType theCodeSystemUrl, @OperationParam(name="version", min=0, max=1) StringType theVersion, @OperationParam(name="code", min=0, max=1) CodeType theCode, @OperationParam(name="display", min=0, max=1) StringType theDisplay, @OperationParam(name="coding", min=0, max=1) Coding theCoding, @OperationParam(name="codeableConcept", min=0, max=1) CodeableConcept theCodeableConcept, RequestDetails theRequestDetails) {
        IValidationSupport.CodeValidationResult result = null;
        this.startRequest(theServletRequest);
        try {
            if (this.myValidationSupportChain.isRemoteTerminologyServiceConfigured()) {
                String display;
                String codeSystemUrl = theCodeSystemUrl != null && theCodeSystemUrl.hasValue() ? theCodeSystemUrl.asStringValue() : null;
                String code = theCode != null && theCode.hasValue() ? theCode.asStringValue() : null;
                String string = display = theDisplay != null && theDisplay.hasValue() ? theDisplay.asStringValue() : null;
                if (theCoding != null && theCoding.hasSystem()) {
                    if (codeSystemUrl != null && !codeSystemUrl.equalsIgnoreCase(theCoding.getSystem())) {
                        throw new InvalidRequestException(Msg.code((int)1160) + "Coding.system '" + theCoding.getSystem() + "' does not equal param url '" + theCodeSystemUrl + "'. Unable to validate-code.");
                    }
                    codeSystemUrl = theCoding.getSystem();
                    code = theCoding.getCode();
                    display = theCoding.getDisplay();
                    result = this.myValidationSupportChain.validateCode(new ValidationSupportContext((IValidationSupport)this.myValidationSupportChain), new ConceptValidationOptions(), codeSystemUrl, code, display, null);
                }
            } else {
                IFhirResourceDaoCodeSystem dao = (IFhirResourceDaoCodeSystem)this.getDao();
                result = dao.validateCode((IIdType)theId, (IPrimitiveType)theCodeSystemUrl, (IPrimitiveType)theVersion, (IPrimitiveType)theCode, (IPrimitiveType)theDisplay, (Object)theCoding, (Object)theCodeableConcept, theRequestDetails);
            }
            Parameters parameters = (Parameters)BaseJpaResourceProviderValueSetDstu2.toValidateCodeResult(this.getContext(), result);
            return parameters;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

