/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r4;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoObservation;
import ca.uhn.fhir.jpa.provider.r4.JpaResourceProviderR4;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.UnsignedIntType;

public class BaseJpaResourceProviderObservationR4
extends JpaResourceProviderR4<Observation> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$lastn", idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider observationLastN(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count") UnsignedIntType theCount, @Description(shortDefinition="The classification of the type of observation") @OperationParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="The code of the observation type") @OperationParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="The effective date of the observation") @OperationParam(name="date") DateAndListParam theDate, @Description(shortDefinition="The subject that the observation is about (if patient)") @OperationParam(name="patient") ReferenceAndListParam thePatient, @Description(shortDefinition="The subject that the observation is about") @OperationParam(name="subject") ReferenceAndListParam theSubject, @Description(shortDefinition="The maximum number of observations to return for each observation code") @OperationParam(name="max", typeName="integer", min=0, max=1) IPrimitiveType<Integer> theMax, @RawParam Map<String, List<String>> theAdditionalRawParams) {
        this.startRequest(theServletRequest);
        try {
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            if (thePatient != null) {
                paramMap.add("patient", (IQueryParameterAnd)thePatient);
            }
            if (theSubject != null) {
                paramMap.add("subject", (IQueryParameterAnd)theSubject);
            }
            if (theMax != null) {
                paramMap.setLastNMax((Integer)theMax.getValue());
            }
            if (theCount != null) {
                paramMap.setCount((Integer)theCount.getValue());
            }
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = ((IFhirResourceDaoObservation)this.getDao()).observationsLastN(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

