/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r4;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoPatient;
import ca.uhn.fhir.jpa.provider.r4.JpaResourceProviderR4;
import ca.uhn.fhir.jpa.provider.r4.MemberMatcherR4Helper;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseJpaResourceProviderPatientR4
extends JpaResourceProviderR4<Patient> {
    @Autowired
    private MemberMatcherR4Helper myMemberMatcherR4Helper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$everything", idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider patientInstanceEverything(HttpServletRequest theServletRequest, @IdParam IdType theId, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count") UnsignedIntType theCount, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset") UnsignedIntType theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Description(shortDefinition="Filter the resources to return only resources matching the given _content filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_content", min=0, max=-1) List<StringType> theContent, @Description(shortDefinition="Filter the resources to return only resources matching the given _text filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_text", min=0, max=-1) List<StringType> theNarrative, @Description(shortDefinition="Filter the resources to return only resources matching the given _filter filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_filter", min=0, max=-1) List<StringType> theFilter, @Description(shortDefinition="Filter the resources to return only resources matching the given _type filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_type", min=0, max=-1) List<StringType> theTypes, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider iBundleProvider = ((IFhirResourceDaoPatient)this.getDao()).patientInstanceEverything(theServletRequest, (IIdType)theId, (IPrimitiveType)theCount, (IPrimitiveType)theOffset, theLastUpdated, theSortSpec, this.toStringAndList(theContent), this.toStringAndList(theNarrative), this.toStringAndList(theFilter), this.toStringAndList(theTypes), theRequestDetails);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$everything", idempotent=true, bundleType=BundleTypeEnum.SEARCHSET)
    public IBundleProvider patientTypeEverything(HttpServletRequest theServletRequest, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count") UnsignedIntType theCount, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset") UnsignedIntType theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Description(shortDefinition="Filter the resources to return only resources matching the given _content filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_content", min=0, max=-1) List<StringType> theContent, @Description(shortDefinition="Filter the resources to return only resources matching the given _text filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_text", min=0, max=-1) List<StringType> theNarrative, @Description(shortDefinition="Filter the resources to return only resources matching the given _filter filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_filter", min=0, max=-1) List<StringType> theFilter, @Description(shortDefinition="Filter the resources to return only resources matching the given _type filter (note that this filter is applied only to results which link to the given patient, not to the patient itself or to supporting resources linked to by the matched resources)") @OperationParam(name="_type", min=0, max=-1) List<StringType> theTypes, @Description(shortDefinition="Filter the resources to return based on the patient ids provided.") @OperationParam(name="_id", min=0, max=-1) List<IdType> theId, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider iBundleProvider = ((IFhirResourceDaoPatient)this.getDao()).patientTypeEverything(theServletRequest, (IPrimitiveType)theCount, (IPrimitiveType)theOffset, theLastUpdated, theSortSpec, this.toStringAndList(theContent), this.toStringAndList(theNarrative), this.toStringAndList(theFilter), this.toStringAndList(theTypes), theRequestDetails, this.toFlattenedPatientIdTokenParamList(theId));
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    @Operation(name="$member-match", idempotent=false, returnParameters={@OperationParam(name="MemberIdentifier", typeName="string")})
    public Parameters patientMemberMatch(HttpServletRequest theServletRequest, @Description(shortDefinition="The target of the operation. Will be returned with Identifier for matched coverage added.") @OperationParam(name="MemberPatient", min=1, max=1) Patient theMemberPatient, @Description(shortDefinition="Old coverage information as extracted from beneficiary's card.") @OperationParam(name="OldCoverage", min=1, max=1) Coverage oldCoverage, @Description(shortDefinition="New Coverage information. Provided as a reference. Optionally returned unmodified.") @OperationParam(name="NewCoverage", min=1, max=1) Coverage newCoverage, RequestDetails theRequestDetails) {
        return this.doMemberMatchOperation(theServletRequest, theMemberPatient, oldCoverage, newCoverage, theRequestDetails);
    }

    private Parameters doMemberMatchOperation(HttpServletRequest theServletRequest, Patient theMemberPatient, Coverage theCoverageToMatch, Coverage theCoverageToLink, RequestDetails theRequestDetails) {
        this.validateParams(theMemberPatient, theCoverageToMatch, theCoverageToLink);
        Optional<Coverage> coverageOpt = this.myMemberMatcherR4Helper.findMatchingCoverage(theCoverageToMatch);
        if (!coverageOpt.isPresent()) {
            String i18nMessage = this.getContext().getLocalizer().getMessage("operation.member.match.error.coverage.not.found", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)1155) + i18nMessage);
        }
        Coverage coverage = coverageOpt.get();
        Optional<Patient> patientOpt = this.myMemberMatcherR4Helper.getBeneficiaryPatient(coverage);
        if (!patientOpt.isPresent()) {
            String i18nMessage = this.getContext().getLocalizer().getMessage("operation.member.match.error.beneficiary.not.found", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)1156) + i18nMessage);
        }
        Patient patient = patientOpt.get();
        if (patient.getIdentifier().isEmpty()) {
            String i18nMessage = this.getContext().getLocalizer().getMessage("operation.member.match.error.beneficiary.without.identifier", new Object[0]);
            throw new UnprocessableEntityException(Msg.code((int)1157) + i18nMessage);
        }
        this.myMemberMatcherR4Helper.addMemberIdentifierToMemberPatient(theMemberPatient, patient.getIdentifierFirstRep());
        return this.myMemberMatcherR4Helper.buildSuccessReturnParameters(theMemberPatient, theCoverageToLink);
    }

    private void validateParams(Patient theMemberPatient, Coverage theOldCoverage, Coverage theNewCoverage) {
        this.validateParam(theMemberPatient, "MemberPatient");
        this.validateParam(theOldCoverage, "OldCoverage");
        this.validateParam(theNewCoverage, "NewCoverage");
    }

    private void validateParam(Object theParam, String theParamName) {
        if (theParam == null) {
            String i18nMessage = this.getContext().getLocalizer().getMessage("operation.member.match.error.missing.parameter", new Object[]{theParamName});
            throw new UnprocessableEntityException(Msg.code((int)1158) + i18nMessage);
        }
    }

    private TokenOrListParam toFlattenedPatientIdTokenParamList(List<IdType> theId) {
        TokenOrListParam retVal = new TokenOrListParam();
        if (theId != null) {
            for (IdType next : theId) {
                if (!StringUtils.isNotBlank((CharSequence)next.getValue())) continue;
                String[] split = next.getValueAsString().split(",");
                Arrays.stream(split).map(IdType::new).forEach(id -> retVal.addOr(new TokenParam(id.getIdPart())));
            }
        }
        return retVal.getValuesAsQueryTokens().isEmpty() ? null : retVal;
    }

    private StringAndListParam toStringAndList(List<StringType> theNarrative) {
        StringAndListParam retVal = new StringAndListParam();
        if (theNarrative != null) {
            for (StringType next : theNarrative) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)next.getValue()))) continue;
                retVal.addAnd(new StringOrListParam().addOr(new StringParam((String)next.getValue())));
            }
        }
        if (retVal.getValuesAsQueryTokens().isEmpty()) {
            return null;
        }
        return retVal;
    }
}

