/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider.r5;

import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoConceptMap;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.provider.r5.JpaResourceProviderR5;
import ca.uhn.fhir.jpa.term.TermConceptMappingSvcImpl;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.StringType;

public class BaseJpaResourceProviderConceptMapR5
extends JpaResourceProviderR5<ConceptMap> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$translate", idempotent=true, returnParameters={@OperationParam(name="result", type=BooleanType.class, min=1, max=1), @OperationParam(name="message", type=StringType.class, min=0, max=1)})
    public org.hl7.fhir.r5.model.Parameters translate(HttpServletRequest theServletRequest, @IdParam(optional=true) IdType theId, @OperationParam(name="url", min=0, max=1) org.hl7.fhir.r5.model.UriType theUrl, @OperationParam(name="conceptMapVersion", min=0, max=1) StringType theConceptMapVersion, @OperationParam(name="code", min=0, max=1) org.hl7.fhir.r5.model.CodeType theSourceCode, @OperationParam(name="system", min=0, max=1) org.hl7.fhir.r5.model.UriType theSourceCodeSystem, @OperationParam(name="version", min=0, max=1) StringType theSourceCodeSystemVersion, @OperationParam(name="source", min=0, max=1) org.hl7.fhir.r5.model.UriType theSourceValueSet, @OperationParam(name="coding", min=0, max=1) Coding theSourceCoding, @OperationParam(name="codeableConcept", min=0, max=1) CodeableConcept theSourceCodeableConcept, @OperationParam(name="target", min=0, max=1) org.hl7.fhir.r5.model.UriType theTargetValueSet, @OperationParam(name="targetsystem", min=0, max=1) org.hl7.fhir.r5.model.UriType theTargetCodeSystem, @OperationParam(name="reverse", min=0, max=1) BooleanType theReverse, RequestDetails theRequestDetails) {
        boolean haveId;
        boolean haveUrl = theUrl != null && theUrl.hasValue();
        boolean haveConceptMapVersion = theConceptMapVersion != null && theConceptMapVersion.hasValue();
        boolean haveSourceCode = theSourceCode != null && theSourceCode.hasCode();
        boolean haveSourceCodeSystem = theSourceCodeSystem != null && theSourceCodeSystem.hasValue();
        boolean haveSourceCodeSystemVersion = theSourceCodeSystemVersion != null && theSourceCodeSystemVersion.hasValue();
        boolean haveSourceValueSet = theSourceValueSet != null && theSourceValueSet.hasValue();
        boolean haveSourceCoding = theSourceCoding != null && theSourceCoding.hasCode();
        boolean haveSourceCodeableConcept = theSourceCodeableConcept != null && theSourceCodeableConcept.hasCoding() && theSourceCodeableConcept.getCodingFirstRep().hasCode();
        boolean haveTargetValueSet = theTargetValueSet != null && theTargetValueSet.hasValue();
        boolean haveTargetCodeSystem = theTargetCodeSystem != null && theTargetCodeSystem.hasValue();
        boolean haveReverse = theReverse != null;
        boolean bl = haveId = theId != null && theId.hasIdPart();
        if (!haveSourceCode && !haveSourceCoding && !haveSourceCodeableConcept || BaseJpaResourceProviderConceptMapR5.moreThanOneTrue(haveSourceCode, haveSourceCoding, haveSourceCodeableConcept)) {
            throw new InvalidRequestException(Msg.code((int)1161) + "One (and only one) of the in parameters (code, coding, codeableConcept) must be provided, to identify the code that is to be translated.");
        }
        TranslationRequest translationRequest = new TranslationRequest();
        if (haveUrl) {
            translationRequest.setUrl((UriType)VersionConvertorFactory_40_50.convertType((DataType)theUrl, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        }
        if (haveConceptMapVersion) {
            translationRequest.setConceptMapVersion((org.hl7.fhir.r4.model.StringType)VersionConvertorFactory_40_50.convertType((DataType)theConceptMapVersion, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        }
        if (haveSourceCode) {
            translationRequest.getCodeableConcept().addCoding().setCodeElement((CodeType)VersionConvertorFactory_40_50.convertType((DataType)theSourceCode, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
            if (haveSourceCodeSystem) {
                translationRequest.getCodeableConcept().getCodingFirstRep().setSystemElement((UriType)VersionConvertorFactory_40_50.convertType((DataType)theSourceCodeSystem, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
            }
            if (haveSourceCodeSystemVersion) {
                translationRequest.getCodeableConcept().getCodingFirstRep().setVersionElement((org.hl7.fhir.r4.model.StringType)VersionConvertorFactory_40_50.convertType((DataType)theSourceCodeSystemVersion, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
            }
        } else if (haveSourceCoding) {
            translationRequest.getCodeableConcept().addCoding((org.hl7.fhir.r4.model.Coding)VersionConvertorFactory_40_50.convertType((DataType)theSourceCoding, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        } else {
            translationRequest.setCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)VersionConvertorFactory_40_50.convertType((DataType)theSourceCodeableConcept, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        }
        if (haveSourceValueSet) {
            translationRequest.setSource((UriType)VersionConvertorFactory_40_50.convertType((DataType)theSourceValueSet, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        }
        if (haveTargetValueSet) {
            translationRequest.setTarget((UriType)VersionConvertorFactory_40_50.convertType((DataType)theTargetValueSet, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        }
        if (haveTargetCodeSystem) {
            translationRequest.setTargetSystem((UriType)VersionConvertorFactory_40_50.convertType((DataType)theTargetCodeSystem, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        }
        if (haveReverse) {
            translationRequest.setReverse((org.hl7.fhir.r4.model.BooleanType)VersionConvertorFactory_40_50.convertType((DataType)theReverse, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        }
        if (haveId) {
            translationRequest.setResourceId(theId.getIdPartAsLong());
        }
        this.startRequest(theServletRequest);
        try {
            IFhirResourceDaoConceptMap dao = (IFhirResourceDaoConceptMap)this.getDao();
            TranslateConceptResults result = dao.translate(translationRequest, theRequestDetails);
            Parameters parameters = TermConceptMappingSvcImpl.toParameters(result);
            org.hl7.fhir.r5.model.Parameters parameters2 = (org.hl7.fhir.r5.model.Parameters)VersionConvertorFactory_40_50.convertResource((Resource)parameters, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
            return parameters2;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }

    private static boolean moreThanOneTrue(boolean ... theBooleans) {
        boolean haveOne = false;
        for (boolean next : theBooleans) {
            if (!next) continue;
            if (haveOne) {
                return true;
            }
            haveOne = true;
        }
        return false;
    }
}

