/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.reindex;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.pid.EmptyResourcePidList;
import ca.uhn.fhir.jpa.api.pid.HomogeneousResourcePidList;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.MixedResourcePidList;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.util.DateRangeUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.annotation.Transactional;

public class Batch2DaoSvcImpl
implements IBatch2DaoSvc {
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myFhirContext;

    public boolean isAllResourceTypeSupported() {
        return true;
    }

    @Transactional
    public IResourcePidList fetchResourceIdsPage(Date theStart, Date theEnd, @Nonnull Integer thePageSize, @Nullable RequestPartitionId theRequestPartitionId, @Nullable String theUrl) {
        if (theUrl == null) {
            return this.fetchResourceIdsPageNoUrl(theStart, theEnd, thePageSize, theRequestPartitionId);
        }
        return this.fetchResourceIdsPageWithUrl(theStart, theEnd, thePageSize, theUrl, theRequestPartitionId);
    }

    private IResourcePidList fetchResourceIdsPageWithUrl(Date theStart, Date theEnd, int thePageSize, String theUrl, RequestPartitionId theRequestPartitionId) {
        String resourceType = theUrl.substring(0, theUrl.indexOf(63));
        RuntimeResourceDefinition def = this.myFhirContext.getResourceDefinition(resourceType);
        SearchParameterMap searchParamMap = this.myMatchUrlService.translateMatchUrl(theUrl, def, new MatchUrlService.Flag[0]);
        searchParamMap.setSort(new SortSpec("_lastUpdated", SortOrderEnum.ASC));
        DateRangeParam chunkDateRange = DateRangeUtil.narrowDateRange((DateRangeParam)searchParamMap.getLastUpdated(), (Date)theStart, (Date)theEnd);
        searchParamMap.setLastUpdated(chunkDateRange);
        searchParamMap.setCount(Integer.valueOf(thePageSize));
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        SystemRequestDetails request = new SystemRequestDetails();
        request.setRequestPartitionId(theRequestPartitionId);
        List ids = dao.searchForIds(searchParamMap, (RequestDetails)request);
        Date lastDate = null;
        if (ids.size() > 0) {
            lastDate = dao.readByPid((ResourcePersistentId)ids.get(ids.size() - 1)).getMeta().getLastUpdated();
        }
        return new HomogeneousResourcePidList(resourceType, (Collection)ids, lastDate);
    }

    @Nonnull
    private IResourcePidList fetchResourceIdsPageNoUrl(Date theStart, Date theEnd, int thePagesize, RequestPartitionId theRequestPartitionId) {
        Pageable page = Pageable.ofSize((int)thePagesize);
        Slice<Object[]> slice = theRequestPartitionId == null || theRequestPartitionId.isAllPartitions() ? this.myResourceTableDao.findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldest(page, theStart, theEnd) : (theRequestPartitionId.isDefaultPartition() ? this.myResourceTableDao.findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForDefaultPartition(page, theStart, theEnd) : this.myResourceTableDao.findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForPartitionIds(page, theStart, theEnd, theRequestPartitionId.getPartitionIds()));
        List content = slice.getContent();
        if (content.isEmpty()) {
            return new EmptyResourcePidList();
        }
        List ids = content.stream().map(t -> new ResourcePersistentId(t[0])).collect(Collectors.toList());
        List types = content.stream().map(t -> (String)t[1]).collect(Collectors.toList());
        Date lastDate = (Date)((Object[])content.get(content.size() - 1))[2];
        return new MixedResourcePidList(types, ids, lastDate);
    }
}

