/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.dstu3;

import ca.uhn.fhir.jpa.provider.dstu3.JpaResourceProviderDstu3;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.dstu3.model.Condition;

public class ConditionResourceProvider
extends JpaResourceProviderDstu3<Condition> {
    public Class<Condition> getResourceType() {
        return Condition.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Abatement as age or age range") @OptionalParam(name="abatement-age") QuantityAndListParam theAbatement_age, @Description(shortDefinition="Abatement boolean (boolean is true or non-boolean values are present)") @OptionalParam(name="abatement-boolean") TokenAndListParam theAbatement_boolean, @Description(shortDefinition="Date-related abatements (dateTime and period)") @OptionalParam(name="abatement-date") DateRangeParam theAbatement_date, @Description(shortDefinition="Abatement as a string") @OptionalParam(name="abatement-string") StringAndListParam theAbatement_string, @Description(shortDefinition="Date record was believed accurate") @OptionalParam(name="asserted-date") DateRangeParam theAsserted_date, @Description(shortDefinition="Person who asserts this condition") @OptionalParam(name="asserter", targetTypes={}) ReferenceAndListParam theAsserter, @Description(shortDefinition="Anatomical location, if relevant") @OptionalParam(name="body-site") TokenAndListParam theBody_site, @Description(shortDefinition="The category of the condition") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="The clinical status of the condition") @OptionalParam(name="clinical-status") TokenAndListParam theClinical_status, @Description(shortDefinition="Code for the condition") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Encounter or episode when condition first asserted") @OptionalParam(name="context", targetTypes={}) ReferenceAndListParam theContext, @Description(shortDefinition="Encounter when condition first asserted") @OptionalParam(name="encounter", targetTypes={}) ReferenceAndListParam theEncounter, @Description(shortDefinition="Manifestation/symptom") @OptionalParam(name="evidence") TokenAndListParam theEvidence, @Description(shortDefinition="Supporting information found elsewhere") @OptionalParam(name="evidence-detail", targetTypes={}) ReferenceAndListParam theEvidence_detail, @Description(shortDefinition="A unique identifier of the condition record") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Onsets as age or age range") @OptionalParam(name="onset-age") QuantityAndListParam theOnset_age, @Description(shortDefinition="Date related onsets (dateTime and Period)") @OptionalParam(name="onset-date") DateRangeParam theOnset_date, @Description(shortDefinition="Onsets as a string") @OptionalParam(name="onset-info") StringAndListParam theOnset_info, @Description(shortDefinition="Who has the condition?") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="The severity of the condition") @OptionalParam(name="severity") TokenAndListParam theSeverity, @Description(shortDefinition="Simple summary (disease specific)") @OptionalParam(name="stage") TokenAndListParam theStage, @Description(shortDefinition="Who has the condition?") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @Description(shortDefinition="provisional | differential | confirmed | refuted | entered-in-error | unknown") @OptionalParam(name="verification-status") TokenAndListParam theVerification_status, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("abatement-age", (IQueryParameterAnd)theAbatement_age);
            paramMap.add("abatement-boolean", (IQueryParameterAnd)theAbatement_boolean);
            paramMap.add("abatement-date", (IQueryParameterAnd)theAbatement_date);
            paramMap.add("abatement-string", (IQueryParameterAnd)theAbatement_string);
            paramMap.add("asserted-date", (IQueryParameterAnd)theAsserted_date);
            paramMap.add("asserter", (IQueryParameterAnd)theAsserter);
            paramMap.add("body-site", (IQueryParameterAnd)theBody_site);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("clinical-status", (IQueryParameterAnd)theClinical_status);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("context", (IQueryParameterAnd)theContext);
            paramMap.add("encounter", (IQueryParameterAnd)theEncounter);
            paramMap.add("evidence", (IQueryParameterAnd)theEvidence);
            paramMap.add("evidence-detail", (IQueryParameterAnd)theEvidence_detail);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("onset-age", (IQueryParameterAnd)theOnset_age);
            paramMap.add("onset-date", (IQueryParameterAnd)theOnset_date);
            paramMap.add("onset-info", (IQueryParameterAnd)theOnset_info);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("severity", (IQueryParameterAnd)theSeverity);
            paramMap.add("stage", (IQueryParameterAnd)theStage);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.add("verification-status", (IQueryParameterAnd)theVerification_status);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

