/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.dstu3;

import ca.uhn.fhir.jpa.provider.dstu3.JpaResourceProviderDstu3;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.dstu3.model.Medication;

public class MedicationResourceProvider
extends JpaResourceProviderDstu3<Medication> {
    public Class<Medication> getResourceType() {
        return Medication.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Codes that identify this medication") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="E.g. box, vial, blister-pack") @OptionalParam(name="container") TokenAndListParam theContainer, @Description(shortDefinition="powder | tablets | capsule +") @OptionalParam(name="form") TokenAndListParam theForm, @Description(shortDefinition="The product contained") @OptionalParam(name="ingredient", targetTypes={}) ReferenceAndListParam theIngredient, @Description(shortDefinition="The product contained") @OptionalParam(name="ingredient-code") TokenAndListParam theIngredient_code, @Description(shortDefinition="Manufacturer of the item") @OptionalParam(name="manufacturer", targetTypes={}) ReferenceAndListParam theManufacturer, @Description(shortDefinition="True if medication does not require a prescription") @OptionalParam(name="over-the-counter") TokenAndListParam theOver_the_counter, @Description(shortDefinition="The item in the package") @OptionalParam(name="package-item", targetTypes={}) ReferenceAndListParam thePackage_item, @Description(shortDefinition="The item in the package") @OptionalParam(name="package-item-code") TokenAndListParam thePackage_item_code, @Description(shortDefinition="active | inactive | entered-in-error") @OptionalParam(name="status") TokenAndListParam theStatus, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("container", (IQueryParameterAnd)theContainer);
            paramMap.add("form", (IQueryParameterAnd)theForm);
            paramMap.add("ingredient", (IQueryParameterAnd)theIngredient);
            paramMap.add("ingredient-code", (IQueryParameterAnd)theIngredient_code);
            paramMap.add("manufacturer", (IQueryParameterAnd)theManufacturer);
            paramMap.add("over-the-counter", (IQueryParameterAnd)theOver_the_counter);
            paramMap.add("package-item", (IQueryParameterAnd)thePackage_item);
            paramMap.add("package-item-code", (IQueryParameterAnd)thePackage_item_code);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

