/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.dstu3;

import ca.uhn.fhir.jpa.provider.dstu3.JpaResourceProviderDstu3;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.dstu3.model.ReferralRequest;

public class ReferralRequestResourceProvider
extends JpaResourceProviderDstu3<ReferralRequest> {
    public Class<ReferralRequest> getResourceType() {
        return ReferralRequest.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Creation or activation date") @OptionalParam(name="authored-on") DateRangeParam theAuthored_on, @Description(shortDefinition="Request being fulfilled") @OptionalParam(name="based-on", targetTypes={}) ReferenceAndListParam theBased_on, @Description(shortDefinition="Part of encounter or episode of care") @OptionalParam(name="context", targetTypes={}) ReferenceAndListParam theContext, @Description(shortDefinition="Instantiates protocol or definition") @OptionalParam(name="definition", targetTypes={}) ReferenceAndListParam theDefinition, @Description(shortDefinition="Originating encounter") @OptionalParam(name="encounter", targetTypes={}) ReferenceAndListParam theEncounter, @Description(shortDefinition="Part of common request") @OptionalParam(name="group-identifier") TokenAndListParam theGroup_identifier, @Description(shortDefinition="Business identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Proposal, plan or order") @OptionalParam(name="intent") TokenAndListParam theIntent, @Description(shortDefinition="When the service(s) requested in the referral should occur") @OptionalParam(name="occurrence-date") DateRangeParam theOccurrence_date, @Description(shortDefinition="Who the referral is about") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="The priority assigned to the referral") @OptionalParam(name="priority") TokenAndListParam thePriority, @Description(shortDefinition="The person that the referral was sent to") @OptionalParam(name="recipient", targetTypes={}) ReferenceAndListParam theRecipient, @Description(shortDefinition="Request(s) replaced by this request") @OptionalParam(name="replaces", targetTypes={}) ReferenceAndListParam theReplaces, @Description(shortDefinition="Individual making the request") @OptionalParam(name="requester", targetTypes={}) ReferenceAndListParam theRequester, @Description(shortDefinition="Actions requested as part of the referral") @OptionalParam(name="service") TokenAndListParam theService, @Description(shortDefinition="The specialty that the referral is for") @OptionalParam(name="specialty") TokenAndListParam theSpecialty, @Description(shortDefinition="The status of the referral") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="Patient referred to care or transfer") @OptionalParam(name="subject", targetTypes={}) ReferenceAndListParam theSubject, @Description(shortDefinition="The type of the referral") @OptionalParam(name="type") TokenAndListParam theType, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("authored-on", (IQueryParameterAnd)theAuthored_on);
            paramMap.add("based-on", (IQueryParameterAnd)theBased_on);
            paramMap.add("context", (IQueryParameterAnd)theContext);
            paramMap.add("definition", (IQueryParameterAnd)theDefinition);
            paramMap.add("encounter", (IQueryParameterAnd)theEncounter);
            paramMap.add("group-identifier", (IQueryParameterAnd)theGroup_identifier);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("intent", (IQueryParameterAnd)theIntent);
            paramMap.add("occurrence-date", (IQueryParameterAnd)theOccurrence_date);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("priority", (IQueryParameterAnd)thePriority);
            paramMap.add("recipient", (IQueryParameterAnd)theRecipient);
            paramMap.add("replaces", (IQueryParameterAnd)theReplaces);
            paramMap.add("requester", (IQueryParameterAnd)theRequester);
            paramMap.add("service", (IQueryParameterAnd)theService);
            paramMap.add("specialty", (IQueryParameterAnd)theSpecialty);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("subject", (IQueryParameterAnd)theSubject);
            paramMap.add("type", (IQueryParameterAnd)theType);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

