/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.r5.JpaResourceProviderR5;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeAndListParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.r5.model.Citation;

public class CitationResourceProvider
extends JpaResourceProviderR5<Citation> {
    public Class<Citation> getResourceType() {
        return Citation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="A use context assigned to the citation") @OptionalParam(name="context") TokenAndListParam theContext, @Description(shortDefinition="A quantity- or range-valued use context assigned to the citation") @OptionalParam(name="context-quantity") QuantityAndListParam theContext_quantity, @Description(shortDefinition="A type of use context assigned to the citation") @OptionalParam(name="context-type") TokenAndListParam theContext_type, @Description(shortDefinition="A use context type and quantity- or range-based value assigned to the citation") @OptionalParam(name="context-type-quantity", compositeTypes={TokenParam.class, QuantityParam.class}) CompositeAndListParam<TokenParam, QuantityParam> theContext_type_quantity, @Description(shortDefinition="A use context type and value assigned to the citation") @OptionalParam(name="context-type-value", compositeTypes={TokenParam.class, TokenParam.class}) CompositeAndListParam<TokenParam, TokenParam> theContext_type_value, @Description(shortDefinition="The citation publication date") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="The description of the citation") @OptionalParam(name="description") StringAndListParam theDescription, @Description(shortDefinition="The time during which the citation is intended to be in use") @OptionalParam(name="effective") DateRangeParam theEffective, @Description(shortDefinition="External identifier for the citation") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Intended jurisdiction for the citation") @OptionalParam(name="jurisdiction") TokenAndListParam theJurisdiction, @Description(shortDefinition="Computationally friendly name of the citation") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="Name of the publisher of the citation") @OptionalParam(name="publisher") StringAndListParam thePublisher, @Description(shortDefinition="The current status of the citation") @OptionalParam(name="status") TokenAndListParam theStatus, @Description(shortDefinition="The human-friendly name of the citation") @OptionalParam(name="title") StringAndListParam theTitle, @Description(shortDefinition="The uri that identifies the citation") @OptionalParam(name="url") UriAndListParam theUrl, @Description(shortDefinition="The business version of the citation") @OptionalParam(name="version") TokenAndListParam theVersion, @RawParam Map<String, List<String>> theAdditionalRawParams, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam theLastUpdated, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        this.startRequest(theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("context", (IQueryParameterAnd)theContext);
            paramMap.add("context-quantity", (IQueryParameterAnd)theContext_quantity);
            paramMap.add("context-type", (IQueryParameterAnd)theContext_type);
            paramMap.add("context-type-quantity", theContext_type_quantity);
            paramMap.add("context-type-value", theContext_type_value);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("description", (IQueryParameterAnd)theDescription);
            paramMap.add("effective", (IQueryParameterAnd)theEffective);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("jurisdiction", (IQueryParameterAnd)theJurisdiction);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("publisher", (IQueryParameterAnd)thePublisher);
            paramMap.add("status", (IQueryParameterAnd)theStatus);
            paramMap.add("title", (IQueryParameterAnd)theTitle);
            paramMap.add("url", (IQueryParameterAnd)theUrl);
            paramMap.add("version", (IQueryParameterAnd)theVersion);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(theLastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            this.endRequest(theServletRequest);
        }
    }
}

