/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchInclude;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.interceptor.JpaPreResourceAccessDetails;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.ISynchronousSearchSvc;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProvider;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProviderFactory;
import ca.uhn.fhir.jpa.search.PersistedJpaSearchFirstPageBundleProvider;
import ca.uhn.fhir.jpa.search.SearchStrategyFactory;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.search.cache.ISearchResultCacheSvc;
import ca.uhn.fhir.jpa.search.cache.SearchCacheStatusEnum;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.SearchParameterMapCalculator;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.method.PageMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ICachedSearchDetails;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.AsyncUtil;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import co.elastic.apm.api.ElasticApm;
import co.elastic.apm.api.Span;
import co.elastic.apm.api.Transaction;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.AbstractPageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="mySearchCoordinatorSvc")
public class SearchCoordinatorSvcImpl
implements ISearchCoordinatorSvc {
    public static final int DEFAULT_SYNC_SIZE = 250;
    public static final String UNIT_TEST_CAPTURE_STACK = "unit_test_capture_stack";
    private static final Logger ourLog = LoggerFactory.getLogger(SearchCoordinatorSvcImpl.class);
    private final ConcurrentHashMap<String, SearchTask> myIdToSearchTask = new ConcurrentHashMap();
    @Autowired
    private FhirContext myContext;
    @Autowired
    private DaoConfig myDaoConfig;
    private Integer myLoadingThrottleForUnitTests = null;
    private long myMaxMillisToWaitForRemoteResults = 60000L;
    private boolean myNeverUseLocalSearchForUnitTests;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private PlatformTransactionManager myManagedTxManager;
    @Autowired
    private ISearchCacheSvc mySearchCacheSvc;
    @Autowired
    private ISearchResultCacheSvc mySearchResultCacheSvc;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IPagingProvider myPagingProvider;
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private ISynchronousSearchSvc mySynchronousSearchSvc;
    private int mySyncSize = 250;
    private boolean myCustomIsolationSupported;
    @Autowired
    private PersistedJpaBundleProviderFactory myPersistedJpaBundleProviderFactory;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private SearchStrategyFactory mySearchStrategyFactory;
    private StorageInterceptorHooks myStorageInterceptorHooks = new StorageInterceptorHooks();

    @Autowired
    public SearchCoordinatorSvcImpl() {
    }

    @VisibleForTesting
    Set<String> getActiveSearchIds() {
        return this.myIdToSearchTask.keySet();
    }

    @VisibleForTesting
    public void setSearchCacheServicesForUnitTest(ISearchCacheSvc theSearchCacheSvc, ISearchResultCacheSvc theSearchResultCacheSvc) {
        this.mySearchCacheSvc = theSearchCacheSvc;
        this.mySearchResultCacheSvc = theSearchResultCacheSvc;
    }

    @PostConstruct
    public void start() {
        JpaDialect jpaDialect;
        if (this.myManagedTxManager instanceof JpaTransactionManager && (jpaDialect = ((JpaTransactionManager)this.myManagedTxManager).getJpaDialect()) instanceof HibernateJpaDialect) {
            this.myCustomIsolationSupported = true;
        }
        if (!this.myCustomIsolationSupported) {
            ourLog.warn("JPA dialect does not support transaction isolation! This can have an impact on search performance.");
        }
    }

    public void cancelAllActiveSearches() {
        for (SearchTask next : this.myIdToSearchTask.values()) {
            ourLog.info("Requesting immediate abort of search: {}", (Object)next.getSearch().getUuid());
            next.requestImmediateAbort();
            AsyncUtil.awaitLatchAndIgnoreInterrupt((CountDownLatch)next.getCompletionLatch(), (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @VisibleForTesting
    void setMaxMillisToWaitForRemoteResultsForUnitTest(long theMaxMillisToWaitForRemoteResults) {
        this.myMaxMillisToWaitForRemoteResults = theMaxMillisToWaitForRemoteResults;
    }

    @Transactional(propagation=Propagation.NEVER)
    public List<ResourcePersistentId> getResources(String theUuid, int theFrom, int theTo, @Nullable RequestDetails theRequestDetails) {
        Search search;
        TransactionTemplate txTemplate = new TransactionTemplate(this.myManagedTxManager);
        txTemplate.setPropagationBehavior(0);
        SearchTask searchTask = this.myIdToSearchTask.get(theUuid);
        if (searchTask != null) {
            searchTask.awaitInitialSync();
        }
        ourLog.trace("About to start looking for resources {}-{}", (Object)theFrom, (Object)theTo);
        StopWatch sw = new StopWatch();
        while (true) {
            if (!this.myNeverUseLocalSearchForUnitTests && searchTask != null) {
                ourLog.trace("Local search found");
                List<ResourcePersistentId> resourcePids = searchTask.getResourcePids(theFrom, theTo);
                ourLog.trace("Local search returned {} pids, wanted {}-{} - Search: {}", new Object[]{resourcePids.size(), theFrom, theTo, searchTask.getSearch()});
                if (searchTask.getSearch().getNumFound() - searchTask.getSearch().getNumBlocked() >= theTo || resourcePids.size() == theTo - theFrom) {
                    return resourcePids;
                }
            }
            search = this.mySearchCacheSvc.fetchByUuid(theUuid).orElseThrow(() -> this.newResourceGoneException(theUuid));
            SearchCoordinatorSvcImpl.verifySearchHasntFailedOrThrowInternalErrorException(search);
            if (search.getStatus() == SearchStatusEnum.FINISHED) {
                ourLog.trace("Search entity marked as finished with {} results", (Object)search.getNumFound());
                break;
            }
            if (search.getNumFound() - search.getNumBlocked() >= theTo) {
                ourLog.trace("Search entity has {} results so far", (Object)search.getNumFound());
                break;
            }
            if (sw.getMillis() > this.myMaxMillisToWaitForRemoteResults) {
                ourLog.error("Search {} of type {} for {}{} timed out after {}ms", new Object[]{search.getId(), search.getSearchType(), search.getResourceType(), search.getSearchQueryString(), sw.getMillis()});
                throw new InternalErrorException(Msg.code((int)1163) + "Request timed out after " + sw.getMillis() + "ms");
            }
            if (search.getStatus() == SearchStatusEnum.PASSCMPLET) {
                ourLog.trace("Going to try to start next search");
                Optional<Search> newSearch = this.mySearchCacheSvc.tryToMarkSearchAsInProgress(search);
                if (newSearch.isPresent()) {
                    ourLog.trace("Launching new search");
                    search = newSearch.get();
                    String resourceType = search.getResourceType();
                    SearchParameterMap params = search.getSearchParameterMap().orElseThrow(() -> new IllegalStateException("No map in PASSCOMPLET search"));
                    IFhirResourceDao resourceDao = this.myDaoRegistry.getResourceDao(resourceType);
                    RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForSearchType(theRequestDetails, resourceType, params, null);
                    SearchContinuationTask task = new SearchContinuationTask(search, (IDao)resourceDao, params, resourceType, theRequestDetails, requestPartitionId);
                    this.myIdToSearchTask.put(search.getUuid(), task);
                    task.call();
                }
            }
            AsyncUtil.sleep((long)500L);
        }
        ourLog.trace("Finished looping");
        List<ResourcePersistentId> pids = this.mySearchResultCacheSvc.fetchResultPids(search, theFrom, theTo);
        if (pids == null) {
            throw this.newResourceGoneException(theUuid);
        }
        ourLog.trace("Fetched {} results", (Object)pids.size());
        return pids;
    }

    @Nonnull
    private ResourceGoneException newResourceGoneException(String theUuid) {
        ourLog.trace("Client requested unknown paging ID[{}]", (Object)theUuid);
        String msg = this.myContext.getLocalizer().getMessage(PageMethodBinding.class, "unknownSearchId", new Object[]{theUuid});
        return new ResourceGoneException(msg);
    }

    public IBundleProvider registerSearch(IFhirResourceDao<?> theCallingDao, SearchParameterMap theParams, String theResourceType, CacheControlDirective theCacheControlDirective, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        PersistedJpaBundleProvider foundSearchProvider;
        String searchUuid = UUID.randomUUID().toString();
        String queryString = theParams.toNormalizedQueryString(this.myContext);
        ourLog.debug("Registering new search {}", (Object)searchUuid);
        Search search = new Search();
        SearchCoordinatorSvcImpl.populateSearchEntity(theParams, theResourceType, searchUuid, queryString, search, theRequestPartitionId);
        this.myStorageInterceptorHooks.callStoragePresearchRegistered(theRequestDetails, theParams, search);
        this.validateSearch(theParams);
        Class resourceTypeClass = this.myContext.getResourceDefinition(theResourceType).getImplementingClass();
        ISearchBuilder sb = this.mySearchBuilderFactory.newSearchBuilder(theCallingDao, theResourceType, resourceTypeClass);
        sb.setFetchSize(this.mySyncSize);
        Integer loadSynchronousUpTo = this.getLoadSynchronousUpToOrNull(theCacheControlDirective);
        boolean isOffsetQuery = theParams.isOffsetQuery();
        if (this.mySearchStrategyFactory.isSupportsHSearchDirect(theResourceType, theParams, theRequestDetails)) {
            ourLog.info("Search {} is using direct load strategy", (Object)searchUuid);
            SearchStrategyFactory.ISearchStrategy direct = this.mySearchStrategyFactory.makeDirectStrategy(searchUuid, theResourceType, theParams, theRequestDetails);
            return (IBundleProvider)direct.get();
        }
        if (theParams.isLoadSynchronous() || loadSynchronousUpTo != null || isOffsetQuery) {
            ourLog.debug("Search {} is loading in synchronous mode", (Object)searchUuid);
            return this.mySynchronousSearchSvc.executeQuery(theParams, theRequestDetails, searchUuid, sb, loadSynchronousUpTo, theRequestPartitionId);
        }
        SearchCacheStatusEnum cacheStatus = SearchCacheStatusEnum.MISS;
        if (theCacheControlDirective != null && theCacheControlDirective.isNoCache()) {
            cacheStatus = SearchCacheStatusEnum.NOT_TRIED;
        }
        if (cacheStatus != SearchCacheStatusEnum.NOT_TRIED && theParams.getEverythingMode() == null && this.myDaoConfig.getReuseCachedSearchResultsForMillis() != null && (foundSearchProvider = this.findCachedQuery(theParams, theResourceType, theRequestDetails, queryString, theRequestPartitionId)) != null) {
            foundSearchProvider.setCacheStatus(SearchCacheStatusEnum.HIT);
            return foundSearchProvider;
        }
        PersistedJpaSearchFirstPageBundleProvider retVal = this.submitSearch((IDao)theCallingDao, theParams, theResourceType, theRequestDetails, searchUuid, sb, queryString, theRequestPartitionId, search);
        retVal.setCacheStatus(cacheStatus);
        return retVal;
    }

    private void validateSearch(SearchParameterMap theParams) {
        this.validateIncludes(theParams.getIncludes(), "_include");
        this.validateIncludes(theParams.getRevIncludes(), "_revinclude");
    }

    private void validateIncludes(Set<Include> includes, String name) {
        for (Include next : includes) {
            String value = next.getValue();
            if (value.equals("*") || StringUtils.isBlank((CharSequence)value)) continue;
            String paramType = next.getParamType();
            String paramName = next.getParamName();
            String paramTargetType = next.getParamTargetType();
            if (StringUtils.isBlank((CharSequence)paramType) || StringUtils.isBlank((CharSequence)paramName)) {
                String msg = this.myContext.getLocalizer().getMessageSanitized(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{name, value, ""});
                throw new InvalidRequestException(Msg.code((int)2018) + msg);
            }
            if (!this.myDaoRegistry.isResourceTypeSupported(paramType)) {
                String resourceTypeMsg = this.myContext.getLocalizer().getMessageSanitized(SearchCoordinatorSvcImpl.class, "invalidResourceType", new Object[]{paramType});
                String msg = this.myContext.getLocalizer().getMessage(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)name), UrlUtil.sanitizeUrlPart((CharSequence)value), resourceTypeMsg});
                throw new InvalidRequestException(Msg.code((int)2017) + msg);
            }
            if (StringUtils.isNotBlank((CharSequence)paramTargetType) && !this.myDaoRegistry.isResourceTypeSupported(paramTargetType)) {
                String resourceTypeMsg = this.myContext.getLocalizer().getMessageSanitized(SearchCoordinatorSvcImpl.class, "invalidResourceType", new Object[]{paramTargetType});
                String msg = this.myContext.getLocalizer().getMessage(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)name), UrlUtil.sanitizeUrlPart((CharSequence)value), resourceTypeMsg});
                throw new InvalidRequestException(Msg.code((int)2016) + msg);
            }
            if ("*".equals(paramName) || this.mySearchParamRegistry.getActiveSearchParam(paramType, paramName) != null) continue;
            List validNames = this.mySearchParamRegistry.getActiveSearchParams(paramType).values().stream().filter(t -> t.getParamType() == RestSearchParameterTypeEnum.REFERENCE).map(t -> UrlUtil.sanitizeUrlPart((CharSequence)t.getName())).sorted().collect(Collectors.toList());
            String searchParamMessage = this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidSearchParameter", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)paramName), UrlUtil.sanitizeUrlPart((CharSequence)paramType), validNames});
            String msg = this.myContext.getLocalizer().getMessage(SearchCoordinatorSvcImpl.class, "invalidInclude", new Object[]{UrlUtil.sanitizeUrlPart((CharSequence)name), UrlUtil.sanitizeUrlPart((CharSequence)value), searchParamMessage});
            throw new InvalidRequestException(Msg.code((int)2015) + msg);
        }
    }

    public Optional<Integer> getSearchTotal(String theUuid) {
        Optional<SearchParameterMap> searchParameterMap;
        SearchTask task = this.myIdToSearchTask.get(theUuid);
        if (task != null) {
            return Optional.ofNullable(task.awaitInitialSync());
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.myManagedTxManager);
        txTemplate.setPropagationBehavior(0);
        Optional<Search> search = this.mySearchCacheSvc.fetchByUuid(theUuid);
        if (search.isPresent() && (searchParameterMap = search.get().getSearchParameterMap()).isPresent() && searchParameterMap.get().getSearchTotalMode() == SearchTotalModeEnum.ACCURATE) {
            for (int i = 0; i < 10; ++i) {
                if (search.isPresent()) {
                    SearchCoordinatorSvcImpl.verifySearchHasntFailedOrThrowInternalErrorException(search.get());
                    if (search.get().getTotalCount() != null) {
                        return Optional.of(search.get().getTotalCount());
                    }
                }
                search = this.mySearchCacheSvc.fetchByUuid(theUuid);
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private PersistedJpaSearchFirstPageBundleProvider submitSearch(IDao theCallingDao, SearchParameterMap theParams, String theResourceType, RequestDetails theRequestDetails, String theSearchUuid, ISearchBuilder theSb, String theQueryString, RequestPartitionId theRequestPartitionId, Search theSearch) {
        StopWatch w = new StopWatch();
        SearchTask task = new SearchTask(theSearch, theCallingDao, theParams, theResourceType, theRequestDetails, theRequestPartitionId);
        this.myIdToSearchTask.put(theSearch.getUuid(), task);
        task.call();
        PersistedJpaSearchFirstPageBundleProvider retVal = this.myPersistedJpaBundleProviderFactory.newInstanceFirstPage(theRequestDetails, theSearch, task, theSb);
        ourLog.debug("Search initial phase completed in {}ms", (Object)w.getMillis());
        return retVal;
    }

    @Nullable
    private PersistedJpaBundleProvider findCachedQuery(SearchParameterMap theParams, String theResourceType, RequestDetails theRequestDetails, String theQueryString, RequestPartitionId theRequestPartitionId) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myManagedTxManager);
        return (PersistedJpaBundleProvider)txTemplate.execute(t -> {
            HookParams params = new HookParams().add(SearchParameterMap.class, (Object)theParams).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
            Object outcome = CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PRECHECK_FOR_CACHED_SEARCH, (HookParams)params);
            if (Boolean.FALSE.equals(outcome)) {
                return null;
            }
            Search searchToUse = this.findSearchToUseOrNull(theQueryString, theResourceType, theRequestPartitionId);
            if (searchToUse == null) {
                return null;
            }
            ourLog.debug("Reusing search {} from cache", (Object)searchToUse.getUuid());
            params = new HookParams().add(SearchParameterMap.class, (Object)theParams).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_REUSING_CACHED, (HookParams)params);
            return this.myPersistedJpaBundleProviderFactory.newInstance(theRequestDetails, searchToUse.getUuid());
        });
    }

    @Nullable
    private Search findSearchToUseOrNull(String theQueryString, String theResourceType, RequestPartitionId theRequestPartitionId) {
        Instant createdCutoff = Instant.now().minus(this.myDaoConfig.getReuseCachedSearchResultsForMillis(), ChronoUnit.MILLIS);
        Optional<Search> candidate = this.mySearchCacheSvc.findCandidatesForReuse(theResourceType, theQueryString, createdCutoff, theRequestPartitionId);
        return candidate.orElse(null);
    }

    @Nullable
    private Integer getLoadSynchronousUpToOrNull(CacheControlDirective theCacheControlDirective) {
        Integer loadSynchronousUpTo;
        if (theCacheControlDirective != null && theCacheControlDirective.isNoStore()) {
            if (theCacheControlDirective.getMaxResults() != null) {
                loadSynchronousUpTo = theCacheControlDirective.getMaxResults();
                if (loadSynchronousUpTo > this.myDaoConfig.getCacheControlNoStoreMaxResultsUpperLimit()) {
                    throw new InvalidRequestException(Msg.code((int)1165) + "Cache-Control header max-results value must not exceed " + this.myDaoConfig.getCacheControlNoStoreMaxResultsUpperLimit());
                }
            } else {
                loadSynchronousUpTo = 100;
            }
        } else {
            loadSynchronousUpTo = null;
        }
        return loadSynchronousUpTo;
    }

    @VisibleForTesting
    void setContextForUnitTest(FhirContext theCtx) {
        this.myContext = theCtx;
    }

    @VisibleForTesting
    void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    @VisibleForTesting
    public void setLoadingThrottleForUnitTests(Integer theLoadingThrottleForUnitTests) {
        this.myLoadingThrottleForUnitTests = theLoadingThrottleForUnitTests;
    }

    @VisibleForTesting
    public void setNeverUseLocalSearchForUnitTests(boolean theNeverUseLocalSearchForUnitTests) {
        this.myNeverUseLocalSearchForUnitTests = theNeverUseLocalSearchForUnitTests;
    }

    @VisibleForTesting
    public void setSyncSizeForUnitTests(int theSyncSize) {
        this.mySyncSize = theSyncSize;
    }

    @VisibleForTesting
    void setTransactionManagerForUnitTest(PlatformTransactionManager theTxManager) {
        this.myManagedTxManager = theTxManager;
    }

    @VisibleForTesting
    void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @VisibleForTesting
    void setInterceptorBroadcasterForUnitTest(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setSearchBuilderFactoryForUnitTest(SearchBuilderFactory theSearchBuilderFactory) {
        this.mySearchBuilderFactory = theSearchBuilderFactory;
    }

    @VisibleForTesting
    public void setPersistedJpaBundleProviderFactoryForUnitTest(PersistedJpaBundleProviderFactory thePersistedJpaBundleProviderFactory) {
        this.myPersistedJpaBundleProviderFactory = thePersistedJpaBundleProviderFactory;
    }

    @VisibleForTesting
    public void setRequestPartitionHelperService(IRequestPartitionHelperSvc theRequestPartitionHelperService) {
        this.myRequestPartitionHelperService = theRequestPartitionHelperService;
    }

    @VisibleForTesting
    public void setSynchronousSearchSvc(ISynchronousSearchSvc theSynchronousSearchSvc) {
        this.mySynchronousSearchSvc = theSynchronousSearchSvc;
    }

    public static void populateSearchEntity(SearchParameterMap theParams, String theResourceType, String theSearchUuid, String theQueryString, Search theSearch, RequestPartitionId theRequestPartitionId) {
        theSearch.setDeleted(false);
        theSearch.setUuid(theSearchUuid);
        theSearch.setCreated(new Date());
        theSearch.setTotalCount(null);
        theSearch.setNumFound(0);
        theSearch.setPreferredPageSize(theParams.getCount());
        theSearch.setSearchType(theParams.getEverythingMode() != null ? SearchTypeEnum.EVERYTHING : SearchTypeEnum.SEARCH);
        theSearch.setLastUpdated(theParams.getLastUpdated());
        theSearch.setResourceType(theResourceType);
        theSearch.setStatus(SearchStatusEnum.LOADING);
        theSearch.setSearchQueryString(theQueryString, theRequestPartitionId);
        if (theParams.hasIncludes()) {
            for (Include next : theParams.getIncludes()) {
                theSearch.addInclude(new SearchInclude(theSearch, next.getValue(), false, next.isRecurse()));
            }
        }
        for (Include next : theParams.getRevIncludes()) {
            theSearch.addInclude(new SearchInclude(theSearch, next.getValue(), true, next.isRecurse()));
        }
    }

    @Nullable
    public static Pageable toPage(final int theFromIndex, int theToIndex) {
        int pageSize = theToIndex - theFromIndex;
        if (pageSize < 1) {
            return null;
        }
        int pageIndex = theFromIndex / pageSize;
        AbstractPageRequest page = new AbstractPageRequest(pageIndex, pageSize){
            private static final long serialVersionUID = 1L;

            public long getOffset() {
                return theFromIndex;
            }

            public Sort getSort() {
                return Sort.unsorted();
            }

            public Pageable next() {
                return null;
            }

            public Pageable previous() {
                return null;
            }

            public Pageable first() {
                return null;
            }

            public Pageable withPage(int theI) {
                return null;
            }
        };
        return page;
    }

    static void verifySearchHasntFailedOrThrowInternalErrorException(Search theSearch) {
        if (theSearch.getStatus() == SearchStatusEnum.FAILED) {
            Integer status = theSearch.getFailureCode();
            status = (Integer)ObjectUtils.defaultIfNull((Object)status, (Object)500);
            String message = theSearch.getFailureMessage();
            throw BaseServerResponseException.newInstance((int)status, (String)message);
        }
    }

    public class StorageInterceptorHooks {
        private void callStoragePresearchRegistered(RequestDetails theRequestDetails, SearchParameterMap theParams, Search search) {
            HookParams params = new HookParams().add(ICachedSearchDetails.class, (Object)search).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(SearchParameterMap.class, (Object)theParams);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchCoordinatorSvcImpl.this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PRESEARCH_REGISTERED, (HookParams)params);
        }
    }

    public class SearchTask
    implements Callable<Void> {
        private final SearchParameterMap myParams;
        private final IDao myCallingDao;
        private final String myResourceType;
        private final ArrayList<ResourcePersistentId> mySyncedPids = new ArrayList();
        private final CountDownLatch myInitialCollectionLatch = new CountDownLatch(1);
        private final CountDownLatch myCompletionLatch;
        private final ArrayList<ResourcePersistentId> myUnsyncedPids = new ArrayList();
        private final RequestDetails myRequest;
        private final RequestPartitionId myRequestPartitionId;
        private final SearchRuntimeDetails mySearchRuntimeDetails;
        private final Transaction myParentTransaction;
        private Search mySearch;
        private boolean myAbortRequested;
        private int myCountSavedTotal = 0;
        private int myCountSavedThisPass = 0;
        private int myCountBlockedThisPass = 0;
        private boolean myAdditionalPrefetchThresholdsRemaining;
        private List<ResourcePersistentId> myPreviouslyAddedResourcePids;
        private Integer myMaxResultsToFetch;

        protected SearchTask(Search theSearch, IDao theCallingDao, SearchParameterMap theParams, String theResourceType, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
            this.mySearch = theSearch;
            this.myCallingDao = theCallingDao;
            this.myParams = theParams;
            this.myResourceType = theResourceType;
            this.myCompletionLatch = new CountDownLatch(1);
            this.mySearchRuntimeDetails = new SearchRuntimeDetails(theRequest, this.mySearch.getUuid());
            this.mySearchRuntimeDetails.setQueryString(theParams.toNormalizedQueryString(theCallingDao.getContext()));
            this.myRequestPartitionId = theRequestPartitionId;
            this.myRequest = theRequest;
            this.myParentTransaction = ElasticApm.currentTransaction();
        }

        Integer awaitInitialSync() {
            ourLog.trace("Awaiting initial sync");
            do {
                ourLog.trace("Search {} aborted: {}", (Object)this.getSearch().getUuid(), (Object)(!this.isNotAborted() ? 1 : 0));
            } while (!AsyncUtil.awaitLatchAndThrowInternalErrorExceptionOnInterrupt((CountDownLatch)this.getInitialCollectionLatch(), (long)250L, (TimeUnit)TimeUnit.MILLISECONDS) && this.getSearch().getStatus() == SearchStatusEnum.LOADING);
            ourLog.trace("Initial sync completed");
            return this.getSearch().getTotalCount();
        }

        protected Search getSearch() {
            return this.mySearch;
        }

        CountDownLatch getInitialCollectionLatch() {
            return this.myInitialCollectionLatch;
        }

        void setPreviouslyAddedResourcePids(List<ResourcePersistentId> thePreviouslyAddedResourcePids) {
            this.myPreviouslyAddedResourcePids = thePreviouslyAddedResourcePids;
            this.myCountSavedTotal = this.myPreviouslyAddedResourcePids.size();
        }

        private ISearchBuilder newSearchBuilder() {
            Class resourceTypeClass = SearchCoordinatorSvcImpl.this.myContext.getResourceDefinition(this.myResourceType).getImplementingClass();
            return SearchCoordinatorSvcImpl.this.mySearchBuilderFactory.newSearchBuilder(this.myCallingDao, this.myResourceType, resourceTypeClass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        List<ResourcePersistentId> getResourcePids(int theFromIndex, int theToIndex) {
            boolean keepWaiting;
            ourLog.debug("Requesting search PIDs from {}-{}", (Object)theFromIndex, (Object)theToIndex);
            do {
                ArrayList<ResourcePersistentId> arrayList = this.mySyncedPids;
                synchronized (arrayList) {
                    boolean haveEnoughResults;
                    ourLog.trace("Search status is {}", (Object)this.mySearch.getStatus());
                    boolean bl = haveEnoughResults = this.mySyncedPids.size() >= theToIndex;
                    if (!haveEnoughResults) {
                        switch (this.mySearch.getStatus()) {
                            case LOADING: {
                                keepWaiting = true;
                                break;
                            }
                            case PASSCMPLET: {
                                keepWaiting = false;
                                break;
                            }
                            default: {
                                keepWaiting = false;
                                break;
                            }
                        }
                    } else {
                        keepWaiting = false;
                    }
                }
                if (!keepWaiting) continue;
                ourLog.info("Waiting as we only have {} results - Search status: {}", (Object)this.mySyncedPids.size(), (Object)this.mySearch.getStatus());
                AsyncUtil.sleep((long)500L);
            } while (keepWaiting);
            ourLog.debug("Proceeding, as we have {} results", (Object)this.mySyncedPids.size());
            ArrayList<ResourcePersistentId> retVal = new ArrayList<ResourcePersistentId>();
            ArrayList<ResourcePersistentId> arrayList = this.mySyncedPids;
            synchronized (arrayList) {
                SearchCoordinatorSvcImpl.verifySearchHasntFailedOrThrowInternalErrorException(this.mySearch);
                int toIndex = theToIndex;
                if (this.mySyncedPids.size() < toIndex) {
                    toIndex = this.mySyncedPids.size();
                }
                for (int i = theFromIndex; i < toIndex; ++i) {
                    retVal.add(this.mySyncedPids.get(i));
                }
            }
            ourLog.trace("Done syncing results - Wanted {}-{} and returning {} of {}", new Object[]{theFromIndex, theToIndex, retVal.size(), this.mySyncedPids.size()});
            return retVal;
        }

        void saveSearch() {
            TransactionTemplate txTemplate = new TransactionTemplate(SearchCoordinatorSvcImpl.this.myManagedTxManager);
            txTemplate.setPropagationBehavior(3);
            txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(@Nonnull TransactionStatus theArg0) {
                    SearchTask.this.doSaveSearch();
                }
            });
        }

        private void saveUnsynced(final IResultIterator theResultIter) {
            TransactionTemplate txTemplate = new TransactionTemplate(SearchCoordinatorSvcImpl.this.myManagedTxManager);
            txTemplate.setPropagationBehavior(0);
            txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doInTransactionWithoutResult(@Nonnull TransactionStatus theArg0) {
                    int numSynced;
                    Object accessDetails;
                    if (SearchTask.this.mySearch.getId() == null) {
                        SearchTask.this.doSaveSearch();
                    }
                    ArrayList<ResourcePersistentId> unsyncedPids = SearchTask.this.myUnsyncedPids;
                    int countBlocked = 0;
                    if (SearchTask.this.mySearchRuntimeDetails.getRequestDetails() != null && !unsyncedPids.isEmpty()) {
                        accessDetails = new JpaPreResourceAccessDetails(unsyncedPids, (ICallable<ISearchBuilder>)((ICallable)() -> SearchTask.this.newSearchBuilder()));
                        HookParams params = new HookParams().add(IPreResourceAccessDetails.class, accessDetails).add(RequestDetails.class, (Object)SearchTask.this.mySearchRuntimeDetails.getRequestDetails()).addIfMatchesType(ServletRequestDetails.class, (Object)SearchTask.this.mySearchRuntimeDetails.getRequestDetails());
                        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchCoordinatorSvcImpl.this.myInterceptorBroadcaster, (RequestDetails)SearchTask.this.myRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
                        for (int i = unsyncedPids.size() - 1; i >= 0; --i) {
                            if (!((JpaPreResourceAccessDetails)accessDetails).isDontReturnResourceAtIndex(i)) continue;
                            unsyncedPids.remove(i);
                            ++SearchTask.this.myCountBlockedThisPass;
                            ++SearchTask.this.myCountSavedTotal;
                            ++countBlocked;
                        }
                    }
                    SearchTask.this.myCountSavedTotal += unsyncedPids.size();
                    SearchTask.this.myCountSavedThisPass += unsyncedPids.size();
                    SearchCoordinatorSvcImpl.this.mySearchResultCacheSvc.storeResults(SearchTask.this.mySearch, SearchTask.this.mySyncedPids, unsyncedPids);
                    accessDetails = SearchTask.this.mySyncedPids;
                    synchronized (accessDetails) {
                        int numSyncedThisPass = unsyncedPids.size();
                        ourLog.trace("Syncing {} search results - Have more: {}", (Object)numSyncedThisPass, (Object)theResultIter.hasNext());
                        SearchTask.this.mySyncedPids.addAll(unsyncedPids);
                        unsyncedPids.clear();
                        if (!theResultIter.hasNext()) {
                            int skippedCount = theResultIter.getSkippedCount();
                            int nonSkippedCount = theResultIter.getNonSkippedCount();
                            int totalFetched = skippedCount + SearchTask.this.myCountSavedThisPass + SearchTask.this.myCountBlockedThisPass;
                            ourLog.trace("MaxToFetch[{}] SkippedCount[{}] CountSavedThisPass[{}] CountSavedThisTotal[{}] AdditionalPrefetchRemaining[{}]", new Object[]{SearchTask.this.myMaxResultsToFetch, skippedCount, SearchTask.this.myCountSavedThisPass, SearchTask.this.myCountSavedTotal, SearchTask.this.myAdditionalPrefetchThresholdsRemaining});
                            if (nonSkippedCount == 0 || SearchTask.this.myMaxResultsToFetch != null && totalFetched < SearchTask.this.myMaxResultsToFetch) {
                                ourLog.trace("Setting search status to FINISHED");
                                SearchTask.this.mySearch.setStatus(SearchStatusEnum.FINISHED);
                                SearchTask.this.mySearch.setTotalCount(SearchTask.this.myCountSavedTotal - countBlocked);
                            } else if (SearchTask.this.myAdditionalPrefetchThresholdsRemaining) {
                                ourLog.trace("Setting search status to PASSCMPLET");
                                SearchTask.this.mySearch.setStatus(SearchStatusEnum.PASSCMPLET);
                                SearchTask.this.mySearch.setSearchParameterMap(SearchTask.this.myParams);
                            } else {
                                ourLog.trace("Setting search status to FINISHED");
                                SearchTask.this.mySearch.setStatus(SearchStatusEnum.FINISHED);
                                SearchTask.this.mySearch.setTotalCount(SearchTask.this.myCountSavedTotal - countBlocked);
                            }
                        }
                    }
                    SearchTask.this.mySearch.setNumFound(SearchTask.this.myCountSavedTotal);
                    SearchTask.this.mySearch.setNumBlocked(SearchTask.this.mySearch.getNumBlocked() + countBlocked);
                    ArrayList<ResourcePersistentId> arrayList = SearchTask.this.mySyncedPids;
                    synchronized (arrayList) {
                        numSynced = SearchTask.this.mySyncedPids.size();
                    }
                    if (SearchCoordinatorSvcImpl.this.myDaoConfig.getCountSearchResultsUpTo() == null || SearchCoordinatorSvcImpl.this.myDaoConfig.getCountSearchResultsUpTo() <= 0 || SearchCoordinatorSvcImpl.this.myDaoConfig.getCountSearchResultsUpTo() <= numSynced) {
                        SearchTask.this.myInitialCollectionLatch.countDown();
                    }
                    SearchTask.this.doSaveSearch();
                    ourLog.trace("saveUnsynced() - pre-commit");
                }
            });
            ourLog.trace("saveUnsynced() - post-commit");
        }

        boolean isNotAborted() {
            return !this.myAbortRequested;
        }

        void markComplete() {
            this.myCompletionLatch.countDown();
        }

        CountDownLatch getCompletionLatch() {
            return this.myCompletionLatch;
        }

        void requestImmediateAbort() {
            this.myAbortRequested = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            StopWatch sw = new StopWatch();
            Span span = this.myParentTransaction.startSpan("db", "query", "search");
            span.setName("FHIR Database Search");
            try {
                this.saveSearch();
                TransactionTemplate txTemplate = new TransactionTemplate(SearchCoordinatorSvcImpl.this.myManagedTxManager);
                txTemplate.setPropagationBehavior(0);
                if (SearchCoordinatorSvcImpl.this.myCustomIsolationSupported) {
                    txTemplate.setIsolationLevel(2);
                }
                txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(@Nonnull TransactionStatus theStatus) {
                        SearchTask.this.doSearch();
                    }
                });
                this.mySearchRuntimeDetails.setSearchStatus(this.mySearch.getStatus());
                if (this.mySearch.getStatus() == SearchStatusEnum.FINISHED) {
                    HookParams params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchCoordinatorSvcImpl.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_COMPLETE, (HookParams)params);
                } else {
                    HookParams params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchCoordinatorSvcImpl.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_PASS_COMPLETE, (HookParams)params);
                }
                ourLog.trace("Have completed search for [{}{}] and found {} resources in {}ms - Status is {}", new Object[]{this.mySearch.getResourceType(), this.mySearch.getSearchQueryString(), this.mySyncedPids.size(), sw.getMillis(), this.mySearch.getStatus()});
            }
            catch (Throwable t) {
                BaseServerResponseException exception;
                boolean logged = false;
                if (t instanceof BaseServerResponseException && (exception = (BaseServerResponseException)t).getStatusCode() >= 400 && exception.getStatusCode() < 500) {
                    logged = true;
                    ourLog.warn("Failed during search due to invalid request: {}", (Object)t.toString());
                }
                if (!logged) {
                    ourLog.error("Failed during search loading after {}ms", (Object)sw.getMillis(), (Object)t);
                }
                this.myUnsyncedPids.clear();
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)t);
                rootCause = (Throwable)ObjectUtils.defaultIfNull((Object)rootCause, (Object)t);
                Object failureMessage = rootCause.getMessage();
                int failureCode = 500;
                if (t instanceof BaseServerResponseException) {
                    failureCode = ((BaseServerResponseException)t).getStatusCode();
                }
                if (System.getProperty(SearchCoordinatorSvcImpl.UNIT_TEST_CAPTURE_STACK) != null) {
                    failureMessage = (String)failureMessage + "\nStack\n" + ExceptionUtils.getStackTrace((Throwable)rootCause);
                }
                this.mySearch.setFailureMessage((String)failureMessage);
                this.mySearch.setFailureCode(failureCode);
                this.mySearch.setStatus(SearchStatusEnum.FAILED);
                this.mySearchRuntimeDetails.setSearchStatus(this.mySearch.getStatus());
                HookParams params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchCoordinatorSvcImpl.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FAILED, (HookParams)params);
                this.saveSearch();
                span.captureException(t);
            }
            finally {
                SearchCoordinatorSvcImpl.this.myIdToSearchTask.remove(this.mySearch.getUuid());
                this.myInitialCollectionLatch.countDown();
                this.markComplete();
                span.end();
            }
            return null;
        }

        private void doSaveSearch() {
            Search newSearch = SearchCoordinatorSvcImpl.this.mySearchCacheSvc.save(this.mySearch);
            if (newSearch != null) {
                this.mySearch = newSearch;
            }
        }

        private void doSearch() {
            ISearchBuilder sb;
            boolean myParamOrDefaultWantCount;
            final boolean myParamWantOnlyCount = SearchParameterMapCalculator.isWantOnlyCount(this.myParams);
            boolean bl = myParamOrDefaultWantCount = Objects.nonNull(this.myParams.getSearchTotalMode()) ? SearchParameterMapCalculator.isWantCount(this.myParams) : SearchParameterMapCalculator.isWantCount(SearchCoordinatorSvcImpl.this.myDaoConfig.getDefaultTotalMode());
            if (myParamWantOnlyCount || myParamOrDefaultWantCount) {
                ourLog.trace("Performing count");
                sb = this.newSearchBuilder();
                final Long count = sb.createCountQuery(this.myParams.clone(), this.mySearch.getUuid(), this.myRequest, this.myRequestPartitionId);
                ourLog.trace("Got count {}", (Object)count);
                TransactionTemplate txTemplate = new TransactionTemplate(SearchCoordinatorSvcImpl.this.myManagedTxManager);
                txTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(@Nonnull TransactionStatus theArg0) {
                        SearchTask.this.mySearch.setTotalCount(count.intValue());
                        if (myParamWantOnlyCount) {
                            SearchTask.this.mySearch.setStatus(SearchStatusEnum.FINISHED);
                        }
                        SearchTask.this.doSaveSearch();
                    }
                });
                if (myParamWantOnlyCount) {
                    return;
                }
            }
            ourLog.trace("Done count");
            sb = this.newSearchBuilder();
            int currentlyLoaded = (Integer)ObjectUtils.defaultIfNull((Object)this.mySearch.getNumFound(), (Object)0);
            int minWanted = 0;
            if (this.myParams.getCount() != null) {
                minWanted = this.myParams.getCount();
                minWanted = Math.min(minWanted, SearchCoordinatorSvcImpl.this.myPagingProvider.getMaximumPageSize());
                minWanted += currentlyLoaded;
            }
            Iterator iter = SearchCoordinatorSvcImpl.this.myDaoConfig.getSearchPreFetchThresholds().iterator();
            while (iter.hasNext()) {
                int next = (Integer)iter.next();
                if (next != -1 && next <= currentlyLoaded) continue;
                if (next == -1) {
                    sb.setMaxResultsToFetch(null);
                } else {
                    this.myMaxResultsToFetch = Math.max(next, minWanted);
                    sb.setMaxResultsToFetch(this.myMaxResultsToFetch);
                }
                if (!iter.hasNext()) break;
                this.myAdditionalPrefetchThresholdsRemaining = true;
                break;
            }
            if (this.myPreviouslyAddedResourcePids != null) {
                sb.setPreviouslyAddedResourcePids(this.myPreviouslyAddedResourcePids);
                this.mySyncedPids.addAll(this.myPreviouslyAddedResourcePids);
            }
            try (IResultIterator resultIterator = sb.createQuery(this.myParams, this.mySearchRuntimeDetails, this.myRequest, this.myRequestPartitionId);){
                assert (resultIterator != null);
                int syncSize = SearchCoordinatorSvcImpl.this.mySyncSize;
                while (resultIterator.hasNext()) {
                    boolean shouldSync;
                    this.myUnsyncedPids.add((ResourcePersistentId)resultIterator.next());
                    boolean bl2 = shouldSync = this.myUnsyncedPids.size() >= syncSize;
                    if (SearchCoordinatorSvcImpl.this.myDaoConfig.getCountSearchResultsUpTo() != null && SearchCoordinatorSvcImpl.this.myDaoConfig.getCountSearchResultsUpTo() > 0 && SearchCoordinatorSvcImpl.this.myDaoConfig.getCountSearchResultsUpTo() < this.myUnsyncedPids.size()) {
                        shouldSync = false;
                    }
                    if (this.myUnsyncedPids.size() > 50000) {
                        shouldSync = true;
                    }
                    Validate.isTrue((boolean)this.isNotAborted(), (String)"Abort has been requested", (Object[])new Object[0]);
                    if (shouldSync) {
                        this.saveUnsynced(resultIterator);
                    }
                    if (SearchCoordinatorSvcImpl.this.myLoadingThrottleForUnitTests == null) continue;
                    AsyncUtil.sleep((long)SearchCoordinatorSvcImpl.this.myLoadingThrottleForUnitTests.intValue());
                }
                Validate.isTrue((boolean)this.isNotAborted(), (String)"Abort has been requested", (Object[])new Object[0]);
                this.saveUnsynced(resultIterator);
            }
            catch (IOException e) {
                ourLog.error("IO failure during database access", (Throwable)e);
                throw new InternalErrorException(Msg.code((int)1166) + e);
            }
        }
    }

    public class SearchContinuationTask
    extends SearchTask {
        public SearchContinuationTask(Search theSearch, IDao theCallingDao, SearchParameterMap theParams, String theResourceType, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
            super(theSearch, theCallingDao, theParams, theResourceType, theRequest, theRequestPartitionId);
        }

        @Override
        public Void call() {
            try {
                TransactionTemplate txTemplate = new TransactionTemplate(SearchCoordinatorSvcImpl.this.myManagedTxManager);
                txTemplate.afterPropertiesSet();
                txTemplate.execute(t -> {
                    List<ResourcePersistentId> previouslyAddedResourcePids = SearchCoordinatorSvcImpl.this.mySearchResultCacheSvc.fetchAllResultPids(this.getSearch());
                    if (previouslyAddedResourcePids == null) {
                        throw SearchCoordinatorSvcImpl.this.newResourceGoneException(this.getSearch().getUuid());
                    }
                    ourLog.trace("Have {} previously added IDs in search: {}", (Object)previouslyAddedResourcePids.size(), (Object)this.getSearch().getUuid());
                    this.setPreviouslyAddedResourcePids(previouslyAddedResourcePids);
                    return null;
                });
            }
            catch (Throwable e) {
                ourLog.error("Failure processing search", e);
                this.getSearch().setFailureMessage(e.getMessage());
                this.getSearch().setStatus(SearchStatusEnum.FAILED);
                if (e instanceof BaseServerResponseException) {
                    this.getSearch().setFailureCode(((BaseServerResponseException)e).getStatusCode());
                }
                this.saveSearch();
                return null;
            }
            return super.call();
        }
    }
}

