/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.search.IStaleSearchDeletingSvc;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import javax.annotation.PostConstruct;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class StaleSearchDeletingSvcImpl
implements IStaleSearchDeletingSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(StaleSearchDeletingSvcImpl.class);
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private ISearchCacheSvc mySearchCacheSvc;
    @Autowired
    private ISchedulerService mySchedulerService;

    @Override
    @Transactional(propagation=Propagation.NEVER)
    public void pollForStaleSearchesAndDeleteThem() {
        this.mySearchCacheSvc.pollForStaleSearchesAndDeleteThem();
    }

    @PostConstruct
    public void scheduleJob() {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        this.mySchedulerService.scheduleClusteredJob(10000L, jobDetail);
    }

    @Override
    @Transactional(propagation=Propagation.NEVER)
    public synchronized void schedulePollForStaleSearches() {
        if (!this.myDaoConfig.isSchedulingDisabled() && this.myDaoConfig.isEnableTaskStaleSearchCleanup()) {
            this.pollForStaleSearchesAndDeleteThem();
        }
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private IStaleSearchDeletingSvc myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.schedulePollForStaleSearches();
        }
    }
}

