/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.autocomplete;

import ca.uhn.fhir.jpa.search.autocomplete.RawElasticJsonBuilder;
import ca.uhn.fhir.jpa.search.autocomplete.TokenAutocompleteHit;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class TokenAutocompleteAggregation {
    static final JsonObject AGGREGATION_TEMPLATE = (JsonObject)new Gson().fromJson("         {            \"nested\": { \"path\": \"nsp.PLACEHOLDER\" },            \"aggs\": {                \"search\": {                    \"filter\": {                        \"bool\": {                            \"must\": [                                { \"match_bool_prefix\":                                  { \"nsp.PLACEHOLDER.string.text\": {                                      \"query\": \"Mors\"}                                  }                                }                            ]                        }                    },                    \"aggs\": {                        \"group_by_token\": {                            \"terms\": {                                \"field\": \"nsp.PLACEHOLDER.token.code-system\",                                \"size\": 30,                                \"min_doc_count\": 1,                                \"shard_min_doc_count\": 0,                                \"show_term_doc_count_error\": false                            },                            \"aggs\": {                                \"top_tags_hits\": {                                    \"top_hits\": {                                        \"_source\": {                                            \"includes\": [ \"nsp.PLACEHOLDER\" ]                                        },                                        \"size\": 1                                    }                                }                            }                        }                    }                }            }        }", JsonObject.class);
    static final Configuration configuration = Configuration.builder().mappingProvider((MappingProvider)new GsonMappingProvider()).jsonProvider((JsonProvider)new GsonJsonProvider()).build();
    static final ParseContext parseContext = JsonPath.using((Configuration)configuration);
    private final String mySpName;
    private final int myCount;
    private final JsonObject mySearch;

    public TokenAutocompleteAggregation(String theSpName, int theCount, String theSearchText, String theSearchModifier) {
        Validate.notEmpty((CharSequence)theSpName);
        Validate.isTrue((theCount > 0 ? 1 : 0) != 0, (String)"count must be positive", (Object[])new Object[0]);
        Validate.isTrue(("text".equalsIgnoreCase(theSearchModifier) || "".equals(theSearchModifier) || theSearchModifier == null ? 1 : 0) != 0, (String)("Unsupported search modifier " + theSearchModifier), (Object[])new Object[0]);
        this.mySpName = theSpName;
        this.myCount = theCount;
        this.mySearch = this.makeSearch(theSearchText, theSearchModifier);
    }

    private JsonObject makeSearch(String theSearchText, String theSearchModifier) {
        theSearchText = StringUtils.defaultString((String)theSearchText);
        theSearchModifier = StringUtils.defaultString((String)theSearchModifier);
        if (StringUtils.isEmpty((CharSequence)theSearchText)) {
            return RawElasticJsonBuilder.makeMatchAllPredicate();
        }
        if ("text".equalsIgnoreCase(theSearchModifier)) {
            return RawElasticJsonBuilder.makeMatchBoolPrefixPredicate("nsp." + this.mySpName + ".string.text", theSearchText);
        }
        return RawElasticJsonBuilder.makeWildcardPredicate("nsp." + this.mySpName + ".token.code", theSearchText + "*");
    }

    JsonObject toJsonAggregation() {
        JsonObject result = AGGREGATION_TEMPLATE.deepCopy();
        DocumentContext documentContext = parseContext.parse((Object)result);
        String nestedSearchParamPath = "nsp." + this.mySpName;
        documentContext.set("nested.path", (Object)nestedSearchParamPath, new Predicate[0]);
        documentContext.set("aggs.search.filter.bool.must[0]", (Object)this.mySearch, new Predicate[0]);
        documentContext.set("aggs.search.aggs.group_by_token.terms.field", (Object)("nsp." + this.mySpName + ".token.code-system"), new Predicate[0]);
        documentContext.set("aggs.search.aggs.group_by_token.terms.size", (Object)this.myCount, new Predicate[0]);
        documentContext.set("aggs.search.aggs.group_by_token.aggs.top_tags_hits.top_hits._source.includes[0]", (Object)nestedSearchParamPath, new Predicate[0]);
        return result;
    }

    @Nonnull
    List<TokenAutocompleteHit> extractResults(@Nonnull JsonObject theAggregationResult) {
        Validate.notNull((Object)theAggregationResult);
        JsonArray buckets = theAggregationResult.getAsJsonObject("search").getAsJsonObject("group_by_token").getAsJsonArray("buckets");
        List<TokenAutocompleteHit> result = StreamSupport.stream(buckets.spliterator(), false).map(b -> this.bucketToEntry((JsonObject)b)).collect(Collectors.toList());
        return result;
    }

    @Nonnull
    TokenAutocompleteHit bucketToEntry(JsonObject theBucketJson) {
        DocumentContext documentContext = parseContext.parse((Object)theBucketJson);
        String bucketKey = (String)documentContext.read("key", String.class, new Predicate[0]);
        String displayText = (String)documentContext.read("top_tags_hits.hits.hits[0]._source.string.text", String.class, new Predicate[0]);
        return new TokenAutocompleteHit(bucketKey, displayText);
    }
}

