/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.autocomplete;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchClauseBuilder;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.search.autocomplete.TokenAutocompleteAggregation;
import ca.uhn.fhir.jpa.search.autocomplete.TokenAutocompleteHit;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.backend.elasticsearch.ElasticsearchExtension;
import org.hibernate.search.backend.elasticsearch.search.aggregation.dsl.ElasticsearchSearchAggregationFactory;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactoryExtension;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAutocompleteSearch {
    private static final Logger ourLog = LoggerFactory.getLogger(TokenAutocompleteSearch.class);
    private static final AggregationKey<JsonObject> AGGREGATION_KEY = AggregationKey.of((String)"autocomplete");
    private final FhirContext myFhirContext;
    private final ModelConfig myModelConfig;
    private final SearchSession mySession;

    public TokenAutocompleteSearch(FhirContext theFhirContext, ModelConfig theModelConfig, SearchSession theSession) {
        this.myFhirContext = theFhirContext;
        this.myModelConfig = theModelConfig;
        this.mySession = theSession;
    }

    @Nonnull
    public List<TokenAutocompleteHit> search(String theResourceName, String theSPName, String theSearchText, String theSearchModifier, int theCount) {
        TokenAutocompleteAggregation tokenAutocompleteAggregation = new TokenAutocompleteAggregation(theSPName, theCount, theSearchText, theSearchModifier);
        SearchQueryOptionsStep query = this.mySession.search(ResourceTable.class).where(predFactory -> predFactory.bool(boolBuilder -> {
            ExtendedHSearchClauseBuilder clauseBuilder = new ExtendedHSearchClauseBuilder(this.myFhirContext, this.myModelConfig, (BooleanPredicateClausesStep<?>)boolBuilder, (SearchPredicateFactory)predFactory);
            if (StringUtils.isNotBlank((CharSequence)theResourceName)) {
                clauseBuilder.addResourceTypeClause(theResourceName);
            }
        })).aggregation(AGGREGATION_KEY, this.buildAggregation(tokenAutocompleteAggregation));
        SearchResult result = query.fetch(Integer.valueOf(0));
        JsonObject resultAgg = (JsonObject)result.aggregation(AGGREGATION_KEY);
        List<TokenAutocompleteHit> aggEntries = tokenAutocompleteAggregation.extractResults(resultAgg);
        return aggEntries;
    }

    SearchAggregation<JsonObject> buildAggregation(TokenAutocompleteAggregation tokenAutocompleteAggregation) {
        JsonObject jsonAggregation = tokenAutocompleteAggregation.toJsonAggregation();
        SearchAggregation aggregation = ((ElasticsearchSearchAggregationFactory)this.mySession.scope(ResourceTable.class).aggregation().extension((SearchAggregationFactoryExtension)ElasticsearchExtension.get())).fromJson(jsonAggregation).toAggregation();
        return aggregation;
    }
}

