/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.autocomplete;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class ValueSetAutocompleteOptions {
    private final String myResourceType;
    private final String mySearchParamCode;
    private final String mySearchParamModifier;
    private final String myFilter;
    private final Integer myCount;
    static final List<String> ourSupportedModifiers = Arrays.asList("", TokenParamModifier.TEXT.getBareModifier());

    public ValueSetAutocompleteOptions(String theContext, String theFilter, Integer theCount) {
        String codeWithPossibleModifier;
        this.myFilter = theFilter;
        this.myCount = theCount;
        int separatorIdx = theContext.indexOf(46);
        if (separatorIdx >= 0) {
            this.myResourceType = theContext.substring(0, separatorIdx);
            codeWithPossibleModifier = theContext.substring(separatorIdx + 1);
        } else {
            this.myResourceType = null;
            codeWithPossibleModifier = theContext;
        }
        int modifierIdx = codeWithPossibleModifier.indexOf(58);
        if (modifierIdx >= 0) {
            this.mySearchParamCode = codeWithPossibleModifier.substring(0, modifierIdx);
            this.mySearchParamModifier = codeWithPossibleModifier.substring(modifierIdx + 1);
        } else {
            this.mySearchParamCode = codeWithPossibleModifier;
            this.mySearchParamModifier = null;
        }
    }

    public static ValueSetAutocompleteOptions validateAndParseOptions(DaoConfig theDaoConfig, IPrimitiveType<String> theContext, IPrimitiveType<String> theFilter, IPrimitiveType<Integer> theCount, IIdType theId, IPrimitiveType<String> theUrl, IBaseResource theValueSet) {
        boolean haveValueSet;
        boolean haveId = theId != null && theId.hasIdPart();
        boolean haveIdentifier = theUrl != null && StringUtils.isNotBlank((CharSequence)((CharSequence)theUrl.getValue()));
        boolean bl = haveValueSet = theValueSet != null && !theValueSet.isEmpty();
        if (haveId || haveIdentifier || haveValueSet) {
            throw new InvalidRequestException(Msg.code((int)2020) + "$expand with contexDirection='existing' is only supported at the type leve. It is not supported at instance level, with a url specified, or with a ValueSet .");
        }
        if (!theDaoConfig.isAdvancedHSearchIndexing()) {
            throw new InvalidRequestException(Msg.code((int)2022) + "$expand with contexDirection='existing' requires Extended Lucene Indexing.");
        }
        if (theContext == null || theContext.isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)2021) + "$expand with contexDirection='existing' requires a context");
        }
        String filter = theFilter == null ? null : (String)theFilter.getValue();
        ValueSetAutocompleteOptions result = new ValueSetAutocompleteOptions((String)theContext.getValue(), filter, (Integer)IPrimitiveType.toValueOrNull(theCount));
        if (!ourSupportedModifiers.contains(StringUtils.defaultString((String)result.getSearchParamModifier()))) {
            throw new InvalidRequestException(Msg.code((int)2069) + "$expand with contexDirection='existing' only supports plain token search, or the :text modifier.  Received " + result.getSearchParamModifier());
        }
        return result;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public String getSearchParamCode() {
        return this.mySearchParamCode;
    }

    public String getSearchParamModifier() {
        return this.mySearchParamModifier;
    }

    public String getFilter() {
        return this.myFilter;
    }

    public Optional<Integer> getCount() {
        return Optional.ofNullable(this.myCount);
    }
}

