/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.autocomplete;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.search.autocomplete.TokenAutocompleteHit;
import ca.uhn.fhir.jpa.search.autocomplete.TokenAutocompleteSearch;
import ca.uhn.fhir.jpa.search.autocomplete.ValueSetAutocompleteOptions;
import ca.uhn.fhir.rest.param.TokenParam;
import java.util.List;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ValueSet;

public class ValueSetAutocompleteSearch {
    private final FhirContext myFhirContext;
    private final ModelConfig myModelConfig;
    private final TokenAutocompleteSearch myAutocompleteSearch;
    static final int DEFAULT_SIZE = 30;

    public ValueSetAutocompleteSearch(FhirContext theFhirContext, ModelConfig theModelConfig, SearchSession theSession) {
        this.myFhirContext = theFhirContext;
        this.myModelConfig = theModelConfig;
        this.myAutocompleteSearch = new TokenAutocompleteSearch(this.myFhirContext, this.myModelConfig, theSession);
    }

    public IBaseResource search(ValueSetAutocompleteOptions theOptions) {
        List<TokenAutocompleteHit> aggEntries = this.myAutocompleteSearch.search(theOptions.getResourceType(), theOptions.getSearchParamCode(), theOptions.getFilter(), theOptions.getSearchParamModifier(), theOptions.getCount().orElse(30));
        ValueSet result = new ValueSet();
        ValueSet.ValueSetExpansionComponent expansion = new ValueSet.ValueSetExpansionComponent();
        result.setExpansion(expansion);
        result.setStatus(Enumerations.PublicationStatus.ACTIVE);
        aggEntries.stream().map(this::makeCoding).forEach(arg_0 -> ((ValueSet.ValueSetExpansionComponent)expansion).addContains(arg_0));
        return result;
    }

    ValueSet.ValueSetExpansionContainsComponent makeCoding(TokenAutocompleteHit theSearchHit) {
        TokenParam tokenParam = new TokenParam();
        tokenParam.setValueAsQueryToken(this.myFhirContext, null, null, theSearchHit.mySystemCode);
        ValueSet.ValueSetExpansionContainsComponent coding = new ValueSet.ValueSetExpansionContainsComponent();
        coding.setCode(tokenParam.getValue());
        coding.setSystem(tokenParam.getSystem());
        coding.setDisplay(theSearchHit.myDisplayText);
        return coding;
    }
}

