/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.exception.TokenParamFormatInvalidRequestException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboNonUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.CoordsPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.DatePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ForcedIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.NumberPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityBasePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceLinkPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceTablePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SearchParamPresentPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SourcePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TagPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TokenPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.UriPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.SourceParam;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SetOperationQuery;
import com.healthmarketscience.sqlbuilder.Subquery;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStack {
    private static final Logger ourLog = LoggerFactory.getLogger(QueryStack.class);
    private static final BidiMap<SearchFilterParser.CompareOperation, ParamPrefixEnum> ourCompareOperationToParamPrefix;
    private final ModelConfig myModelConfig;
    private final FhirContext myFhirContext;
    private final SearchQueryBuilder mySqlBuilder;
    private final SearchParameterMap mySearchParameters;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final PartitionSettings myPartitionSettings;
    private final DaoConfig myDaoConfig;
    private final EnumSet<PredicateBuilderTypeEnum> myReusePredicateBuilderTypes;
    private Map<PredicateBuilderCacheKey, BaseJoiningPredicateBuilder> myJoinMap;

    public QueryStack(SearchParameterMap theSearchParameters, DaoConfig theDaoConfig, ModelConfig theModelConfig, FhirContext theFhirContext, SearchQueryBuilder theSqlBuilder, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings) {
        this(theSearchParameters, theDaoConfig, theModelConfig, theFhirContext, theSqlBuilder, theSearchParamRegistry, thePartitionSettings, EnumSet.of(PredicateBuilderTypeEnum.DATE));
    }

    private QueryStack(SearchParameterMap theSearchParameters, DaoConfig theDaoConfig, ModelConfig theModelConfig, FhirContext theFhirContext, SearchQueryBuilder theSqlBuilder, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings, EnumSet<PredicateBuilderTypeEnum> theReusePredicateBuilderTypes) {
        this.myPartitionSettings = thePartitionSettings;
        assert (theSearchParameters != null);
        assert (theDaoConfig != null);
        assert (theModelConfig != null);
        assert (theFhirContext != null);
        assert (theSqlBuilder != null);
        this.mySearchParameters = theSearchParameters;
        this.myDaoConfig = theDaoConfig;
        this.myModelConfig = theModelConfig;
        this.myFhirContext = theFhirContext;
        this.mySqlBuilder = theSqlBuilder;
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myReusePredicateBuilderTypes = theReusePredicateBuilderTypes;
    }

    public void addSortOnDate(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        DatePredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addDatePredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortDate(sortPredicateBuilder.getColumnValueLow(), theAscending);
    }

    public void addSortOnLastUpdated(boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ResourceTablePredicateBuilder resourceTablePredicateBuilder = firstPredicateBuilder instanceof ResourceTablePredicateBuilder ? (ResourceTablePredicateBuilder)firstPredicateBuilder : this.mySqlBuilder.addResourceTablePredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        this.mySqlBuilder.addSortDate(resourceTablePredicateBuilder.getColumnLastUpdated(), theAscending);
    }

    public void addSortOnNumber(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        NumberPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addNumberPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortNumeric(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    public void addSortOnQuantity(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        QuantityPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addQuantityPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortNumeric(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    public void addSortOnResourceId(boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ForcedIdPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addForcedIdPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        if (!theAscending) {
            this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnForcedId(), false, OrderObject.NullOrder.FIRST);
        } else {
            this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnForcedId(), true);
        }
        this.mySqlBuilder.addSortNumeric(firstPredicateBuilder.getResourceIdColumn(), theAscending);
    }

    public void addSortOnResourceLink(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ResourceLinkPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addReferencePredicateBuilder(this, firstPredicateBuilder.getResourceIdColumn());
        Condition pathPredicate = sortPredicateBuilder.createPredicateSourcePaths(theResourceName, theParamName, new ArrayList<String>());
        this.mySqlBuilder.addPredicate(pathPredicate);
        this.mySqlBuilder.addSortNumeric(sortPredicateBuilder.getColumnTargetResourceId(), theAscending);
    }

    public void addSortOnString(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        StringPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addStringPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnValueNormalized(), theAscending);
    }

    public void addSortOnToken(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        TokenPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addTokenPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnSystem(), theAscending);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    public void addSortOnUri(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        UriPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addUriPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    private <T extends BaseJoiningPredicateBuilder> PredicateBuilderCacheLookupResult<T> createOrReusePredicateBuilder(PredicateBuilderTypeEnum theType, DbColumn theSourceJoinColumn, String theParamName, Supplier<T> theFactoryMethod) {
        BaseJoiningPredicateBuilder retVal;
        boolean cacheHit = false;
        if (this.myReusePredicateBuilderTypes.contains((Object)theType)) {
            PredicateBuilderCacheKey key = new PredicateBuilderCacheKey(theSourceJoinColumn, theType, theParamName);
            if (this.myJoinMap == null) {
                this.myJoinMap = new HashMap<PredicateBuilderCacheKey, BaseJoiningPredicateBuilder>();
            }
            if ((retVal = this.myJoinMap.get(key)) != null) {
                cacheHit = true;
            } else {
                retVal = (BaseJoiningPredicateBuilder)theFactoryMethod.get();
                this.myJoinMap.put(key, retVal);
            }
        } else {
            retVal = (BaseJoiningPredicateBuilder)theFactoryMethod.get();
        }
        return new PredicateBuilderCacheLookupResult<BaseJoiningPredicateBuilder>(cacheHit, retVal);
    }

    private Condition createPredicateComposite(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theNextAnd, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateComposite(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDef, theNextAnd, theRequestPartitionId, this.mySqlBuilder);
    }

    private Condition createPredicateComposite(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theNextAnd, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        Condition orCondidtion = null;
        for (IQueryParameterType iQueryParameterType : theNextAnd) {
            if (!(iQueryParameterType instanceof CompositeParam)) {
                throw new InvalidRequestException(Msg.code((int)1203) + "Invalid type for composite param (must be " + CompositeParam.class.getSimpleName() + ": " + iQueryParameterType.getClass());
            }
            CompositeParam cp = (CompositeParam)iQueryParameterType;
            List componentParams = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParamDef);
            RuntimeSearchParam left = (RuntimeSearchParam)componentParams.get(0);
            IQueryParameterType leftValue = cp.getLeftValue();
            Condition leftPredicate = this.createPredicateCompositePart(theSourceJoinColumn, theResourceName, theSpnamePrefix, left, leftValue, theRequestPartitionId, theSqlBuilder);
            RuntimeSearchParam right = (RuntimeSearchParam)componentParams.get(1);
            IQueryParameterType rightValue = cp.getRightValue();
            Condition rightPredicate = this.createPredicateCompositePart(theSourceJoinColumn, theResourceName, theSpnamePrefix, right, rightValue, theRequestPartitionId, theSqlBuilder);
            Condition andCondition = QueryStack.toAndPredicate(leftPredicate, rightPredicate);
            if (orCondidtion == null) {
                orCondidtion = QueryStack.toOrPredicate(andCondition);
                continue;
            }
            orCondidtion = QueryStack.toOrPredicate(orCondidtion, andCondition);
        }
        return orCondidtion;
    }

    private Condition createPredicateCompositePart(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParam, IQueryParameterType theParamValue, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        switch (theParam.getParamType()) {
            case STRING: {
                return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId, theSqlBuilder);
            }
            case TOKEN: {
                return this.createPredicateToken(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId, theSqlBuilder);
            }
            case DATE: {
                return this.createPredicateDate(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), QueryStack.toOperation(((DateParam)theParamValue).getPrefix()), theRequestPartitionId, theSqlBuilder);
            }
            case QUANTITY: {
                return this.createPredicateQuantity(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId, theSqlBuilder);
            }
        }
        throw new InvalidRequestException(Msg.code((int)1204) + "Don't know how to handle composite parameter with type of " + theParam.getParamType());
    }

    public Condition createPredicateCoords(@Nullable DbColumn theSourceJoinColumn, String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, RequestPartitionId theRequestPartitionId) {
        CoordsPredicateBuilder predicateBuilder = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.COORDS, theSourceJoinColumn, theSearchParam.getName(), () -> this.mySqlBuilder.addCoordsPredicateBuilder(theSourceJoinColumn)).getResult();
        if (theList.get(0).getMissing() != null) {
            return predicateBuilder.createPredicateParamMissingForNonReference(theResourceName, theSearchParam.getName(), theList.get(0).getMissing(), theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition singleCode = predicateBuilder.createPredicateCoords(this.mySearchParameters, iQueryParameterType, theResourceName, theSearchParam, predicateBuilder, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        return predicateBuilder.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateDate(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateDate(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateDate(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        PredicateBuilderCacheLookupResult<DatePredicateBuilder> predicateBuilderLookupResult = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.DATE, theSourceJoinColumn, paramName, () -> theSqlBuilder.addDatePredicateBuilder(theSourceJoinColumn));
        DatePredicateBuilder predicateBuilder = predicateBuilderLookupResult.getResult();
        boolean cacheHit = predicateBuilderLookupResult.isCacheHit();
        if (theList.get(0).getMissing() != null) {
            Boolean missing = theList.get(0).getMissing();
            return predicateBuilder.createPredicateParamMissingForNonReference(theResourceName, paramName, missing, theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition p = predicateBuilder.createPredicateDateWithoutIdentityPredicate(iQueryParameterType, theOperation);
            codePredicates.add(p);
        }
        Condition predicate = QueryStack.toOrPredicate(codePredicates);
        if (!cacheHit) {
            predicate = predicateBuilder.combineWithHashIdentityPredicate(theResourceName, paramName, predicate);
            predicate = predicateBuilder.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
        }
        return predicate;
    }

    private Condition createPredicateFilter(QueryStack theQueryStack3, SearchFilterParser.Filter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        if (theFilter instanceof SearchFilterParser.FilterParameter) {
            return this.createPredicateFilter(theQueryStack3, (SearchFilterParser.FilterParameter)theFilter, theResourceName, theRequest, theRequestPartitionId);
        }
        if (theFilter instanceof SearchFilterParser.FilterLogical) {
            Condition xPredicate = this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterLogical)theFilter).getFilter1(), theResourceName, theRequest, theRequestPartitionId);
            Condition yPredicate = this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterLogical)theFilter).getFilter2(), theResourceName, theRequest, theRequestPartitionId);
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.and) {
                return ComboCondition.and((Condition[])new Condition[]{xPredicate, yPredicate});
            }
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.or) {
                return ComboCondition.or((Condition[])new Condition[]{xPredicate, yPredicate});
            }
            throw new InvalidRequestException(Msg.code((int)1205) + "Don't know how to handle operation " + ((SearchFilterParser.FilterLogical)theFilter).getOperation());
        }
        return this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterParameterGroup)theFilter).getContained(), theResourceName, theRequest, theRequestPartitionId);
    }

    private Condition createPredicateFilter(QueryStack theQueryStack3, SearchFilterParser.FilterParameter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        String paramName;
        switch (paramName = theFilter.getParamPath().getName()) {
            case "_id": {
                TokenParam param = new TokenParam();
                param.setValueAsQueryToken(null, null, null, theFilter.getValue());
                return theQueryStack3.createPredicateResourceId(null, Collections.singletonList(Collections.singletonList(param)), theResourceName, theFilter.getOperation(), theRequestPartitionId);
            }
            case "_source": {
                TokenParam param = new TokenParam();
                param.setValueAsQueryToken(null, null, null, theFilter.getValue());
                return this.createPredicateSource(null, Collections.singletonList(param));
            }
        }
        RuntimeSearchParam searchParam = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, paramName);
        if (searchParam == null) {
            Collection validNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName);
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSearchParameter", new Object[]{paramName, theResourceName, validNames});
            throw new InvalidRequestException(Msg.code((int)1206) + msg);
        }
        RestSearchParameterTypeEnum typeEnum = searchParam.getParamType();
        if (typeEnum == RestSearchParameterTypeEnum.URI) {
            return theQueryStack3.createPredicateUri(null, theResourceName, null, searchParam, Collections.singletonList(new UriParam(theFilter.getValue())), theFilter.getOperation(), theRequest, theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.STRING) {
            return theQueryStack3.createPredicateString(null, theResourceName, null, searchParam, Collections.singletonList(new StringParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.DATE) {
            return theQueryStack3.createPredicateDate(null, theResourceName, null, searchParam, Collections.singletonList(new DateParam(QueryStack.fromOperation(theFilter.getOperation()), theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.NUMBER) {
            return theQueryStack3.createPredicateNumber(null, theResourceName, null, searchParam, Collections.singletonList(new NumberParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.REFERENCE) {
            SearchFilterParser.CompareOperation operation = theFilter.getOperation();
            String resourceType = null;
            String chain = theFilter.getParamPath().getNext() != null ? theFilter.getParamPath().getNext().toString() : null;
            String value = theFilter.getValue();
            ReferenceParam referenceParam = new ReferenceParam(resourceType, chain, value);
            return theQueryStack3.createPredicateReference(null, theResourceName, paramName, new ArrayList<String>(), Collections.singletonList(referenceParam), operation, theRequest, theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.QUANTITY) {
            return theQueryStack3.createPredicateQuantity(null, theResourceName, null, searchParam, Collections.singletonList(new QuantityParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.COMPOSITE) {
            throw new InvalidRequestException(Msg.code((int)1207) + "Composite search parameters not currently supported with _filter clauses");
        }
        if (typeEnum == RestSearchParameterTypeEnum.TOKEN) {
            TokenParam param = new TokenParam();
            param.setValueAsQueryToken(null, null, null, theFilter.getValue());
            return theQueryStack3.createPredicateToken(null, theResourceName, null, searchParam, Collections.singletonList(param), theFilter.getOperation(), theRequestPartitionId);
        }
        return null;
    }

    private Condition createPredicateHas(@Nullable DbColumn theSourceJoinColumn, String theResourceType, List<List<IQueryParameterType>> theHasParameters, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        ArrayList<Condition> andPredicates = new ArrayList<Condition>();
        for (List<IQueryParameterType> nextOrList : theHasParameters) {
            int colonIndex;
            String targetResourceType = null;
            String paramReference = null;
            String parameterName = null;
            String paramName = null;
            ArrayList<QualifiedParamList> parameters = new ArrayList<QualifiedParamList>();
            for (IQueryParameterType nextParam : nextOrList) {
                HasParam next = (HasParam)nextParam;
                targetResourceType = next.getTargetResourceType();
                paramReference = next.getReferenceFieldName();
                parameterName = next.getParameterName();
                paramName = parameterName.replaceAll("\\..*", "");
                parameters.add(QualifiedParamList.singleton(null, (String)next.getValueAsQueryToken(this.myFhirContext)));
            }
            if (paramName == null) continue;
            try {
                this.myFhirContext.getResourceDefinition(targetResourceType);
            }
            catch (DataFormatException e) {
                throw new InvalidRequestException(Msg.code((int)1208) + "Invalid resource type: " + targetResourceType);
            }
            ArrayList orValues = Lists.newArrayList();
            if (paramName.startsWith("_has:")) {
                ourLog.trace("Handing double _has query: {}", (Object)paramName);
                String qualifier = paramName.substring(4);
                for (IQueryParameterType iQueryParameterType : nextOrList) {
                    HasParam nextHasParam = new HasParam();
                    nextHasParam.setValueAsQueryToken(this.myFhirContext, "_has", qualifier, iQueryParameterType.getValueAsQueryToken(this.myFhirContext));
                    orValues.add(nextHasParam);
                }
            } else {
                RuntimeSearchParam owningParameterDef = this.mySearchParamRegistry.getRuntimeSearchParam(targetResourceType, paramName);
                this.mySearchParamRegistry.getRuntimeSearchParam(targetResourceType, paramReference);
                IQueryParameterAnd parsedParam = JpaParamUtil.parseQueryParams((ISearchParamRegistry)this.mySearchParamRegistry, (FhirContext)this.myFhirContext, (RuntimeSearchParam)owningParameterDef, (String)paramName, parameters);
                for (IQueryParameterOr next2 : parsedParam.getValuesAsQueryTokens()) {
                    orValues.addAll(next2.getValuesAsQueryTokens());
                }
            }
            if (parameterName.contains(".")) {
                String chainedPartOfParameter = QueryStack.getChainedPart(parameterName);
                orValues.stream().filter(qp -> qp instanceof ReferenceParam).map(qp -> (ReferenceParam)qp).forEach(rp -> rp.setChain(QueryStack.getChainedPart(chainedPartOfParameter)));
                parameterName = parameterName.substring(0, parameterName.indexOf(46));
            }
            if ((colonIndex = parameterName.indexOf(58)) != -1) {
                parameterName = parameterName.substring(0, colonIndex);
            }
            ResourceLinkPredicateBuilder join = this.mySqlBuilder.addReferencePredicateBuilderReversed(this, theSourceJoinColumn);
            Condition condition = join.createPartitionIdPredicate(theRequestPartitionId);
            List<String> paths = join.createResourceLinkPaths(targetResourceType, paramReference, new ArrayList<String>());
            BinaryCondition typePredicate = BinaryCondition.equalTo((Object)join.getColumnTargetResourceType(), (Object)this.mySqlBuilder.generatePlaceholder(theResourceType));
            Condition pathPredicate = QueryStack.toEqualToOrInPredicate(join.getColumnSourcePath(), this.mySqlBuilder.generatePlaceholders(paths));
            Condition linkedPredicate = this.searchForIdsWithAndOr(join.getColumnSrcResourceId(), targetResourceType, parameterName, Collections.singletonList(orValues), theRequest, theRequestPartitionId, SearchContainedModeEnum.FALSE);
            andPredicates.add(QueryStack.toAndPredicate(new Condition[]{condition, pathPredicate, typePredicate, linkedPredicate}));
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    public Condition createPredicateNumber(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateNumber(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateNumber(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        NumberPredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.NUMBER, theSourceJoinColumn, paramName, () -> theSqlBuilder.addNumberPredicateBuilder(theSourceJoinColumn)).getResult();
        if (theList.get(0).getMissing() != null) {
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof NumberParam) {
                NumberParam param = (NumberParam)iQueryParameterType;
                BigDecimal value = param.getValue();
                if (value == null) continue;
                SearchFilterParser.CompareOperation operation = theOperation;
                if (operation == null) {
                    operation = QueryStack.toOperation(param.getPrefix());
                }
                Condition predicate = join.createPredicateNumeric(theResourceName, paramName, operation, value, theRequestPartitionId, iQueryParameterType);
                codePredicates.add(predicate);
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1211) + "Invalid token type: " + iQueryParameterType.getClass());
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateQuantity(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateQuantity(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateQuantity(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        List normalizedQuantityParams;
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        if (theList.get(0).getMissing() != null) {
            QuantityBasePredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, theSearchParam.getName(), () -> theSqlBuilder.addQuantityPredicateBuilder(theSourceJoinColumn)).getResult();
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        List quantityParams = theList.stream().map(t -> QuantityParam.toQuantityParam((IQueryParameterType)t)).collect(Collectors.toList());
        QuantityBasePredicateBuilder join = null;
        boolean normalizedSearchEnabled = this.myModelConfig.getNormalizedQuantitySearchLevel().equals((Object)NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_SUPPORTED);
        if (normalizedSearchEnabled && (normalizedQuantityParams = quantityParams.stream().map(t -> UcumServiceUtil.toCanonicalQuantityOrNull((QuantityParam)t)).filter(t -> t != null).collect(Collectors.toList())).size() == quantityParams.size()) {
            join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, paramName, () -> theSqlBuilder.addQuantityNormalizedPredicateBuilder(theSourceJoinColumn)).getResult();
            quantityParams = normalizedQuantityParams;
        }
        if (join == null) {
            join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, paramName, () -> theSqlBuilder.addQuantityPredicateBuilder(theSourceJoinColumn)).getResult();
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (QuantityParam nextOr : quantityParams) {
            Condition singleCode = join.createPredicateQuantity(nextOr, theResourceName, paramName, null, join, theOperation, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateReference(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<String> theQualifiers, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateReference(theSourceJoinColumn, theResourceName, theParamName, theQualifiers, theList, theOperation, theRequest, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateReference(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<String> theQualifiers, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        if (theOperation != null && theOperation != SearchFilterParser.CompareOperation.eq && theOperation != SearchFilterParser.CompareOperation.ne) {
            throw new InvalidRequestException(Msg.code((int)1212) + "Invalid operator specified for reference predicate.  Supported operators for reference predicate are \"eq\" and \"ne\".");
        }
        if (theList.get(0).getMissing() != null) {
            SearchParamPresentPredicateBuilder join = theSqlBuilder.addSearchParamPresentPredicateBuilder(theSourceJoinColumn);
            return join.createPredicateParamMissingForReference(theResourceName, theParamName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        ResourceLinkPredicateBuilder predicateBuilder = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.REFERENCE, theSourceJoinColumn, theParamName, () -> theSqlBuilder.addReferencePredicateBuilder(this, theSourceJoinColumn)).getResult();
        return predicateBuilder.createPredicate(theRequest, theResourceName, theParamName, theQualifiers, theList, theOperation, theRequestPartitionId);
    }

    public Condition createPredicateReferenceForContainedResource(@Nullable DbColumn theSourceJoinColumn, String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        EnumSet<PredicateBuilderTypeEnum> cachedReusePredicateBuilderTypes = EnumSet.copyOf(this.myReusePredicateBuilderTypes);
        this.myReusePredicateBuilderTypes.clear();
        UnionQuery union = new UnionQuery(SetOperationQuery.Type.UNION_ALL);
        ReferenceChainExtractor chainExtractor = new ReferenceChainExtractor();
        chainExtractor.deriveChains(theResourceName, theSearchParam, theList);
        Map<List<ChainElement>, Set<LeafNodeDefinition>> chains = chainExtractor.getChains();
        HashMap referenceLinks = Maps.newHashMap();
        for (List<ChainElement> nextChain : chains.keySet()) {
            Set<LeafNodeDefinition> leafNodes = chains.get(nextChain);
            this.collateChainedSearchOptions(referenceLinks, nextChain, leafNodes);
        }
        for (List<ChainElement> nextReferenceLink : referenceLinks.keySet()) {
            for (LeafNodeDefinition leafNodeDefinition : (Set)referenceLinks.get(nextReferenceLink)) {
                SearchQueryBuilder builder = this.mySqlBuilder.newChildSqlBuilder();
                DbColumn previousJoinColumn = null;
                for (String string : nextReferenceLink) {
                    ResourceLinkPredicateBuilder resourceLinkPredicateBuilder = builder.addReferencePredicateBuilder(this, previousJoinColumn);
                    builder.addPredicate(resourceLinkPredicateBuilder.createPredicateSourcePaths(Lists.newArrayList((Object[])new String[]{string})));
                    previousJoinColumn = resourceLinkPredicateBuilder.getColumnTargetResourceId();
                }
                Condition containedCondition = this.createIndexPredicate(previousJoinColumn, leafNodeDefinition.getLeafTarget(), leafNodeDefinition.getLeafPathPrefix(), leafNodeDefinition.getLeafParamName(), leafNodeDefinition.getParamDefinition(), leafNodeDefinition.getOrValues(), theOperation, leafNodeDefinition.getQualifiers(), theRequest, theRequestPartitionId, builder);
                builder.addPredicate(containedCondition);
                union.addQueries(new SelectQuery[]{builder.getSelect()});
            }
        }
        InCondition inCondition = theSourceJoinColumn == null ? new InCondition((Object)this.mySqlBuilder.getOrCreateFirstPredicateBuilder(false).getResourceIdColumn(), new Object[]{union}) : new InCondition((Object)theSourceJoinColumn, new Object[]{union});
        this.myReusePredicateBuilderTypes.addAll(cachedReusePredicateBuilderTypes);
        return inCondition;
    }

    private void collateChainedSearchOptions(Map<List<String>, Set<LeafNodeDefinition>> referenceLinks, List<ChainElement> nextChain, Set<LeafNodeDefinition> leafNodes) {
        if (nextChain.size() == 1) {
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath()}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList(), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(0)).getResourceType(), ((ChainElement)nextChain.get(0)).getSearchParameterName())).collect(Collectors.toSet()));
        } else if (nextChain.size() == 2) {
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), nextChain.get(1).getPath()}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath()}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(1)).getResourceType(), ((ChainElement)nextChain.get(1)).getSearchParameterName())).collect(Collectors.toSet()));
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath())}), leafNodes);
            if (this.myModelConfig.isIndexOnContainedResourcesRecursively()) {
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList(), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(0)).getResourceType(), ((ChainElement)nextChain.get(0)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(1)).getSearchParameterName())).collect(Collectors.toSet()));
            }
        } else if (nextChain.size() == 3) {
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), nextChain.get(1).getPath(), nextChain.get(2).getPath()}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), nextChain.get(1).getPath()}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(2)).getResourceType(), ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath(), this.mergePaths(nextChain.get(1).getPath(), nextChain.get(2).getPath())}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath()), nextChain.get(2).getPath()}), leafNodes);
            this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath())}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(2)).getResourceType(), ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
            if (this.myModelConfig.isIndexOnContainedResourcesRecursively()) {
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{this.mergePaths(nextChain.get(0).getPath(), nextChain.get(1).getPath(), nextChain.get(2).getPath())}), leafNodes);
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList((Object[])new String[]{nextChain.get(0).getPath()}), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(1)).getResourceType(), ((ChainElement)nextChain.get(1)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
                this.updateMapOfReferenceLinks(referenceLinks, Lists.newArrayList(), leafNodes.stream().map(t -> t.withPathPrefix(((ChainElement)nextChain.get(0)).getResourceType(), ((ChainElement)nextChain.get(0)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(1)).getSearchParameterName() + "." + ((ChainElement)nextChain.get(2)).getSearchParameterName())).collect(Collectors.toSet()));
            }
        } else {
            throw new InvalidRequestException(Msg.code((int)2011) + "The search chain is too long. Only chains of up to three references are supported.");
        }
    }

    private void updateMapOfReferenceLinks(Map<List<String>, Set<LeafNodeDefinition>> theReferenceLinksMap, ArrayList<String> thePath, Set<LeafNodeDefinition> theLeafNodesToAdd) {
        HashSet leafNodes = theReferenceLinksMap.get(thePath);
        if (leafNodes == null) {
            leafNodes = Sets.newHashSet();
            theReferenceLinksMap.put(thePath, leafNodes);
        }
        leafNodes.addAll(theLeafNodesToAdd);
    }

    private String mergePaths(String ... paths) {
        Object result = "";
        for (String nextPath : paths) {
            int separatorIndex = nextPath.indexOf(46);
            result = StringUtils.isEmpty((CharSequence)result) ? nextPath : (String)result + nextPath.substring(separatorIndex);
        }
        return result;
    }

    private Condition createIndexPredicate(DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, String theParamName, RuntimeSearchParam theParamDefinition, ArrayList<IQueryParameterType> theOrValues, SearchFilterParser.CompareOperation theOperation, List<String> theQualifiers, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        Condition containedCondition;
        switch (theParamDefinition.getParamType()) {
            case DATE: {
                containedCondition = this.createPredicateDate(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case NUMBER: {
                containedCondition = this.createPredicateNumber(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case QUANTITY: {
                containedCondition = this.createPredicateQuantity(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case STRING: {
                containedCondition = this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case TOKEN: {
                containedCondition = this.createPredicateToken(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case COMPOSITE: {
                containedCondition = this.createPredicateComposite(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case URI: {
                containedCondition = this.createPredicateUri(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParamDefinition, theOrValues, theOperation, theRequest, theRequestPartitionId, theSqlBuilder);
                break;
            }
            case REFERENCE: {
                containedCondition = this.createPredicateReference(theSourceJoinColumn, theResourceName, (String)(StringUtils.isBlank((CharSequence)theSpnamePrefix) ? theParamName : theSpnamePrefix + "." + theParamName), theQualifiers, theOrValues, theOperation, theRequest, theRequestPartitionId, theSqlBuilder);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1215) + "The search type:" + theParamDefinition.getParamType() + " is not supported.");
            }
        }
        return containedCondition;
    }

    @Nullable
    public Condition createPredicateResourceId(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theValues, String theResourceName, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        ResourceIdPredicateBuilder builder = this.mySqlBuilder.newResourceIdBuilder();
        return builder.createPredicateResourceId(theSourceJoinColumn, theResourceName, theValues, theOperation, theRequestPartitionId);
    }

    private Condition createPredicateSourceForAndList(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theAndOrParams) {
        ArrayList<Condition> andPredicates = new ArrayList<Condition>(theAndOrParams.size());
        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
            andPredicates.add(this.createPredicateSource(theSourceJoinColumn, nextAnd));
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    private Condition createPredicateSource(@Nullable DbColumn theSourceJoinColumn, List<? extends IQueryParameterType> theList) {
        if (this.myDaoConfig.getStoreMetaSourceInformation() == DaoConfig.StoreMetaSourceInformationEnum.NONE) {
            String msg = this.myFhirContext.getLocalizer().getMessage(QueryStack.class, "sourceParamDisabled", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)1216) + msg);
        }
        SourcePredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.SOURCE, theSourceJoinColumn, "_source", () -> this.mySqlBuilder.addSourcePredicateBuilder(theSourceJoinColumn)).getResult();
        ArrayList<Condition> orPredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            SourceParam sourceParameter = new SourceParam(iQueryParameterType.getValueAsQueryToken(this.myFhirContext));
            String sourceUri = sourceParameter.getSourceUri();
            String requestId = sourceParameter.getRequestId();
            if (StringUtils.isNotBlank((CharSequence)sourceUri) && StringUtils.isNotBlank((CharSequence)requestId)) {
                orPredicates.add(QueryStack.toAndPredicate(join.createPredicateSourceUri(sourceUri), join.createPredicateRequestId(requestId)));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)sourceUri)) {
                orPredicates.add(join.createPredicateSourceUri(sourceUri));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)requestId)) continue;
            orPredicates.add(join.createPredicateRequestId(requestId));
        }
        return QueryStack.toOrPredicate(orPredicates);
    }

    public Condition createPredicateString(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateString(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        StringPredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.STRING, theSourceJoinColumn, paramName, () -> theSqlBuilder.addStringPredicateBuilder(theSourceJoinColumn)).getResult();
        if (theList.get(0).getMissing() != null) {
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition singleCode = join.createPredicateString(iQueryParameterType, theResourceName, theSpnamePrefix, theSearchParam, join, theOperation);
            codePredicates.add(singleCode);
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, QueryStack.toOrPredicate(codePredicates));
    }

    public Condition createPredicateTag(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theList, String theParamName, RequestPartitionId theRequestPartitionId) {
        TagTypeEnum tagType;
        if ("_tag".equals(theParamName)) {
            tagType = TagTypeEnum.TAG;
        } else if ("_profile".equals(theParamName)) {
            tagType = TagTypeEnum.PROFILE;
        } else if ("_security".equals(theParamName)) {
            tagType = TagTypeEnum.SECURITY_LABEL;
        } else {
            throw new IllegalArgumentException(Msg.code((int)1217) + "Param name: " + theParamName);
        }
        ArrayList<Condition> andPredicates = new ArrayList<Condition>();
        for (List<IQueryParameterType> nextAndParams : theList) {
            Condition tagPredicate;
            BaseJoiningPredicateBuilder join;
            if (!this.checkHaveTags(nextAndParams, theParamName)) continue;
            ArrayList tokens = Lists.newArrayList();
            boolean paramInverted = this.populateTokens(tokens, nextAndParams);
            if (tokens.isEmpty()) continue;
            if (paramInverted) {
                SearchQueryBuilder sqlBuilder = this.mySqlBuilder.newChildSqlBuilder();
                TagPredicateBuilder tagSelector = sqlBuilder.addTagPredicateBuilder(null);
                sqlBuilder.addPredicate(tagSelector.createPredicateTag(tagType, tokens, theParamName, theRequestPartitionId));
                SelectQuery sql = sqlBuilder.getSelect();
                join = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
                Subquery subSelect = new Subquery((Object)sql);
                tagPredicate = new InCondition((Object)join.getResourceIdColumn(), new Object[]{subSelect}).setNegate(true);
            } else {
                this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
                TagPredicateBuilder tagJoin = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.TAG, theSourceJoinColumn, theParamName, () -> this.mySqlBuilder.addTagPredicateBuilder(theSourceJoinColumn)).getResult();
                tagPredicate = tagJoin.createPredicateTag(tagType, tokens, theParamName, theRequestPartitionId);
                join = tagJoin;
            }
            andPredicates.add(join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, tagPredicate));
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    private boolean populateTokens(List<Triple<String, String, String>> theTokens, List<? extends IQueryParameterType> theAndParams) {
        boolean paramInverted = false;
        for (IQueryParameterType iQueryParameterType : theAndParams) {
            String system;
            String code;
            TokenParam nextParam;
            if (iQueryParameterType instanceof TokenParam) {
                nextParam = (TokenParam)iQueryParameterType;
                code = nextParam.getValue();
                system = nextParam.getSystem();
                if (nextParam.getModifier() == TokenParamModifier.NOT) {
                    paramInverted = true;
                }
            } else {
                nextParam = (UriParam)iQueryParameterType;
                code = nextParam.getValue();
                system = null;
            }
            if (!StringUtils.isNotBlank((CharSequence)code)) continue;
            theTokens.add((Triple<String, String, String>)Triple.of((Object)system, (Object)iQueryParameterType.getQueryParameterQualifier(), (Object)code));
        }
        return paramInverted;
    }

    private boolean checkHaveTags(List<? extends IQueryParameterType> theParams, String theParamName) {
        for (IQueryParameterType iQueryParameterType : theParams) {
            TokenParam nextParam;
            if (iQueryParameterType instanceof TokenParam) {
                nextParam = (TokenParam)iQueryParameterType;
                if (StringUtils.isNotBlank((CharSequence)nextParam.getValue())) {
                    return true;
                }
                if (StringUtils.isNotBlank((CharSequence)nextParam.getSystem())) {
                    throw new TokenParamFormatInvalidRequestException(Msg.code((int)1218), theParamName, nextParam.getValueAsQueryToken(this.myFhirContext));
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(nextParam = (UriParam)iQueryParameterType).getValue())) continue;
            return true;
        }
        return false;
    }

    public Condition createPredicateToken(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateToken(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestPartitionId, this.mySqlBuilder);
    }

    /*
     * WARNING - void declaration
     */
    public Condition createPredicateToken(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        void var13_18;
        BaseJoiningPredicateBuilder join;
        ArrayList<IQueryParameterType> tokens = new ArrayList<IQueryParameterType>();
        boolean paramInverted = false;
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof TokenParam) {
                if (((TokenParam)iQueryParameterType).isEmpty()) continue;
                TokenParam id = (TokenParam)iQueryParameterType;
                if (id.isText()) {
                    boolean tokenTextIndexingEnabled = BaseSearchParamExtractor.tokenTextIndexingEnabledForSearchParam((ModelConfig)this.myModelConfig, (RuntimeSearchParam)theSearchParam);
                    if (!tokenTextIndexingEnabled) {
                        String msg = this.myModelConfig.isSuppressStringIndexingInTokens() ? this.myFhirContext.getLocalizer().getMessage(QueryStack.class, "textModifierDisabledForServer", new Object[0]) : this.myFhirContext.getLocalizer().getMessage(QueryStack.class, "textModifierDisabledForSearchParam", new Object[0]);
                        throw new MethodNotAllowedException(Msg.code((int)1219) + msg);
                    }
                    return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, null, theRequestPartitionId, theSqlBuilder);
                }
                TokenParamModifier modifier = id.getModifier();
                if (modifier == TokenParamModifier.NOT) {
                    tokens.add((IQueryParameterType)new TokenParam(((TokenParam)iQueryParameterType).getSystem(), ((TokenParam)iQueryParameterType).getValue()));
                    paramInverted = true;
                    continue;
                }
                tokens.add(iQueryParameterType);
                continue;
            }
            tokens.add(iQueryParameterType);
        }
        if (tokens.isEmpty()) {
            return null;
        }
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        if (paramInverted) {
            SearchQueryBuilder sqlBuilder = theSqlBuilder.newChildSqlBuilder();
            TokenPredicateBuilder tokenSelector = sqlBuilder.addTokenPredicateBuilder(null);
            sqlBuilder.addPredicate(tokenSelector.createPredicateToken(tokens, theResourceName, theSpnamePrefix, theSearchParam, theRequestPartitionId));
            SelectQuery sql = sqlBuilder.getSelect();
            Subquery subSelect = new Subquery((Object)sql);
            join = theSqlBuilder.getOrCreateFirstPredicateBuilder();
            if (theSourceJoinColumn == null) {
                InCondition inCondition = new InCondition((Object)join.getResourceIdColumn(), new Object[]{subSelect}).setNegate(true);
            } else {
                InCondition inCondition = new InCondition((Object)theSourceJoinColumn, new Object[]{subSelect}).setNegate(true);
            }
        } else {
            TokenPredicateBuilder tokenJoin = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.TOKEN, theSourceJoinColumn, paramName, () -> theSqlBuilder.addTokenPredicateBuilder(theSourceJoinColumn)).getResult();
            if (theList.get(0).getMissing() != null) {
                return tokenJoin.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
            }
            Condition condition = tokenJoin.createPredicateToken(tokens, theResourceName, theSpnamePrefix, theSearchParam, theOperation, theRequestPartitionId);
            join = tokenJoin;
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)var13_18);
    }

    public Condition createPredicateUri(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        return this.createPredicateUri(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, theOperation, theRequestDetails, theRequestPartitionId, this.mySqlBuilder);
    }

    public Condition createPredicateUri(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId, SearchQueryBuilder theSqlBuilder) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        UriPredicateBuilder join = theSqlBuilder.addUriPredicateBuilder(theSourceJoinColumn);
        if (theList.get(0).getMissing() != null) {
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        Condition predicate = join.addPredicate(theList, paramName, theOperation, theRequestDetails);
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
    }

    public QueryStack newChildQueryFactoryWithFullBuilderReuse() {
        return new QueryStack(this.mySearchParameters, this.myDaoConfig, this.myModelConfig, this.myFhirContext, this.mySqlBuilder, this.mySearchParamRegistry, this.myPartitionSettings, EnumSet.allOf(PredicateBuilderTypeEnum.class));
    }

    @Nullable
    public Condition searchForIdsWithAndOr(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, SearchContainedModeEnum theSearchContainedMode) {
        if (theAndOrParams.isEmpty()) {
            return null;
        }
        switch (theParamName) {
            case "_id": {
                return this.createPredicateResourceId(theSourceJoinColumn, theAndOrParams, theResourceName, null, theRequestPartitionId);
            }
            case "_has": {
                return this.createPredicateHas(theSourceJoinColumn, theResourceName, theAndOrParams, theRequest, theRequestPartitionId);
            }
            case "_tag": 
            case "_profile": 
            case "_security": {
                if (this.myDaoConfig.getTagStorageMode() == DaoConfig.TagStorageModeEnum.INLINE) {
                    return this.createPredicateSearchParameter(theSourceJoinColumn, theResourceName, theParamName, theAndOrParams, theRequest, theRequestPartitionId);
                }
                return this.createPredicateTag(theSourceJoinColumn, theAndOrParams, theParamName, theRequestPartitionId);
            }
            case "_source": {
                return this.createPredicateSourceForAndList(theSourceJoinColumn, theAndOrParams);
            }
        }
        return this.createPredicateSearchParameter(theSourceJoinColumn, theResourceName, theParamName, theAndOrParams, theRequest, theRequestPartitionId);
    }

    @Nullable
    private Condition createPredicateSearchParameter(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        ArrayList<Condition> andPredicates;
        block35: {
            block34: {
                andPredicates = new ArrayList<Condition>();
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
                if (nextParamDef == null) break block34;
                if (this.myPartitionSettings.isPartitioningEnabled() && this.myPartitionSettings.isIncludePartitionInSearchHashes() && theRequestPartitionId.isAllPartitions()) {
                    throw new PreconditionFailedException(Msg.code((int)1220) + "This server is not configured to support search against all partitions");
                }
                switch (nextParamDef.getParamType()) {
                    case DATE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            SearchFilterParser.CompareOperation operation = null;
                            if (nextAnd.size() > 0) {
                                DateParam param = (DateParam)nextAnd.get(0);
                                operation = QueryStack.toOperation(param.getPrefix());
                            }
                            andPredicates.add(this.createPredicateDate(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, operation, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case QUANTITY: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            SearchFilterParser.CompareOperation operation = null;
                            if (nextAnd.size() > 0) {
                                QuantityParam param = (QuantityParam)nextAnd.get(0);
                                operation = QueryStack.toOperation(param.getPrefix());
                            }
                            andPredicates.add(this.createPredicateQuantity(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, operation, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case REFERENCE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if (this.isEligibleForContainedResourceSearch(nextAnd)) {
                                andPredicates.add(this.createPredicateReferenceForContainedResource(theSourceJoinColumn, theResourceName, nextParamDef, nextAnd, null, theRequest, theRequestPartitionId));
                                continue;
                            }
                            andPredicates.add(this.createPredicateReference(theSourceJoinColumn, theResourceName, theParamName, new ArrayList<String>(), nextAnd, null, theRequest, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case STRING: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateString(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.sw, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case TOKEN: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if ("Location.position".equals(nextParamDef.getPath())) {
                                andPredicates.add(this.createPredicateCoords(theSourceJoinColumn, theResourceName, nextParamDef, nextAnd, theRequestPartitionId));
                                continue;
                            }
                            andPredicates.add(this.createPredicateToken(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, null, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case NUMBER: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateNumber(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, null, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case COMPOSITE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateComposite(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case URI: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateUri(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.eq, theRequest, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case HAS: 
                    case SPECIAL: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if (!"Location.position".equals(nextParamDef.getPath())) continue;
                            andPredicates.add(this.createPredicateCoords(theSourceJoinColumn, theResourceName, nextParamDef, nextAnd, theRequestPartitionId));
                        }
                        break;
                    }
                }
                break block35;
            }
            if (!"_content".equals(theParamName) && !"_text".equals(theParamName)) {
                if ("_filter".equals(theParamName)) {
                    if (theAndOrParams.get(0).get(0) instanceof StringParam) {
                        SearchFilterParser.Filter filter;
                        String filterString = ((StringParam)theAndOrParams.get(0).get(0)).getValue();
                        try {
                            filter = SearchFilterParser.parse(filterString);
                        }
                        catch (SearchFilterParser.FilterSyntaxException theE) {
                            throw new InvalidRequestException(Msg.code((int)1221) + "Error parsing _filter syntax: " + theE.getMessage());
                        }
                        if (filter != null) {
                            if (!this.myDaoConfig.isFilterParameterEnabled()) {
                                throw new InvalidRequestException(Msg.code((int)1222) + "_filter parameter is disabled on this server");
                            }
                            Condition predicate = this.createPredicateFilter(this, filter, theResourceName, theRequest, theRequestPartitionId);
                            if (predicate != null) {
                                this.mySqlBuilder.addPredicate(predicate);
                            }
                        }
                    }
                } else {
                    String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSearchParameter", new Object[]{theParamName, theResourceName, this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName)});
                    throw new InvalidRequestException(Msg.code((int)1223) + msg);
                }
            }
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    private boolean isEligibleForContainedResourceSearch(List<? extends IQueryParameterType> nextAnd) {
        return this.myModelConfig.isIndexOnContainedResources() && nextAnd.stream().filter(t -> t instanceof ReferenceParam).map(t -> ((ReferenceParam)t).getChain()).anyMatch(StringUtils::isNotBlank);
    }

    public void addPredicateCompositeUnique(String theIndexString, RequestPartitionId theRequestPartitionId) {
        ComboUniqueSearchParameterPredicateBuilder predicateBuilder = this.mySqlBuilder.addComboUniquePredicateBuilder();
        Condition predicate = predicateBuilder.createPredicateIndexString(theRequestPartitionId, theIndexString);
        this.mySqlBuilder.addPredicate(predicate);
    }

    public void addPredicateCompositeNonUnique(String theIndexString, RequestPartitionId theRequestPartitionId) {
        ComboNonUniqueSearchParameterPredicateBuilder predicateBuilder = this.mySqlBuilder.addComboNonUniquePredicateBuilder();
        Condition predicate = predicateBuilder.createPredicateHashComplete(theRequestPartitionId, theIndexString);
        this.mySqlBuilder.addPredicate(predicate);
    }

    public void addPredicateEverythingOperation(String theResourceName, List<String> theTypeSourceResourceNames, Long ... theTargetPids) {
        ResourceLinkPredicateBuilder table = this.mySqlBuilder.addReferencePredicateBuilder(this, null);
        Condition predicate = table.createEverythingPredicate(theResourceName, theTypeSourceResourceNames, theTargetPids);
        this.mySqlBuilder.addPredicate(predicate);
    }

    private IQueryParameterType toParameterType(RuntimeSearchParam theParam) {
        DateParam qp;
        switch (theParam.getParamType()) {
            case DATE: {
                qp = new DateParam();
                break;
            }
            case NUMBER: {
                qp = new NumberParam();
                break;
            }
            case QUANTITY: {
                qp = new QuantityParam();
                break;
            }
            case STRING: {
                qp = new StringParam();
                break;
            }
            case TOKEN: {
                qp = new TokenParam();
                break;
            }
            case COMPOSITE: {
                List compositeOf = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParam);
                if (compositeOf.size() != 2) {
                    throw new InternalErrorException(Msg.code((int)1224) + "Parameter " + theParam.getName() + " has " + compositeOf.size() + " composite parts. Don't know how handlt this.");
                }
                IQueryParameterType leftParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(0));
                IQueryParameterType rightParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(1));
                qp = new CompositeParam(leftParam, rightParam);
                break;
            }
            case URI: {
                qp = new UriParam();
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1225) + "The search type: " + theParam.getParamType() + " is not supported.");
            }
        }
        return qp;
    }

    @Nullable
    public static Condition toAndPredicate(List<Condition> theAndPredicates) {
        List<Condition> andPredicates = theAndPredicates.stream().filter(t -> t != null).collect(Collectors.toList());
        if (andPredicates.size() == 0) {
            return null;
        }
        if (andPredicates.size() == 1) {
            return (Condition)andPredicates.get(0);
        }
        return ComboCondition.and((Condition[])andPredicates.toArray(new Condition[0]));
    }

    @Nullable
    public static Condition toOrPredicate(List<Condition> theOrPredicates) {
        List<Condition> orPredicates = theOrPredicates.stream().filter(t -> t != null).collect(Collectors.toList());
        if (orPredicates.size() == 0) {
            return null;
        }
        if (orPredicates.size() == 1) {
            return (Condition)orPredicates.get(0);
        }
        return ComboCondition.or((Condition[])orPredicates.toArray(new Condition[0]));
    }

    @Nullable
    public static Condition toOrPredicate(Condition ... theOrPredicates) {
        return QueryStack.toOrPredicate(Arrays.asList(theOrPredicates));
    }

    @Nullable
    public static Condition toAndPredicate(Condition ... theAndPredicates) {
        return QueryStack.toAndPredicate(Arrays.asList(theAndPredicates));
    }

    @Nonnull
    public static Condition toEqualToOrInPredicate(DbColumn theColumn, List<String> theValuePlaceholders, boolean theInverse) {
        if (theInverse) {
            return QueryStack.toNotEqualToOrNotInPredicate(theColumn, theValuePlaceholders);
        }
        return QueryStack.toEqualToOrInPredicate(theColumn, theValuePlaceholders);
    }

    @Nonnull
    public static Condition toEqualToOrInPredicate(DbColumn theColumn, List<String> theValuePlaceholders) {
        if (theValuePlaceholders.size() == 1) {
            return BinaryCondition.equalTo((Object)theColumn, (Object)theValuePlaceholders.get(0));
        }
        return new InCondition((Object)theColumn, theValuePlaceholders);
    }

    @Nonnull
    public static Condition toNotEqualToOrNotInPredicate(DbColumn theColumn, List<String> theValuePlaceholders) {
        if (theValuePlaceholders.size() == 1) {
            return BinaryCondition.notEqualTo((Object)theColumn, (Object)theValuePlaceholders.get(0));
        }
        return new InCondition((Object)theColumn, theValuePlaceholders).setNegate(true);
    }

    public static SearchFilterParser.CompareOperation toOperation(ParamPrefixEnum thePrefix) {
        SearchFilterParser.CompareOperation retVal = null;
        if (thePrefix != null && ourCompareOperationToParamPrefix.containsValue((Object)thePrefix)) {
            retVal = (SearchFilterParser.CompareOperation)((Object)ourCompareOperationToParamPrefix.getKey((Object)thePrefix));
        }
        return (SearchFilterParser.CompareOperation)((Object)ObjectUtils.defaultIfNull(retVal, (Object)((Object)SearchFilterParser.CompareOperation.eq)));
    }

    public static ParamPrefixEnum fromOperation(SearchFilterParser.CompareOperation thePrefix) {
        ParamPrefixEnum retVal = null;
        if (thePrefix != null && ourCompareOperationToParamPrefix.containsKey((Object)thePrefix)) {
            retVal = (ParamPrefixEnum)ourCompareOperationToParamPrefix.get((Object)thePrefix);
        }
        return (ParamPrefixEnum)ObjectUtils.defaultIfNull(retVal, (Object)ParamPrefixEnum.EQUAL);
    }

    private static String getChainedPart(String parameter) {
        return parameter.substring(parameter.indexOf(".") + 1);
    }

    public static String getParamNameWithPrefix(String theSpnamePrefix, String theParamName) {
        if (StringUtils.isBlank((CharSequence)theSpnamePrefix)) {
            return theParamName;
        }
        return theSpnamePrefix + "." + theParamName;
    }

    static {
        DualHashBidiMap compareOperationToParamPrefix = new DualHashBidiMap();
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ap, (Object)ParamPrefixEnum.APPROXIMATE);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.eq, (Object)ParamPrefixEnum.EQUAL);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.gt, (Object)ParamPrefixEnum.GREATERTHAN);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ge, (Object)ParamPrefixEnum.GREATERTHAN_OR_EQUALS);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.lt, (Object)ParamPrefixEnum.LESSTHAN);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.le, (Object)ParamPrefixEnum.LESSTHAN_OR_EQUALS);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ne, (Object)ParamPrefixEnum.NOT_EQUAL);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.eb, (Object)ParamPrefixEnum.ENDS_BEFORE);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.sa, (Object)ParamPrefixEnum.STARTS_AFTER);
        ourCompareOperationToParamPrefix = UnmodifiableBidiMap.unmodifiableBidiMap((BidiMap)compareOperationToParamPrefix);
    }

    private static enum PredicateBuilderTypeEnum {
        DATE,
        COORDS,
        NUMBER,
        QUANTITY,
        REFERENCE,
        SOURCE,
        STRING,
        TOKEN,
        TAG;

    }

    private static class PredicateBuilderCacheKey {
        private final DbColumn myDbColumn;
        private final PredicateBuilderTypeEnum myType;
        private final String myParamName;
        private final int myHashCode;

        private PredicateBuilderCacheKey(DbColumn theDbColumn, PredicateBuilderTypeEnum theType, String theParamName) {
            this.myDbColumn = theDbColumn;
            this.myType = theType;
            this.myParamName = theParamName;
            this.myHashCode = new HashCodeBuilder().append((Object)this.myDbColumn).append((Object)this.myType).append((Object)this.myParamName).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            PredicateBuilderCacheKey that = (PredicateBuilderCacheKey)theO;
            return new EqualsBuilder().append((Object)this.myDbColumn, (Object)that.myDbColumn).append((Object)this.myType, (Object)that.myType).append((Object)this.myParamName, (Object)that.myParamName).isEquals();
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }

    private static class PredicateBuilderCacheLookupResult<T extends BaseJoiningPredicateBuilder> {
        private final boolean myCacheHit;
        private final T myResult;

        private PredicateBuilderCacheLookupResult(boolean theCacheHit, T theResult) {
            this.myCacheHit = theCacheHit;
            this.myResult = theResult;
        }

        public boolean isCacheHit() {
            return this.myCacheHit;
        }

        public T getResult() {
            return this.myResult;
        }
    }

    private class ReferenceChainExtractor {
        private final Map<List<ChainElement>, Set<LeafNodeDefinition>> myChains = Maps.newHashMap();

        private ReferenceChainExtractor() {
        }

        public Map<List<ChainElement>, Set<LeafNodeDefinition>> getChains() {
            return this.myChains;
        }

        private boolean isReferenceParamValid(ReferenceParam theReferenceParam) {
            return StringUtils.split((String)theReferenceParam.getChain(), (char)'.').length <= 3;
        }

        private List<String> extractPaths(String theResourceType, RuntimeSearchParam theSearchParam) {
            List<String> pathsForType = theSearchParam.getPathsSplit().stream().map(String::trim).filter(t -> t.startsWith(theResourceType)).collect(Collectors.toList());
            if (pathsForType.isEmpty()) {
                ourLog.warn("Search parameter {} does not have a path for resource type {}.", (Object)theSearchParam.getName(), (Object)theResourceType);
            }
            return pathsForType;
        }

        public void deriveChains(String theResourceType, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList) {
            List<String> paths = this.extractPaths(theResourceType, theSearchParam);
            for (String path : paths) {
                ArrayList searchParams = Lists.newArrayList();
                searchParams.add(new ChainElement(theResourceType, theSearchParam.getName(), path));
                for (IQueryParameterType iQueryParameterType : theList) {
                    String targetValue = iQueryParameterType.getValueAsQueryToken(QueryStack.this.myFhirContext);
                    if (!(iQueryParameterType instanceof ReferenceParam)) continue;
                    ReferenceParam referenceParam = (ReferenceParam)iQueryParameterType;
                    if (!this.isReferenceParamValid(referenceParam)) {
                        throw new InvalidRequestException(Msg.code((int)2007) + "The search chain " + theSearchParam.getName() + "." + referenceParam.getChain() + " is too long. Only chains up to three references are supported.");
                    }
                    String targetChain = referenceParam.getChain();
                    ArrayList qualifiers = Lists.newArrayList((Object[])new String[]{referenceParam.getResourceType()});
                    this.processNextLinkInChain(searchParams, theSearchParam, targetChain, targetValue, qualifiers, referenceParam.getResourceType());
                }
            }
        }

        private void processNextLinkInChain(List<ChainElement> theSearchParams, RuntimeSearchParam thePreviousSearchParam, String theChain, String theTargetValue, List<String> theQualifiers, String theResourceType) {
            int qualifierIndex;
            String nextParamName = theChain;
            String nextChain = null;
            String nextQualifier = null;
            int linkIndex = theChain.indexOf(46);
            if (linkIndex != -1) {
                nextParamName = theChain.substring(0, linkIndex);
                nextChain = theChain.substring(linkIndex + 1);
            }
            if ((qualifierIndex = nextParamName.indexOf(58)) != -1) {
                nextParamName = nextParamName.substring(0, qualifierIndex);
                nextQualifier = nextParamName.substring(qualifierIndex);
            }
            ArrayList qualifiersBranch = Lists.newArrayList();
            qualifiersBranch.addAll(theQualifiers);
            qualifiersBranch.add(nextQualifier);
            boolean searchParamFound = false;
            for (String nextTarget : thePreviousSearchParam.getTargets()) {
                RuntimeSearchParam nextSearchParam = null;
                if (StringUtils.isBlank((CharSequence)theResourceType) || theResourceType.equals(nextTarget)) {
                    nextSearchParam = QueryStack.this.mySearchParamRegistry.getActiveSearchParam(nextTarget, nextParamName);
                }
                if (nextSearchParam == null) continue;
                searchParamFound = true;
                if (StringUtils.isEmpty((CharSequence)nextChain)) {
                    ArrayList orValues = Lists.newArrayList();
                    if (RestSearchParameterTypeEnum.REFERENCE.equals((Object)nextSearchParam.getParamType())) {
                        orValues.add(new ReferenceParam(nextQualifier, "", theTargetValue));
                    } else {
                        IQueryParameterType qp = QueryStack.this.toParameterType(nextSearchParam);
                        qp.setValueAsQueryToken(QueryStack.this.myFhirContext, nextSearchParam.getName(), null, theTargetValue);
                        orValues.add(qp);
                    }
                    HashSet leafNodes = this.myChains.get(theSearchParams);
                    if (leafNodes == null) {
                        leafNodes = Sets.newHashSet();
                        this.myChains.put(theSearchParams, leafNodes);
                    }
                    leafNodes.add(new LeafNodeDefinition(nextSearchParam, orValues, nextTarget, nextParamName, "", qualifiersBranch));
                    continue;
                }
                List<String> nextPaths = this.extractPaths(nextTarget, nextSearchParam);
                for (String nextPath : nextPaths) {
                    ArrayList searchParamBranch = Lists.newArrayList();
                    searchParamBranch.addAll(theSearchParams);
                    searchParamBranch.add(new ChainElement(nextTarget, nextSearchParam.getName(), nextPath));
                    this.processNextLinkInChain(searchParamBranch, nextSearchParam, nextChain, theTargetValue, qualifiersBranch, nextQualifier);
                }
            }
            if (!searchParamFound) {
                throw new InvalidRequestException(Msg.code((int)1214) + QueryStack.this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "invalidParameterChain", new Object[]{thePreviousSearchParam.getName() + "." + theChain}));
            }
        }
    }

    private static class LeafNodeDefinition {
        private final RuntimeSearchParam myParamDefinition;
        private final ArrayList<IQueryParameterType> myOrValues;
        private final String myLeafTarget;
        private final String myLeafParamName;
        private final String myLeafPathPrefix;
        private final List<String> myQualifiers;

        public LeafNodeDefinition(RuntimeSearchParam theParamDefinition, ArrayList<IQueryParameterType> theOrValues, String theLeafTarget, String theLeafParamName, String theLeafPathPrefix, List<String> theQualifiers) {
            this.myParamDefinition = theParamDefinition;
            this.myOrValues = theOrValues;
            this.myLeafTarget = theLeafTarget;
            this.myLeafParamName = theLeafParamName;
            this.myLeafPathPrefix = theLeafPathPrefix;
            this.myQualifiers = theQualifiers;
        }

        public RuntimeSearchParam getParamDefinition() {
            return this.myParamDefinition;
        }

        public ArrayList<IQueryParameterType> getOrValues() {
            return this.myOrValues;
        }

        public String getLeafTarget() {
            return this.myLeafTarget;
        }

        public String getLeafParamName() {
            return this.myLeafParamName;
        }

        public String getLeafPathPrefix() {
            return this.myLeafPathPrefix;
        }

        public List<String> getQualifiers() {
            return this.myQualifiers;
        }

        public LeafNodeDefinition withPathPrefix(String theResourceType, String theName) {
            return new LeafNodeDefinition(this.myParamDefinition, this.myOrValues, theResourceType, this.myLeafParamName, theName, this.myQualifiers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeafNodeDefinition that = (LeafNodeDefinition)o;
            return Objects.equals(this.myParamDefinition, that.myParamDefinition) && Objects.equals(this.myOrValues, that.myOrValues) && Objects.equals(this.myLeafTarget, that.myLeafTarget) && Objects.equals(this.myLeafParamName, that.myLeafParamName) && Objects.equals(this.myLeafPathPrefix, that.myLeafPathPrefix) && Objects.equals(this.myQualifiers, that.myQualifiers);
        }

        public int hashCode() {
            return Objects.hash(this.myParamDefinition, this.myOrValues, this.myLeafTarget, this.myLeafParamName, this.myLeafPathPrefix, this.myQualifiers);
        }
    }

    private class ChainElement {
        private final String myResourceType;
        private final String mySearchParameterName;
        private final String myPath;

        public ChainElement(String theResourceType, String theSearchParameterName, String thePath) {
            this.myResourceType = theResourceType;
            this.mySearchParameterName = theSearchParameterName;
            this.myPath = thePath;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getSearchParameterName() {
            return this.mySearchParameterName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChainElement that = (ChainElement)o;
            return this.myResourceType.equals(that.myResourceType) && this.mySearchParameterName.equals(that.mySearchParameterName) && this.myPath.equals(that.myPath);
        }

        public int hashCode() {
            return Objects.hash(this.myResourceType, this.mySearchParameterName, this.myPath);
        }
    }
}

