/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.config.HapiFhirLocalContainerEntityManagerFactoryBean;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.data.IResourceSearchViewDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.entity.ResourceSearchView;
import ca.uhn.fhir.jpa.interceptor.JpaPreResourceAccessDetails;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTag;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.SearchQueryExecutors;
import ca.uhn.fhir.jpa.search.builder.sql.GeneratedSql;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.sql.SqlObjectFactory;
import ca.uhn.fhir.jpa.search.lastn.IElasticsearchSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.Dstu3DistanceHelper;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.LastNParameterHelper;
import ca.uhn.fhir.jpa.util.BaseIterator;
import ca.uhn.fhir.jpa.util.CurrentThreadCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.jpa.util.SqlQueryList;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SearchBuilder
implements ISearchBuilder {
    @Deprecated
    public static final int MAXIMUM_PAGE_SIZE = 800;
    public static final int MAXIMUM_PAGE_SIZE_FOR_TESTING = 50;
    private static final Logger ourLog = LoggerFactory.getLogger(SearchBuilder.class);
    private static final ResourcePersistentId NO_MORE = new ResourcePersistentId((Object)-1L);
    private static final String MY_TARGET_RESOURCE_PID = "myTargetResourcePid";
    private static final String MY_SOURCE_RESOURCE_PID = "mySourceResourcePid";
    private static final String MY_TARGET_RESOURCE_VERSION = "myTargetResourceVersion";
    public static final String RESOURCE_ID_ALIAS = "resource_id";
    public static final String RESOURCE_VERSION_ALIAS = "resource_version";
    public static boolean myUseMaxPageSize50ForTest = false;
    private final String myResourceName;
    private final Class<? extends IBaseResource> myResourceType;
    private final IDao myCallingDao;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected IResourceTagDao myResourceTagDao;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IResourceSearchViewDao myResourceSearchViewDao;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired(required=false)
    private IElasticsearchSvc myIElasticsearchSvc;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    private List<ResourcePersistentId> myAlsoIncludePids;
    private CriteriaBuilder myCriteriaBuilder;
    private SearchParameterMap myParams;
    private String mySearchUuid;
    private int myFetchSize;
    private Integer myMaxResultsToFetch;
    private Set<ResourcePersistentId> myPidSet;
    private boolean myHasNextIteratorQuery = false;
    private RequestPartitionId myRequestPartitionId;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private HapiFhirLocalContainerEntityManagerFactoryBean myEntityManagerFactory;
    @Autowired
    private SqlObjectFactory mySqlBuilderFactory;
    @Autowired
    private HibernatePropertiesProvider myDialectProvider;
    @Autowired
    private ModelConfig myModelConfig;

    public SearchBuilder(IDao theDao, String theResourceName, Class<? extends IBaseResource> theResourceType) {
        this.myCallingDao = theDao;
        this.myResourceName = theResourceName;
        this.myResourceType = theResourceType;
    }

    public void setMaxResultsToFetch(Integer theMaxResultsToFetch) {
        this.myMaxResultsToFetch = theMaxResultsToFetch;
    }

    private void searchForIdsWithAndOr(SearchQueryBuilder theSearchSqlBuilder, QueryStack theQueryStack, @Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        this.myParams = theParams;
        theParams.clean();
        if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU3) {
            Dstu3DistanceHelper.setNearDistance(this.myResourceType, (SearchParameterMap)theParams);
        }
        if (this.isCompositeUniqueSpCandidate()) {
            this.attemptComboUniqueSpProcessing(theQueryStack, theParams, theRequest);
        }
        SearchContainedModeEnum searchContainedMode = theParams.getSearchContainedMode();
        List paramNames = this.myParams.keySet().stream().filter(t -> !t.equals("_id")).filter(t -> !t.equals("_tag")).collect(Collectors.toList());
        if (this.myParams.containsKey("_id")) {
            paramNames.add("_id");
        }
        if (this.myParams.containsKey("_tag")) {
            paramNames.add("_tag");
        }
        for (String nextParamName : paramNames) {
            List andOrParams;
            Condition predicate;
            if (this.myParams.isLastN() && LastNParameterHelper.isLastNParameter((String)nextParamName, (FhirContext)this.myContext) || (predicate = theQueryStack.searchForIdsWithAndOr(null, this.myResourceName, nextParamName, andOrParams = this.myParams.get(nextParamName), theRequest, this.myRequestPartitionId, searchContainedMode)) == null) continue;
            theSearchSqlBuilder.addPredicate(predicate);
        }
    }

    private boolean isCompositeUniqueSpCandidate() {
        return this.myDaoConfig.isUniqueIndexesEnabled() && this.myParams.getEverythingMode() == null && this.myParams.isAllParametersHaveNoModifier();
    }

    public Long createCountQuery(SearchParameterMap theParams, String theSearchUuid, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchUuid, theRequestPartitionId);
        if (this.checkUseHibernateSearch()) {
            long count = this.myFulltextSearchSvc.count(this.myResourceName, theParams.clone());
            return count;
        }
        List<ISearchQueryExecutor> queries = this.createQuery(theParams.clone(), null, null, null, true, theRequest, null);
        if (queries.isEmpty()) {
            return 0L;
        }
        return (Long)queries.get(0).next();
    }

    public void setPreviouslyAddedResourcePids(@Nonnull List<ResourcePersistentId> thePidSet) {
        this.myPidSet = new HashSet<ResourcePersistentId>(thePidSet);
    }

    public IResultIterator createQuery(SearchParameterMap theParams, SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest, @Nonnull RequestPartitionId theRequestPartitionId) {
        assert (theRequestPartitionId != null);
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        this.init(theParams, theSearchRuntimeDetails.getSearchUuid(), theRequestPartitionId);
        if (this.myPidSet == null) {
            this.myPidSet = new HashSet<ResourcePersistentId>();
        }
        return new QueryIterator(theSearchRuntimeDetails, theRequest);
    }

    private void init(SearchParameterMap theParams, String theSearchUuid, RequestPartitionId theRequestPartitionId) {
        this.myCriteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        this.myParams = theParams;
        this.mySearchUuid = theSearchUuid;
        this.myRequestPartitionId = theRequestPartitionId;
    }

    private List<ISearchQueryExecutor> createQuery(SearchParameterMap theParams, SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCountOnlyFlag, RequestDetails theRequest, SearchRuntimeDetails theSearchRuntimeDetails) {
        ArrayList<ISearchQueryExecutor> queries = new ArrayList<ISearchQueryExecutor>();
        if (this.checkUseHibernateSearch()) {
            boolean canSkipDatabase;
            ISearchQueryExecutor fulltextExecutor = null;
            List<ResourcePersistentId> fulltextMatchIds = null;
            int resultCount = 0;
            if (this.myParams.isLastN()) {
                fulltextMatchIds = this.executeLastNAgainstIndex(theMaximumResults);
                resultCount = fulltextMatchIds.size();
            } else if (this.myParams.getEverythingMode() != null) {
                fulltextMatchIds = this.queryHibernateSearchForEverythingPids();
                resultCount = fulltextMatchIds.size();
            } else {
                fulltextExecutor = this.myFulltextSearchSvc.searchNotScrolled(this.myResourceName, this.myParams, this.myMaxResultsToFetch);
            }
            if (fulltextExecutor == null) {
                fulltextExecutor = SearchQueryExecutors.from(fulltextMatchIds);
            }
            if (theSearchRuntimeDetails != null) {
                theSearchRuntimeDetails.setFoundIndexMatchesCount(resultCount);
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(SearchRuntimeDetails.class, (Object)theSearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INDEXSEARCH_QUERY_COMPLETE, (HookParams)params);
            }
            boolean bl = canSkipDatabase = !fulltextExecutor.hasNext() || !this.myPartitionSettings.isPartitioningEnabled() && theParams.isEmpty() && theParams.getNearDistanceParam() == null && theParams.getLastUpdated() == null && theParams.getEverythingMode() == null && theParams.getOffset() == null;
            if (canSkipDatabase) {
                ourLog.trace("Query finished after HSearch.  Skip db query phase");
                if (theMaximumResults != null) {
                    fulltextExecutor = SearchQueryExecutors.limited(fulltextExecutor, theMaximumResults.intValue());
                }
                queries.add(fulltextExecutor);
            } else {
                ourLog.trace("Query needs db after HSearch.  Chunking.");
                new QueryChunker().chunk(Streams.stream((Iterator)fulltextExecutor).collect(Collectors.toList()), t -> this.doCreateChunkedQueries(theParams, (List<Long>)t, theOffset, sort, theCountOnlyFlag, theRequest, queries));
            }
        } else {
            Optional<SearchQueryExecutor> query = this.createChunkedQuery(theParams, sort, theOffset, theMaximumResults, theCountOnlyFlag, theRequest, null);
            query.ifPresent(queries::add);
        }
        return queries;
    }

    private boolean checkUseHibernateSearch() {
        boolean fulltextEnabled;
        boolean bl = fulltextEnabled = this.myFulltextSearchSvc != null && !this.myFulltextSearchSvc.isDisabled();
        if (!fulltextEnabled) {
            this.failIfUsed("_text");
            this.failIfUsed("_content");
        }
        return fulltextEnabled && this.myParams != null && this.myParams.getSearchContainedMode() == SearchContainedModeEnum.FALSE && this.myFulltextSearchSvc.supportsSomeOf(this.myParams);
    }

    private void failIfUsed(String theParamName) {
        if (this.myParams.containsKey(theParamName)) {
            throw new InvalidRequestException(Msg.code((int)1192) + "Fulltext search is not enabled on this service, can not process parameter: " + theParamName);
        }
    }

    private List<ResourcePersistentId> executeLastNAgainstIndex(Integer theMaximumResults) {
        if (this.myDaoConfig.isAdvancedHSearchIndexing()) {
            if (this.myFulltextSearchSvc == null) {
                throw new InvalidRequestException(Msg.code((int)2027) + "LastN operation is not enabled on this service, can not process this request");
            }
            return this.myFulltextSearchSvc.lastN(this.myParams, theMaximumResults).stream().map(lastNResourceId -> this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, String.valueOf(lastNResourceId))).collect(Collectors.toList());
        }
        if (this.myIElasticsearchSvc == null) {
            throw new InvalidRequestException(Msg.code((int)2033) + "LastN operation is not enabled on this service, can not process this request");
        }
        return this.myIElasticsearchSvc.executeLastN(this.myParams, this.myContext, theMaximumResults).stream().map(lastnResourceId -> this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, lastnResourceId)).collect(Collectors.toList());
    }

    private List<ResourcePersistentId> queryHibernateSearchForEverythingPids() {
        ResourcePersistentId pid = null;
        if (this.myParams.get("_id") != null) {
            String idParamValue;
            IQueryParameterType idParam = (IQueryParameterType)((List)this.myParams.get("_id").get(0)).get(0);
            if (idParam instanceof TokenParam) {
                TokenParam idParm = (TokenParam)idParam;
                idParamValue = idParm.getValue();
            } else {
                StringParam idParm = (StringParam)idParam;
                idParamValue = idParm.getValue();
            }
            pid = this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, idParamValue);
        }
        List<ResourcePersistentId> pids = this.myFulltextSearchSvc.everything(this.myResourceName, this.myParams, pid);
        return pids;
    }

    private void doCreateChunkedQueries(SearchParameterMap theParams, List<Long> thePids, Integer theOffset, SortSpec sort, boolean theCount, RequestDetails theRequest, ArrayList<ISearchQueryExecutor> theQueries) {
        if (thePids.size() < SearchBuilder.getMaximumPageSize()) {
            this.normalizeIdListForLastNInClause(thePids);
        }
        Optional<SearchQueryExecutor> query = this.createChunkedQuery(theParams, sort, theOffset, thePids.size(), theCount, theRequest, thePids);
        query.ifPresent(t -> theQueries.add((ISearchQueryExecutor)t));
    }

    private void extractTargetPidsFromIdParams(HashSet<Long> theTargetPids) {
        HashSet<String> ids = new HashSet<String>();
        List params = this.myParams.get("_id");
        for (List paramList : params) {
            for (IQueryParameterType param : paramList) {
                if (param instanceof StringParam) {
                    ids.add(((StringParam)param).getValue());
                    continue;
                }
                if (param instanceof TokenParam) {
                    ids.add(((TokenParam)param).getValue());
                    continue;
                }
                throw new IllegalArgumentException(Msg.code((int)1193) + "_id parameter must be a StringParam or TokenParam");
            }
        }
        Map idToPid = this.myIdHelperService.resolveResourcePersistentIds(this.myRequestPartitionId, this.myResourceName, new ArrayList(ids));
        if (this.myAlsoIncludePids == null) {
            this.myAlsoIncludePids = new ArrayList<ResourcePersistentId>();
        }
        for (ResourcePersistentId pid : idToPid.values()) {
            this.myAlsoIncludePids.add(pid);
            theTargetPids.add(pid.getIdAsLong());
        }
    }

    private Optional<SearchQueryExecutor> createChunkedQuery(SearchParameterMap theParams, SortSpec sort, Integer theOffset, Integer theMaximumResults, boolean theCountOnlyFlag, RequestDetails theRequest, List<Long> thePidList) {
        GeneratedSql generatedSql;
        DateRangeParam lu;
        Condition partitionIdPredicate;
        List activeComboParams;
        String sqlBuilderResourceName = this.myParams.getEverythingMode() == null ? this.myResourceName : null;
        SearchQueryBuilder sqlBuilder = new SearchQueryBuilder(this.myContext, this.myDaoConfig.getModelConfig(), this.myPartitionSettings, this.myRequestPartitionId, sqlBuilderResourceName, this.mySqlBuilderFactory, this.myDialectProvider, theCountOnlyFlag);
        QueryStack queryStack3 = new QueryStack(theParams, this.myDaoConfig, this.myDaoConfig.getModelConfig(), this.myContext, sqlBuilder, this.mySearchParamRegistry, this.myPartitionSettings);
        if ((theParams.keySet().size() > 1 || theParams.getSort() != null || theParams.keySet().contains("_has") || this.isPotentiallyContainedReferenceParameterExistsAtRoot(theParams)) && (activeComboParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName, theParams.keySet())).isEmpty()) {
            sqlBuilder.setNeedResourceTableRoot(true);
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.myEntityManagerFactory.getDataSource());
        jdbcTemplate.setFetchSize(this.myFetchSize);
        if (theMaximumResults != null) {
            jdbcTemplate.setMaxRows(theMaximumResults.intValue());
        }
        if (this.myParams.getEverythingMode() != null) {
            HashSet<Long> targetPids = new HashSet<Long>();
            if (this.myParams.get("_id") != null) {
                this.extractTargetPidsFromIdParams(targetPids);
            } else {
                SearchQueryBuilder fetchPidsSqlBuilder = new SearchQueryBuilder(this.myContext, this.myDaoConfig.getModelConfig(), this.myPartitionSettings, this.myRequestPartitionId, this.myResourceName, this.mySqlBuilderFactory, this.myDialectProvider, theCountOnlyFlag);
                GeneratedSql allTargetsSql = fetchPidsSqlBuilder.generate(theOffset, this.myMaxResultsToFetch);
                String sql = allTargetsSql.getSql();
                Object[] args = allTargetsSql.getBindVariables().toArray(new Object[0]);
                List output = jdbcTemplate.query(sql, args, (RowMapper)new SingleColumnRowMapper(Long.class));
                if (this.myAlsoIncludePids == null) {
                    this.myAlsoIncludePids = new ArrayList<ResourcePersistentId>(output.size());
                }
                this.myAlsoIncludePids.addAll(ResourcePersistentId.fromLongList((List)output));
            }
            ArrayList<String> typeSourceResources = new ArrayList<String>();
            if (this.myParams.get("_type") != null) {
                typeSourceResources.addAll(this.extractTypeSourceResourcesFromParams());
            }
            queryStack3.addPredicateEverythingOperation(this.myResourceName, typeSourceResources, targetPids.toArray(new Long[0]));
        } else {
            if (theParams.containsKey("_filter") && (partitionIdPredicate = sqlBuilder.getOrCreateResourceTablePredicateBuilder().createPartitionIdPredicate(this.myRequestPartitionId)) != null) {
                sqlBuilder.addPredicate(partitionIdPredicate);
            }
            this.searchForIdsWithAndOr(sqlBuilder, queryStack3, this.myParams, theRequest);
        }
        if (!sqlBuilder.haveAtLeastOnePredicate() && (partitionIdPredicate = sqlBuilder.getOrCreateResourceTablePredicateBuilder().createPartitionIdPredicate(this.myRequestPartitionId)) != null) {
            sqlBuilder.addPredicate(partitionIdPredicate);
        }
        if (thePidList != null && thePidList.size() > 0) {
            sqlBuilder.addResourceIdsPredicate(thePidList);
        }
        if ((lu = this.myParams.getLastUpdated()) != null && !lu.isEmpty()) {
            ComboCondition lastUpdatedPredicates = sqlBuilder.addPredicateLastUpdated(lu);
            sqlBuilder.addPredicate((Condition)lastUpdatedPredicates);
        }
        if (this.myHasNextIteratorQuery && this.myPidSet.size() + sqlBuilder.countBindVariables() < 900) {
            sqlBuilder.excludeResourceIdsPredicate(this.myPidSet);
        }
        if (sort != null) {
            assert (!theCountOnlyFlag);
            this.createSort(queryStack3, sort);
        }
        if ((generatedSql = sqlBuilder.generate(theOffset, this.myMaxResultsToFetch)).isMatchNothing()) {
            return Optional.empty();
        }
        SearchQueryExecutor executor = this.mySqlBuilderFactory.newSearchQueryExecutor(generatedSql, this.myMaxResultsToFetch);
        return Optional.of(executor);
    }

    private Collection<String> extractTypeSourceResourcesFromParams() {
        List listOfList = this.myParams.get("_type");
        List iQueryParameterTypesList = listOfList.stream().flatMap(Collection::stream).collect(Collectors.toList());
        List resourceTypes = iQueryParameterTypesList.stream().map(param -> ((StringParam)param).getValue()).map(csvString -> List.of(csvString.split(","))).flatMap(Collection::stream).collect(Collectors.toList());
        Set<String> retVal = resourceTypes.stream().map(String::trim).collect(Collectors.toSet());
        return retVal;
    }

    private boolean isPotentiallyContainedReferenceParameterExistsAtRoot(SearchParameterMap theParams) {
        return this.myModelConfig.isIndexOnContainedResources() && theParams.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).anyMatch(t -> t instanceof ReferenceParam);
    }

    private List<Long> normalizeIdListForLastNInClause(List<Long> lastnResourceIds) {
        int listSize = lastnResourceIds.size();
        if (listSize > 1 && listSize < 10) {
            this.padIdListWithPlaceholders(lastnResourceIds, 10);
        } else if (listSize > 10 && listSize < 50) {
            this.padIdListWithPlaceholders(lastnResourceIds, 50);
        } else if (listSize > 50 && listSize < 100) {
            this.padIdListWithPlaceholders(lastnResourceIds, 100);
        } else if (listSize > 100 && listSize < 200) {
            this.padIdListWithPlaceholders(lastnResourceIds, 200);
        } else if (listSize > 200 && listSize < 500) {
            this.padIdListWithPlaceholders(lastnResourceIds, 500);
        } else if (listSize > 500 && listSize < 800) {
            this.padIdListWithPlaceholders(lastnResourceIds, 800);
        }
        return lastnResourceIds;
    }

    private void padIdListWithPlaceholders(List<Long> theIdList, int preferredListSize) {
        while (theIdList.size() < preferredListSize) {
            theIdList.add(-1L);
        }
    }

    private void createSort(QueryStack theQueryStack, SortSpec theSort) {
        boolean ascending;
        if (theSort == null || StringUtils.isBlank((CharSequence)theSort.getParamName())) {
            return;
        }
        boolean bl = ascending = theSort.getOrder() == null || theSort.getOrder() == SortOrderEnum.ASC;
        if ("_id".equals(theSort.getParamName())) {
            theQueryStack.addSortOnResourceId(ascending);
        } else if ("_lastUpdated".equals(theSort.getParamName())) {
            theQueryStack.addSortOnLastUpdated(ascending);
        } else {
            RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, theSort.getParamName());
            if (param == null) {
                String msg = this.myContext.getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidSortParameter", new Object[]{theSort.getParamName(), this.getResourceName(), this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(this.getResourceName())});
                throw new InvalidRequestException(Msg.code((int)1194) + msg);
            }
            switch (param.getParamType()) {
                case STRING: {
                    theQueryStack.addSortOnString(this.myResourceName, theSort.getParamName(), ascending);
                    break;
                }
                case DATE: {
                    theQueryStack.addSortOnDate(this.myResourceName, theSort.getParamName(), ascending);
                    break;
                }
                case REFERENCE: {
                    theQueryStack.addSortOnResourceLink(this.myResourceName, theSort.getParamName(), ascending);
                    break;
                }
                case TOKEN: {
                    theQueryStack.addSortOnToken(this.myResourceName, theSort.getParamName(), ascending);
                    break;
                }
                case NUMBER: {
                    theQueryStack.addSortOnNumber(this.myResourceName, theSort.getParamName(), ascending);
                    break;
                }
                case URI: {
                    theQueryStack.addSortOnUri(this.myResourceName, theSort.getParamName(), ascending);
                    break;
                }
                case QUANTITY: {
                    theQueryStack.addSortOnQuantity(this.myResourceName, theSort.getParamName(), ascending);
                    break;
                }
                case COMPOSITE: {
                    List compositeList = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)param);
                    if (compositeList == null) {
                        throw new InvalidRequestException(Msg.code((int)1195) + "The composite _sort parameter " + theSort.getParamName() + " is not defined by the resource " + this.myResourceName);
                    }
                    if (compositeList.size() != 2) {
                        throw new InvalidRequestException(Msg.code((int)1196) + "The composite _sort parameter " + theSort.getParamName() + " must have 2 composite types declared in parameter annotation, found " + compositeList.size());
                    }
                    RuntimeSearchParam left = (RuntimeSearchParam)compositeList.get(0);
                    RuntimeSearchParam right = (RuntimeSearchParam)compositeList.get(1);
                    this.createCompositeSort(theQueryStack, this.myResourceName, left.getParamType(), left.getName(), ascending);
                    this.createCompositeSort(theQueryStack, this.myResourceName, right.getParamType(), right.getName(), ascending);
                    break;
                }
                default: {
                    throw new InvalidRequestException(Msg.code((int)1197) + "This server does not support _sort specifications of type " + param.getParamType() + " - Can't serve _sort=" + theSort.getParamName());
                }
            }
        }
        this.createSort(theQueryStack, theSort.getChain());
    }

    private void createCompositeSort(QueryStack theQueryStack, String theResourceName, RestSearchParameterTypeEnum theParamType, String theParamName, boolean theAscending) {
        switch (theParamType) {
            case STRING: {
                theQueryStack.addSortOnString(this.myResourceName, theParamName, theAscending);
                break;
            }
            case DATE: {
                theQueryStack.addSortOnDate(this.myResourceName, theParamName, theAscending);
                break;
            }
            case TOKEN: {
                theQueryStack.addSortOnToken(this.myResourceName, theParamName, theAscending);
                break;
            }
            case QUANTITY: {
                theQueryStack.addSortOnQuantity(this.myResourceName, theParamName, theAscending);
                break;
            }
            default: {
                throw new InvalidRequestException(Msg.code((int)1198) + "Don't know how to handle composite parameter with type of " + theParamType + " on _sort=" + theParamName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doLoadPids(Collection<ResourcePersistentId> thePids, Collection<ResourcePersistentId> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, Map<ResourcePersistentId, Integer> thePosition) {
        HashMap<Long, Long> resourcePidToVersion = null;
        for (ResourcePersistentId next : thePids) {
            if (next.getVersion() == null || !this.myModelConfig.isRespectVersionsForSearchIncludes()) continue;
            if (resourcePidToVersion == null) {
                resourcePidToVersion = new HashMap<Long, Long>();
            }
            resourcePidToVersion.put(next.getIdAsLong(), next.getVersion());
        }
        List<Long> versionlessPids = ResourcePersistentId.toLongList(thePids);
        if (versionlessPids.size() < SearchBuilder.getMaximumPageSize()) {
            versionlessPids = this.normalizeIdListForLastNInClause(versionlessPids);
        }
        Collection<ResourceSearchView> resourceSearchViewList = this.myResourceSearchViewDao.findByResourceIds(versionlessPids);
        Map<Long, Collection<ResourceTag>> tagMap = this.getResourceTagMap(resourceSearchViewList);
        for (IBaseResourceEntity iBaseResourceEntity : resourceSearchViewList) {
            void var11_11;
            if (iBaseResourceEntity.getDeleted() != null) continue;
            Class resourceType = this.myContext.getResourceDefinition(iBaseResourceEntity.getResourceType()).getImplementingClass();
            ResourcePersistentId resourceId = new ResourcePersistentId((Object)iBaseResourceEntity.getResourceId());
            if (resourcePidToVersion != null) {
                Long version = (Long)resourcePidToVersion.get(iBaseResourceEntity.getResourceId());
                resourceId.setVersion(version);
                if (version != null && !version.equals(iBaseResourceEntity.getVersion())) {
                    IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
                    BaseHasResource baseHasResource = dao.readEntity((IIdType)iBaseResourceEntity.getIdDt().withVersion(Long.toString(version)), null);
                }
            }
            IBaseResource resource = null;
            if (var11_11 != null) {
                resource = this.myCallingDao.toResource(resourceType, (IBaseResourceEntity)var11_11, tagMap.get(var11_11.getId()), theForHistoryOperation);
            }
            if (resource == null) {
                ourLog.warn("Unable to find resource {}/{}/_history/{} in database", new Object[]{var11_11.getResourceType(), var11_11.getIdDt().getIdPart(), var11_11.getVersion()});
                continue;
            }
            Integer index = thePosition.get(resourceId);
            if (index == null) {
                ourLog.warn("Got back unexpected resource PID {}", (Object)resourceId);
                continue;
            }
            if (resource instanceof IResource) {
                if (theIncludedPids.contains(resourceId)) {
                    ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IResource)resource, (Object)BundleEntrySearchModeEnum.INCLUDE);
                } else {
                    ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IResource)resource, (Object)BundleEntrySearchModeEnum.MATCH);
                }
            } else if (theIncludedPids.contains(resourceId)) {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IAnyResource)resource, (Object)BundleEntrySearchModeEnum.INCLUDE.getCode());
            } else {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put((IAnyResource)resource, (Object)BundleEntrySearchModeEnum.MATCH.getCode());
            }
            theResourceListToPopulate.set(index, resource);
        }
    }

    private Map<Long, Collection<ResourceTag>> getResourceTagMap(Collection<? extends IBaseResourceEntity> theResourceSearchViewList) {
        ArrayList<Long> idList = new ArrayList<Long>(theResourceSearchViewList.size());
        for (IBaseResourceEntity iBaseResourceEntity : theResourceSearchViewList) {
            if (!iBaseResourceEntity.isHasTags()) continue;
            idList.add(iBaseResourceEntity.getId());
        }
        return this.getPidToTagMap(idList);
    }

    @Nonnull
    private Map<Long, Collection<ResourceTag>> getPidToTagMap(List<Long> thePidList) {
        HashMap<Long, Collection<ResourceTag>> tagMap = new HashMap<Long, Collection<ResourceTag>>();
        if (thePidList.size() == 0) {
            return tagMap;
        }
        Collection<ResourceTag> tagList = this.myResourceTagDao.findByResourceIds(thePidList);
        for (ResourceTag tag : tagList) {
            ResourcePersistentId resourceId = new ResourcePersistentId((Object)tag.getResourceId());
            ArrayList<ResourceTag> tagCol = (ArrayList<ResourceTag>)tagMap.get(resourceId.getIdAsLong());
            if (tagCol == null) {
                tagCol = new ArrayList<ResourceTag>();
                tagCol.add(tag);
                tagMap.put(resourceId.getIdAsLong(), tagCol);
                continue;
            }
            tagCol.add(tag);
        }
        return tagMap;
    }

    public void loadResourcesByPid(Collection<ResourcePersistentId> thePids, Collection<ResourcePersistentId> theIncludedPids, List<IBaseResource> theResourceListToPopulate, boolean theForHistoryOperation, RequestDetails theDetails) {
        if (thePids.isEmpty()) {
            ourLog.debug("The include pids are empty");
        }
        assert (new HashSet<ResourcePersistentId>(thePids).size() == thePids.size()) : "PID list contains duplicates: " + thePids;
        HashMap<ResourcePersistentId, Integer> position = new HashMap<ResourcePersistentId, Integer>();
        for (ResourcePersistentId next : thePids) {
            position.put(next, theResourceListToPopulate.size());
            theResourceListToPopulate.add(null);
        }
        if (this.isLoadingFromElasticSearchSupported(thePids)) {
            theResourceListToPopulate.addAll(this.loadResourcesFromElasticSearch(thePids));
        } else {
            new QueryChunker<ResourcePersistentId>().chunk(thePids, t -> this.doLoadPids((Collection<ResourcePersistentId>)t, theIncludedPids, theResourceListToPopulate, theForHistoryOperation, (Map<ResourcePersistentId, Integer>)position));
        }
    }

    private boolean isLoadingFromElasticSearchSupported(Collection<ResourcePersistentId> thePids) {
        return this.myDaoConfig.isStoreResourceInHSearchIndex() && thePids.stream().noneMatch(p -> p.getVersion() != null) && this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3);
    }

    private List<IBaseResource> loadResourcesFromElasticSearch(Collection<ResourcePersistentId> thePids) {
        if (this.myDaoConfig.isAdvancedHSearchIndexing() && this.myDaoConfig.isStoreResourceInHSearchIndex()) {
            List<Long> pidList = thePids.stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
            List<IBaseResource> resources = this.myFulltextSearchSvc.getResources(pidList);
            return resources;
        }
        if (!Objects.isNull(this.myParams) && this.myParams.isLastN()) {
            return this.myIElasticsearchSvc.getObservationResources(thePids);
        }
        return Collections.emptyList();
    }

    public Set<ResourcePersistentId> loadIncludes(FhirContext theContext, EntityManager theEntityManager, Collection<ResourcePersistentId> theMatches, Set<Include> theIncludes, boolean theReverseMode, DateRangeParam theLastUpdated, String theSearchIdOrDescription, RequestDetails theRequest, Integer theMaxCount) {
        boolean addedSomeThisRound;
        if (theMatches.size() == 0) {
            return new HashSet<ResourcePersistentId>();
        }
        if (theIncludes == null || theIncludes.isEmpty()) {
            return new HashSet<ResourcePersistentId>();
        }
        String searchPidFieldName = theReverseMode ? MY_TARGET_RESOURCE_PID : MY_SOURCE_RESOURCE_PID;
        String findPidFieldName = theReverseMode ? MY_SOURCE_RESOURCE_PID : MY_TARGET_RESOURCE_PID;
        String findVersionFieldName = null;
        if (!theReverseMode && this.myModelConfig.isRespectVersionsForSearchIncludes()) {
            findVersionFieldName = MY_TARGET_RESOURCE_VERSION;
        }
        ArrayList<ResourcePersistentId> nextRoundMatches = new ArrayList<ResourcePersistentId>(theMatches);
        HashSet<ResourcePersistentId> allAdded = new HashSet<ResourcePersistentId>();
        HashSet<ResourcePersistentId> original = new HashSet<ResourcePersistentId>(theMatches);
        ArrayList<Include> includes = new ArrayList<Include>(theIncludes);
        int roundCounts = 0;
        StopWatch w = new StopWatch();
        do {
            ++roundCounts;
            HashSet<ResourcePersistentId> pidsToInclude = new HashSet<ResourcePersistentId>();
            Iterator<Object> iter = includes.iterator();
            while (iter.hasNext()) {
                Include nextInclude = iter.next();
                if (!nextInclude.isRecurse()) {
                    iter.remove();
                }
                boolean matchAll = "*".equals(nextInclude.getValue());
                String wantResourceType = null;
                if (!matchAll && "*".equals(nextInclude.getParamName())) {
                    wantResourceType = nextInclude.getParamType();
                    matchAll = true;
                }
                if (matchAll) {
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("SELECT r.").append(findPidFieldName);
                    if (findVersionFieldName != null) {
                        sqlBuilder.append(", r." + findVersionFieldName);
                    }
                    sqlBuilder.append(" FROM ResourceLink r WHERE ");
                    sqlBuilder.append("r.");
                    sqlBuilder.append(searchPidFieldName);
                    sqlBuilder.append(" IN (:target_pids)");
                    if (wantResourceType != null && theReverseMode) {
                        sqlBuilder.append(" AND r.mySourceResourceType = :want_resource_type");
                    } else {
                        wantResourceType = null;
                    }
                    String sql = sqlBuilder.toString();
                    List<Collection<ResourcePersistentId>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
                    for (Collection<ResourcePersistentId> nextPartition : partitions) {
                        TypedQuery q = theEntityManager.createQuery(sql, Object[].class);
                        q.setParameter("target_pids", (Object)ResourcePersistentId.toLongList(nextPartition));
                        if (wantResourceType != null) {
                            q.setParameter("want_resource_type", (Object)wantResourceType);
                        }
                        if (theMaxCount != null) {
                            q.setMaxResults(theMaxCount.intValue());
                        }
                        List results = q.getResultList();
                        for (Object nextRow : results) {
                            Long resourceLink;
                            if (nextRow == null) continue;
                            Long version = null;
                            if (findVersionFieldName != null) {
                                resourceLink = (Long)((Object[])nextRow)[0];
                                version = (Long)((Object[])nextRow)[1];
                            } else {
                                resourceLink = (Long)nextRow;
                            }
                            pidsToInclude.add(new ResourcePersistentId((Object)resourceLink, version));
                        }
                    }
                    continue;
                }
                String resType = nextInclude.getParamType();
                if (StringUtils.isBlank((CharSequence)resType)) continue;
                RuntimeResourceDefinition def = theContext.getResourceDefinition(resType);
                if (def == null) {
                    ourLog.warn("Unknown resource type in include/revinclude=" + nextInclude.getValue());
                    continue;
                }
                String paramName = nextInclude.getParamName();
                RuntimeSearchParam param = StringUtils.isNotBlank((CharSequence)paramName) ? this.mySearchParamRegistry.getActiveSearchParam(resType, paramName) : null;
                if (param == null) {
                    ourLog.warn("Unknown param name in include/revinclude=" + nextInclude.getValue());
                    continue;
                }
                List paths = theReverseMode ? param.getPathsSplitForResourceType(resType) : param.getPathsSplit();
                String targetResourceType = StringUtils.defaultString((String)nextInclude.getParamTargetType(), null);
                for (String nextPath : paths) {
                    boolean haveTargetTypesDefinedByParam = param.hasTargets();
                    String findPidFieldSqlColumn = findPidFieldName.equals(MY_SOURCE_RESOURCE_PID) ? "src_resource_id" : "target_resource_id";
                    String fieldsToLoad = "r." + findPidFieldSqlColumn + " AS resource_id";
                    if (findVersionFieldName != null) {
                        fieldsToLoad = fieldsToLoad + ", r.target_resource_version AS resource_version";
                    }
                    String searchPidFieldSqlColumn = searchPidFieldName.equals(MY_TARGET_RESOURCE_PID) ? "target_resource_id" : "src_resource_id";
                    StringBuilder resourceIdBasedQuery = new StringBuilder("SELECT " + fieldsToLoad + " FROM hfj_res_link r  WHERE r.src_path = :src_path AND  r.target_resource_id IS NOT NULL AND  r." + searchPidFieldSqlColumn + " IN (:target_pids) ");
                    if (targetResourceType != null) {
                        resourceIdBasedQuery.append(" AND r.target_resource_type = :target_resource_type ");
                    } else if (haveTargetTypesDefinedByParam) {
                        resourceIdBasedQuery.append(" AND r.target_resource_type in (:target_resource_types) ");
                    }
                    Object fieldsToLoadFromSpidxUriTable = "rUri.res_id";
                    if (fieldsToLoad.split(",").length > 1) {
                        for (int i = 0; i < fieldsToLoad.split(",").length - 1; ++i) {
                            fieldsToLoadFromSpidxUriTable = (String)fieldsToLoadFromSpidxUriTable + ", NULL";
                        }
                    }
                    String resourceUrlBasedQuery = "SELECT " + (String)fieldsToLoadFromSpidxUriTable + " FROM hfj_res_link r  JOIN hfj_spidx_uri rUri ON (    r.target_resource_url = rUri.sp_uri AND    rUri.sp_name = 'url' " + (targetResourceType != null ? " AND rUri.res_type = :target_resource_type " : "") + (haveTargetTypesDefinedByParam ? " AND rUri.res_type IN (:target_resource_types) " : "") + " )  WHERE r.src_path = :src_path AND  r.target_resource_id IS NULL AND  r." + searchPidFieldSqlColumn + " IN (:target_pids) ";
                    String sql = resourceIdBasedQuery + " UNION " + resourceUrlBasedQuery;
                    List<Collection<ResourcePersistentId>> partitions = this.partition(nextRoundMatches, SearchBuilder.getMaximumPageSize());
                    for (Collection<ResourcePersistentId> nextPartition : partitions) {
                        Query q = theEntityManager.createNativeQuery(sql, Tuple.class);
                        q.setParameter("src_path", (Object)nextPath);
                        q.setParameter("target_pids", (Object)ResourcePersistentId.toLongList(nextPartition));
                        if (targetResourceType != null) {
                            q.setParameter("target_resource_type", (Object)targetResourceType);
                        } else if (haveTargetTypesDefinedByParam) {
                            q.setParameter("target_resource_types", (Object)param.getTargets());
                        }
                        List results = q.getResultList();
                        if (theMaxCount != null) {
                            q.setMaxResults(theMaxCount.intValue());
                        }
                        for (Tuple result : results) {
                            if (result == null) continue;
                            Long resourceId = NumberUtils.createLong((String)String.valueOf(result.get(RESOURCE_ID_ALIAS)));
                            Long resourceVersion = null;
                            if (findVersionFieldName != null && result.get(RESOURCE_VERSION_ALIAS) != null) {
                                resourceVersion = NumberUtils.createLong((String)String.valueOf(result.get(RESOURCE_VERSION_ALIAS)));
                            }
                            pidsToInclude.add(new ResourcePersistentId((Object)resourceId, resourceVersion));
                        }
                    }
                }
            }
            if (theReverseMode && theLastUpdated != null && (theLastUpdated.getLowerBoundAsInstant() != null || theLastUpdated.getUpperBoundAsInstant() != null)) {
                pidsToInclude = new HashSet<ResourcePersistentId>(SearchBuilder.filterResourceIdsByLastUpdated(theEntityManager, theLastUpdated, pidsToInclude));
            }
            nextRoundMatches.clear();
            for (ResourcePersistentId next : pidsToInclude) {
                if (original.contains(next) || allAdded.contains(next)) continue;
                nextRoundMatches.add(next);
            }
            addedSomeThisRound = allAdded.addAll(pidsToInclude);
        } while ((theMaxCount == null || allAdded.size() < theMaxCount) && includes.size() > 0 && nextRoundMatches.size() > 0 && addedSomeThisRound);
        allAdded.removeAll(original);
        ourLog.info("Loaded {} {} in {} rounds and {} ms for search {}", new Object[]{allAdded.size(), theReverseMode ? "_revincludes" : "_includes", roundCounts, w.getMillisAndRestart(), theSearchIdOrDescription});
        if (allAdded.size() > 0 && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
            ArrayList<ResourcePersistentId> includedPidList = new ArrayList<ResourcePersistentId>(allAdded);
            JpaPreResourceAccessDetails accessDetails = new JpaPreResourceAccessDetails(includedPidList, (ICallable<ISearchBuilder>)((ICallable)() -> this));
            HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
            for (int i = includedPidList.size() - 1; i >= 0; --i) {
                ResourcePersistentId value;
                if (!accessDetails.isDontReturnResourceAtIndex(i) || (value = (ResourcePersistentId)includedPidList.remove(i)) == null) continue;
                allAdded.remove(value);
            }
        }
        return allAdded;
    }

    private List<Collection<ResourcePersistentId>> partition(Collection<ResourcePersistentId> theNextRoundMatches, int theMaxLoad) {
        if (theNextRoundMatches.size() <= theMaxLoad) {
            return Collections.singletonList(theNextRoundMatches);
        }
        ArrayList<Collection<ResourcePersistentId>> retVal = new ArrayList<Collection<ResourcePersistentId>>();
        ArrayList<ResourcePersistentId> current = null;
        for (ResourcePersistentId next : theNextRoundMatches) {
            if (current == null) {
                current = new ArrayList<ResourcePersistentId>(theMaxLoad);
                retVal.add(current);
            }
            current.add(next);
            if (current.size() < theMaxLoad) continue;
            current = null;
        }
        return retVal;
    }

    private void attemptComboUniqueSpProcessing(QueryStack theQueryStack3, @Nonnull SearchParameterMap theParams, RequestDetails theRequest) {
        Object comboParam = null;
        List<Object> comboParamNames = null;
        List exactMatchParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName, theParams.keySet());
        if (exactMatchParams.size() > 0) {
            comboParam = (RuntimeSearchParam)exactMatchParams.get(0);
            comboParamNames = new ArrayList(theParams.keySet());
        }
        if (comboParam == null) {
            List candidateComboParams = this.mySearchParamRegistry.getActiveComboSearchParams(this.myResourceName);
            for (Object nextCandidate : candidateComboParams) {
                List nextCandidateParamNames = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)nextCandidate).stream().map(t -> t.getName()).collect(Collectors.toList());
                if (!theParams.keySet().containsAll(nextCandidateParamNames)) continue;
                comboParam = nextCandidate;
                comboParamNames = nextCandidateParamNames;
                break;
            }
        }
        if (comboParam != null) {
            theParams.values().forEach(nextAndList -> this.ensureSubListsAreWritable((List)nextAndList));
            StringBuilder sb = new StringBuilder();
            sb.append(this.myResourceName);
            sb.append("?");
            boolean first = true;
            Collections.sort(comboParamNames);
            for (String nextParamName : comboParamNames) {
                ReferenceParam param;
                List nextValues = theParams.get(nextParamName);
                if (nextValues.isEmpty()) {
                    ourLog.error("query parameter {} is unexpectedly empty. Encountered while considering {} index for {}", new Object[]{nextParamName, comboParam.getName(), theRequest.getCompleteUrl()});
                    sb = null;
                    break;
                }
                if (((List)nextValues.get(0)).size() != 1) {
                    sb = null;
                    break;
                }
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(this.myResourceName, nextParamName);
                if (nextParamDef.getParamType() == RestSearchParameterTypeEnum.REFERENCE && StringUtils.isBlank((CharSequence)(param = (ReferenceParam)((List)nextValues.get(0)).get(0)).getResourceType())) {
                    sb = null;
                    break;
                }
                List nextAnd = (List)nextValues.remove(0);
                IQueryParameterType nextOr = (IQueryParameterType)nextAnd.remove(0);
                String nextOrValue = nextOr.getValueAsQueryToken(this.myContext);
                if (comboParam.getComboSearchParamType() == ComboSearchParamType.NON_UNIQUE && nextParamDef.getParamType() == RestSearchParameterTypeEnum.STRING) {
                    nextOrValue = StringUtil.normalizeStringForSearchIndexing((String)nextOrValue);
                }
                if (first) {
                    first = false;
                } else {
                    sb.append('&');
                }
                nextParamName = UrlUtil.escapeUrlParam((String)nextParamName);
                nextOrValue = UrlUtil.escapeUrlParam((String)nextOrValue);
                sb.append(nextParamName).append('=').append(nextOrValue);
            }
            if (sb != null) {
                String indexString = sb.toString();
                ourLog.debug("Checking for {} combo index for query: {}", (Object)comboParam.getComboSearchParamType(), (Object)indexString);
                StorageProcessingMessage msg = new StorageProcessingMessage().setMessage("Using " + comboParam.getComboSearchParamType() + " index for query for search: " + indexString);
                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)msg);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
                switch (comboParam.getComboSearchParamType()) {
                    case UNIQUE: {
                        theQueryStack3.addPredicateCompositeUnique(indexString, this.myRequestPartitionId);
                        break;
                    }
                    case NON_UNIQUE: {
                        theQueryStack3.addPredicateCompositeNonUnique(indexString, this.myRequestPartitionId);
                    }
                }
                theParams.clean();
            }
        }
    }

    private <T> void ensureSubListsAreWritable(List<List<T>> theListOfLists) {
        for (int i = 0; i < theListOfLists.size(); ++i) {
            List<T> oldSubList = theListOfLists.get(i);
            if (oldSubList instanceof ArrayList) continue;
            ArrayList<T> newSubList = new ArrayList<T>(oldSubList);
            theListOfLists.set(i, newSubList);
        }
    }

    public void setFetchSize(int theFetchSize) {
        this.myFetchSize = theFetchSize;
    }

    public SearchParameterMap getParams() {
        return this.myParams;
    }

    public CriteriaBuilder getBuilder() {
        return this.myCriteriaBuilder;
    }

    public Class<? extends IBaseResource> getResourceType() {
        return this.myResourceType;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    @VisibleForTesting
    public void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    public static int getMaximumPageSize() {
        if (myUseMaxPageSize50ForTest) {
            return 50;
        }
        return 800;
    }

    public static void setMaxPageSize50ForTest(boolean theIsTest) {
        myUseMaxPageSize50ForTest = theIsTest;
    }

    private static List<Predicate> createLastUpdatedPredicates(DateRangeParam theLastUpdated, CriteriaBuilder builder, From<?, ResourceTable> from) {
        ArrayList<Predicate> lastUpdatedPredicates = new ArrayList<Predicate>();
        if (theLastUpdated != null) {
            if (theLastUpdated.getLowerBoundAsInstant() != null) {
                ourLog.debug("LastUpdated lower bound: {}", (Object)new InstantDt(theLastUpdated.getLowerBoundAsInstant()));
                Predicate predicateLower = builder.greaterThanOrEqualTo((Expression)from.get("myUpdated"), (Comparable)theLastUpdated.getLowerBoundAsInstant());
                lastUpdatedPredicates.add(predicateLower);
            }
            if (theLastUpdated.getUpperBoundAsInstant() != null) {
                Predicate predicateUpper = builder.lessThanOrEqualTo((Expression)from.get("myUpdated"), (Comparable)theLastUpdated.getUpperBoundAsInstant());
                lastUpdatedPredicates.add(predicateUpper);
            }
        }
        return lastUpdatedPredicates;
    }

    private static List<ResourcePersistentId> filterResourceIdsByLastUpdated(EntityManager theEntityManager, DateRangeParam theLastUpdated, Collection<ResourcePersistentId> thePids) {
        if (thePids.isEmpty()) {
            return Collections.emptyList();
        }
        CriteriaBuilder builder = theEntityManager.getCriteriaBuilder();
        CriteriaQuery cq = builder.createQuery(Long.class);
        Root from = cq.from(ResourceTable.class);
        cq.select((Selection)from.get("myId").as(Long.class));
        List<Predicate> lastUpdatedPredicates = SearchBuilder.createLastUpdatedPredicates(theLastUpdated, builder, from);
        lastUpdatedPredicates.add(from.get("myId").as(Long.class).in((Collection)ResourcePersistentId.toLongList(thePids)));
        cq.where(SearchBuilder.toPredicateArray(lastUpdatedPredicates));
        TypedQuery query = theEntityManager.createQuery(cq);
        return ResourcePersistentId.fromLongList((List)query.getResultList());
    }

    public static Predicate[] toPredicateArray(List<Predicate> thePredicates) {
        return thePredicates.toArray(new Predicate[0]);
    }

    private final class QueryIterator
    extends BaseIterator<ResourcePersistentId>
    implements IResultIterator {
        private final SearchRuntimeDetails mySearchRuntimeDetails;
        private final RequestDetails myRequest;
        private final boolean myHaveRawSqlHooks;
        private final boolean myHavePerfTraceFoundIdHook;
        private final SortSpec mySort;
        private final Integer myOffset;
        private boolean myFirst = true;
        private IncludesIterator myIncludesIterator;
        private ResourcePersistentId myNext;
        private ISearchQueryExecutor myResultsIterator;
        private boolean myFetchIncludesForEverythingOperation;
        private int mySkipCount = 0;
        private int myNonSkipCount = 0;
        private List<ISearchQueryExecutor> myQueryList = new ArrayList<ISearchQueryExecutor>();

        private QueryIterator(SearchRuntimeDetails theSearchRuntimeDetails, RequestDetails theRequest) {
            this.mySearchRuntimeDetails = theSearchRuntimeDetails;
            this.mySort = SearchBuilder.this.myParams.getSort();
            this.myOffset = SearchBuilder.this.myParams.getOffset();
            this.myRequest = theRequest;
            if (SearchBuilder.this.myParams.getEverythingMode() != null && !SearchBuilder.this.myParams.containsKey("_type")) {
                this.myFetchIncludesForEverythingOperation = true;
            }
            this.myHavePerfTraceFoundIdHook = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
            this.myHaveRawSqlHooks = CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchNext() {
            HookParams params;
            HookParams params2;
            try {
                if (this.myHaveRawSqlHooks) {
                    CurrentThreadCaptureQueriesListener.startCapturing();
                }
                if (this.myResultsIterator == null) {
                    if (SearchBuilder.this.myMaxResultsToFetch == null) {
                        SearchBuilder.this.myMaxResultsToFetch = SearchBuilder.this.myParams.getLoadSynchronousUpTo() != null ? SearchBuilder.this.myParams.getLoadSynchronousUpTo() : (SearchBuilder.this.myParams.getOffset() != null && SearchBuilder.this.myParams.getCount() != null ? SearchBuilder.this.myParams.getCount() : SearchBuilder.this.myDaoConfig.getFetchSizeDefaultMaximum());
                    }
                    this.initializeIteratorQuery(this.myOffset, SearchBuilder.this.myMaxResultsToFetch);
                    if (SearchBuilder.this.myAlsoIncludePids == null) {
                        SearchBuilder.this.myAlsoIncludePids = new ArrayList<ResourcePersistentId>();
                    }
                }
                if (this.myNext == null) {
                    for (ResourcePersistentId next : SearchBuilder.this.myAlsoIncludePids) {
                        if (next == null || !SearchBuilder.this.myPidSet.add(next)) continue;
                        this.myNext = next;
                        break;
                    }
                    if (this.myNext == null) {
                        while (this.myResultsIterator.hasNext() || !this.myQueryList.isEmpty()) {
                            if (!this.myResultsIterator.hasNext()) {
                                this.retrieveNextIteratorQuery();
                            }
                            Long nextLong = (Long)this.myResultsIterator.next();
                            if (this.myHavePerfTraceFoundIdHook) {
                                params2 = new HookParams().add(Integer.class, (Object)System.identityHashCode(this)).add(Object.class, (Object)nextLong);
                                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FOUND_ID, (HookParams)params2);
                            }
                            if (nextLong != null) {
                                ResourcePersistentId next;
                                next = new ResourcePersistentId((Object)nextLong);
                                if (SearchBuilder.this.myPidSet.add(next)) {
                                    this.myNext = next;
                                    ++this.myNonSkipCount;
                                    break;
                                }
                                ++this.mySkipCount;
                            }
                            if (this.myResultsIterator.hasNext() || SearchBuilder.this.myMaxResultsToFetch == null || this.mySkipCount + this.myNonSkipCount != SearchBuilder.this.myMaxResultsToFetch || this.mySkipCount <= 0 || this.myNonSkipCount != 0) continue;
                            StorageProcessingMessage message = new StorageProcessingMessage();
                            String msg = "Pass completed with no matching results seeking rows " + SearchBuilder.this.myPidSet.size() + "-" + this.mySkipCount + ". This indicates an inefficient query! Retrying with new max count of " + SearchBuilder.this.myMaxResultsToFetch;
                            ourLog.warn(msg);
                            message.setMessage(msg);
                            HookParams params3 = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(StorageProcessingMessage.class, (Object)message);
                            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (HookParams)params3);
                            SearchBuilder.this.myMaxResultsToFetch = SearchBuilder.this.myMaxResultsToFetch + 1000;
                            this.initializeIteratorQuery(this.myOffset, SearchBuilder.this.myMaxResultsToFetch);
                        }
                    }
                    if (this.myNext == null) {
                        if (this.myFetchIncludesForEverythingOperation) {
                            this.myIncludesIterator = new IncludesIterator(SearchBuilder.this.myPidSet, this.myRequest);
                            this.myFetchIncludesForEverythingOperation = false;
                        }
                        if (this.myIncludesIterator != null) {
                            while (this.myIncludesIterator.hasNext()) {
                                ResourcePersistentId next = this.myIncludesIterator.next();
                                if (next == null || !SearchBuilder.this.myPidSet.add(next)) continue;
                                this.myNext = next;
                                break;
                            }
                            if (this.myNext == null) {
                                this.myNext = NO_MORE;
                            }
                        } else {
                            this.myNext = NO_MORE;
                        }
                    }
                }
                this.mySearchRuntimeDetails.setFoundMatchesCount(SearchBuilder.this.myPidSet.size());
            }
            finally {
                if (this.myHaveRawSqlHooks) {
                    SqlQueryList capturedQueries = CurrentThreadCaptureQueriesListener.getCurrentQueueAndStopCapturing();
                    params2 = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SqlQueryList.class, (Object)capturedQueries);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_RAW_SQL, (HookParams)params2);
                }
            }
            if (this.myFirst) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_FIRST_RESULT_LOADED, (HookParams)params);
                this.myFirst = false;
            }
            if (NO_MORE.equals((Object)this.myNext)) {
                params = new HookParams().add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest).add(SearchRuntimeDetails.class, (Object)this.mySearchRuntimeDetails);
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)SearchBuilder.this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.JPA_PERFTRACE_SEARCH_SELECT_COMPLETE, (HookParams)params);
            }
        }

        private void initializeIteratorQuery(Integer theOffset, Integer theMaxResultsToFetch) {
            if (this.myQueryList.isEmpty()) {
                this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
                this.myQueryList = SearchBuilder.this.createQuery(SearchBuilder.this.myParams, this.mySort, theOffset, theMaxResultsToFetch, false, this.myRequest, this.mySearchRuntimeDetails);
            }
            this.mySearchRuntimeDetails.setQueryStopwatch(new StopWatch());
            this.retrieveNextIteratorQuery();
            this.mySkipCount = 0;
            this.myNonSkipCount = 0;
        }

        private void retrieveNextIteratorQuery() {
            this.close();
            if (this.myQueryList != null && this.myQueryList.size() > 0) {
                this.myResultsIterator = this.myQueryList.remove(0);
                SearchBuilder.this.myHasNextIteratorQuery = true;
            } else {
                this.myResultsIterator = SearchQueryExecutor.emptyExecutor();
                SearchBuilder.this.myHasNextIteratorQuery = false;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.myNext == null) {
                this.fetchNext();
            }
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public ResourcePersistentId next() {
            this.fetchNext();
            ResourcePersistentId retVal = this.myNext;
            this.myNext = null;
            Validate.isTrue((!NO_MORE.equals((Object)retVal) ? 1 : 0) != 0, (String)"No more elements", (Object[])new Object[0]);
            return retVal;
        }

        public int getSkippedCount() {
            return this.mySkipCount;
        }

        public int getNonSkippedCount() {
            return this.myNonSkipCount;
        }

        public Collection<ResourcePersistentId> getNextResultBatch(long theBatchSize) {
            ArrayList<ResourcePersistentId> batch = new ArrayList<ResourcePersistentId>();
            while (this.hasNext() && (long)batch.size() < theBatchSize) {
                batch.add(this.next());
            }
            return batch;
        }

        public void close() {
            if (this.myResultsIterator != null) {
                this.myResultsIterator.close();
            }
            this.myResultsIterator = null;
        }
    }

    public class IncludesIterator
    extends BaseIterator<ResourcePersistentId>
    implements Iterator<ResourcePersistentId> {
        private final RequestDetails myRequest;
        private final Set<ResourcePersistentId> myCurrentPids;
        private Iterator<ResourcePersistentId> myCurrentIterator;
        private ResourcePersistentId myNext;

        IncludesIterator(Set<ResourcePersistentId> thePidSet, RequestDetails theRequest) {
            this.myCurrentPids = new HashSet<ResourcePersistentId>(thePidSet);
            this.myCurrentIterator = null;
            this.myRequest = theRequest;
        }

        private void fetchNext() {
            while (this.myNext == null) {
                if (this.myCurrentIterator == null) {
                    Set<Include> includes = Collections.singleton(new Include("*", true));
                    Set<ResourcePersistentId> newPids = SearchBuilder.this.loadIncludes(SearchBuilder.this.myContext, SearchBuilder.this.myEntityManager, this.myCurrentPids, includes, false, SearchBuilder.this.getParams().getLastUpdated(), SearchBuilder.this.mySearchUuid, this.myRequest, null);
                    this.myCurrentIterator = newPids.iterator();
                }
                if (this.myCurrentIterator.hasNext()) {
                    this.myNext = this.myCurrentIterator.next();
                    continue;
                }
                this.myNext = NO_MORE;
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return !NO_MORE.equals((Object)this.myNext);
        }

        @Override
        public ResourcePersistentId next() {
            this.fetchNext();
            ResourcePersistentId retVal = this.myNext;
            this.myNext = null;
            return retVal;
        }
    }
}

