/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class SearchQueryExecutors {
    public static ISearchQueryExecutor limited(final ISearchQueryExecutor theExecutor, final long theLimit) {
        Validate.isTrue((theLimit >= 0L ? 1 : 0) != 0, (String)"limit must be non-negative", (Object[])new Object[0]);
        return new ISearchQueryExecutor(){
            long myCount = 0L;

            @Override
            public void close() {
                theExecutor.close();
            }

            @Override
            public boolean hasNext() {
                return theExecutor.hasNext() && this.myCount < theLimit;
            }

            @Override
            public Long next() {
                ++this.myCount;
                return (Long)theExecutor.next();
            }
        };
    }

    @Nonnull
    public static ISearchQueryExecutor from(List<Long> rawPids) {
        return new ResolvedSearchQueryExecutor(rawPids);
    }

    public static ISearchQueryExecutor from(Iterator<ResourcePersistentId> theIterator) {
        return new ResourcePersistentIdQueryAdaptor(theIterator);
    }

    public static ISearchQueryExecutor from(Iterable<ResourcePersistentId> theIterable) {
        return new ResourcePersistentIdQueryAdaptor(theIterable.iterator());
    }

    static class ResolvedSearchQueryExecutor
    implements ISearchQueryExecutor {
        private final Iterator<Long> myIterator;

        ResolvedSearchQueryExecutor(Iterable<Long> theIterable) {
            this(theIterable.iterator());
        }

        ResolvedSearchQueryExecutor(Iterator<Long> theIterator) {
            this.myIterator = theIterator;
        }

        @Nonnull
        public static ResolvedSearchQueryExecutor from(List<Long> rawPids) {
            return new ResolvedSearchQueryExecutor(rawPids);
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public Long next() {
            return this.myIterator.next();
        }

        @Override
        public void close() {
        }
    }

    static class ResourcePersistentIdQueryAdaptor
    implements ISearchQueryExecutor {
        final Iterator<ResourcePersistentId> myIterator;

        ResourcePersistentIdQueryAdaptor(Iterator<ResourcePersistentId> theIterator) {
            this.myIterator = theIterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public Long next() {
            ResourcePersistentId next = this.myIterator.next();
            return next == null ? null : next.getIdAsLong();
        }
    }
}

