/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.CoordCalculator;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.TokenParam;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.engine.spatial.GeoBoundingBox;

public class CoordsPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private final DbColumn myColumnLatitude = this.getTable().addColumn("SP_LATITUDE");
    private final DbColumn myColumnLongitude = this.getTable().addColumn("SP_LONGITUDE");

    public CoordsPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_COORDS"));
    }

    public Condition createPredicateCoords(SearchParameterMap theParams, IQueryParameterType theParam, String theResourceName, RuntimeSearchParam theSearchParam, CoordsPredicateBuilder theFrom, RequestPartitionId theRequestPartitionId) {
        Condition longitudePredicate;
        Condition latitudePredicate;
        String longitudeValue;
        String latitudeValue;
        String[] parts;
        String value;
        TokenParam param;
        double distanceKm = 0.0;
        if (theParam instanceof TokenParam) {
            param = (TokenParam)theParam;
            value = param.getValue();
            parts = value.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException(Msg.code((int)1228) + "Invalid position format '" + value + "'.  Required format is 'latitude:longitude'");
            }
            latitudeValue = parts[0];
            longitudeValue = parts[1];
            if (StringUtils.isBlank((CharSequence)latitudeValue) || StringUtils.isBlank((CharSequence)longitudeValue)) {
                throw new IllegalArgumentException(Msg.code((int)1229) + "Invalid position format '" + value + "'.  Both latitude and longitude must be provided.");
            }
            QuantityParam distanceParam = theParams.getNearDistanceParam();
            if (distanceParam != null) {
                distanceKm = distanceParam.getValue().doubleValue();
            }
        } else if (theParam instanceof SpecialParam) {
            String distanceString;
            param = (SpecialParam)theParam;
            value = param.getValue();
            parts = value.split("\\|");
            if (parts.length < 2 || parts.length > 4) {
                throw new IllegalArgumentException(Msg.code((int)1230) + "Invalid position format '" + value + "'.  Required format is 'latitude|longitude' or 'latitude|longitude|distance' or 'latitude|longitude|distance|units'");
            }
            latitudeValue = parts[0];
            longitudeValue = parts[1];
            if (StringUtils.isBlank((CharSequence)latitudeValue) || StringUtils.isBlank((CharSequence)longitudeValue)) {
                throw new IllegalArgumentException(Msg.code((int)1231) + "Invalid position format '" + value + "'.  Both latitude and longitude must be provided.");
            }
            if (parts.length >= 3 && !StringUtils.isBlank((CharSequence)(distanceString = parts[2]))) {
                distanceKm = Double.parseDouble(distanceString);
            }
        } else {
            throw new IllegalArgumentException(Msg.code((int)1232) + "Invalid position type: " + theParam.getClass());
        }
        if (distanceKm == 0.0) {
            latitudePredicate = theFrom.createPredicateLatitudeExact(latitudeValue);
            longitudePredicate = theFrom.createPredicateLongitudeExact(longitudeValue);
        } else {
            if (distanceKm < 0.0) {
                throw new IllegalArgumentException(Msg.code((int)1233) + "Invalid near-distance parameter '" + distanceKm + "' must be >= 0.0");
            }
            if (distanceKm > 10000.0) {
                throw new IllegalArgumentException(Msg.code((int)1234) + "Invalid near-distance parameter '" + distanceKm + "' must be <= 10000.0");
            }
            double latitudeDegrees = Double.parseDouble(latitudeValue);
            double longitudeDegrees = Double.parseDouble(longitudeValue);
            GeoBoundingBox box = CoordCalculator.getBox(latitudeDegrees, longitudeDegrees, distanceKm);
            latitudePredicate = theFrom.createLatitudePredicateFromBox(box);
            longitudePredicate = theFrom.createLongitudePredicateFromBox(box);
        }
        ComboCondition singleCode = ComboCondition.and((Condition[])new Condition[]{latitudePredicate, longitudePredicate});
        return this.combineWithHashIdentityPredicate(theResourceName, theSearchParam.getName(), (Condition)singleCode);
    }

    public Condition createPredicateLatitudeExact(String theLatitudeValue) {
        return BinaryCondition.equalTo((Object)this.myColumnLatitude, (Object)this.generatePlaceholder(theLatitudeValue));
    }

    public Condition createPredicateLongitudeExact(String theLongitudeValue) {
        return BinaryCondition.equalTo((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theLongitudeValue));
    }

    public Condition createLatitudePredicateFromBox(GeoBoundingBox theBox) {
        return ComboCondition.and((Condition[])new Condition[]{BinaryCondition.greaterThanOrEq((Object)this.myColumnLatitude, (Object)this.generatePlaceholder(theBox.bottomRight().latitude())), BinaryCondition.lessThanOrEq((Object)this.myColumnLatitude, (Object)this.generatePlaceholder(theBox.topLeft().latitude()))});
    }

    public Condition createLongitudePredicateFromBox(GeoBoundingBox theBox) {
        if (theBox.bottomRight().longitude() < theBox.topLeft().longitude()) {
            return ComboCondition.or((Condition[])new Condition[]{BinaryCondition.greaterThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.bottomRight().longitude())), BinaryCondition.lessThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.topLeft().longitude()))});
        }
        return ComboCondition.and((Condition[])new Condition[]{BinaryCondition.greaterThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.topLeft().longitude())), BinaryCondition.lessThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.bottomRight().longitude()))});
    }
}

