/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.NotCondition;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.Set;

public class ResourceTablePredicateBuilder
extends BaseJoiningPredicateBuilder {
    private final DbColumn myColumnResId = this.getTable().addColumn("RES_ID");
    private final DbColumn myColumnResDeletedAt;
    private final DbColumn myColumnResType = this.getTable().addColumn("RES_TYPE");
    private final DbColumn myColumnLastUpdated;
    private final DbColumn myColumnLanguage;

    public ResourceTablePredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_RESOURCE"));
        this.myColumnResDeletedAt = this.getTable().addColumn("RES_DELETED_AT");
        this.myColumnLastUpdated = this.getTable().addColumn("RES_UPDATED");
        this.myColumnLanguage = this.getTable().addColumn("RES_LANGUAGE");
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myColumnResId;
    }

    public Condition createResourceTypeAndNonDeletedPredicates() {
        BinaryCondition typePredicate = null;
        if (this.getResourceType() != null) {
            typePredicate = BinaryCondition.equalTo((Object)this.myColumnResType, (Object)this.generatePlaceholder(this.getResourceType()));
        }
        return QueryStack.toAndPredicate(new Condition[]{typePredicate, UnaryCondition.isNull((Object)this.myColumnResDeletedAt)});
    }

    public DbColumn getLastUpdatedColumn() {
        return this.myColumnLastUpdated;
    }

    public Condition createLanguagePredicate(Set<String> theValues, boolean theNegated) {
        Condition condition = QueryStack.toEqualToOrInPredicate(this.myColumnLanguage, this.generatePlaceholders(theValues));
        if (theNegated) {
            condition = new NotCondition(condition);
        }
        return condition;
    }

    public DbColumn getColumnLastUpdated() {
        return this.myColumnLastUpdated;
    }
}

