/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamString;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.StringUtil;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class StringPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private final DbColumn myColumnResId = this.getTable().addColumn("RES_ID");
    private final DbColumn myColumnValueExact = this.getTable().addColumn("SP_VALUE_EXACT");
    private final DbColumn myColumnValueNormalized = this.getTable().addColumn("SP_VALUE_NORMALIZED");
    private final DbColumn myColumnHashNormPrefix = this.getTable().addColumn("HASH_NORM_PREFIX");
    private final DbColumn myColumnHashIdentity = this.getTable().addColumn("HASH_IDENTITY");
    private final DbColumn myColumnHashExact = this.getTable().addColumn("HASH_EXACT");
    @Autowired
    private DaoConfig myDaoConfig;

    public StringPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_STRING"));
    }

    public DbColumn getColumnValueNormalized() {
        return this.myColumnValueNormalized;
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myColumnResId;
    }

    public Condition createPredicateString(IQueryParameterType theParameter, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, StringPredicateBuilder theFrom, SearchFilterParser.CompareOperation operation) {
        Condition predicate;
        boolean exactMatch;
        String rawSearchTerm;
        TokenParam id;
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        if (theParameter instanceof TokenParam) {
            id = (TokenParam)theParameter;
            if (!id.isText()) {
                throw new IllegalStateException(Msg.code((int)1257) + "Trying to process a text search on a non-text token parameter");
            }
            rawSearchTerm = id.getValue();
        } else if (theParameter instanceof StringParam) {
            id = (StringParam)theParameter;
            rawSearchTerm = id.getValue();
            if (id.isContains()) {
                if (!this.myDaoConfig.isAllowContainsSearches()) {
                    throw new MethodNotAllowedException(Msg.code((int)1258) + ":contains modifier is disabled on this server");
                }
            } else {
                rawSearchTerm = theSearchParam.encode(rawSearchTerm);
            }
        } else if (theParameter instanceof IPrimitiveDatatype) {
            id = (IPrimitiveDatatype)theParameter;
            rawSearchTerm = id.getValueAsString();
        } else {
            throw new IllegalArgumentException(Msg.code((int)1259) + "Invalid token type: " + theParameter.getClass());
        }
        if (rawSearchTerm.length() > 200) {
            throw new InvalidRequestException(Msg.code((int)1260) + "Parameter[" + paramName + "] has length (" + rawSearchTerm.length() + ") that is longer than maximum allowed (200): " + rawSearchTerm);
        }
        boolean bl = exactMatch = theParameter instanceof StringParam && ((StringParam)theParameter).isExact();
        if (exactMatch) {
            return theFrom.createPredicateExact(theResourceName, paramName, rawSearchTerm);
        }
        String normalizedString = StringUtil.normalizeStringForSearchIndexing((String)rawSearchTerm);
        String likeExpression = theParameter instanceof StringParam && (((StringParam)theParameter).isContains() && this.myDaoConfig.isAllowContainsSearches() || operation == SearchFilterParser.CompareOperation.co) ? StringPredicateBuilder.createLeftAndRightMatchLikeExpression(normalizedString) : (operation != SearchFilterParser.CompareOperation.ne && operation != SearchFilterParser.CompareOperation.gt && operation != SearchFilterParser.CompareOperation.lt && operation != SearchFilterParser.CompareOperation.ge && operation != SearchFilterParser.CompareOperation.le ? (operation == SearchFilterParser.CompareOperation.ew ? StringPredicateBuilder.createRightMatchLikeExpression(normalizedString) : StringPredicateBuilder.createLeftMatchLikeExpression(normalizedString)) : normalizedString);
        if (operation == null || operation == SearchFilterParser.CompareOperation.sw) {
            predicate = theFrom.createPredicateNormalLike(theResourceName, paramName, normalizedString, likeExpression);
        } else if (operation == SearchFilterParser.CompareOperation.ew || operation == SearchFilterParser.CompareOperation.co) {
            predicate = theFrom.createPredicateLikeExpressionOnly(theResourceName, paramName, likeExpression, false);
        } else if (operation == SearchFilterParser.CompareOperation.eq) {
            predicate = theFrom.createPredicateNormal(theResourceName, paramName, normalizedString);
        } else if (operation == SearchFilterParser.CompareOperation.ne) {
            predicate = theFrom.createPredicateLikeExpressionOnly(theResourceName, paramName, likeExpression, true);
        } else if (operation == SearchFilterParser.CompareOperation.gt) {
            predicate = theFrom.createPredicateNormalGreaterThan(theResourceName, paramName, likeExpression);
        } else if (operation == SearchFilterParser.CompareOperation.ge) {
            predicate = theFrom.createPredicateNormalGreaterThanOrEqual(theResourceName, paramName, likeExpression);
        } else if (operation == SearchFilterParser.CompareOperation.lt) {
            predicate = theFrom.createPredicateNormalLessThan(theResourceName, paramName, likeExpression);
        } else if (operation == SearchFilterParser.CompareOperation.le) {
            predicate = theFrom.createPredicateNormalLessThanOrEqual(theResourceName, paramName, likeExpression);
        } else {
            throw new IllegalArgumentException(Msg.code((int)1261) + "Don't yet know how to handle operation " + operation + " on a string");
        }
        return predicate;
    }

    @Nonnull
    public Condition createPredicateExact(String theResourceType, String theParamName, String theTheValueExact) {
        long hash = ResourceIndexedSearchParamString.calculateHashExact((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)theResourceType, (String)theParamName, (String)theTheValueExact);
        String placeholderValue = this.generatePlaceholder(hash);
        return BinaryCondition.equalTo((Object)this.myColumnHashExact, (Object)placeholderValue);
    }

    @Nonnull
    public Condition createPredicateNormalLike(String theResourceType, String theParamName, String theNormalizedString, String theLikeExpression) {
        Long hash = ResourceIndexedSearchParamString.calculateHashNormalized((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (ModelConfig)this.getModelConfig(), (String)theResourceType, (String)theParamName, (String)theNormalizedString);
        BinaryCondition hashPredicate = BinaryCondition.equalTo((Object)this.myColumnHashNormPrefix, (Object)this.generatePlaceholder(hash));
        BinaryCondition valuePredicate = BinaryCondition.like((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theLikeExpression));
        return ComboCondition.and((Condition[])new Condition[]{hashPredicate, valuePredicate});
    }

    @Nonnull
    public Condition createPredicateNormal(String theResourceType, String theParamName, String theNormalizedString) {
        Long hash = ResourceIndexedSearchParamString.calculateHashNormalized((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (ModelConfig)this.getModelConfig(), (String)theResourceType, (String)theParamName, (String)theNormalizedString);
        BinaryCondition hashPredicate = BinaryCondition.equalTo((Object)this.myColumnHashNormPrefix, (Object)this.generatePlaceholder(hash));
        BinaryCondition valuePredicate = BinaryCondition.equalTo((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theNormalizedString));
        return ComboCondition.and((Condition[])new Condition[]{hashPredicate, valuePredicate});
    }

    private Condition createPredicateNormalGreaterThanOrEqual(String theResourceType, String theParamName, String theNormalizedString) {
        Condition hashPredicate = this.createHashIdentityPredicate(theResourceType, theParamName);
        BinaryCondition valuePredicate = BinaryCondition.greaterThanOrEq((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theNormalizedString));
        return ComboCondition.and((Condition[])new Condition[]{hashPredicate, valuePredicate});
    }

    private Condition createPredicateNormalGreaterThan(String theResourceType, String theParamName, String theNormalizedString) {
        Condition hashPredicate = this.createHashIdentityPredicate(theResourceType, theParamName);
        BinaryCondition valuePredicate = BinaryCondition.greaterThan((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theNormalizedString));
        return ComboCondition.and((Condition[])new Condition[]{hashPredicate, valuePredicate});
    }

    private Condition createPredicateNormalLessThanOrEqual(String theResourceType, String theParamName, String theNormalizedString) {
        Condition hashPredicate = this.createHashIdentityPredicate(theResourceType, theParamName);
        BinaryCondition valuePredicate = BinaryCondition.lessThanOrEq((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theNormalizedString));
        return ComboCondition.and((Condition[])new Condition[]{hashPredicate, valuePredicate});
    }

    private Condition createPredicateNormalLessThan(String theResourceType, String theParamName, String theNormalizedString) {
        Condition hashPredicate = this.createHashIdentityPredicate(theResourceType, theParamName);
        BinaryCondition valuePredicate = BinaryCondition.lessThan((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theNormalizedString));
        return ComboCondition.and((Condition[])new Condition[]{hashPredicate, valuePredicate});
    }

    @Nonnull
    public Condition createPredicateLikeExpressionOnly(String theResourceType, String theParamName, String theLikeExpression, boolean theInverse) {
        long hashIdentity = ResourceIndexedSearchParamString.calculateHashIdentity((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)theResourceType, (String)theParamName);
        BinaryCondition identityPredicate = BinaryCondition.equalTo((Object)this.myColumnHashIdentity, (Object)this.generatePlaceholder(hashIdentity));
        BinaryCondition likePredicate = theInverse ? BinaryCondition.notLike((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theLikeExpression)) : BinaryCondition.like((Object)this.myColumnValueNormalized, (Object)this.generatePlaceholder(theLikeExpression));
        return ComboCondition.and((Condition[])new Condition[]{identityPredicate, likePredicate});
    }

    public static String createLeftAndRightMatchLikeExpression(String likeExpression) {
        return "%" + likeExpression.replace("%", "\\%") + "%";
    }

    public static String createLeftMatchLikeExpression(String likeExpression) {
        return likeExpression.replace("%", "\\%") + "%";
    }

    public static String createRightMatchLikeExpression(String likeExpression) {
        return "%" + likeExpression.replace("%", "\\%");
    }
}

