/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.data.IResourceIndexedSearchParamUriDao;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ResourceIndexedSearchParamUri;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.param.UriParamQualifierEnum;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UriPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(UriPredicateBuilder.class);
    private final DbColumn myColumnUri = this.getTable().addColumn("SP_URI");
    private final DbColumn myColumnHashUri = this.getTable().addColumn("HASH_URI");
    @Autowired
    private IResourceIndexedSearchParamUriDao myResourceIndexedSearchParamUriDao;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    public UriPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_URI"));
    }

    public Condition addPredicate(List<? extends IQueryParameterType> theUriOrParameterList, String theParamName, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequestDetails) {
        ArrayList<Object> codePredicates = new ArrayList<Object>();
        boolean predicateIsHash = false;
        for (IQueryParameterType iQueryParameterType : theUriOrParameterList) {
            if (iQueryParameterType instanceof UriParam) {
                BinaryCondition uriPredicate;
                UriParam param = (UriParam)iQueryParameterType;
                String value = param.getValue();
                if (value == null) continue;
                if (param.getQualifier() == UriParamQualifierEnum.ABOVE) {
                    String msg = "Searching for candidate URI:above parameters for Resource[" + this.getResourceType() + "] param[" + theParamName + "]";
                    ourLog.info(msg);
                    StorageProcessingMessage message = new StorageProcessingMessage();
                    ourLog.warn(msg);
                    message.setMessage(msg);
                    HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(StorageProcessingMessage.class, (Object)message);
                    CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (HookParams)params);
                    Collection<String> candidates = this.myResourceIndexedSearchParamUriDao.findAllByResourceTypeAndParamName(this.getResourceType(), theParamName);
                    ArrayList<String> toFind = new ArrayList<String>();
                    for (String next : candidates) {
                        if (value.length() < next.length() || !value.startsWith(next)) continue;
                        toFind.add(next);
                    }
                    if (toFind.isEmpty()) continue;
                    Condition uriPredicate2 = QueryStack.toEqualToOrInPredicate(this.myColumnUri, this.generatePlaceholders(toFind));
                    Condition hashAndUriPredicate = this.combineWithHashIdentityPredicate(this.getResourceType(), theParamName, uriPredicate2);
                    codePredicates.add(hashAndUriPredicate);
                    continue;
                }
                if (param.getQualifier() == UriParamQualifierEnum.BELOW) {
                    uriPredicate = BinaryCondition.like((Object)this.myColumnUri, (Object)this.generatePlaceholder(StringPredicateBuilder.createLeftMatchLikeExpression(value)));
                    Condition hashAndUriPredicate = this.combineWithHashIdentityPredicate(this.getResourceType(), theParamName, (Condition)uriPredicate);
                    codePredicates.add(hashAndUriPredicate);
                    continue;
                }
                uriPredicate = null;
                if (theOperation == null || theOperation == SearchFilterParser.CompareOperation.eq) {
                    long hashUri = ResourceIndexedSearchParamUri.calculateHashUri((PartitionSettings)this.getPartitionSettings(), (RequestPartitionId)this.getRequestPartitionId(), (String)this.getResourceType(), (String)theParamName, (String)value);
                    uriPredicate = BinaryCondition.equalTo((Object)this.myColumnHashUri, (Object)this.generatePlaceholder(hashUri));
                    predicateIsHash = true;
                } else if (theOperation == SearchFilterParser.CompareOperation.ne) {
                    uriPredicate = BinaryCondition.notEqualTo((Object)this.myColumnUri, (Object)this.generatePlaceholder(value));
                } else if (theOperation == SearchFilterParser.CompareOperation.co) {
                    uriPredicate = BinaryCondition.like((Object)this.myColumnUri, (Object)this.generatePlaceholder(StringPredicateBuilder.createLeftAndRightMatchLikeExpression(value)));
                } else if (theOperation == SearchFilterParser.CompareOperation.gt) {
                    uriPredicate = BinaryCondition.greaterThan((Object)this.myColumnUri, (Object)this.generatePlaceholder(value));
                } else if (theOperation == SearchFilterParser.CompareOperation.lt) {
                    uriPredicate = BinaryCondition.lessThan((Object)this.myColumnUri, (Object)this.generatePlaceholder(value));
                } else if (theOperation == SearchFilterParser.CompareOperation.ge) {
                    uriPredicate = BinaryCondition.greaterThanOrEq((Object)this.myColumnUri, (Object)this.generatePlaceholder(value));
                } else if (theOperation == SearchFilterParser.CompareOperation.le) {
                    uriPredicate = BinaryCondition.lessThanOrEq((Object)this.myColumnUri, (Object)this.generatePlaceholder(value));
                } else if (theOperation == SearchFilterParser.CompareOperation.sw) {
                    uriPredicate = BinaryCondition.like((Object)this.myColumnUri, (Object)this.generatePlaceholder(StringPredicateBuilder.createLeftMatchLikeExpression(value)));
                } else if (theOperation == SearchFilterParser.CompareOperation.ew) {
                    uriPredicate = BinaryCondition.like((Object)this.myColumnUri, (Object)this.generatePlaceholder(StringPredicateBuilder.createRightMatchLikeExpression(value)));
                } else {
                    throw new IllegalArgumentException(Msg.code((int)1226) + String.format("Unsupported operator specified in _filter clause, %s", theOperation.toString()));
                }
                codePredicates.add(uriPredicate);
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1227) + "Invalid URI type: " + iQueryParameterType.getClass());
        }
        if (codePredicates.isEmpty()) {
            this.setMatchNothing();
            return null;
        }
        ComboCondition orPredicate = ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0]));
        if (predicateIsHash) {
            return orPredicate;
        }
        return this.combineWithHashIdentityPredicate(this.getResourceType(), theParamName, (Condition)orPredicate);
    }

    public DbColumn getColumnValue() {
        return this.myColumnUri;
    }
}

