/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.sql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboNonUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.CoordsPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.DatePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ForcedIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.NumberPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityNormalizedPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceLinkPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceTablePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SearchParamPresentPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SourcePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TagPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TokenPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.UriPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.GeneratedSql;
import ca.uhn.fhir.jpa.search.builder.sql.SqlObjectFactory;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Join;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbJoin;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.engine.spi.RowSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchQueryBuilder.class);
    private final String myBindVariableSubstitutionBase;
    private final ArrayList<Object> myBindVariableValues;
    private final DbSpec mySpec;
    private final DbSchema mySchema;
    private final SelectQuery mySelect;
    private final PartitionSettings myPartitionSettings;
    private final RequestPartitionId myRequestPartitionId;
    private final String myResourceType;
    private final ModelConfig myModelConfig;
    private final FhirContext myFhirContext;
    private final SqlObjectFactory mySqlBuilderFactory;
    private final boolean myCountQuery;
    private final Dialect myDialect;
    private boolean myMatchNothing;
    private ResourceTablePredicateBuilder myResourceTableRoot;
    private boolean myHaveAtLeastOnePredicate;
    private BaseJoiningPredicateBuilder myFirstPredicateBuilder;
    private boolean dialectIsMsSql;
    private boolean dialectIsMySql;
    private boolean myNeedResourceTableRoot;

    public SearchQueryBuilder(FhirContext theFhirContext, ModelConfig theModelConfig, PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, SqlObjectFactory theSqlBuilderFactory, HibernatePropertiesProvider theDialectProvider, boolean theCountQuery) {
        this(theFhirContext, theModelConfig, thePartitionSettings, theRequestPartitionId, theResourceType, theSqlBuilderFactory, UUID.randomUUID() + "-", theDialectProvider.getDialect(), theCountQuery, new ArrayList<Object>());
    }

    private SearchQueryBuilder(FhirContext theFhirContext, ModelConfig theModelConfig, PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, SqlObjectFactory theSqlBuilderFactory, String theBindVariableSubstitutionBase, Dialect theDialect, boolean theCountQuery, ArrayList<Object> theBindVariableValues) {
        this.myFhirContext = theFhirContext;
        this.myModelConfig = theModelConfig;
        this.myPartitionSettings = thePartitionSettings;
        this.myRequestPartitionId = theRequestPartitionId;
        this.myResourceType = theResourceType;
        this.mySqlBuilderFactory = theSqlBuilderFactory;
        this.myCountQuery = theCountQuery;
        this.myDialect = theDialect;
        if (this.myDialect instanceof MySQLDialect) {
            this.dialectIsMySql = true;
        }
        if (this.myDialect instanceof SQLServerDialect) {
            this.dialectIsMsSql = true;
        }
        this.mySpec = new DbSpec();
        this.mySchema = this.mySpec.addDefaultSchema();
        this.mySelect = new SelectQuery();
        this.myBindVariableSubstitutionBase = theBindVariableSubstitutionBase;
        this.myBindVariableValues = theBindVariableValues;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public ComboUniqueSearchParameterPredicateBuilder addComboUniquePredicateBuilder() {
        ComboUniqueSearchParameterPredicateBuilder retVal = this.mySqlBuilderFactory.newComboUniqueSearchParameterPredicateBuilder(this);
        this.addTable(retVal, null);
        return retVal;
    }

    public ComboNonUniqueSearchParameterPredicateBuilder addComboNonUniquePredicateBuilder() {
        ComboNonUniqueSearchParameterPredicateBuilder retVal = this.mySqlBuilderFactory.newComboNonUniqueSearchParameterPredicateBuilder(this);
        this.addTable(retVal, null);
        return retVal;
    }

    public CoordsPredicateBuilder addCoordsPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        CoordsPredicateBuilder retVal = this.mySqlBuilderFactory.coordsPredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public DatePredicateBuilder addDatePredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        DatePredicateBuilder retVal = this.mySqlBuilderFactory.dateIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public ForcedIdPredicateBuilder addForcedIdPredicateBuilder(@Nonnull DbColumn theSourceJoinColumn) {
        Validate.isTrue((theSourceJoinColumn != null ? 1 : 0) != 0);
        ForcedIdPredicateBuilder retVal = this.mySqlBuilderFactory.newForcedIdPredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public NumberPredicateBuilder addNumberPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        NumberPredicateBuilder retVal = this.mySqlBuilderFactory.numberIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public ResourceTablePredicateBuilder addResourceTablePredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        ResourceTablePredicateBuilder retVal = this.mySqlBuilderFactory.resourceTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public QuantityPredicateBuilder addQuantityPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        QuantityPredicateBuilder retVal = this.mySqlBuilderFactory.quantityIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public QuantityNormalizedPredicateBuilder addQuantityNormalizedPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        QuantityNormalizedPredicateBuilder retVal = this.mySqlBuilderFactory.quantityNormalizedIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public SourcePredicateBuilder addSourcePredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        SourcePredicateBuilder retVal = this.mySqlBuilderFactory.newSourcePredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public ResourceLinkPredicateBuilder addReferencePredicateBuilder(QueryStack theQueryStack, @Nullable DbColumn theSourceJoinColumn) {
        ResourceLinkPredicateBuilder retVal = this.mySqlBuilderFactory.referenceIndexTable(theQueryStack, this, false);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public ResourceLinkPredicateBuilder addReferencePredicateBuilderReversed(QueryStack theQueryStack, DbColumn theSourceJoinColumn) {
        ResourceLinkPredicateBuilder retVal = this.mySqlBuilderFactory.referenceIndexTable(theQueryStack, this, true);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public StringPredicateBuilder addStringPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        StringPredicateBuilder retVal = this.mySqlBuilderFactory.stringIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public TagPredicateBuilder addTagPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        TagPredicateBuilder retVal = this.mySqlBuilderFactory.newTagPredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public TokenPredicateBuilder addTokenPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        TokenPredicateBuilder retVal = this.mySqlBuilderFactory.tokenIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public SearchParamPresentPredicateBuilder addSearchParamPresentPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        SearchParamPresentPredicateBuilder retVal = this.mySqlBuilderFactory.searchParamPresentPredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public UriPredicateBuilder addUriPredicateBuilder(@Nullable DbColumn theSourceJoinColumn) {
        UriPredicateBuilder retVal = this.mySqlBuilderFactory.uriIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public ResourceIdPredicateBuilder newResourceIdBuilder() {
        return this.mySqlBuilderFactory.resourceId(this);
    }

    private void addTable(BaseJoiningPredicateBuilder thePredicateBuilder, @Nullable DbColumn theSourceJoinColumn) {
        if (theSourceJoinColumn != null) {
            DbTable fromTable = theSourceJoinColumn.getTable();
            DbTable toTable = thePredicateBuilder.getTable();
            DbColumn toColumn = thePredicateBuilder.getResourceIdColumn();
            this.addJoin(fromTable, toTable, theSourceJoinColumn, toColumn);
        } else {
            if (this.myFirstPredicateBuilder == null) {
                BaseJoiningPredicateBuilder root = !this.myNeedResourceTableRoot ? thePredicateBuilder : (thePredicateBuilder instanceof ResourceTablePredicateBuilder ? thePredicateBuilder : this.mySqlBuilderFactory.resourceTable(this));
                if (this.myCountQuery) {
                    this.mySelect.addCustomColumns(new Object[]{FunctionCall.count().setIsDistinct(true).addColumnParams(new Column[]{root.getResourceIdColumn()})});
                } else {
                    this.mySelect.addColumns(new Column[]{root.getResourceIdColumn()});
                }
                this.mySelect.addFromTable((Table)root.getTable());
                this.myFirstPredicateBuilder = root;
                if (!this.myNeedResourceTableRoot || thePredicateBuilder instanceof ResourceTablePredicateBuilder) {
                    return;
                }
            }
            DbTable fromTable = this.myFirstPredicateBuilder.getTable();
            DbTable toTable = thePredicateBuilder.getTable();
            DbColumn fromColumn = this.myFirstPredicateBuilder.getResourceIdColumn();
            DbColumn toColumn = thePredicateBuilder.getResourceIdColumn();
            this.addJoin(fromTable, toTable, fromColumn, toColumn);
        }
    }

    public void addJoin(DbTable theFromTable, DbTable theToTable, DbColumn theFromColumn, DbColumn theToColumn) {
        DbJoin join = new DbJoin(this.mySpec, theFromTable, theToTable, new DbColumn[]{theFromColumn}, new DbColumn[]{theToColumn});
        this.mySelect.addJoins(SelectQuery.JoinType.LEFT_OUTER, new Join[]{join});
    }

    public GeneratedSql generate(@Nullable Integer theOffset, @Nullable Integer theMaxResultsToFetch) {
        int idx;
        this.getOrCreateFirstPredicateBuilder();
        this.mySelect.validate();
        Object sql = this.mySelect.toString();
        ArrayList<Object> bindVariables = new ArrayList<Object>();
        while ((idx = ((String)sql).indexOf(this.myBindVariableSubstitutionBase)) != -1) {
            int endIdx = ((String)sql).indexOf("'", idx + this.myBindVariableSubstitutionBase.length());
            String substitutionIndexString = ((String)sql).substring(idx + this.myBindVariableSubstitutionBase.length(), endIdx);
            int substitutionIndex = Integer.parseInt(substitutionIndexString);
            bindVariables.add(this.myBindVariableValues.get(substitutionIndex));
            sql = ((String)sql).substring(0, idx - 1) + "?" + ((String)sql).substring(endIdx + 1);
        }
        Integer maxResultsToFetch = theMaxResultsToFetch;
        Integer offset = theOffset;
        if (offset != null && offset == 0) {
            offset = null;
        }
        if (maxResultsToFetch != null || offset != null) {
            maxResultsToFetch = (Integer)ObjectUtils.defaultIfNull((Object)maxResultsToFetch, (Object)10000);
            AbstractLimitHandler limitHandler = (AbstractLimitHandler)this.myDialect.getLimitHandler();
            RowSelection selection = new RowSelection();
            selection.setFirstRow(offset);
            selection.setMaxRows(maxResultsToFetch);
            sql = limitHandler.processSql((String)sql, selection);
            int startOfQueryParameterIndex = 0;
            boolean isSqlServer = this.myDialect instanceof SQLServerDialect;
            if (isSqlServer) {
                if (((String)sql).contains("top(?)")) {
                    bindVariables.add(0, maxResultsToFetch);
                }
                if (((String)sql).contains("offset 0 rows fetch next ? rows only")) {
                    bindVariables.add(maxResultsToFetch);
                }
                if (((String)sql).contains("offset ? rows fetch next ? rows only")) {
                    bindVariables.add(theOffset);
                    bindVariables.add(maxResultsToFetch);
                }
                if (offset != null && ((String)sql).contains("__row__")) {
                    bindVariables.add(theOffset + 1);
                    bindVariables.add(theOffset + maxResultsToFetch + 1);
                }
            } else if (limitHandler.supportsVariableLimit()) {
                boolean bindLimitParametersFirst = limitHandler.bindLimitParametersFirst();
                if (limitHandler.useMaxForLimit() && offset != null) {
                    maxResultsToFetch = maxResultsToFetch + offset;
                }
                if (limitHandler.bindLimitParametersInReverseOrder()) {
                    startOfQueryParameterIndex = this.bindCountParameter(bindVariables, maxResultsToFetch, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
                    this.bindOffsetParameter(bindVariables, offset, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
                } else {
                    startOfQueryParameterIndex = this.bindOffsetParameter(bindVariables, offset, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
                    this.bindCountParameter(bindVariables, maxResultsToFetch, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
                }
            }
        }
        return new GeneratedSql(this.myMatchNothing, (String)sql, bindVariables);
    }

    private int bindCountParameter(List<Object> bindVariables, Integer maxResultsToFetch, AbstractLimitHandler limitHandler, int startOfQueryParameterIndex, boolean bindLimitParametersFirst) {
        if (limitHandler.supportsLimit()) {
            if (bindLimitParametersFirst) {
                bindVariables.add(startOfQueryParameterIndex++, maxResultsToFetch);
            } else {
                bindVariables.add(maxResultsToFetch);
            }
        }
        return startOfQueryParameterIndex;
    }

    public int bindOffsetParameter(List<Object> theBindVariables, @Nullable Integer theOffset, AbstractLimitHandler theLimitHandler, int theStartOfQueryParameterIndex, boolean theBindLimitParametersFirst) {
        if (theLimitHandler.supportsLimitOffset() && theOffset != null) {
            if (theBindLimitParametersFirst) {
                theBindVariables.add(theStartOfQueryParameterIndex++, theOffset);
            } else {
                theBindVariables.add(theOffset);
            }
        }
        return theStartOfQueryParameterIndex;
    }

    public BaseJoiningPredicateBuilder getOrCreateFirstPredicateBuilder() {
        return this.getOrCreateFirstPredicateBuilder(true);
    }

    public BaseJoiningPredicateBuilder getOrCreateFirstPredicateBuilder(boolean theIncludeResourceTypeAndNonDeletedFlag) {
        if (this.myFirstPredicateBuilder == null) {
            this.getOrCreateResourceTablePredicateBuilder(theIncludeResourceTypeAndNonDeletedFlag);
        }
        return this.myFirstPredicateBuilder;
    }

    public ResourceTablePredicateBuilder getOrCreateResourceTablePredicateBuilder() {
        return this.getOrCreateResourceTablePredicateBuilder(true);
    }

    public ResourceTablePredicateBuilder getOrCreateResourceTablePredicateBuilder(boolean theIncludeResourceTypeAndNonDeletedFlag) {
        if (this.myResourceTableRoot == null) {
            ResourceTablePredicateBuilder resourceTable = this.mySqlBuilderFactory.resourceTable(this);
            this.addTable(resourceTable, null);
            if (theIncludeResourceTypeAndNonDeletedFlag) {
                Condition typeAndDeletionPredicate = resourceTable.createResourceTypeAndNonDeletedPredicates();
                this.addPredicate(typeAndDeletionPredicate);
            }
            this.myResourceTableRoot = resourceTable;
        }
        return this.myResourceTableRoot;
    }

    public String generatePlaceholder(Object theValue) {
        String placeholder = this.myBindVariableSubstitutionBase + this.myBindVariableValues.size();
        this.myBindVariableValues.add(theValue);
        return placeholder;
    }

    public List<String> generatePlaceholders(Collection<?> theValues) {
        return theValues.stream().map(t -> this.generatePlaceholder(t)).collect(Collectors.toList());
    }

    public int countBindVariables() {
        return this.myBindVariableValues.size();
    }

    public void setMatchNothing() {
        this.myMatchNothing = true;
    }

    public DbTable addTable(String theTableName) {
        return this.mySchema.addTable(theTableName);
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public ModelConfig getModelConfig() {
        return this.myModelConfig;
    }

    public void addPredicate(@Nonnull Condition theCondition) {
        assert (theCondition != null);
        this.mySelect.addCondition(theCondition);
        this.myHaveAtLeastOnePredicate = true;
    }

    public ComboCondition addPredicateLastUpdated(DateRangeParam theDateRange) {
        BinaryCondition condition;
        ResourceTablePredicateBuilder resourceTableRoot = this.getOrCreateResourceTablePredicateBuilder(false);
        ArrayList<BinaryCondition> conditions = new ArrayList<BinaryCondition>(2);
        if (this.isNotEqualsComparator(theDateRange)) {
            BinaryCondition condition2 = this.createConditionForValueWithComparator(ParamPrefixEnum.LESSTHAN, resourceTableRoot.getLastUpdatedColumn(), theDateRange.getLowerBoundAsInstant());
            conditions.add(condition2);
            condition2 = this.createConditionForValueWithComparator(ParamPrefixEnum.GREATERTHAN, resourceTableRoot.getLastUpdatedColumn(), theDateRange.getUpperBoundAsInstant());
            conditions.add(condition2);
            return ComboCondition.or((Condition[])conditions.toArray(new Condition[0]));
        }
        if (theDateRange.getLowerBoundAsInstant() != null) {
            condition = this.createConditionForValueWithComparator(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, resourceTableRoot.getLastUpdatedColumn(), theDateRange.getLowerBoundAsInstant());
            conditions.add(condition);
        }
        if (theDateRange.getUpperBoundAsInstant() != null) {
            condition = this.createConditionForValueWithComparator(ParamPrefixEnum.LESSTHAN_OR_EQUALS, resourceTableRoot.getLastUpdatedColumn(), theDateRange.getUpperBoundAsInstant());
            conditions.add(condition);
        }
        return ComboCondition.and((Condition[])conditions.toArray(new Condition[0]));
    }

    private boolean isNotEqualsComparator(DateRangeParam theDateRange) {
        if (theDateRange != null) {
            DateParam lb = theDateRange.getLowerBound();
            DateParam ub = theDateRange.getUpperBound();
            return lb != null && ub != null && lb.getPrefix().equals((Object)ParamPrefixEnum.NOT_EQUAL) && ub.getPrefix().equals((Object)ParamPrefixEnum.NOT_EQUAL);
        }
        return false;
    }

    public void addResourceIdsPredicate(List<Long> thePidList) {
        DbColumn resourceIdColumn = this.getOrCreateFirstPredicateBuilder().getResourceIdColumn();
        InCondition predicate = new InCondition((Object)resourceIdColumn, this.generatePlaceholders(thePidList));
        this.addPredicate((Condition)predicate);
    }

    public void excludeResourceIdsPredicate(Set<ResourcePersistentId> theExsitinghPidSetToExclude) {
        if (theExsitinghPidSetToExclude == null || theExsitinghPidSetToExclude.isEmpty()) {
            return;
        }
        List excludePids = ResourcePersistentId.toLongList(theExsitinghPidSetToExclude);
        ourLog.trace("excludePids = " + excludePids);
        DbColumn resourceIdColumn = this.getOrCreateFirstPredicateBuilder().getResourceIdColumn();
        InCondition predicate = new InCondition((Object)resourceIdColumn, this.generatePlaceholders(excludePids));
        predicate.setNegate(true);
        this.addPredicate((Condition)predicate);
    }

    public BinaryCondition createConditionForValueWithComparator(ParamPrefixEnum theComparator, DbColumn theColumn, Object theValue) {
        switch (theComparator) {
            case LESSTHAN: {
                return BinaryCondition.lessThan((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case LESSTHAN_OR_EQUALS: {
                return BinaryCondition.lessThanOrEq((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case GREATERTHAN: {
                return BinaryCondition.greaterThan((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case GREATERTHAN_OR_EQUALS: {
                return BinaryCondition.greaterThanOrEq((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case NOT_EQUAL: {
                return BinaryCondition.notEqualTo((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
        }
        throw new IllegalArgumentException(Msg.code((int)1263));
    }

    public SearchQueryBuilder newChildSqlBuilder() {
        return new SearchQueryBuilder(this.myFhirContext, this.myModelConfig, this.myPartitionSettings, this.myRequestPartitionId, this.myResourceType, this.mySqlBuilderFactory, this.myBindVariableSubstitutionBase, this.myDialect, false, this.myBindVariableValues);
    }

    public SelectQuery getSelect() {
        return this.mySelect;
    }

    public boolean haveAtLeastOnePredicate() {
        return this.myHaveAtLeastOnePredicate;
    }

    public void addSortString(DbColumn theColumnValueNormalized, boolean theAscending) {
        OrderObject.NullOrder nullOrder = OrderObject.NullOrder.LAST;
        this.addSortString(theColumnValueNormalized, theAscending, nullOrder);
    }

    public void addSortNumeric(DbColumn theColumnValueNormalized, boolean theAscending) {
        OrderObject.NullOrder nullOrder = OrderObject.NullOrder.LAST;
        this.addSortNumeric(theColumnValueNormalized, theAscending, nullOrder);
    }

    public void addSortDate(DbColumn theColumnValueNormalized, boolean theAscending) {
        OrderObject.NullOrder nullOrder = OrderObject.NullOrder.LAST;
        this.addSortDate(theColumnValueNormalized, theAscending, nullOrder);
    }

    public void addSortString(DbColumn theTheColumnValueNormalized, boolean theTheAscending, OrderObject.NullOrder theNullOrder) {
        if (this.dialectIsMySql || this.dialectIsMsSql) {
            String direction = theTheAscending ? " ASC" : " DESC";
            String sortColumnName = theTheColumnValueNormalized.getTable().getAlias() + "." + theTheColumnValueNormalized.getName();
            StringBuilder sortColumnNameBuilder = new StringBuilder();
            sortColumnNameBuilder.append(sortColumnName).append(direction);
            this.mySelect.addCustomOrderings(new Object[]{sortColumnNameBuilder.toString()});
        } else {
            this.addSort(theTheColumnValueNormalized, theTheAscending, theNullOrder);
        }
    }

    public void addSortNumeric(DbColumn theTheColumnValueNormalized, boolean theTheAscending, OrderObject.NullOrder theNullOrder) {
        if (this.dialectIsMySql || this.dialectIsMsSql) {
            String direction;
            String sortColumnName = theTheColumnValueNormalized.getTable().getAlias() + "." + theTheColumnValueNormalized.getName();
            if (theTheAscending && theNullOrder == OrderObject.NullOrder.LAST || !theTheAscending && theNullOrder == OrderObject.NullOrder.FIRST) {
                direction = theTheAscending ? " DESC" : " ASC";
                sortColumnName = "-" + sortColumnName;
            } else {
                direction = theTheAscending ? " ASC" : " DESC";
            }
            this.mySelect.addCustomOrderings(new Object[]{sortColumnName + direction});
        } else {
            this.addSort(theTheColumnValueNormalized, theTheAscending, theNullOrder);
        }
    }

    public void addSortDate(DbColumn theTheColumnValueNormalized, boolean theTheAscending, OrderObject.NullOrder theNullOrder) {
        if (this.dialectIsMySql || this.dialectIsMsSql) {
            String direction = theTheAscending ? " ASC" : " DESC";
            String sortColumnName = theTheColumnValueNormalized.getTable().getAlias() + "." + theTheColumnValueNormalized.getName();
            StringBuilder sortColumnNameBuilder = new StringBuilder();
            sortColumnNameBuilder.append(sortColumnName).append(direction);
            this.mySelect.addCustomOrderings(new Object[]{sortColumnNameBuilder.toString()});
        } else {
            this.addSort(theTheColumnValueNormalized, theTheAscending, theNullOrder);
        }
    }

    private void addSort(DbColumn theTheColumnValueNormalized, boolean theTheAscending, OrderObject.NullOrder theNullOrder) {
        OrderObject.Dir direction = theTheAscending ? OrderObject.Dir.ASCENDING : OrderObject.Dir.DESCENDING;
        OrderObject orderObject = new OrderObject(direction, (Object)theTheColumnValueNormalized);
        orderObject.setNullOrder(theNullOrder);
        this.mySelect.addCustomOrderings(new Object[]{orderObject});
    }

    public void setNeedResourceTableRoot(boolean theNeedResourceTableRoot) {
        this.myNeedResourceTableRoot = theNeedResourceTableRoot;
    }
}

