/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.cache;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.data.ISearchDao;
import ca.uhn.fhir.jpa.dao.data.ISearchIncludeDao;
import ca.uhn.fhir.jpa.dao.data.ISearchResultDao;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchInclude;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseSearchCacheSvcImpl
implements ISearchCacheSvc {
    public static final int DEFAULT_MAX_RESULTS_TO_DELETE_IN_ONE_STMT = 500;
    public static final int DEFAULT_MAX_RESULTS_TO_DELETE_IN_ONE_PAS = 20000;
    public static final long SEARCH_CLEANUP_JOB_INTERVAL_MILLIS = 10000L;
    public static final int DEFAULT_MAX_DELETE_CANDIDATES_TO_FIND = 2000;
    private static final Logger ourLog = LoggerFactory.getLogger(DatabaseSearchCacheSvcImpl.class);
    private static int ourMaximumResultsToDeleteInOneStatement = 500;
    private static int ourMaximumResultsToDeleteInOnePass = 20000;
    private static int ourMaximumSearchesToCheckForDeletionCandidacy = 2000;
    private static Long ourNowForUnitTests;
    private long myCutoffSlack = 10000L;
    @Autowired
    private ISearchDao mySearchDao;
    @Autowired
    private ISearchResultDao mySearchResultDao;
    @Autowired
    private ISearchIncludeDao mySearchIncludeDao;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private DaoConfig myDaoConfig;

    @VisibleForTesting
    public void setCutoffSlackForUnitTest(long theCutoffSlack) {
        this.myCutoffSlack = theCutoffSlack;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public Search save(Search theSearch) {
        Search newSearch;
        if (theSearch.getId() == null) {
            newSearch = (Search)this.mySearchDao.save(theSearch);
            for (SearchInclude next : theSearch.getIncludes()) {
                this.mySearchIncludeDao.save(next);
            }
        } else {
            newSearch = (Search)this.mySearchDao.save(theSearch);
        }
        return newSearch;
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public Optional<Search> fetchByUuid(String theUuid) {
        Validate.notBlank((CharSequence)theUuid);
        return this.mySearchDao.findByUuidAndFetchIncludes(theUuid);
    }

    void setSearchDaoForUnitTest(ISearchDao theSearchDao) {
        this.mySearchDao = theSearchDao;
    }

    void setTxManagerForUnitTest(PlatformTransactionManager theTxManager) {
        this.myTxManager = theTxManager;
    }

    @Override
    @Transactional(value=Transactional.TxType.NEVER)
    public Optional<Search> tryToMarkSearchAsInProgress(Search theSearch) {
        ourLog.trace("Going to try to change search status from {} to {}", (Object)theSearch.getStatus(), (Object)SearchStatusEnum.LOADING);
        try {
            TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
            txTemplate.setPropagationBehavior(3);
            txTemplate.afterPropertiesSet();
            return (Optional)txTemplate.execute(t -> {
                Search search = this.mySearchDao.findById(theSearch.getId()).orElse(theSearch);
                if (search.getStatus() != SearchStatusEnum.PASSCMPLET) {
                    throw new IllegalStateException(Msg.code((int)1167) + "Can't change to LOADING because state is " + theSearch.getStatus());
                }
                search.setStatus(SearchStatusEnum.LOADING);
                Search newSearch = (Search)this.mySearchDao.save(search);
                return Optional.of(newSearch);
            });
        }
        catch (Exception e) {
            ourLog.warn("Failed to activate search: {}", (Object)e.toString());
            ourLog.trace("Failed to activate search", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<Search> findCandidatesForReuse(String theResourceType, String theQueryString, Instant theCreatedAfter, RequestPartitionId theRequestPartitionId) {
        String queryString = Search.createSearchQueryStringForStorage(theQueryString, theRequestPartitionId);
        int hashCode = queryString.hashCode();
        Collection<Search> candidates = this.mySearchDao.findWithCutoffOrExpiry(theResourceType, hashCode, Date.from(theCreatedAfter));
        for (Search nextCandidateSearch : candidates) {
            if (!queryString.equals(nextCandidateSearch.getSearchQueryString()) || !nextCandidateSearch.getCreated().toInstant().isAfter(theCreatedAfter)) continue;
            return Optional.of(nextCandidateSearch);
        }
        return Optional.empty();
    }

    @Override
    @Transactional(value=Transactional.TxType.NEVER)
    public void pollForStaleSearchesAndDeleteThem() {
        if (!this.myDaoConfig.isExpireSearchResults()) {
            return;
        }
        long cutoffMillis = this.myDaoConfig.getExpireSearchResultsAfterMillis();
        if (this.myDaoConfig.getReuseCachedSearchResultsForMillis() != null) {
            cutoffMillis += this.myDaoConfig.getReuseCachedSearchResultsForMillis().longValue();
        }
        Date cutoff = new Date(DatabaseSearchCacheSvcImpl.now() - cutoffMillis - this.myCutoffSlack);
        if (ourNowForUnitTests != null) {
            ourLog.info("Searching for searches which are before {} - now is {}", (Object)new InstantType(cutoff), (Object)new InstantType(new Date(DatabaseSearchCacheSvcImpl.now())));
        }
        ourLog.debug("Searching for searches which are before {}", (Object)cutoff);
        TransactionTemplate tt = new TransactionTemplate(this.myTxManager);
        Slice toMarkDeleted = (Slice)tt.execute(theStatus -> this.mySearchDao.findWhereCreatedBefore(cutoff, new Date(), (Pageable)PageRequest.of((int)0, (int)ourMaximumSearchesToCheckForDeletionCandidacy)));
        assert (toMarkDeleted != null);
        for (Object nextSearchToDelete : toMarkDeleted) {
            ourLog.debug("Deleting search with PID {}", nextSearchToDelete);
            tt.execute(arg_0 -> this.lambda$pollForStaleSearchesAndDeleteThem$2((Long)nextSearchToDelete, arg_0));
        }
        Slice toDelete = (Slice)tt.execute(theStatus -> this.mySearchDao.findDeleted((Pageable)PageRequest.of((int)0, (int)ourMaximumSearchesToCheckForDeletionCandidacy)));
        assert (toDelete != null);
        for (Long nextSearchToDelete : toDelete) {
            ourLog.debug("Deleting search with PID {}", (Object)nextSearchToDelete);
            tt.execute(t -> {
                this.deleteSearch(nextSearchToDelete);
                return null;
            });
        }
        int count = toDelete.getContent().size();
        if (count > 0 && (ourLog.isDebugEnabled() || "true".equalsIgnoreCase(System.getProperty("test")))) {
            Long total = (Long)tt.execute(t -> this.mySearchDao.count());
            ourLog.debug("Deleted {} searches, {} remaining", (Object)count, (Object)total);
        }
    }

    private void deleteSearch(Long theSearchPid) {
        this.mySearchDao.findById(theSearchPid).ifPresent(searchToDelete -> {
            this.mySearchIncludeDao.deleteForSearch(searchToDelete.getId());
            int max = ourMaximumResultsToDeleteInOnePass;
            Slice<Long> resultPids = this.mySearchResultDao.findForSearch((Pageable)PageRequest.of((int)0, (int)max), searchToDelete.getId());
            if (resultPids.hasContent()) {
                List partitions = Lists.partition((List)resultPids.getContent(), (int)ourMaximumResultsToDeleteInOneStatement);
                for (List nextPartition : partitions) {
                    this.mySearchResultDao.deleteByIds(nextPartition);
                }
            }
            if (resultPids.getNumberOfElements() < max) {
                ourLog.debug("Deleting search {}/{} - Created[{}]", new Object[]{searchToDelete.getId(), searchToDelete.getUuid(), new InstantType(searchToDelete.getCreated())});
                this.mySearchDao.deleteByPid(searchToDelete.getId());
            } else {
                ourLog.debug("Purged {} search results for deleted search {}/{}", new Object[]{resultPids.getSize(), searchToDelete.getId(), searchToDelete.getUuid()});
            }
        });
    }

    @VisibleForTesting
    public static void setMaximumSearchesToCheckForDeletionCandidacyForUnitTest(int theMaximumSearchesToCheckForDeletionCandidacy) {
        ourMaximumSearchesToCheckForDeletionCandidacy = theMaximumSearchesToCheckForDeletionCandidacy;
    }

    @VisibleForTesting
    public static void setMaximumResultsToDeleteInOnePassForUnitTest(int theMaximumResultsToDeleteInOnePass) {
        ourMaximumResultsToDeleteInOnePass = theMaximumResultsToDeleteInOnePass;
    }

    @VisibleForTesting
    public static void setMaximumResultsToDeleteForUnitTest(int theMaximumResultsToDelete) {
        ourMaximumResultsToDeleteInOneStatement = theMaximumResultsToDelete;
    }

    @VisibleForTesting
    public static void setNowForUnitTests(Long theNowForUnitTests) {
        ourNowForUnitTests = theNowForUnitTests;
    }

    private static long now() {
        if (ourNowForUnitTests != null) {
            return ourNowForUnitTests;
        }
        return System.currentTimeMillis();
    }

    private /* synthetic */ Object lambda$pollForStaleSearchesAndDeleteThem$2(Long nextSearchToDelete, TransactionStatus t) {
        this.mySearchDao.updateDeleted(nextSearchToDelete, true);
        return null;
    }
}

