/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.elastic;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IndexNamePrefixLayoutStrategy
implements IndexLayoutStrategy {
    @Autowired
    private DaoConfig myDaoConfig;
    static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final String NAME = "prefix";
    public static final Pattern UNIQUE_KEY_EXTRACTION_PATTERN = Pattern.compile("(.*)-\\d{6}");

    public String createInitialElasticsearchIndexName(String hibernateSearchIndexName) {
        return this.addPrefixIfNecessary(hibernateSearchIndexName + "-000001");
    }

    public String createWriteAlias(String hibernateSearchIndexName) {
        return this.addPrefixIfNecessary(hibernateSearchIndexName + "-write");
    }

    public String createReadAlias(String hibernateSearchIndexName) {
        return this.addPrefixIfNecessary(hibernateSearchIndexName + "-read");
    }

    private String addPrefixIfNecessary(String theCandidateName) {
        this.validateDaoConfigIsPresent();
        if (!StringUtils.isBlank((CharSequence)this.myDaoConfig.getHSearchIndexPrefix())) {
            return this.myDaoConfig.getHSearchIndexPrefix() + "-" + theCandidateName;
        }
        return theCandidateName;
    }

    public String extractUniqueKeyFromHibernateSearchIndexName(String hibernateSearchIndexName) {
        return hibernateSearchIndexName;
    }

    public String extractUniqueKeyFromElasticsearchIndexName(String elasticsearchIndexName) {
        Matcher matcher = UNIQUE_KEY_EXTRACTION_PATTERN.matcher(elasticsearchIndexName);
        if (!matcher.matches()) {
            throw log.invalidIndexPrimaryName(elasticsearchIndexName, UNIQUE_KEY_EXTRACTION_PATTERN);
        }
        String candidateUniqueKey = matcher.group(1);
        return this.removePrefixIfNecessary(candidateUniqueKey);
    }

    private String removePrefixIfNecessary(String theCandidateUniqueKey) {
        this.validateDaoConfigIsPresent();
        if (!StringUtils.isBlank((CharSequence)this.myDaoConfig.getHSearchIndexPrefix())) {
            return theCandidateUniqueKey.replace(this.myDaoConfig.getHSearchIndexPrefix() + "-", "");
        }
        return theCandidateUniqueKey;
    }

    private void validateDaoConfigIsPresent() {
        if (this.myDaoConfig == null) {
            throw new ConfigurationException(Msg.code((int)1168) + "While attempting to boot HAPI FHIR, the Hibernate Search bootstrapper failed to find the DaoConfig. This probably means Hibernate Search has been recently upgraded, or somebody modified HapiFhirLocalContainerEntityManagerFactoryBean.");
        }
    }
}

