/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.lastn;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchRestClientFactory {
    public static RestHighLevelClient createElasticsearchHighLevelRestClient(String protocol, String hosts, @Nullable String theUsername, @Nullable String thePassword) {
        List<Node> clientNodes;
        if (hosts.contains("://")) {
            throw new ConfigurationException(Msg.code((int)1173) + "Elasticsearch URLs cannot include a protocol, that is a separate property. Remove http:// or https:// from this URL.");
        }
        String[] hostArray = hosts.split(",");
        if (hostArray.length != (clientNodes = Arrays.stream(hostArray).map(String::trim).filter(s -> s.contains(":")).map(h -> {
            int colonIndex = h.indexOf(":");
            String host = h.substring(0, colonIndex);
            int port = Integer.parseInt(h.substring(colonIndex + 1));
            return new Node(new HttpHost(host, port, protocol));
        }).collect(Collectors.toList())).size()) {
            throw new ConfigurationException(Msg.code((int)1174) + "Elasticsearch URLs have to contain ':' as a host:port separator. Example: localhost:9200,localhost:9201,localhost:9202");
        }
        RestClientBuilder clientBuilder = RestClient.builder((Node[])clientNodes.toArray(new Node[0]));
        if (StringUtils.isNotBlank((CharSequence)theUsername) && StringUtils.isNotBlank((CharSequence)thePassword)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(theUsername, thePassword));
            clientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchRestClientFactory.lambda$createElasticsearchHighLevelRestClient$2((CredentialsProvider)credentialsProvider, arg_0));
        }
        Header[] defaultHeaders = new Header[]{new BasicHeader("Content-Type", "application/json")};
        clientBuilder.setDefaultHeaders(defaultHeaders);
        return new RestHighLevelClient(clientBuilder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticsearchHighLevelRestClient$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

