/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.lastn;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.TolerantJsonParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.util.CodeSystemHash;
import ca.uhn.fhir.jpa.search.lastn.ElasticsearchRestClientFactory;
import ca.uhn.fhir.jpa.search.lastn.IElasticsearchSvc;
import ca.uhn.fhir.jpa.search.lastn.json.CodeJson;
import ca.uhn.fhir.jpa.search.lastn.json.ObservationJson;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.LastNParameterHelper;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedTopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticsearchSvcImpl
implements IElasticsearchSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(ElasticsearchSvcImpl.class);
    public static final String OBSERVATION_INDEX = "observation_index";
    public static final String OBSERVATION_CODE_INDEX = "code_index";
    public static final String OBSERVATION_DOCUMENT_TYPE = "ca.uhn.fhir.jpa.model.entity.ObservationIndexedSearchParamLastNEntity";
    public static final String CODE_DOCUMENT_TYPE = "ca.uhn.fhir.jpa.model.entity.ObservationIndexedCodeCodeableConceptEntity";
    public static final String OBSERVATION_INDEX_SCHEMA_FILE = "ObservationIndexSchema.json";
    public static final String OBSERVATION_CODE_INDEX_SCHEMA_FILE = "ObservationCodeIndexSchema.json";
    private static final String GROUP_BY_SUBJECT = "group_by_subject";
    private static final String GROUP_BY_SYSTEM = "group_by_system";
    private static final String GROUP_BY_CODE = "group_by_code";
    private static final String MOST_RECENT_EFFECTIVE = "most_recent_effective";
    private static final String OBSERVATION_IDENTIFIER_FIELD_NAME = "identifier";
    private static final String OBSERVATION_SUBJECT_FIELD_NAME = "subject";
    private static final String OBSERVATION_CODEVALUE_FIELD_NAME = "codeconceptcodingcode";
    private static final String OBSERVATION_CODESYSTEM_FIELD_NAME = "codeconceptcodingsystem";
    private static final String OBSERVATION_CODEHASH_FIELD_NAME = "codeconceptcodingcode_system_hash";
    private static final String OBSERVATION_CODEDISPLAY_FIELD_NAME = "codeconceptcodingdisplay";
    private static final String OBSERVATION_CODE_TEXT_FIELD_NAME = "codeconcepttext";
    private static final String OBSERVATION_EFFECTIVEDTM_FIELD_NAME = "effectivedtm";
    private static final String OBSERVATION_CATEGORYHASH_FIELD_NAME = "categoryconceptcodingcode_system_hash";
    private static final String OBSERVATION_CATEGORYVALUE_FIELD_NAME = "categoryconceptcodingcode";
    private static final String OBSERVATION_CATEGORYSYSTEM_FIELD_NAME = "categoryconceptcodingsystem";
    private static final String OBSERVATION_CATEGORYDISPLAY_FIELD_NAME = "categoryconceptcodingdisplay";
    private static final String OBSERVATION_CATEGORYTEXT_FIELD_NAME = "categoryconcepttext";
    private static final String CODE_HASH = "codingcode_system_hash";
    private static final String CODE_TEXT = "text";
    private static final String OBSERVATION_RESOURCE_NAME = "Observation";
    private final RestHighLevelClient myRestHighLevelClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private FhirContext myContext;

    public ElasticsearchSvcImpl(PartitionSettings thePartitionSetings, String theProtocol, String theHostname, @Nullable String theUsername, @Nullable String thePassword) {
        this(theProtocol, theHostname, theUsername, thePassword);
        this.myPartitionSettings = thePartitionSetings;
    }

    public ElasticsearchSvcImpl(String theProtocol, String theHostname, @Nullable String theUsername, @Nullable String thePassword) {
        this.myRestHighLevelClient = ElasticsearchRestClientFactory.createElasticsearchHighLevelRestClient(theProtocol, theHostname, theUsername, thePassword);
        try {
            this.createObservationIndexIfMissing();
            this.createObservationCodeIndexIfMissing();
        }
        catch (IOException theE) {
            throw new RuntimeException(Msg.code((int)1175) + "Failed to create document index", theE);
        }
    }

    private String getIndexSchema(String theSchemaFileName) throws IOException {
        String str;
        InputStreamReader input = new InputStreamReader(ElasticsearchSvcImpl.class.getResourceAsStream(theSchemaFileName));
        BufferedReader reader = new BufferedReader(input);
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    private void createObservationIndexIfMissing() throws IOException {
        if (this.indexExists(OBSERVATION_INDEX)) {
            return;
        }
        String observationMapping = this.getIndexSchema(OBSERVATION_INDEX_SCHEMA_FILE);
        if (!this.createIndex(OBSERVATION_INDEX, observationMapping)) {
            throw new RuntimeException(Msg.code((int)1176) + "Failed to create observation index");
        }
    }

    private void createObservationCodeIndexIfMissing() throws IOException {
        if (this.indexExists(OBSERVATION_CODE_INDEX)) {
            return;
        }
        String observationCodeMapping = this.getIndexSchema(OBSERVATION_CODE_INDEX_SCHEMA_FILE);
        if (!this.createIndex(OBSERVATION_CODE_INDEX, observationCodeMapping)) {
            throw new RuntimeException(Msg.code((int)1177) + "Failed to create observation code index");
        }
    }

    private boolean createIndex(String theIndexName, String theMapping) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(theIndexName);
        request.source(theMapping, XContentType.JSON);
        CreateIndexResponse createIndexResponse = this.myRestHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
        return createIndexResponse.isAcknowledged();
    }

    private boolean indexExists(String theIndexName) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{theIndexName});
        return this.myRestHighLevelClient.indices().exists(request, RequestOptions.DEFAULT);
    }

    @Override
    public List<String> executeLastN(SearchParameterMap theSearchParameterMap, FhirContext theFhirContext, Integer theMaxResultsToFetch) {
        Validate.isTrue((!this.myPartitionSettings.isPartitioningEnabled() ? 1 : 0) != 0, (String)"$lastn is not currently supported on partitioned servers", (Object[])new Object[0]);
        String[] topHitsInclude = new String[]{OBSERVATION_IDENTIFIER_FIELD_NAME};
        return this.buildAndExecuteSearch(theSearchParameterMap, theFhirContext, topHitsInclude, ObservationJson::getIdentifier, theMaxResultsToFetch);
    }

    private <T> List<T> buildAndExecuteSearch(SearchParameterMap theSearchParameterMap, FhirContext theFhirContext, String[] topHitsInclude, Function<ObservationJson, T> setValue, Integer theMaxResultsToFetch) {
        String patientParamName = LastNParameterHelper.getPatientParamName((FhirContext)theFhirContext);
        String subjectParamName = LastNParameterHelper.getSubjectParamName((FhirContext)theFhirContext);
        ArrayList<T> searchResults = new ArrayList<T>();
        if (theSearchParameterMap.containsKey(patientParamName) || theSearchParameterMap.containsKey(subjectParamName)) {
            for (String subject : this.getSubjectReferenceCriteria(patientParamName, subjectParamName, theSearchParameterMap)) {
                if (theMaxResultsToFetch == null || searchResults.size() < theMaxResultsToFetch) {
                    SearchRequest myLastNRequest = this.buildObservationsSearchRequest(subject, theSearchParameterMap, theFhirContext, (AggregationBuilder)this.createObservationSubjectAggregationBuilder(this.getMaxParameter(theSearchParameterMap), topHitsInclude));
                    ourLog.debug("ElasticSearch query: {}", (Object)myLastNRequest.source().toString());
                    try {
                        SearchResponse lastnResponse = this.executeSearchRequest(myLastNRequest);
                        searchResults.addAll(this.buildObservationList(lastnResponse, setValue, theSearchParameterMap, theFhirContext, theMaxResultsToFetch));
                        continue;
                    }
                    catch (IOException theE) {
                        throw new InvalidRequestException(Msg.code((int)1178) + "Unable to execute LastN request", (Throwable)theE);
                    }
                }
                break;
            }
        } else {
            SearchRequest myLastNRequest = this.buildObservationsSearchRequest(theSearchParameterMap, theFhirContext, (AggregationBuilder)this.createObservationCodeAggregationBuilder(this.getMaxParameter(theSearchParameterMap), topHitsInclude));
            ourLog.debug("ElasticSearch query: {}", (Object)myLastNRequest.source().toString());
            try {
                SearchResponse lastnResponse = this.executeSearchRequest(myLastNRequest);
                searchResults.addAll(this.buildObservationList(lastnResponse, setValue, theSearchParameterMap, theFhirContext, theMaxResultsToFetch));
            }
            catch (IOException theE) {
                throw new InvalidRequestException(Msg.code((int)1179) + "Unable to execute LastN request", (Throwable)theE);
            }
        }
        return searchResults;
    }

    private int getMaxParameter(SearchParameterMap theSearchParameterMap) {
        if (theSearchParameterMap.getLastNMax() == null) {
            return 1;
        }
        return theSearchParameterMap.getLastNMax();
    }

    private List<String> getSubjectReferenceCriteria(String thePatientParamName, String theSubjectParamName, SearchParameterMap theSearchParameterMap) {
        ArrayList<String> subjectReferenceCriteria = new ArrayList<String>();
        ArrayList patientParams = new ArrayList();
        if (theSearchParameterMap.get(thePatientParamName) != null) {
            patientParams.addAll(theSearchParameterMap.get(thePatientParamName));
        }
        if (theSearchParameterMap.get(theSubjectParamName) != null) {
            patientParams.addAll(theSearchParameterMap.get(theSubjectParamName));
        }
        for (List nextSubjectList : patientParams) {
            subjectReferenceCriteria.addAll(this.getReferenceValues(nextSubjectList));
        }
        return subjectReferenceCriteria;
    }

    private List<String> getReferenceValues(List<? extends IQueryParameterType> referenceParams) {
        ArrayList<String> referenceList = new ArrayList<String>();
        for (IQueryParameterType iQueryParameterType : referenceParams) {
            if (iQueryParameterType instanceof ReferenceParam) {
                ReferenceParam ref = (ReferenceParam)iQueryParameterType;
                if (!StringUtils.isBlank((CharSequence)ref.getChain())) continue;
                referenceList.add(ref.getValue());
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1180) + "Invalid token type (expecting ReferenceParam): " + iQueryParameterType.getClass());
        }
        return referenceList;
    }

    private CompositeAggregationBuilder createObservationSubjectAggregationBuilder(Integer theMaxNumberObservationsPerCode, String[] theTopHitsInclude) {
        CompositeValuesSourceBuilder subjectValuesBuilder = new TermsValuesSourceBuilder(OBSERVATION_SUBJECT_FIELD_NAME).field(OBSERVATION_SUBJECT_FIELD_NAME);
        ArrayList<CompositeValuesSourceBuilder> compositeAggSubjectSources = new ArrayList<CompositeValuesSourceBuilder>();
        compositeAggSubjectSources.add(subjectValuesBuilder);
        CompositeAggregationBuilder compositeAggregationSubjectBuilder = new CompositeAggregationBuilder(GROUP_BY_SUBJECT, compositeAggSubjectSources);
        compositeAggregationSubjectBuilder.subAggregation((AggregationBuilder)this.createObservationCodeAggregationBuilder(theMaxNumberObservationsPerCode, theTopHitsInclude));
        compositeAggregationSubjectBuilder.size(10000);
        return compositeAggregationSubjectBuilder;
    }

    private TermsAggregationBuilder createObservationCodeAggregationBuilder(int theMaxNumberObservationsPerCode, String[] theTopHitsInclude) {
        TermsAggregationBuilder observationCodeCodeAggregationBuilder = (TermsAggregationBuilder)new TermsAggregationBuilder(GROUP_BY_CODE).field(OBSERVATION_CODEVALUE_FIELD_NAME);
        observationCodeCodeAggregationBuilder.order(BucketOrder.key((boolean)true));
        observationCodeCodeAggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)MOST_RECENT_EFFECTIVE).sort(OBSERVATION_EFFECTIVEDTM_FIELD_NAME, SortOrder.DESC).fetchSource(theTopHitsInclude, null).size(theMaxNumberObservationsPerCode));
        observationCodeCodeAggregationBuilder.size(10000);
        TermsAggregationBuilder observationCodeSystemAggregationBuilder = (TermsAggregationBuilder)new TermsAggregationBuilder(GROUP_BY_SYSTEM).field(OBSERVATION_CODESYSTEM_FIELD_NAME);
        observationCodeSystemAggregationBuilder.order(BucketOrder.key((boolean)true));
        observationCodeSystemAggregationBuilder.subAggregation((AggregationBuilder)observationCodeCodeAggregationBuilder);
        return observationCodeSystemAggregationBuilder;
    }

    private SearchResponse executeSearchRequest(SearchRequest searchRequest) throws IOException {
        return this.myRestHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
    }

    private <T> List<T> buildObservationList(SearchResponse theSearchResponse, Function<ObservationJson, T> setValue, SearchParameterMap theSearchParameterMap, FhirContext theFhirContext, Integer theMaxResultsToFetch) throws IOException {
        ArrayList<ObservationJson> theObservationList = new ArrayList<ObservationJson>();
        if (theSearchParameterMap.containsKey(LastNParameterHelper.getPatientParamName((FhirContext)theFhirContext)) || theSearchParameterMap.containsKey(LastNParameterHelper.getSubjectParamName((FhirContext)theFhirContext))) {
            block0: for (ParsedComposite.ParsedBucket parsedBucket : this.getSubjectBuckets(theSearchResponse)) {
                if (theMaxResultsToFetch == null || theObservationList.size() < theMaxResultsToFetch) {
                    block1: for (Terms.Bucket bucket : this.getObservationCodeBuckets(parsedBucket)) {
                        if (theMaxResultsToFetch != null && theObservationList.size() >= theMaxResultsToFetch) continue block0;
                        for (SearchHit lastNMatch : this.getLastNMatches(bucket)) {
                            if (theMaxResultsToFetch != null && theObservationList.size() >= theMaxResultsToFetch) continue block1;
                            String indexedObservation = lastNMatch.getSourceAsString();
                            ObservationJson observationJson = (ObservationJson)this.objectMapper.readValue(indexedObservation, ObservationJson.class);
                            theObservationList.add(setValue.apply(observationJson));
                        }
                    }
                    continue;
                }
                break;
            }
        } else {
            block3: for (Terms.Bucket bucket : this.getObservationCodeBuckets(theSearchResponse)) {
                if (theMaxResultsToFetch == null || theObservationList.size() < theMaxResultsToFetch) {
                    for (SearchHit lastNMatch : this.getLastNMatches(bucket)) {
                        if (theMaxResultsToFetch != null && theObservationList.size() >= theMaxResultsToFetch) continue block3;
                        String indexedObservation = lastNMatch.getSourceAsString();
                        ObservationJson observationJson = (ObservationJson)this.objectMapper.readValue(indexedObservation, ObservationJson.class);
                        theObservationList.add(setValue.apply(observationJson));
                    }
                    continue;
                }
                break;
            }
        }
        return theObservationList;
    }

    private List<ParsedComposite.ParsedBucket> getSubjectBuckets(SearchResponse theSearchResponse) {
        Aggregations responseAggregations = theSearchResponse.getAggregations();
        ParsedComposite aggregatedSubjects = (ParsedComposite)responseAggregations.get(GROUP_BY_SUBJECT);
        return aggregatedSubjects.getBuckets();
    }

    private List<? extends Terms.Bucket> getObservationCodeBuckets(SearchResponse theSearchResponse) {
        Aggregations responseAggregations = theSearchResponse.getAggregations();
        return this.getObservationCodeBuckets(responseAggregations);
    }

    private List<? extends Terms.Bucket> getObservationCodeBuckets(ParsedComposite.ParsedBucket theSubjectBucket) {
        Aggregations observationCodeSystemAggregations = theSubjectBucket.getAggregations();
        return this.getObservationCodeBuckets(observationCodeSystemAggregations);
    }

    private List<? extends Terms.Bucket> getObservationCodeBuckets(Aggregations theObservationCodeSystemAggregations) {
        ArrayList retVal = new ArrayList();
        ParsedTerms aggregatedObservationCodeSystems = (ParsedTerms)theObservationCodeSystemAggregations.get(GROUP_BY_SYSTEM);
        for (Terms.Bucket observationCodeSystem : aggregatedObservationCodeSystems.getBuckets()) {
            Aggregations observationCodeCodeAggregations = observationCodeSystem.getAggregations();
            ParsedTerms aggregatedObservationCodeCodes = (ParsedTerms)observationCodeCodeAggregations.get(GROUP_BY_CODE);
            retVal.addAll(aggregatedObservationCodeCodes.getBuckets());
        }
        return retVal;
    }

    private SearchHit[] getLastNMatches(Terms.Bucket theObservationCodeBucket) {
        Aggregations topHitObservationCodes = theObservationCodeBucket.getAggregations();
        ParsedTopHits parsedTopHits = (ParsedTopHits)topHitObservationCodes.get(MOST_RECENT_EFFECTIVE);
        return parsedTopHits.getHits().getHits();
    }

    private SearchRequest buildObservationsSearchRequest(SearchParameterMap theSearchParameterMap, FhirContext theFhirContext, AggregationBuilder theAggregationBuilder) {
        SearchRequest searchRequest = new SearchRequest(new String[]{OBSERVATION_INDEX});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (!this.searchParamsHaveLastNCriteria(theSearchParameterMap, theFhirContext).booleanValue()) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            this.addCategoriesCriteria(boolQueryBuilder, theSearchParameterMap, theFhirContext);
            this.addObservationCodeCriteria(boolQueryBuilder, theSearchParameterMap, theFhirContext);
            this.addDateCriteria(boolQueryBuilder, theSearchParameterMap, theFhirContext);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        }
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation(theAggregationBuilder);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private SearchRequest buildObservationsSearchRequest(String theSubjectParam, SearchParameterMap theSearchParameterMap, FhirContext theFhirContext, AggregationBuilder theAggregationBuilder) {
        SearchRequest searchRequest = new SearchRequest(new String[]{OBSERVATION_INDEX});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)OBSERVATION_SUBJECT_FIELD_NAME, (String)theSubjectParam));
        this.addCategoriesCriteria(boolQueryBuilder, theSearchParameterMap, theFhirContext);
        this.addObservationCodeCriteria(boolQueryBuilder, theSearchParameterMap, theFhirContext);
        this.addDateCriteria(boolQueryBuilder, theSearchParameterMap, theFhirContext);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.size(0);
        searchSourceBuilder.aggregation(theAggregationBuilder);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private Boolean searchParamsHaveLastNCriteria(SearchParameterMap theSearchParameterMap, FhirContext theFhirContext) {
        return theSearchParameterMap != null && (theSearchParameterMap.containsKey(LastNParameterHelper.getPatientParamName((FhirContext)theFhirContext)) || theSearchParameterMap.containsKey(LastNParameterHelper.getSubjectParamName((FhirContext)theFhirContext)) || theSearchParameterMap.containsKey(LastNParameterHelper.getCategoryParamName((FhirContext)theFhirContext)) || theSearchParameterMap.containsKey(LastNParameterHelper.getCodeParamName((FhirContext)theFhirContext)));
    }

    private void addCategoriesCriteria(BoolQueryBuilder theBoolQueryBuilder, SearchParameterMap theSearchParameterMap, FhirContext theFhirContext) {
        String categoryParamName = LastNParameterHelper.getCategoryParamName((FhirContext)theFhirContext);
        if (theSearchParameterMap.containsKey(categoryParamName)) {
            ArrayList<String> codeSystemHashList = new ArrayList<String>();
            ArrayList<String> codeOnlyList = new ArrayList<String>();
            ArrayList<String> systemOnlyList = new ArrayList<String>();
            ArrayList<String> textOnlyList = new ArrayList<String>();
            List andOrParams = theSearchParameterMap.get(categoryParamName);
            for (List nextAnd : andOrParams) {
                codeSystemHashList.addAll(this.getCodingCodeSystemValues(nextAnd));
                codeOnlyList.addAll(this.getCodingCodeOnlyValues(nextAnd));
                systemOnlyList.addAll(this.getCodingSystemOnlyValues(nextAnd));
                textOnlyList.addAll(this.getCodingTextOnlyValues(nextAnd));
            }
            if (codeSystemHashList.size() > 0) {
                theBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)OBSERVATION_CATEGORYHASH_FIELD_NAME, codeSystemHashList));
            }
            if (codeOnlyList.size() > 0) {
                theBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)OBSERVATION_CATEGORYVALUE_FIELD_NAME, codeOnlyList));
            }
            if (systemOnlyList.size() > 0) {
                theBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)OBSERVATION_CATEGORYSYSTEM_FIELD_NAME, systemOnlyList));
            }
            if (textOnlyList.size() > 0) {
                BoolQueryBuilder myTextBoolQueryBuilder = QueryBuilders.boolQuery();
                for (String textOnlyParam : textOnlyList) {
                    myTextBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)OBSERVATION_CATEGORYDISPLAY_FIELD_NAME, (Object)textOnlyParam));
                    myTextBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)OBSERVATION_CATEGORYTEXT_FIELD_NAME, (Object)textOnlyParam));
                }
                theBoolQueryBuilder.must((QueryBuilder)myTextBoolQueryBuilder);
            }
        }
    }

    private List<String> getCodingCodeSystemValues(List<? extends IQueryParameterType> codeParams) {
        ArrayList<String> codeSystemHashList = new ArrayList<String>();
        for (IQueryParameterType iQueryParameterType : codeParams) {
            if (iQueryParameterType instanceof TokenParam) {
                TokenParam ref = (TokenParam)iQueryParameterType;
                if (ref.getSystem() == null || ref.getValue() == null) continue;
                codeSystemHashList.add(String.valueOf(CodeSystemHash.hashCodeSystem((String)ref.getSystem(), (String)ref.getValue())));
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1181) + "Invalid token type (expecting TokenParam): " + iQueryParameterType.getClass());
        }
        return codeSystemHashList;
    }

    private List<String> getCodingCodeOnlyValues(List<? extends IQueryParameterType> codeParams) {
        ArrayList<String> codeOnlyList = new ArrayList<String>();
        for (IQueryParameterType iQueryParameterType : codeParams) {
            if (iQueryParameterType instanceof TokenParam) {
                TokenParam ref = (TokenParam)iQueryParameterType;
                if (ref.getValue() == null || ref.getSystem() != null || ref.isText()) continue;
                codeOnlyList.add(ref.getValue());
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1182) + "Invalid token type (expecting TokenParam): " + iQueryParameterType.getClass());
        }
        return codeOnlyList;
    }

    private List<String> getCodingSystemOnlyValues(List<? extends IQueryParameterType> codeParams) {
        ArrayList<String> systemOnlyList = new ArrayList<String>();
        for (IQueryParameterType iQueryParameterType : codeParams) {
            if (iQueryParameterType instanceof TokenParam) {
                TokenParam ref = (TokenParam)iQueryParameterType;
                if (ref.getValue() != null || ref.getSystem() == null) continue;
                systemOnlyList.add(ref.getSystem());
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1183) + "Invalid token type (expecting TokenParam): " + iQueryParameterType.getClass());
        }
        return systemOnlyList;
    }

    private List<String> getCodingTextOnlyValues(List<? extends IQueryParameterType> codeParams) {
        ArrayList<String> textOnlyList = new ArrayList<String>();
        for (IQueryParameterType iQueryParameterType : codeParams) {
            if (iQueryParameterType instanceof TokenParam) {
                TokenParam ref = (TokenParam)iQueryParameterType;
                if (!ref.isText() || ref.getValue() == null) continue;
                textOnlyList.add(ref.getValue());
                continue;
            }
            throw new IllegalArgumentException(Msg.code((int)1184) + "Invalid token type (expecting TokenParam): " + iQueryParameterType.getClass());
        }
        return textOnlyList;
    }

    private void addObservationCodeCriteria(BoolQueryBuilder theBoolQueryBuilder, SearchParameterMap theSearchParameterMap, FhirContext theFhirContext) {
        String codeParamName = LastNParameterHelper.getCodeParamName((FhirContext)theFhirContext);
        if (theSearchParameterMap.containsKey(codeParamName)) {
            ArrayList<String> codeSystemHashList = new ArrayList<String>();
            ArrayList<String> codeOnlyList = new ArrayList<String>();
            ArrayList<String> systemOnlyList = new ArrayList<String>();
            ArrayList<String> textOnlyList = new ArrayList<String>();
            List andOrParams = theSearchParameterMap.get(codeParamName);
            for (List nextAnd : andOrParams) {
                codeSystemHashList.addAll(this.getCodingCodeSystemValues(nextAnd));
                codeOnlyList.addAll(this.getCodingCodeOnlyValues(nextAnd));
                systemOnlyList.addAll(this.getCodingSystemOnlyValues(nextAnd));
                textOnlyList.addAll(this.getCodingTextOnlyValues(nextAnd));
            }
            if (codeSystemHashList.size() > 0) {
                theBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)OBSERVATION_CODEHASH_FIELD_NAME, codeSystemHashList));
            }
            if (codeOnlyList.size() > 0) {
                theBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)OBSERVATION_CODEVALUE_FIELD_NAME, codeOnlyList));
            }
            if (systemOnlyList.size() > 0) {
                theBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)OBSERVATION_CODESYSTEM_FIELD_NAME, systemOnlyList));
            }
            if (textOnlyList.size() > 0) {
                BoolQueryBuilder myTextBoolQueryBuilder = QueryBuilders.boolQuery();
                for (String textOnlyParam : textOnlyList) {
                    myTextBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)OBSERVATION_CODEDISPLAY_FIELD_NAME, (Object)textOnlyParam));
                    myTextBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)OBSERVATION_CODE_TEXT_FIELD_NAME, (Object)textOnlyParam));
                }
                theBoolQueryBuilder.must((QueryBuilder)myTextBoolQueryBuilder);
            }
        }
    }

    private void addDateCriteria(BoolQueryBuilder theBoolQueryBuilder, SearchParameterMap theSearchParameterMap, FhirContext theFhirContext) {
        String dateParamName = LastNParameterHelper.getEffectiveParamName((FhirContext)theFhirContext);
        if (theSearchParameterMap.containsKey(dateParamName)) {
            List andOrParams = theSearchParameterMap.get(dateParamName);
            for (List nextAnd : andOrParams) {
                BoolQueryBuilder myDateBoolQueryBuilder = new BoolQueryBuilder();
                for (IQueryParameterType nextOr : nextAnd) {
                    if (!(nextOr instanceof DateParam)) continue;
                    DateParam myDate = (DateParam)nextOr;
                    this.createDateCriteria(myDate, myDateBoolQueryBuilder);
                }
                theBoolQueryBuilder.must((QueryBuilder)myDateBoolQueryBuilder);
            }
        }
    }

    private void createDateCriteria(DateParam theDate, BoolQueryBuilder theBoolQueryBuilder) {
        Long dateInstant = theDate.getValue().getTime();
        RangeQueryBuilder myRangeQueryBuilder = new RangeQueryBuilder(OBSERVATION_EFFECTIVEDTM_FIELD_NAME);
        ParamPrefixEnum prefix = theDate.getPrefix();
        if (prefix == ParamPrefixEnum.GREATERTHAN || prefix == ParamPrefixEnum.STARTS_AFTER) {
            theBoolQueryBuilder.should((QueryBuilder)myRangeQueryBuilder.gt((Object)dateInstant));
        } else if (prefix == ParamPrefixEnum.LESSTHAN || prefix == ParamPrefixEnum.ENDS_BEFORE) {
            theBoolQueryBuilder.should((QueryBuilder)myRangeQueryBuilder.lt((Object)dateInstant));
        } else if (prefix == ParamPrefixEnum.LESSTHAN_OR_EQUALS) {
            theBoolQueryBuilder.should((QueryBuilder)myRangeQueryBuilder.lte((Object)dateInstant));
        } else if (prefix == ParamPrefixEnum.GREATERTHAN_OR_EQUALS) {
            theBoolQueryBuilder.should((QueryBuilder)myRangeQueryBuilder.gte((Object)dateInstant));
        } else {
            theBoolQueryBuilder.should((QueryBuilder)new MatchQueryBuilder(OBSERVATION_EFFECTIVEDTM_FIELD_NAME, (Object)dateInstant));
        }
    }

    @VisibleForTesting
    public List<ObservationJson> executeLastNWithAllFieldsForTest(SearchParameterMap theSearchParameterMap, FhirContext theFhirContext) {
        return this.buildAndExecuteSearch(theSearchParameterMap, theFhirContext, null, t -> t, 100);
    }

    @VisibleForTesting
    List<CodeJson> queryAllIndexedObservationCodesForTest() throws IOException {
        SearchRequest codeSearchRequest = new SearchRequest(new String[]{OBSERVATION_CODE_INDEX});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        searchSourceBuilder.size(1000);
        codeSearchRequest.source(searchSourceBuilder);
        SearchResponse codeSearchResponse = this.executeSearchRequest(codeSearchRequest);
        return this.buildCodeResult(codeSearchResponse);
    }

    private List<CodeJson> buildCodeResult(SearchResponse theSearchResponse) throws JsonProcessingException {
        SearchHits codeHits = theSearchResponse.getHits();
        ArrayList<CodeJson> codes = new ArrayList<CodeJson>();
        for (SearchHit codeHit : codeHits) {
            CodeJson code = (CodeJson)this.objectMapper.readValue(codeHit.getSourceAsString(), CodeJson.class);
            codes.add(code);
        }
        return codes;
    }

    @Override
    public ObservationJson getObservationDocument(String theDocumentID) {
        if (theDocumentID == null) {
            throw new InvalidRequestException(Msg.code((int)1185) + "Require non-null document ID for observation document query");
        }
        SearchRequest theSearchRequest = this.buildSingleObservationSearchRequest(theDocumentID);
        ObservationJson observationDocumentJson = null;
        try {
            SearchResponse observationDocumentResponse = this.executeSearchRequest(theSearchRequest);
            SearchHit[] observationDocumentHits = observationDocumentResponse.getHits().getHits();
            if (observationDocumentHits.length > 0) {
                String observationDocument = observationDocumentHits[0].getSourceAsString();
                observationDocumentJson = (ObservationJson)this.objectMapper.readValue(observationDocument, ObservationJson.class);
            }
        }
        catch (IOException theE) {
            throw new InvalidRequestException(Msg.code((int)1186) + "Unable to execute observation document query for ID " + theDocumentID, (Throwable)theE);
        }
        return observationDocumentJson;
    }

    private SearchRequest buildSingleObservationSearchRequest(String theObservationIdentifier) {
        SearchRequest searchRequest = new SearchRequest(new String[]{OBSERVATION_INDEX});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)OBSERVATION_IDENTIFIER_FIELD_NAME, (String)theObservationIdentifier));
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.size(1);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    @Override
    public CodeJson getObservationCodeDocument(String theCodeSystemHash, String theText) {
        if (theCodeSystemHash == null && theText == null) {
            throw new InvalidRequestException(Msg.code((int)1187) + "Require a non-null code system hash value or display value for observation code document query");
        }
        SearchRequest theSearchRequest = this.buildSingleObservationCodeSearchRequest(theCodeSystemHash, theText);
        CodeJson observationCodeDocumentJson = null;
        try {
            SearchResponse observationCodeDocumentResponse = this.executeSearchRequest(theSearchRequest);
            SearchHit[] observationCodeDocumentHits = observationCodeDocumentResponse.getHits().getHits();
            if (observationCodeDocumentHits.length > 0) {
                String observationCodeDocument = observationCodeDocumentHits[0].getSourceAsString();
                observationCodeDocumentJson = (CodeJson)this.objectMapper.readValue(observationCodeDocument, CodeJson.class);
            }
        }
        catch (IOException theE) {
            throw new InvalidRequestException(Msg.code((int)1188) + "Unable to execute observation code document query hash code or display", (Throwable)theE);
        }
        return observationCodeDocumentJson;
    }

    private SearchRequest buildSingleObservationCodeSearchRequest(String theCodeSystemHash, String theText) {
        SearchRequest searchRequest = new SearchRequest(new String[]{OBSERVATION_CODE_INDEX});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (theCodeSystemHash != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)CODE_HASH, (String)theCodeSystemHash));
        } else {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)CODE_TEXT, (Object)theText));
        }
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.size(1);
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    @Override
    public Boolean createOrUpdateObservationIndex(String theDocumentId, ObservationJson theObservationDocument) {
        try {
            String documentToIndex = this.objectMapper.writeValueAsString((Object)theObservationDocument);
            return this.performIndex(OBSERVATION_INDEX, theDocumentId, documentToIndex, OBSERVATION_DOCUMENT_TYPE);
        }
        catch (IOException theE) {
            throw new InvalidRequestException(Msg.code((int)1189) + "Unable to persist Observation document " + theDocumentId);
        }
    }

    @Override
    public Boolean createOrUpdateObservationCodeIndex(String theCodeableConceptID, CodeJson theObservationCodeDocument) {
        try {
            String documentToIndex = this.objectMapper.writeValueAsString((Object)theObservationCodeDocument);
            return this.performIndex(OBSERVATION_CODE_INDEX, theCodeableConceptID, documentToIndex, CODE_DOCUMENT_TYPE);
        }
        catch (IOException theE) {
            throw new InvalidRequestException(Msg.code((int)1190) + "Unable to persist Observation Code document " + theCodeableConceptID);
        }
    }

    private boolean performIndex(String theIndexName, String theDocumentId, String theIndexDocument, String theDocumentType) throws IOException {
        IndexResponse indexResponse = this.myRestHighLevelClient.index(this.createIndexRequest(theIndexName, theDocumentId, theIndexDocument, theDocumentType), RequestOptions.DEFAULT);
        return indexResponse.getResult() == DocWriteResponse.Result.CREATED || indexResponse.getResult() == DocWriteResponse.Result.UPDATED;
    }

    @Override
    public void close() throws IOException {
        this.myRestHighLevelClient.close();
    }

    @Override
    public List<IBaseResource> getObservationResources(Collection<ResourcePersistentId> thePids) {
        SearchRequest searchRequest = this.buildObservationResourceSearchRequest(thePids);
        try {
            SearchResponse observationDocumentResponse = this.executeSearchRequest(searchRequest);
            SearchHit[] observationDocumentHits = observationDocumentResponse.getHits().getHits();
            TolerantJsonParser parser = TolerantJsonParser.createWithLenientErrorHandling(this.myContext, null);
            Class resourceType = this.myContext.getResourceDefinition(OBSERVATION_RESOURCE_NAME).getImplementingClass();
            return Arrays.stream(observationDocumentHits).map(this::parseObservationJson).map(arg_0 -> ElasticsearchSvcImpl.lambda$getObservationResources$1((IParser)parser, resourceType, arg_0)).collect(Collectors.toList());
        }
        catch (IOException theE) {
            throw new InvalidRequestException(Msg.code((int)2003) + "Unable to execute observation document query for provided IDs " + thePids, (Throwable)theE);
        }
    }

    private ObservationJson parseObservationJson(SearchHit theSearchHit) {
        try {
            return (ObservationJson)this.objectMapper.readValue(theSearchHit.getSourceAsString(), ObservationJson.class);
        }
        catch (JsonProcessingException exp) {
            throw new InvalidRequestException(Msg.code((int)2004) + "Unable to parse the observation resource json", (Throwable)exp);
        }
    }

    private SearchRequest buildObservationResourceSearchRequest(Collection<ResourcePersistentId> thePids) {
        SearchRequest searchRequest = new SearchRequest(new String[]{OBSERVATION_INDEX});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        List pidParams = thePids.stream().map(Object::toString).collect(Collectors.toList());
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)OBSERVATION_IDENTIFIER_FIELD_NAME, pidParams));
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchSourceBuilder.size(thePids.size());
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private IndexRequest createIndexRequest(String theIndexName, String theDocumentId, String theObservationDocument, String theDocumentType) {
        IndexRequest request = new IndexRequest(theIndexName);
        request.id(theDocumentId);
        request.source(theObservationDocument, XContentType.JSON);
        return request;
    }

    @Override
    public void deleteObservationDocument(String theDocumentId) {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{OBSERVATION_INDEX});
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.termQuery((String)OBSERVATION_IDENTIFIER_FIELD_NAME, (String)theDocumentId));
        try {
            this.myRestHighLevelClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
        }
        catch (IOException theE) {
            throw new InvalidRequestException(Msg.code((int)1191) + "Unable to delete Observation " + theDocumentId);
        }
    }

    @VisibleForTesting
    public void deleteAllDocumentsForTest(String theIndexName) throws IOException {
        DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{theIndexName});
        deleteByQueryRequest.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        this.myRestHighLevelClient.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
    }

    @VisibleForTesting
    public void refreshIndex(String theIndexName) throws IOException {
        this.myRestHighLevelClient.indices().refresh(new RefreshRequest(new String[]{theIndexName}), RequestOptions.DEFAULT);
    }

    private static /* synthetic */ IBaseResource lambda$getObservationResources$1(IParser parser, Class resourceType, ObservationJson observationJson) {
        return parser.parseResource(resourceType, observationJson.getResource());
    }
}

