/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.sp;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.data.ISearchParamPresentDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresentEntity;
import ca.uhn.fhir.jpa.sp.ISearchParamPresenceSvc;
import ca.uhn.fhir.jpa.util.AddRemoveCount;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchParamPresenceSvcImpl
implements ISearchParamPresenceSvc {
    @Autowired
    private ISearchParamPresentDao mySearchParamPresentDao;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private DaoConfig myDaoConfig;

    @VisibleForTesting
    public void setDaoConfig(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    @Override
    public AddRemoveCount updatePresence(ResourceTable theResource, Map<String, Boolean> theParamNameToPresence) {
        AddRemoveCount retVal = new AddRemoveCount();
        if (this.myDaoConfig.getIndexMissingFields() == DaoConfig.IndexEnabledEnum.DISABLED) {
            return retVal;
        }
        HashMap<String, Boolean> presenceMap = new HashMap<String, Boolean>(theParamNameToPresence);
        Collection existing = theResource.getSearchParamPresents();
        HashMap<Long, SearchParamPresentEntity> existingHashToPresence = new HashMap<Long, SearchParamPresentEntity>();
        for (Object nextExistingEntity : existing) {
            existingHashToPresence.put(nextExistingEntity.getHashPresence(), (SearchParamPresentEntity)nextExistingEntity);
        }
        HashMap<Long, SearchParamPresentEntity> newHashToPresence = new HashMap<Long, SearchParamPresentEntity>();
        for (Map.Entry entry : presenceMap.entrySet()) {
            String string = (String)entry.getKey();
            SearchParamPresentEntity searchParamPresentEntity = new SearchParamPresentEntity();
            searchParamPresentEntity.setPartitionSettings(this.myPartitionSettings);
            searchParamPresentEntity.setResource(theResource);
            searchParamPresentEntity.setParamName(string);
            searchParamPresentEntity.setPresent(((Boolean)entry.getValue()).booleanValue());
            searchParamPresentEntity.setPartitionId(theResource.getPartitionId());
            searchParamPresentEntity.calculateHashes();
            newHashToPresence.put(searchParamPresentEntity.getHashPresence(), searchParamPresentEntity);
        }
        ArrayList<SearchParamPresentEntity> toDelete = new ArrayList<SearchParamPresentEntity>();
        for (Map.Entry entry : existingHashToPresence.entrySet()) {
            if (newHashToPresence.containsKey(entry.getKey())) continue;
            toDelete.add((SearchParamPresentEntity)entry.getValue());
        }
        ArrayList<SearchParamPresentEntity> arrayList = new ArrayList<SearchParamPresentEntity>();
        for (Map.Entry entry : newHashToPresence.entrySet()) {
            if (existingHashToPresence.containsKey(entry.getKey())) continue;
            arrayList.add((SearchParamPresentEntity)entry.getValue());
        }
        while (toDelete.size() > 0 && arrayList.size() > 0) {
            SearchParamPresentEntity searchParamPresentEntity = (SearchParamPresentEntity)toDelete.remove(toDelete.size() - 1);
            SearchParamPresentEntity searchParamPresentEntity2 = (SearchParamPresentEntity)arrayList.remove(arrayList.size() - 1);
            searchParamPresentEntity.updateValues(searchParamPresentEntity2);
            this.mySearchParamPresentDao.save(searchParamPresentEntity);
            retVal.addToAddCount(1);
            retVal.addToRemoveCount(1);
        }
        this.mySearchParamPresentDao.deleteAll(toDelete);
        retVal.addToRemoveCount(toDelete.size());
        this.mySearchParamPresentDao.saveAll(arrayList);
        retVal.addToRemoveCount(arrayList.size());
        return retVal;
    }
}

