/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.BaseTermReadSvcImpl;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ValueSet;

public class TermReadSvcDstu2
extends BaseTermReadSvcImpl {
    private void addAllChildren(String theSystemString, ValueSet.CodeSystemConcept theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        if (StringUtils.isNotBlank((CharSequence)theCode.getCode())) {
            theListToPopulate.add(new FhirVersionIndependentConcept(theSystemString, theCode.getCode()));
        }
        for (ValueSet.CodeSystemConcept nextChild : theCode.getConcept()) {
            this.addAllChildren(theSystemString, nextChild, theListToPopulate);
        }
    }

    private boolean addTreeIfItContainsCode(String theSystemString, ValueSet.CodeSystemConcept theNext, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        boolean foundCodeInChild = false;
        for (ValueSet.CodeSystemConcept nextChild : theNext.getConcept()) {
            foundCodeInChild |= this.addTreeIfItContainsCode(theSystemString, nextChild, theCode, theListToPopulate);
        }
        if (theCode.equals(theNext.getCode()) || foundCodeInChild) {
            theListToPopulate.add(new FhirVersionIndependentConcept(theSystemString, theNext.getCode()));
            return true;
        }
        return false;
    }

    @Override
    protected ValueSet getValueSetFromResourceTable(ResourceTable theResourceTable) {
        throw new UnsupportedOperationException(Msg.code((int)852));
    }

    @Override
    protected ValueSet toCanonicalValueSet(IBaseResource theValueSet) {
        throw new UnsupportedOperationException(Msg.code((int)853));
    }

    @Override
    protected CodeSystem toCanonicalCodeSystem(IBaseResource theCodeSystem) {
        throw new UnsupportedOperationException(Msg.code((int)854));
    }

    @Override
    public IBaseResource expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand) {
        throw new UnsupportedOperationException(Msg.code((int)855));
    }

    @Override
    public void expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        throw new UnsupportedOperationException(Msg.code((int)856));
    }

    private void findCodesAbove(ca.uhn.fhir.model.dstu2.resource.ValueSet theSystem, String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        List conceptList = theSystem.getCodeSystem().getConcept();
        for (ValueSet.CodeSystemConcept next : conceptList) {
            this.addTreeIfItContainsCode(theSystemString, next, theCode, theListToPopulate);
        }
    }

    @Override
    public List<FhirVersionIndependentConcept> findCodesAboveUsingBuiltInSystems(String theSystem, String theCode) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        ca.uhn.fhir.model.dstu2.resource.ValueSet system = (ca.uhn.fhir.model.dstu2.resource.ValueSet)this.provideValidationSupport().fetchCodeSystem(theSystem);
        if (system != null) {
            this.findCodesAbove(system, theSystem, theCode, retVal);
        }
        return retVal;
    }

    private void findCodesBelow(ca.uhn.fhir.model.dstu2.resource.ValueSet theSystem, String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        List conceptList = theSystem.getCodeSystem().getConcept();
        this.findCodesBelow(theSystemString, theCode, theListToPopulate, conceptList);
    }

    private void findCodesBelow(String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate, List<ValueSet.CodeSystemConcept> conceptList) {
        for (ValueSet.CodeSystemConcept next : conceptList) {
            if (theCode.equals(next.getCode())) {
                this.addAllChildren(theSystemString, next, theListToPopulate);
                continue;
            }
            this.findCodesBelow(theSystemString, theCode, theListToPopulate, next.getConcept());
        }
    }

    @Override
    public List<FhirVersionIndependentConcept> findCodesBelowUsingBuiltInSystems(String theSystem, String theCode) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        ca.uhn.fhir.model.dstu2.resource.ValueSet system = (ca.uhn.fhir.model.dstu2.resource.ValueSet)this.provideValidationSupport().fetchCodeSystem(theSystem);
        if (system != null) {
            this.findCodesBelow(system, theSystem, theCode, retVal);
        }
        return retVal;
    }

    @Override
    @Nullable
    protected Coding toCanonicalCoding(@Nullable IBaseDatatype theCoding) {
        Coding retVal = null;
        if (theCoding != null) {
            CodingDt coding = (CodingDt)theCoding;
            retVal = new Coding(coding.getSystem(), coding.getCode(), coding.getDisplay());
        }
        return retVal;
    }

    @Override
    @Nullable
    protected Coding toCanonicalCoding(@Nullable IBaseCoding theCoding) {
        Coding retVal = null;
        if (theCoding != null) {
            CodingDt coding = (CodingDt)theCoding;
            retVal = new Coding(coding.getSystem(), coding.getCode(), coding.getDisplay());
        }
        return retVal;
    }

    @Override
    @Nullable
    protected CodeableConcept toCanonicalCodeableConcept(@Nullable IBaseDatatype theCodeableConcept) {
        CodeableConcept outcome = null;
        if (theCodeableConcept != null) {
            outcome = new CodeableConcept();
            CodeableConceptDt cc = (CodeableConceptDt)theCodeableConcept;
            outcome.setText(cc.getText());
            for (CodingDt next : cc.getCoding()) {
                outcome.addCoding(this.toCanonicalCoding((IBaseDatatype)next));
            }
        }
        return outcome;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeIsInPreExpandedValueSet(ConceptValidationOptions theOptions, IBaseResource theValueSet, String theSystem, String theCode, String theDisplay, IBaseDatatype theCoding, IBaseDatatype theCodeableConcept) {
        throw new UnsupportedOperationException(Msg.code((int)857));
    }

    @Override
    public boolean isValueSetPreExpandedForCodeValidation(IBaseResource theValueSet) {
        throw new UnsupportedOperationException(Msg.code((int)858));
    }
}

