/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.BaseTermReadSvcImpl;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcR4;
import ca.uhn.fhir.jpa.term.ex.ExpansionTooCostlyException;
import javax.annotation.Nonnull;
import javax.transaction.Transactional;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class TermReadSvcR4
extends BaseTermReadSvcImpl
implements ITermReadSvcR4 {
    @Autowired
    private PlatformTransactionManager myTransactionManager;

    @Override
    public IBaseResource expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theInput) {
        ValueSet valueSetToExpand = (ValueSet)theInput;
        return super.expandValueSet(theExpansionOptions, valueSetToExpand);
    }

    @Override
    public void expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        ValueSet valueSetToExpand = (ValueSet)theValueSetToExpand;
        super.expandValueSet(theExpansionOptions, valueSetToExpand, theValueSetCodeAccumulator);
    }

    @Transactional(dontRollbackOn={ExpansionTooCostlyException.class})
    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        ValueSet expanded = super.expandValueSet(theExpansionOptions, (ValueSet)theValueSetToExpand);
        return new IValidationSupport.ValueSetExpansionOutcome((IBaseResource)expanded);
    }

    @Override
    protected ValueSet getValueSetFromResourceTable(ResourceTable theResourceTable) {
        return (ValueSet)this.myDaoRegistry.getResourceDao("ValueSet").toResource(ValueSet.class, (IBaseResourceEntity)theResourceTable, null, false);
    }

    public boolean isValueSetSupported(ValidationSupportContext theValidationSupportContext, String theValueSetUrl) {
        return this.fetchValueSet(theValueSetUrl) != null;
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myContext;
    }

    @Override
    protected ValueSet toCanonicalValueSet(IBaseResource theValueSet) {
        return (ValueSet)theValueSet;
    }

    @Override
    protected CodeSystem toCanonicalCodeSystem(IBaseResource theCodeSystem) {
        return (CodeSystem)theCodeSystem;
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        return super.lookupCode(theSystem, theCode, theDisplayLanguage);
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeIsInPreExpandedValueSet(ConceptValidationOptions theOptions, IBaseResource theValueSet, String theSystem, String theCode, String theDisplay, IBaseDatatype theCoding, IBaseDatatype theCodeableConcept) {
        ValueSet valueSet = (ValueSet)theValueSet;
        Coding coding = this.toCanonicalCoding(theCoding);
        CodeableConcept codeableConcept = this.toCanonicalCodeableConcept(theCodeableConcept);
        return super.validateCodeIsInPreExpandedValueSet(theOptions, valueSet, theSystem, theCode, theDisplay, coding, codeableConcept);
    }

    @Override
    protected Coding toCanonicalCoding(IBaseDatatype theCoding) {
        return (Coding)theCoding;
    }

    @Override
    protected Coding toCanonicalCoding(IBaseCoding theCoding) {
        return (Coding)theCoding;
    }

    @Override
    protected CodeableConcept toCanonicalCodeableConcept(IBaseDatatype theCodeableConcept) {
        return (CodeableConcept)theCodeableConcept;
    }

    @Override
    public boolean isValueSetPreExpandedForCodeValidation(IBaseResource theValueSet) {
        ValueSet valueSet = (ValueSet)theValueSet;
        return super.isValueSetPreExpandedForCodeValidation(valueSet);
    }
}

