/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.BaseTermReadSvcImpl;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcR5;
import ca.uhn.fhir.jpa.term.ex.ExpansionTooCostlyException;
import ca.uhn.fhir.util.ValidateUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.transaction.Transactional;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class TermReadSvcR5
extends BaseTermReadSvcImpl
implements IValidationSupport,
ITermReadSvcR5 {
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private PlatformTransactionManager myTransactionManager;

    @Transactional(dontRollbackOn={ExpansionTooCostlyException.class})
    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        ValueSet valueSetToExpand = (ValueSet)theValueSetToExpand;
        org.hl7.fhir.r4.model.ValueSet expandedR4 = super.expandValueSet(theExpansionOptions, (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_40_50.convertResource((Resource)valueSetToExpand, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
        return new IValidationSupport.ValueSetExpansionOutcome((IBaseResource)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)expandedR4, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false))));
    }

    @Override
    public IBaseResource expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theInput) {
        org.hl7.fhir.r4.model.ValueSet valueSetToExpand = this.toCanonicalValueSet(theInput);
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = super.expandValueSet(theExpansionOptions, valueSetToExpand);
        return VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)valueSetR4, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
    }

    @Override
    public void expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        org.hl7.fhir.r4.model.ValueSet valueSetToExpand = this.toCanonicalValueSet(theValueSetToExpand);
        super.expandValueSet(theExpansionOptions, valueSetToExpand, theValueSetCodeAccumulator);
    }

    @Override
    protected org.hl7.fhir.r4.model.ValueSet getValueSetFromResourceTable(ResourceTable theResourceTable) {
        ValueSet valueSetR5 = (ValueSet)this.myDaoRegistry.getResourceDao("ValueSet").toResource(ValueSet.class, (IBaseResourceEntity)theResourceTable, null, false);
        return (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_40_50.convertResource((Resource)valueSetR5, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myContext;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeIsInPreExpandedValueSet(ConceptValidationOptions theOptions, IBaseResource theValueSet, String theSystem, String theCode, String theDisplay, IBaseDatatype theCoding, IBaseDatatype theCodeableConcept) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet, (String)"ValueSet must not be null", (Object[])new Object[0]);
        ValueSet valueSet = (ValueSet)theValueSet;
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = this.toCanonicalValueSet((IBaseResource)valueSet);
        org.hl7.fhir.r4.model.Coding codingR4 = this.toCanonicalCoding(theCoding);
        CodeableConcept codeableConcept = (CodeableConcept)theCodeableConcept;
        org.hl7.fhir.r4.model.CodeableConcept codeableConceptR4 = null;
        if (codeableConcept != null) {
            codeableConceptR4 = new org.hl7.fhir.r4.model.CodeableConcept();
            for (Coding nestedCoding : codeableConcept.getCoding()) {
                codeableConceptR4.addCoding(new org.hl7.fhir.r4.model.Coding(nestedCoding.getSystem(), nestedCoding.getCode(), nestedCoding.getDisplay()));
            }
        }
        return super.validateCodeIsInPreExpandedValueSet(theOptions, valueSetR4, theSystem, theCode, theDisplay, codingR4, codeableConceptR4);
    }

    @Override
    @Nullable
    protected org.hl7.fhir.r4.model.Coding toCanonicalCoding(IBaseDatatype theCoding) {
        return (org.hl7.fhir.r4.model.Coding)VersionConvertorFactory_40_50.convertType((DataType)((Coding)theCoding), (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    protected org.hl7.fhir.r4.model.Coding toCanonicalCoding(IBaseCoding theCoding) {
        return (org.hl7.fhir.r4.model.Coding)VersionConvertorFactory_40_50.convertType((DataType)((Coding)theCoding), (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    protected org.hl7.fhir.r4.model.CodeableConcept toCanonicalCodeableConcept(IBaseDatatype theCoding) {
        return (org.hl7.fhir.r4.model.CodeableConcept)VersionConvertorFactory_40_50.convertType((DataType)((CodeableConcept)theCoding), (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
    }

    @Override
    protected org.hl7.fhir.r4.model.ValueSet toCanonicalValueSet(IBaseResource theValueSet) throws FHIRException {
        return (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_40_50.convertResource((Resource)((ValueSet)theValueSet), (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
    }

    @Override
    protected org.hl7.fhir.r4.model.CodeSystem toCanonicalCodeSystem(IBaseResource theCodeSystem) {
        return (org.hl7.fhir.r4.model.CodeSystem)VersionConvertorFactory_40_50.convertResource((Resource)((CodeSystem)theCodeSystem), (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
    }

    @Override
    public boolean isValueSetPreExpandedForCodeValidation(IBaseResource theValueSet) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet, (String)"ValueSet must not be null", (Object[])new Object[0]);
        ValueSet valueSet = (ValueSet)theValueSet;
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = this.toCanonicalValueSet((IBaseResource)valueSet);
        return super.isValueSetPreExpandedForCodeValidation(valueSetR4);
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode, String theDisplayLanguage) {
        return super.lookupCode(theSystem, theCode, theDisplayLanguage);
    }
}

