/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetDao;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import ca.uhn.fhir.jpa.entity.TermValueSetConceptDesignation;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.util.ValidateUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSetConceptAccumulator
implements IValueSetConceptAccumulator {
    private static final Logger ourLog = LoggerFactory.getLogger(ValueSetConceptAccumulator.class);
    private TermValueSet myTermValueSet;
    private final ITermValueSetDao myValueSetDao;
    private final ITermValueSetConceptDao myValueSetConceptDao;
    private final ITermValueSetConceptDesignationDao myValueSetConceptDesignationDao;
    private int myConceptsSaved;
    private int myDesignationsSaved;
    private int myConceptsExcluded;

    public ValueSetConceptAccumulator(@Nonnull TermValueSet theTermValueSet, @Nonnull ITermValueSetDao theValueSetDao, @Nonnull ITermValueSetConceptDao theValueSetConceptDao, @Nonnull ITermValueSetConceptDesignationDao theValueSetConceptDesignationDao) {
        this.myTermValueSet = theTermValueSet;
        this.myValueSetDao = theValueSetDao;
        this.myValueSetConceptDao = theValueSetConceptDao;
        this.myValueSetConceptDesignationDao = theValueSetConceptDesignationDao;
        this.myConceptsSaved = 0;
        this.myDesignationsSaved = 0;
        this.myConceptsExcluded = 0;
    }

    @Override
    public void addMessage(String theMessage) {
    }

    @Override
    public void includeConcept(String theSystem, String theCode, String theDisplay, Long theSourceConceptPid, String theSourceConceptDirectParentPids, String theSystemVersion) {
        this.saveConcept(theSystem, theCode, theDisplay, theSourceConceptPid, theSourceConceptDirectParentPids, theSystemVersion);
    }

    @Override
    public void includeConceptWithDesignations(String theSystem, String theCode, String theDisplay, Collection<TermConceptDesignation> theDesignations, Long theSourceConceptPid, String theSourceConceptDirectParentPids, String theSystemVersion) {
        TermValueSetConcept concept = this.saveConcept(theSystem, theCode, theDisplay, theSourceConceptPid, theSourceConceptDirectParentPids, theSystemVersion);
        if (theDesignations != null) {
            for (TermConceptDesignation designation : theDesignations) {
                this.saveConceptDesignation(concept, designation);
            }
        }
    }

    @Override
    public boolean excludeConcept(String theSystem, String theCode) {
        Optional<TermValueSetConcept> optionalConcept;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{theSystem, theCode})) {
            return false;
        }
        int versionIdx = theSystem.indexOf("|");
        if (versionIdx >= 0) {
            String systemUrl = theSystem.substring(0, versionIdx);
            String systemVersion = theSystem.substring(versionIdx + 1);
            optionalConcept = this.myValueSetConceptDao.findByTermValueSetIdSystemAndCodeWithVersion(this.myTermValueSet.getId(), systemUrl, systemVersion, theCode);
        } else {
            optionalConcept = this.myValueSetConceptDao.findByTermValueSetIdSystemAndCode(this.myTermValueSet.getId(), theSystem, theCode);
        }
        if (optionalConcept.isPresent()) {
            TermValueSetConcept concept = optionalConcept.get();
            ourLog.debug("Excluding [{}|{}] from ValueSet[{}]", new Object[]{concept.getSystem(), concept.getCode(), this.myTermValueSet.getUrl()});
            for (TermValueSetConceptDesignation designation : concept.getDesignations()) {
                this.myValueSetConceptDesignationDao.deleteById(designation.getId());
                this.myTermValueSet.decrementTotalConceptDesignations();
            }
            this.myValueSetConceptDao.deleteById(concept.getId());
            this.myTermValueSet.decrementTotalConcepts();
            this.myValueSetDao.save(this.myTermValueSet);
            ourLog.debug("Done excluding [{}|{}] from ValueSet[{}]", new Object[]{concept.getSystem(), concept.getCode(), this.myTermValueSet.getUrl()});
            if (++this.myConceptsExcluded % 250 == 0) {
                ourLog.info("Have excluded {} concepts from ValueSet[{}]", (Object)this.myConceptsExcluded, (Object)this.myTermValueSet.getUrl());
            }
        }
        return false;
    }

    private TermValueSetConcept saveConcept(String theSystem, String theCode, String theDisplay, Long theSourceConceptPid, String theSourceConceptDirectParentPids, String theSystemVersion) {
        ValidateUtil.isNotBlankOrThrowInvalidRequest((String)theSystem, (String)"ValueSet contains a concept with no system value");
        ValidateUtil.isNotBlankOrThrowInvalidRequest((String)theCode, (String)"ValueSet contains a concept with no code value");
        TermValueSetConcept concept = new TermValueSetConcept();
        concept.setValueSet(this.myTermValueSet);
        concept.setOrder(this.myConceptsSaved);
        int versionIndex = theSystem.indexOf("|");
        if (versionIndex >= 0) {
            concept.setSystem(theSystem.substring(0, versionIndex));
            concept.setSystemVersion(theSystem.substring(versionIndex + 1));
        } else {
            concept.setSystem(theSystem);
        }
        concept.setCode(theCode);
        if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
            concept.setDisplay(theDisplay);
        }
        concept.setSystemVersion(theSystemVersion);
        concept.setSourceConceptPid(theSourceConceptPid);
        concept.setSourceConceptDirectParentPids(theSourceConceptDirectParentPids);
        this.myValueSetConceptDao.save(concept);
        this.myValueSetDao.save(this.myTermValueSet.incrementTotalConcepts());
        if (++this.myConceptsSaved % 250 == 0) {
            ourLog.info("Have pre-expanded {} concepts in ValueSet[{}]", (Object)this.myConceptsSaved, (Object)this.myTermValueSet.getUrl());
        }
        return concept;
    }

    private TermValueSetConceptDesignation saveConceptDesignation(TermValueSetConcept theConcept, TermConceptDesignation theDesignation) {
        ValidateUtil.isNotBlankOrThrowInvalidRequest((String)theDesignation.getValue(), (String)"ValueSet contains a concept designation with no value");
        TermValueSetConceptDesignation designation = new TermValueSetConceptDesignation();
        designation.setConcept(theConcept);
        designation.setValueSet(this.myTermValueSet);
        designation.setLanguage(theDesignation.getLanguage());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theDesignation.getUseSystem(), theDesignation.getUseCode()})) {
            designation.setUseSystem(theDesignation.getUseSystem());
            designation.setUseCode(theDesignation.getUseCode());
            if (StringUtils.isNotBlank((CharSequence)theDesignation.getUseDisplay())) {
                designation.setUseDisplay(theDesignation.getUseDisplay());
            }
        }
        designation.setValue(theDesignation.getValue());
        this.myValueSetConceptDesignationDao.save(designation);
        this.myValueSetDao.save(this.myTermValueSet.incrementTotalConceptDesignations());
        if (++this.myDesignationsSaved % 250 == 0) {
            ourLog.debug("Have pre-expanded {} designations for Concept[{}|{}] in ValueSet[{}]", new Object[]{this.myDesignationsSaved, theConcept.getSystem(), theConcept.getCode(), this.myTermValueSet.getUrl()});
        }
        return designation;
    }

    public Boolean removeGapsFromConceptOrder() {
        if (this.myConceptsExcluded <= 0) {
            return false;
        }
        ourLog.info("Removing gaps from concept order for ValueSet[{}]", (Object)this.myTermValueSet.getUrl());
        int order = 0;
        List<Long> conceptIds = this.myValueSetConceptDao.findIdsByTermValueSetId(this.myTermValueSet.getId());
        for (Long conceptId : conceptIds) {
            this.myValueSetConceptDao.updateOrderById(conceptId, order++);
        }
        ourLog.info("Have removed gaps from concept order for {} concepts in ValueSet[{}]", (Object)conceptIds.size(), (Object)this.myTermValueSet.getUrl());
        return true;
    }

    public int getConceptsSaved() {
        return this.myConceptsSaved;
    }
}

