/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.icd10cm;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.util.XmlUtil;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Icd10CmLoader {
    private final TermCodeSystemVersion myCodeSystemVersion;
    private int myConceptCount;
    private static final String SEVEN_CHR_DEF = "sevenChrDef";
    private static final String VERSION = "version";
    private static final String EXTENSION = "extension";
    private static final String CHAPTER = "chapter";
    private static final String SECTION = "section";
    private static final String DIAG = "diag";
    private static final String NAME = "name";
    private static final String DESC = "desc";

    public Icd10CmLoader(TermCodeSystemVersion theCodeSystemVersion) {
        this.myCodeSystemVersion = theCodeSystemVersion;
    }

    public void load(Reader theReader) throws IOException, SAXException {
        this.myConceptCount = 0;
        Document document = XmlUtil.parseDocument((Reader)theReader, (boolean)false);
        Element documentElement = document.getDocumentElement();
        for (Element nextVersion : XmlUtil.getChildrenByTagName((Element)documentElement, (String)VERSION)) {
            String versionId = nextVersion.getTextContent();
            if (!StringUtils.isNotBlank((CharSequence)versionId)) continue;
            this.myCodeSystemVersion.setCodeSystemVersionId(versionId);
        }
        for (Element nextChapter : XmlUtil.getChildrenByTagName((Element)documentElement, (String)CHAPTER)) {
            for (Element nextSection : XmlUtil.getChildrenByTagName((Element)nextChapter, (String)SECTION)) {
                for (Element nextDiag : XmlUtil.getChildrenByTagName((Element)nextSection, (String)DIAG)) {
                    this.extractCode(nextDiag, null);
                }
            }
        }
    }

    private void extractCode(Element theDiagElement, TermConcept theParentConcept) {
        String code = theDiagElement.getElementsByTagName(NAME).item(0).getTextContent();
        String display = theDiagElement.getElementsByTagName(DESC).item(0).getTextContent();
        TermConcept concept = theParentConcept == null ? this.myCodeSystemVersion.addConcept() : theParentConcept.addChild(TermConceptParentChildLink.RelationshipTypeEnum.ISA);
        concept.setCode(code);
        concept.setDisplay(display);
        for (Element nextChildDiag : XmlUtil.getChildrenByTagName((Element)theDiagElement, (String)DIAG)) {
            this.extractCode(nextChildDiag, concept);
            if (XmlUtil.getChildrenByTagName((Element)theDiagElement, (String)SEVEN_CHR_DEF).size() == 0) continue;
            this.extractExtension(theDiagElement, nextChildDiag, concept);
        }
        ++this.myConceptCount;
    }

    private void extractExtension(Element theDiagElement, Element theChildDiag, TermConcept theParentConcept) {
        for (Element nextChrNote : XmlUtil.getChildrenByTagName((Element)theDiagElement, (String)SEVEN_CHR_DEF)) {
            for (Element nextExtension : XmlUtil.getChildrenByTagName((Element)nextChrNote, (String)EXTENSION)) {
                String baseCode = theChildDiag.getElementsByTagName(NAME).item(0).getTextContent();
                String sevenChar = nextExtension.getAttributes().item(0).getNodeValue();
                String baseDef = theChildDiag.getElementsByTagName(DESC).item(0).getTextContent();
                String sevenCharDef = nextExtension.getTextContent();
                TermConcept concept = theParentConcept.addChild(TermConceptParentChildLink.RelationshipTypeEnum.ISA);
                concept.setCode(this.getExtendedCode(baseCode, sevenChar));
                concept.setDisplay(this.getExtendedDisplay(baseDef, sevenCharDef));
            }
        }
    }

    private String getExtendedDisplay(String theBaseDef, String theSevenCharDef) {
        return theBaseDef + ", " + theSevenCharDef;
    }

    private String getExtendedCode(String theBaseCode, String theSevenChar) {
        String placeholder = "X";
        Object code = theBaseCode;
        for (int i = ((String)code).length(); i < 7; ++i) {
            code = (String)code + placeholder;
        }
        code = (String)code + theSevenChar;
        return code;
    }

    public int getConceptCount() {
        return this.myConceptCount;
    }
}

