/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ValueSet;

public class LoincIeeeMedicalDeviceCodeHandler
extends BaseLoincHandler
implements IZipContentsHandlerCsv {
    public static final String LOINC_IEEE_CM_ID = "loinc-to-ieee-11073-10101";
    public static final String LOINC_IEEE_CM_URI = "http://loinc.org/cm/loinc-to-ieee-11073-10101";
    public static final String LOINC_IEEE_CM_NAME = "LOINC/IEEE Device Code Mappings";
    private static final String CM_COPYRIGHT = "The LOINC/IEEE Medical Device Code Mapping Table contains content from IEEE (http://ieee.org), copyright \u00a9 2017 IEEE.";

    public LoincIeeeMedicalDeviceCodeHandler(Map<String, TermConcept> theCode2concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties, String theCopyrightStatement) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties, theCopyrightStatement);
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String codeSystemVersionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        Object loincIeeeCmVersion = codeSystemVersionId != null ? this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CONCEPTMAP_VERSION.getCode()) + "-" + codeSystemVersionId : this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CONCEPTMAP_VERSION.getCode());
        String loincNumber = StringUtils.trim((String)theRecord.get("LOINC_NUM"));
        String longCommonName = StringUtils.trim((String)theRecord.get("LOINC_LONG_COMMON_NAME"));
        String ieeeCode = StringUtils.trim((String)theRecord.get("IEEE_CF_CODE10"));
        String ieeeDisplayName = StringUtils.trim((String)theRecord.get("IEEE_REFID"));
        String sourceCodeSystemUri = "http://loinc.org";
        String targetCodeSystemUri = "urn:iso:std:iso:11073:10101";
        Object conceptMapId = codeSystemVersionId != null ? "loinc-to-ieee-11073-10101-" + codeSystemVersionId : LOINC_IEEE_CM_ID;
        this.addConceptMapEntry(new BaseLoincHandler.ConceptMapping().setConceptMapId((String)conceptMapId).setConceptMapUri(LOINC_IEEE_CM_URI).setConceptMapVersion((String)loincIeeeCmVersion).setConceptMapName(LOINC_IEEE_CM_NAME).setSourceCodeSystem(sourceCodeSystemUri).setSourceCodeSystemVersion(codeSystemVersionId).setSourceCode(loincNumber).setSourceDisplay(longCommonName).setTargetCodeSystem(targetCodeSystemUri).setTargetCode(ieeeCode).setTargetDisplay(ieeeDisplayName).setEquivalence(Enumerations.ConceptMapEquivalence.EQUAL), this.myLoincCopyrightStatement + " The LOINC/IEEE Medical Device Code Mapping Table contains content from IEEE (http://ieee.org), copyright \u00a9 2017 IEEE.");
    }
}

