/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class LoincLinguisticVariantsHandler
implements IZipContentsHandlerCsv {
    private final List<LinguisticVariant> myLinguisticVariants;

    public LoincLinguisticVariantsHandler(List<LinguisticVariant> thelinguisticVariants) {
        this.myLinguisticVariants = thelinguisticVariants;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String id = StringUtils.trim((String)theRecord.get("ID"));
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        String isoLanguage = StringUtils.trim((String)theRecord.get("ISO_LANGUAGE"));
        if (StringUtils.isBlank((CharSequence)isoLanguage)) {
            return;
        }
        String isoCountry = StringUtils.trim((String)theRecord.get("ISO_COUNTRY"));
        if (StringUtils.isBlank((CharSequence)isoCountry)) {
            return;
        }
        String languageName = StringUtils.trim((String)theRecord.get("LANGUAGE_NAME"));
        if (StringUtils.isBlank((CharSequence)languageName)) {
            return;
        }
        LinguisticVariant linguisticVariant = new LinguisticVariant(id, isoLanguage, isoCountry, languageName);
        this.myLinguisticVariants.add(linguisticVariant);
    }

    public static class LinguisticVariant {
        private String myId;
        private String myIsoLanguage;
        private String myIsoCountry;
        private String myLanguageName;

        public LinguisticVariant(@Nonnull String theId, @Nonnull String theIsoLanguage, @Nonnull String theIsoCountry, @Nonnull String theLanguageName) {
            this.myId = theId;
            this.myIsoLanguage = theIsoLanguage;
            this.myIsoCountry = theIsoCountry;
            this.myLanguageName = theLanguageName;
        }

        public String getLinguisticVariantFileName() {
            return this.myIsoLanguage + this.myIsoCountry + this.myId + "LinguisticVariant.csv";
        }

        public String getLanguageName() {
            return this.myLanguageName;
        }

        public String getLanguageCode() {
            return this.myIsoLanguage + "-" + this.myIsoCountry;
        }
    }
}

