/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.snomedct;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVRecord;

public final class SctHandlerDescription
implements IZipContentsHandlerCsv {
    private final Map<String, TermConcept> myCode2concept;
    private final TermCodeSystemVersion myCodeSystemVersion;
    private final Map<String, TermConcept> myId2concept;
    private Set<String> myValidConceptIds;

    public SctHandlerDescription(Set<String> theValidConceptIds, Map<String, TermConcept> theCode2concept, Map<String, TermConcept> theId2concept, TermCodeSystemVersion theCodeSystemVersion) {
        this.myCode2concept = theCode2concept;
        this.myId2concept = theId2concept;
        this.myCodeSystemVersion = theCodeSystemVersion;
        this.myValidConceptIds = theValidConceptIds;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String id = theRecord.get("id");
        boolean active = "1".equals(theRecord.get("active"));
        if (!active) {
            return;
        }
        String conceptId = theRecord.get("conceptId");
        if (!this.myValidConceptIds.contains(conceptId)) {
            return;
        }
        String term = theRecord.get("term");
        TermConcept concept = TermLoaderSvcImpl.getOrCreateConcept(this.myId2concept, id);
        concept.setCode(conceptId);
        concept.setDisplay(term);
        concept.setCodeSystemVersion(this.myCodeSystemVersion);
        this.myCode2concept.put(conceptId, concept);
    }
}

