/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.snomedct;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;

public final class SctHandlerRelationship
implements IZipContentsHandlerCsv {
    private final Map<String, TermConcept> myCode2concept;
    private final TermCodeSystemVersion myCodeSystemVersion;
    private final Map<String, TermConcept> myRootConcepts;

    public SctHandlerRelationship(TermCodeSystemVersion theCodeSystemVersion, HashMap<String, TermConcept> theRootConcepts, Map<String, TermConcept> theCode2concept) {
        this.myCodeSystemVersion = theCodeSystemVersion;
        this.myRootConcepts = theRootConcepts;
        this.myCode2concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        HashSet<String> ignoredTypes = new HashSet<String>();
        ignoredTypes.add("Method (attribute)");
        ignoredTypes.add("Direct device (attribute)");
        ignoredTypes.add("Has focus (attribute)");
        ignoredTypes.add("Access instrument");
        ignoredTypes.add("Procedure site (attribute)");
        ignoredTypes.add("Causative agent (attribute)");
        ignoredTypes.add("Course (attribute)");
        ignoredTypes.add("Finding site (attribute)");
        ignoredTypes.add("Has definitional manifestation (attribute)");
        String sourceId = theRecord.get("sourceId");
        String destinationId = theRecord.get("destinationId");
        String typeId = theRecord.get("typeId");
        boolean active = "1".equals(theRecord.get("active"));
        TermConcept typeConcept = this.myCode2concept.get(typeId);
        TermConcept sourceConcept = this.myCode2concept.get(sourceId);
        TermConcept targetConcept = this.myCode2concept.get(destinationId);
        if (sourceConcept != null && targetConcept != null && typeConcept != null) {
            if (typeConcept.getDisplay().equals("Is a (attribute)")) {
                TermConceptParentChildLink.RelationshipTypeEnum relationshipType = TermConceptParentChildLink.RelationshipTypeEnum.ISA;
                if (!sourceId.equals(destinationId)) {
                    if (active) {
                        TermConceptParentChildLink link = new TermConceptParentChildLink();
                        link.setChild(sourceConcept);
                        link.setParent(targetConcept);
                        link.setRelationshipType(relationshipType);
                        link.setCodeSystem(this.myCodeSystemVersion);
                        targetConcept.addChild(sourceConcept, relationshipType);
                    } else {
                        for (TermConceptParentChildLink next : new ArrayList<TermConceptParentChildLink>(targetConcept.getChildren())) {
                            if (next.getRelationshipType() != relationshipType || !next.getChild().getCode().equals(sourceConcept.getCode())) continue;
                            next.getParent().getChildren().remove(next);
                            next.getChild().getParents().remove(next);
                        }
                    }
                }
            } else if (ignoredTypes.contains(typeConcept.getDisplay())) {
                // empty if block
            }
        }
    }
}

