/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch2;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.model.FetchJobInstancesRequest;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.model.WorkChunkCompletionEvent;
import ca.uhn.fhir.batch2.model.WorkChunkCreateEvent;
import ca.uhn.fhir.batch2.model.WorkChunkErrorEvent;
import ca.uhn.fhir.batch2.model.WorkChunkMetadata;
import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.batch2.JobInstanceUtil;
import ca.uhn.fhir.jpa.dao.data.IBatch2JobInstanceRepository;
import ca.uhn.fhir.jpa.dao.data.IBatch2WorkChunkMetadataViewRepository;
import ca.uhn.fhir.jpa.dao.data.IBatch2WorkChunkRepository;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.entity.Batch2JobInstanceEntity;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkEntity;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkMetadataView;
import ca.uhn.fhir.model.api.PagingIterator;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.util.Logs;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaJobPersistenceImpl
implements IJobPersistence {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final String CREATE_TIME = "myCreateTime";
    private final IBatch2JobInstanceRepository myJobInstanceRepository;
    private final IBatch2WorkChunkRepository myWorkChunkRepository;
    private final IBatch2WorkChunkMetadataViewRepository myWorkChunkMetadataViewRepo;
    private final EntityManager myEntityManager;
    private final IHapiTransactionService myTransactionService;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;

    public JpaJobPersistenceImpl(IBatch2JobInstanceRepository theJobInstanceRepository, IBatch2WorkChunkRepository theWorkChunkRepository, IBatch2WorkChunkMetadataViewRepository theWorkChunkMetadataViewRepo, IHapiTransactionService theTransactionService, EntityManager theEntityManager, IInterceptorBroadcaster theInterceptorBroadcaster) {
        Validate.notNull((Object)theJobInstanceRepository, (String)"theJobInstanceRepository", (Object[])new Object[0]);
        Validate.notNull((Object)theWorkChunkRepository, (String)"theWorkChunkRepository", (Object[])new Object[0]);
        this.myJobInstanceRepository = theJobInstanceRepository;
        this.myWorkChunkRepository = theWorkChunkRepository;
        this.myWorkChunkMetadataViewRepo = theWorkChunkMetadataViewRepo;
        this.myTransactionService = theTransactionService;
        this.myEntityManager = theEntityManager;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String onWorkChunkCreate(WorkChunkCreateEvent theBatchWorkChunk) {
        Batch2WorkChunkEntity entity = new Batch2WorkChunkEntity();
        entity.setId(UUID.randomUUID().toString());
        entity.setSequence(theBatchWorkChunk.sequence);
        entity.setJobDefinitionId(theBatchWorkChunk.jobDefinitionId);
        entity.setJobDefinitionVersion(theBatchWorkChunk.jobDefinitionVersion);
        entity.setTargetStepId(theBatchWorkChunk.targetStepId);
        entity.setInstanceId(theBatchWorkChunk.instanceId);
        entity.setSerializedData(theBatchWorkChunk.serializedData);
        entity.setCreateTime(new Date());
        entity.setStartTime(new Date());
        entity.setStatus(JpaJobPersistenceImpl.getOnCreateStatus(theBatchWorkChunk));
        ourLog.debug("Create work chunk {}/{}/{}", new Object[]{entity.getInstanceId(), entity.getId(), entity.getTargetStepId()});
        ourLog.trace("Create work chunk data {}/{}: {}", new Object[]{entity.getInstanceId(), entity.getId(), entity.getSerializedData()});
        this.myTransactionService.withSystemRequestOnDefaultPartition().execute(() -> (Batch2WorkChunkEntity)this.myWorkChunkRepository.save(entity));
        return entity.getId();
    }

    private static WorkChunkStatusEnum getOnCreateStatus(WorkChunkCreateEvent theBatchWorkChunk) {
        if (theBatchWorkChunk.isGatedExecution) {
            return WorkChunkStatusEnum.GATE_WAITING;
        }
        return WorkChunkStatusEnum.READY;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Optional<WorkChunk> onWorkChunkDequeue(String theChunkId) {
        Batch2WorkChunkEntity chunkLock = (Batch2WorkChunkEntity)this.myEntityManager.find(Batch2WorkChunkEntity.class, (Object)theChunkId, LockModeType.PESSIMISTIC_WRITE);
        this.myEntityManager.detach((Object)chunkLock);
        List<WorkChunkStatusEnum> priorStates = List.of(WorkChunkStatusEnum.QUEUED, WorkChunkStatusEnum.ERRORED, WorkChunkStatusEnum.IN_PROGRESS);
        int rowsModified = this.myWorkChunkRepository.updateChunkStatusForStart(theChunkId, new Date(), WorkChunkStatusEnum.IN_PROGRESS, priorStates);
        if (rowsModified == 0) {
            ourLog.info("Attempting to start chunk {} but it was already started.", (Object)theChunkId);
            return Optional.empty();
        }
        Optional chunk = this.myWorkChunkRepository.findById(theChunkId);
        return chunk.map(this::toChunk);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String storeNewInstance(JobInstance theInstance) {
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)theInstance.getInstanceId()));
        this.invokePreStorageBatchHooks(theInstance);
        Batch2JobInstanceEntity entity = new Batch2JobInstanceEntity();
        entity.setId(UUID.randomUUID().toString());
        entity.setDefinitionId(theInstance.getJobDefinitionId());
        entity.setDefinitionVersion(theInstance.getJobDefinitionVersion());
        entity.setStatus(theInstance.getStatus());
        entity.setParams(theInstance.getParameters());
        entity.setCurrentGatedStepId(theInstance.getCurrentGatedStepId());
        entity.setFastTracking(theInstance.isFastTracking());
        entity.setCreateTime(new Date());
        entity.setStartTime(new Date());
        entity.setReport(theInstance.getReport());
        entity.setTriggeringUsername(theInstance.getTriggeringUsername());
        entity.setTriggeringClientId(theInstance.getTriggeringClientId());
        entity = (Batch2JobInstanceEntity)this.myJobInstanceRepository.save(entity);
        return entity.getId();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstances(String theJobDefinitionId, Set<StatusEnum> theStatuses, Date theCutoff, Pageable thePageable) {
        return this.toInstanceList(this.myJobInstanceRepository.findInstancesByJobIdAndStatusAndExpiry(theJobDefinitionId, theStatuses, theCutoff, thePageable));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstancesByJobDefinitionIdAndStatus(String theJobDefinitionId, Set<StatusEnum> theRequestedStatuses, int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{CREATE_TIME});
        return this.toInstanceList(this.myJobInstanceRepository.fetchInstancesByJobDefinitionIdAndStatus(theJobDefinitionId, theRequestedStatuses, (Pageable)pageRequest));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstancesByJobDefinitionId(String theJobDefinitionId, int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{CREATE_TIME});
        return this.toInstanceList(this.myJobInstanceRepository.findInstancesByJobDefinitionId(theJobDefinitionId, (Pageable)pageRequest));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Page<JobInstance> fetchJobInstances(JobInstanceFetchRequest theRequest) {
        PageRequest pageRequest = PageRequest.of((int)theRequest.getPageStart(), (int)theRequest.getBatchSize(), (Sort)theRequest.getSort());
        String jobStatus = theRequest.getJobStatus();
        if (Objects.equals(jobStatus, "")) {
            Page pageOfEntities = this.myJobInstanceRepository.findAll((Pageable)pageRequest);
            return pageOfEntities.map(this::toInstance);
        }
        StatusEnum status = StatusEnum.valueOf((String)jobStatus);
        List<JobInstance> jobs = this.toInstanceList(this.myJobInstanceRepository.findInstancesByJobStatus(status, (Pageable)pageRequest));
        Integer jobsOfStatus = this.myJobInstanceRepository.findTotalJobsOfStatus(status);
        return new PageImpl(jobs, (Pageable)pageRequest, (long)jobsOfStatus.intValue());
    }

    private List<JobInstance> toInstanceList(List<Batch2JobInstanceEntity> theInstancesByJobDefinitionId) {
        return theInstancesByJobDefinitionId.stream().map(this::toInstance).collect(Collectors.toList());
    }

    @Nonnull
    public Optional<JobInstance> fetchInstance(String theInstanceId) {
        return (Optional)this.myTransactionService.withSystemRequestOnDefaultPartition().execute(() -> this.myJobInstanceRepository.findById(theInstanceId).map(this::toInstance));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstances(FetchJobInstancesRequest theRequest, int thePage, int theBatchSize) {
        List<Batch2JobInstanceEntity> instanceEntities;
        String definitionId = theRequest.getJobDefinition();
        String params = theRequest.getParameters();
        Set statuses = theRequest.getStatuses();
        PageRequest pageable = PageRequest.of((int)thePage, (int)theBatchSize);
        if (statuses != null && !statuses.isEmpty()) {
            if ("BULK_EXPORT".equals(definitionId) && this.originalRequestUrlTruncation(params) != null) {
                params = this.originalRequestUrlTruncation(params);
            }
            instanceEntities = this.myJobInstanceRepository.findInstancesByJobIdParamsAndStatus(definitionId, params, statuses, (Pageable)pageable);
        } else {
            instanceEntities = this.myJobInstanceRepository.findInstancesByJobIdAndParams(definitionId, params, (Pageable)pageable);
        }
        return this.toInstanceList(instanceEntities);
    }

    private String originalRequestUrlTruncation(String theParams) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            JsonNode rootNode = mapper.readTree(theParams);
            String originalUrl = "originalRequestUrl";
            if (rootNode instanceof ObjectNode) {
                String url;
                ObjectNode objectNode = (ObjectNode)rootNode;
                if (objectNode.has(originalUrl) && (url = objectNode.get(originalUrl).asText()).contains("?")) {
                    objectNode.put(originalUrl, url.split("\\?")[0]);
                }
                return mapper.writeValueAsString((Object)objectNode);
            }
        }
        catch (Exception e) {
            ourLog.info("Error Truncating Original Request Url", (Throwable)e);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstances(int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{CREATE_TIME});
        return (List)this.myTransactionService.withSystemRequestOnDefaultPartition().execute(() -> this.myJobInstanceRepository.findAll((Pageable)pageRequest).stream().map(this::toInstance).collect(Collectors.toList()));
    }

    public void enqueueWorkChunkForProcessing(String theChunkId, Consumer<Integer> theCallback) {
        int updated = this.myWorkChunkRepository.updateChunkStatus(theChunkId, WorkChunkStatusEnum.READY, WorkChunkStatusEnum.QUEUED);
        theCallback.accept(updated);
    }

    public int updatePollWaitingChunksForJobIfReady(String theInstanceId) {
        return this.myWorkChunkRepository.updateWorkChunksForPollWaiting(theInstanceId, Date.from(Instant.now()), Set.of(WorkChunkStatusEnum.POLL_WAITING), WorkChunkStatusEnum.READY);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchRecentInstances(int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{CREATE_TIME});
        return (List)this.myTransactionService.withSystemRequestOnDefaultPartition().execute(() -> this.myJobInstanceRepository.findAll((Pageable)pageRequest).stream().map(this::toInstance).collect(Collectors.toList()));
    }

    private WorkChunk toChunk(Batch2WorkChunkEntity theEntity) {
        return JobInstanceUtil.fromEntityToWorkChunk(theEntity);
    }

    private JobInstance toInstance(Batch2JobInstanceEntity theEntity) {
        return JobInstanceUtil.fromEntityToInstance(theEntity);
    }

    public WorkChunkStatusEnum onWorkChunkError(WorkChunkErrorEvent theParameters) {
        String chunkId = theParameters.getChunkId();
        String errorMessage = JpaJobPersistenceImpl.truncateErrorMessage(theParameters.getErrorMsg());
        return (WorkChunkStatusEnum)this.myTransactionService.withSystemRequestOnDefaultPartition().execute(() -> {
            int changeCount = this.myWorkChunkRepository.updateChunkStatusAndIncrementErrorCountForEndError(chunkId, new Date(), errorMessage, WorkChunkStatusEnum.ERRORED);
            Validate.isTrue((changeCount > 0 ? 1 : 0) != 0, (String)"changed chunk matching %s", (Object[])new Object[]{chunkId});
            Query query = this.myEntityManager.createQuery("update Batch2WorkChunkEntity set myStatus = :failed ,myErrorMessage = CONCAT('Too many errors: ', CAST(myErrorCount as string), '. Last error msg was ', myErrorMessage) where myId = :chunkId and myErrorCount > :maxCount");
            query.setParameter("chunkId", (Object)chunkId);
            query.setParameter("failed", (Object)WorkChunkStatusEnum.FAILED);
            query.setParameter("maxCount", (Object)3);
            int failChangeCount = query.executeUpdate();
            if (failChangeCount > 0) {
                return WorkChunkStatusEnum.FAILED;
            }
            return WorkChunkStatusEnum.ERRORED;
        });
    }

    public void onWorkChunkPollDelay(String theChunkId, Date theDeadline) {
        int updated = this.myWorkChunkRepository.updateWorkChunkNextPollTime(theChunkId, WorkChunkStatusEnum.POLL_WAITING, Set.of(WorkChunkStatusEnum.IN_PROGRESS), theDeadline);
        if (updated != 1) {
            ourLog.warn("Expected to update 1 work chunk's poll delay; but found {}", (Object)updated);
        }
    }

    public void onWorkChunkFailed(String theChunkId, String theErrorMessage) {
        ourLog.info("Marking chunk {} as failed with message: {}", (Object)theChunkId, (Object)theErrorMessage);
        String errorMessage = JpaJobPersistenceImpl.truncateErrorMessage(theErrorMessage);
        this.myTransactionService.withSystemRequestOnDefaultPartition().execute(() -> this.myWorkChunkRepository.updateChunkStatusAndIncrementErrorCountForEndError(theChunkId, new Date(), errorMessage, WorkChunkStatusEnum.FAILED));
    }

    public void onWorkChunkCompletion(WorkChunkCompletionEvent theEvent) {
        this.myTransactionService.withSystemRequestOnDefaultPartition().execute(() -> this.myWorkChunkRepository.updateChunkStatusAndClearDataForEndSuccess(theEvent.getChunkId(), new Date(), theEvent.getRecordsProcessed(), theEvent.getRecoveredErrorCount(), WorkChunkStatusEnum.COMPLETED, theEvent.getRecoveredWarningMessage()));
    }

    @Nullable
    private static String truncateErrorMessage(String theErrorMessage) {
        String errorMessage;
        if (theErrorMessage != null && theErrorMessage.length() > 500) {
            ourLog.warn("Truncating error message that is too long to store in database: {}", (Object)theErrorMessage);
            errorMessage = theErrorMessage.substring(0, 500);
        } else {
            errorMessage = theErrorMessage;
        }
        return errorMessage;
    }

    public void markWorkChunksWithStatusAndWipeData(String theInstanceId, List<String> theChunkIds, WorkChunkStatusEnum theStatus, String theErrorMessage) {
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        ourLog.debug("Marking all chunks for instance {} to status {}", (Object)theInstanceId, (Object)theStatus);
        String errorMessage = JpaJobPersistenceImpl.truncateErrorMessage(theErrorMessage);
        List listOfListOfIds = ListUtils.partition(theChunkIds, (int)100);
        for (List idList : listOfListOfIds) {
            this.myWorkChunkRepository.updateAllChunksForInstanceStatusClearDataAndSetError(idList, new Date(), theStatus, errorMessage);
        }
    }

    public Set<WorkChunkStatusEnum> getDistinctWorkChunkStatesForJobAndStep(String theInstanceId, String theCurrentStepId) {
        if (this.getRunningJob(theInstanceId) == null) {
            return Collections.unmodifiableSet(new HashSet());
        }
        return this.myWorkChunkRepository.getDistinctStatusesForStep(theInstanceId, theCurrentStepId);
    }

    private Batch2JobInstanceEntity getRunningJob(String theInstanceId) {
        Optional instance = this.myJobInstanceRepository.findById(theInstanceId);
        if (instance.isEmpty()) {
            return null;
        }
        if (((Batch2JobInstanceEntity)instance.get()).getStatus().isEnded()) {
            return null;
        }
        return (Batch2JobInstanceEntity)instance.get();
    }

    private void fetchChunks(String theInstanceId, boolean theIncludeData, int thePageSize, int thePageIndex, Consumer<WorkChunk> theConsumer) {
        this.myTransactionService.withSystemRequestOnDefaultPartition().withPropagation(Propagation.REQUIRES_NEW).execute(() -> {
            List<Batch2WorkChunkEntity> chunks = theIncludeData ? this.myWorkChunkRepository.fetchChunks((Pageable)PageRequest.of((int)thePageIndex, (int)thePageSize), theInstanceId) : this.myWorkChunkRepository.fetchChunksNoData((Pageable)PageRequest.of((int)thePageIndex, (int)thePageSize), theInstanceId);
            for (Batch2WorkChunkEntity chunk : chunks) {
                theConsumer.accept(this.toChunk(chunk));
            }
        });
    }

    public void updateInstanceUpdateTime(String theInstanceId) {
        this.myJobInstanceRepository.updateInstanceUpdateTime(theInstanceId, new Date());
    }

    public WorkChunk createWorkChunk(WorkChunk theWorkChunk) {
        if (theWorkChunk.getId() == null) {
            theWorkChunk.setId(UUID.randomUUID().toString());
        }
        return this.toChunk((Batch2WorkChunkEntity)this.myWorkChunkRepository.save(Batch2WorkChunkEntity.fromWorkChunk(theWorkChunk)));
    }

    public Iterator<WorkChunk> fetchAllWorkChunksIterator(String theInstanceId, boolean theWithData) {
        return new PagingIterator((thePageIndex, theBatchSize, theConsumer) -> this.fetchChunks(theInstanceId, theWithData, theBatchSize, thePageIndex, theConsumer));
    }

    public Stream<WorkChunk> fetchAllWorkChunksForStepStream(String theInstanceId, String theStepId) {
        return this.myWorkChunkRepository.fetchChunksForStep(theInstanceId, theStepId).map(this::toChunk);
    }

    public Page<WorkChunkMetadata> fetchAllWorkChunkMetadataForJobInStates(Pageable thePageable, String theInstanceId, Set<WorkChunkStatusEnum> theStates) {
        Page<Batch2WorkChunkMetadataView> page = this.myWorkChunkMetadataViewRepo.fetchWorkChunkMetadataForJobInStates(thePageable, theInstanceId, theStates);
        return page.map(Batch2WorkChunkMetadataView::toChunkMetadata);
    }

    public boolean updateInstance(String theInstanceId, IJobPersistence.JobInstanceUpdateCallback theModifier) {
        Batch2JobInstanceEntity instanceEntity = (Batch2JobInstanceEntity)this.myEntityManager.find(Batch2JobInstanceEntity.class, (Object)theInstanceId, LockModeType.PESSIMISTIC_WRITE);
        if (null == instanceEntity) {
            ourLog.error("No instance found with Id {}", (Object)theInstanceId);
            return false;
        }
        JobInstance jobInstance = JobInstanceUtil.fromEntityToInstance(instanceEntity);
        boolean wasModified = theModifier.doUpdate(jobInstance);
        if (wasModified) {
            JobInstanceUtil.fromInstanceToEntity(jobInstance, instanceEntity);
        }
        return wasModified;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteInstanceAndChunks(String theInstanceId) {
        ourLog.info("Deleting instance and chunks: {}", (Object)theInstanceId);
        this.myWorkChunkRepository.deleteAllForInstance(theInstanceId);
        this.myJobInstanceRepository.deleteById(theInstanceId);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteChunksAndMarkInstanceAsChunksPurged(String theInstanceId) {
        ourLog.info("Deleting all chunks for instance ID: {}", (Object)theInstanceId);
        int updateCount = this.myJobInstanceRepository.updateWorkChunksPurgedTrue(theInstanceId);
        int deleteCount = this.myWorkChunkRepository.deleteAllForInstance(theInstanceId);
        ourLog.debug("Purged {} chunks, and updated {} instance.", (Object)deleteCount, (Object)updateCount);
    }

    public boolean markInstanceAsStatusWhenStatusIn(String theInstanceId, StatusEnum theStatusEnum, Set<StatusEnum> thePriorStates) {
        int recordsChanged = this.myJobInstanceRepository.updateInstanceStatusIfIn(theInstanceId, theStatusEnum, thePriorStates);
        ourLog.debug("Update job {} to status {} if in status {}: {}", new Object[]{theInstanceId, theStatusEnum, thePriorStates, recordsChanged > 0});
        return recordsChanged > 0;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public JobOperationResultJson cancelInstance(String theInstanceId) {
        int recordsChanged = this.myJobInstanceRepository.updateInstanceCancelled(theInstanceId, true);
        String operationString = "Cancel job instance " + theInstanceId;
        String messagePrefix = "Job instance <" + theInstanceId + ">";
        if (recordsChanged > 0) {
            return JobOperationResultJson.newSuccess((String)operationString, (String)(messagePrefix + " successfully cancelled."));
        }
        Optional<JobInstance> instance = this.fetchInstance(theInstanceId);
        if (instance.isPresent()) {
            return JobOperationResultJson.newFailure((String)operationString, (String)(messagePrefix + " was already cancelled.  Nothing to do."));
        }
        return JobOperationResultJson.newFailure((String)operationString, (String)(messagePrefix + " not found."));
    }

    private void invokePreStorageBatchHooks(JobInstance theJobInstance) {
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_BATCH_JOB_CREATE)) {
            HookParams params = new HookParams().add(JobInstance.class, (Object)theJobInstance).add(RequestDetails.class, (Object)new SystemRequestDetails());
            this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_BATCH_JOB_CREATE, params);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean advanceJobStepAndUpdateChunkStatus(String theJobInstanceId, String theNextStepId, boolean theIsReductionStep) {
        boolean changed = this.updateInstance(theJobInstanceId, instance -> {
            if (instance.getCurrentGatedStepId().equals(theNextStepId)) {
                return false;
            }
            ourLog.debug("Moving gated instance {} to the next step {}.", (Object)theJobInstanceId, (Object)theNextStepId);
            instance.setCurrentGatedStepId(theNextStepId);
            return true;
        });
        if (changed) {
            ourLog.debug("Updating chunk status from GATE_WAITING to READY for gated instance {} in step {}.", (Object)theJobInstanceId, (Object)theNextStepId);
            WorkChunkStatusEnum nextStep = theIsReductionStep ? WorkChunkStatusEnum.REDUCTION_READY : WorkChunkStatusEnum.READY;
            int numChanged = this.myWorkChunkRepository.updateAllChunksForStepWithStatus(theJobInstanceId, theNextStepId, List.of(WorkChunkStatusEnum.GATE_WAITING, WorkChunkStatusEnum.QUEUED), nextStep);
            ourLog.debug("Updated {} chunks of gated instance {} for step {} from fake QUEUED to READY.", new Object[]{numChanged, theJobInstanceId, theNextStepId});
        }
        return changed;
    }
}

