/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binstore;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.binary.api.StoredDetails;
import ca.uhn.fhir.jpa.binary.svc.BaseBinaryStorageSvcImpl;
import ca.uhn.fhir.jpa.dao.data.IBinaryStorageEntityDao;
import ca.uhn.fhir.jpa.model.entity.BinaryStorageEntity;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.hibernate.LobHelper;
import org.hibernate.Session;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DatabaseBinaryContentStorageSvcImpl
extends BaseBinaryStorageSvcImpl {
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private IBinaryStorageEntityDao myBinaryStorageEntityDao;
    private boolean mySupportLegacyLobServer = false;

    @Nonnull
    @Transactional(propagation=Propagation.REQUIRED)
    public StoredDetails storeBinaryContent(IIdType theResourceId, String theBinaryContentIdOrNull, String theContentType, InputStream theInputStream, RequestDetails theRequestDetails) throws IOException {
        Date publishedDate = new Date();
        HashingInputStream hashingInputStream = this.createHashingInputStream(theInputStream);
        CountingInputStream countingInputStream = this.createCountingInputStream((InputStream)hashingInputStream);
        BinaryStorageEntity entity = new BinaryStorageEntity();
        entity.setResourceId(theResourceId.toUnqualifiedVersionless().getValue());
        entity.setContentType(theContentType);
        entity.setPublished(publishedDate);
        Session session = (Session)this.myEntityManager.getDelegate();
        LobHelper lobHelper = session.getLobHelper();
        byte[] loadedStream = IOUtils.toByteArray((InputStream)countingInputStream);
        String id = super.provideIdForNewBinaryContent(theBinaryContentIdOrNull, loadedStream, theRequestDetails, theContentType);
        entity.setContentId(id);
        entity.setStorageContentBin(loadedStream);
        if (this.mySupportLegacyLobServer) {
            Blob dataBlob = lobHelper.createBlob(loadedStream);
            entity.setBlob(dataBlob);
        }
        long bytes = countingInputStream.getByteCount();
        String hash = hashingInputStream.hash().toString();
        entity.setSize(bytes);
        entity.setHash(hash);
        this.myEntityManager.persist((Object)entity);
        return new StoredDetails().setBinaryContentId(id).setBytes(bytes).setPublished(publishedDate).setHash(hash).setContentType(theContentType);
    }

    public StoredDetails fetchBinaryContentDetails(IIdType theResourceId, String theBinaryContentId) {
        Optional<BinaryStorageEntity> entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBinaryContentId, theResourceId.toUnqualifiedVersionless().getValue());
        if (entityOpt.isEmpty()) {
            return null;
        }
        BinaryStorageEntity entity = entityOpt.get();
        return new StoredDetails().setBinaryContentId(theBinaryContentId).setContentType(entity.getContentType()).setHash(entity.getHash()).setPublished(entity.getPublished()).setBytes(entity.getSize());
    }

    public boolean writeBinaryContent(IIdType theResourceId, String theBinaryContentId, OutputStream theOutputStream) throws IOException {
        Optional<BinaryStorageEntity> entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBinaryContentId, theResourceId.toUnqualifiedVersionless().getValue());
        if (entityOpt.isEmpty()) {
            return false;
        }
        this.copyBinaryContentToOutputStream(theOutputStream, entityOpt.get());
        return true;
    }

    public void expungeBinaryContent(IIdType theResourceId, String theBinaryContentId) {
        Optional<BinaryStorageEntity> entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBinaryContentId, theResourceId.toUnqualifiedVersionless().getValue());
        entityOpt.ifPresent(theBinaryStorageEntity -> this.myBinaryStorageEntityDao.deleteByPid(theBinaryStorageEntity.getContentId()));
    }

    public byte[] fetchBinaryContent(IIdType theResourceId, String theBinaryContentId) throws IOException {
        BinaryStorageEntity entityOpt = this.myBinaryStorageEntityDao.findByIdAndResourceId(theBinaryContentId, theResourceId.toUnqualifiedVersionless().getValue()).orElseThrow(() -> new ResourceNotFoundException("Unknown BinaryContent ID: " + theBinaryContentId + " for resource ID " + theResourceId));
        return this.copyBinaryContentToByteArray(entityOpt);
    }

    public DatabaseBinaryContentStorageSvcImpl setSupportLegacyLobServer(boolean theSupportLegacyLobServer) {
        this.mySupportLegacyLobServer = theSupportLegacyLobServer;
        return this;
    }

    void copyBinaryContentToOutputStream(OutputStream theOutputStream, BinaryStorageEntity theEntity) throws IOException {
        try (InputStream inputStream = this.getBinaryContent(theEntity);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)theOutputStream);
        }
        catch (SQLException e) {
            throw new IOException(Msg.code((int)1341) + e);
        }
    }

    byte[] copyBinaryContentToByteArray(BinaryStorageEntity theEntity) throws IOException {
        byte[] retVal;
        try (InputStream inputStream = this.getBinaryContent(theEntity);){
            retVal = ByteStreams.toByteArray((InputStream)inputStream);
        }
        catch (SQLException e) {
            throw new IOException(Msg.code((int)1342) + e);
        }
        return retVal;
    }

    private InputStream getBinaryContent(BinaryStorageEntity theEntity) throws SQLException {
        InputStream retVal = theEntity.hasStorageContent() ? new ByteArrayInputStream(theEntity.getStorageContentBin()) : (theEntity.hasBlob() ? theEntity.getBlob().getBinaryStream() : new ByteArrayInputStream(new byte[0]));
        return retVal;
    }

    @VisibleForTesting
    public DatabaseBinaryContentStorageSvcImpl setEntityManagerForTesting(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
        return this;
    }
}

