/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkExportProcessor;
import ca.uhn.fhir.jpa.bulk.export.model.ExportPIDIteratorParameters;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportHelperService;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.mdm.MdmExpansionCacheSvc;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.SearchBuilderLoadIncludesParameters;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import ca.uhn.fhir.mdm.dao.IMdmLinkDao;
import ca.uhn.fhir.mdm.model.MdmPidTuple;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkExportJobParameters;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.HasOrListParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.Logs;
import ca.uhn.fhir.util.SearchParameterUtil;
import jakarta.annotation.Nonnull;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JpaBulkExportProcessor
implements IBulkExportProcessor<JpaPid> {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaBulkExportProcessor.class);
    public static final int QUERY_CHUNK_SIZE = 100;
    public static final List<String> PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES = List.of("Practitioner", "Organization");
    @Autowired
    private FhirContext myContext;
    @Autowired
    private BulkExportHelperService myBulkExportHelperSvc;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    protected SearchBuilderFactory<JpaPid> mySearchBuilderFactory;
    @Autowired
    private IIdHelperService<JpaPid> myIdHelperService;
    @Autowired
    protected IMdmLinkDao<JpaPid, MdmLink> myMdmLinkDao;
    @Autowired
    private MdmExpansionCacheSvc myMdmExpansionCacheSvc;
    @Autowired
    private EntityManager myEntityManager;
    @Autowired
    private IHapiTransactionService myHapiTransactionService;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    private IFhirPath myFhirPath;

    public Iterator<JpaPid> getResourcePidIterator(ExportPIDIteratorParameters theParams) {
        return (Iterator)this.myHapiTransactionService.withSystemRequest().withRequestPartitionId(theParams.getPartitionIdOrAllPartitions()).readOnly().execute(() -> {
            String resourceType = theParams.getResourceType();
            String jobId = theParams.getInstanceId();
            String chunkId = theParams.getChunkId();
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resourceType);
            LinkedHashSet<JpaPid> pids = theParams.getExportStyle() == BulkExportJobParameters.ExportStyle.PATIENT ? this.getPidsForPatientStyleExport(theParams, resourceType, jobId, chunkId, def) : (theParams.getExportStyle() == BulkExportJobParameters.ExportStyle.GROUP ? this.getPidsForGroupStyleExport(theParams, resourceType, def) : this.getPidsForSystemStyleExport(theParams, jobId, chunkId, def));
            ourLog.debug("Finished expanding resource pids to export, size is {}", (Object)pids.size());
            return pids.iterator();
        });
    }

    private LinkedHashSet<JpaPid> getPidsForPatientStyleExport(ExportPIDIteratorParameters theParams, String resourceType, String theJobId, String theChunkId, RuntimeResourceDefinition def) throws IOException {
        LinkedHashSet<JpaPid> pids = new LinkedHashSet<JpaPid>();
        if (this.myStorageSettings.getIndexMissingFields() == StorageSettings.IndexEnabledEnum.DISABLED) {
            String errorMessage = "You attempted to start a Patient Bulk Export, but the system has `Index Missing Fields` disabled. It must be enabled for Patient Bulk Export";
            ourLog.error(errorMessage);
            throw new IllegalStateException(Msg.code((int)797) + errorMessage);
        }
        Set patientSearchParams = SearchParameterUtil.getPatientSearchParamsForResourceType((FhirContext)this.myContext, (String)theParams.getResourceType());
        for (String patientSearchParam : patientSearchParams) {
            List maps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(def, theParams, false);
            for (SearchParameterMap map : maps) {
                this.validateSearchParametersForPatient(map, theParams);
                ISearchBuilder<JpaPid> searchBuilder = this.getSearchBuilderForResourceType(theParams.getResourceType());
                JpaBulkExportProcessor.filterBySpecificPatient(theParams, resourceType, patientSearchParam, map);
                SearchRuntimeDetails searchRuntime = new SearchRuntimeDetails(null, theJobId);
                Logs.getBatchTroubleshootingLog().debug("Executing query for bulk export job[{}] chunk[{}]: {}", new Object[]{theJobId, theChunkId, map.toNormalizedQueryString(this.myContext)});
                IResultIterator resultIterator = searchBuilder.createQuery(map, searchRuntime, (RequestDetails)new SystemRequestDetails(), theParams.getPartitionIdOrAllPartitions());
                try {
                    int pidCount = 0;
                    while (resultIterator.hasNext()) {
                        if (pidCount % 10000 == 0) {
                            Logs.getBatchTroubleshootingLog().debug("Bulk export job[{}] chunk[{}] has loaded {} pids", new Object[]{theJobId, theChunkId, pidCount});
                        }
                        ++pidCount;
                        pids.add((JpaPid)resultIterator.next());
                    }
                }
                finally {
                    if (resultIterator == null) continue;
                    resultIterator.close();
                }
            }
        }
        return pids;
    }

    private static void filterBySpecificPatient(ExportPIDIteratorParameters theParams, String resourceType, String patientSearchParam, SearchParameterMap map) {
        if (resourceType.equalsIgnoreCase("Patient")) {
            if (theParams.getPatientIds() != null) {
                ReferenceOrListParam referenceOrListParam = JpaBulkExportProcessor.getReferenceOrListParam(theParams);
                map.add("_id", (IQueryParameterOr)referenceOrListParam);
            }
        } else if (theParams.getPatientIds() != null) {
            ReferenceOrListParam referenceOrListParam = JpaBulkExportProcessor.getReferenceOrListParam(theParams);
            map.add(patientSearchParam, (IQueryParameterOr)referenceOrListParam);
        } else {
            map.add(patientSearchParam, (IQueryParameterType)new ReferenceParam().setMissing(Boolean.valueOf(false)));
        }
    }

    @Nonnull
    private static ReferenceOrListParam getReferenceOrListParam(ExportPIDIteratorParameters theParams) {
        ReferenceOrListParam referenceOrListParam = new ReferenceOrListParam();
        for (String patientId : theParams.getPatientIds()) {
            referenceOrListParam.addOr(new ReferenceParam(patientId));
        }
        return referenceOrListParam;
    }

    private LinkedHashSet<JpaPid> getPidsForSystemStyleExport(ExportPIDIteratorParameters theParams, String theJobId, String theChunkId, RuntimeResourceDefinition theDef) throws IOException {
        LinkedHashSet<JpaPid> pids = new LinkedHashSet<JpaPid>();
        List maps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(theDef, theParams, true);
        ISearchBuilder<JpaPid> searchBuilder = this.getSearchBuilderForResourceType(theParams.getResourceType());
        for (SearchParameterMap map : maps) {
            Logs.getBatchTroubleshootingLog().debug("Executing query for bulk export job[{}] chunk[{}]: {}", new Object[]{theJobId, theChunkId, map.toNormalizedQueryString(this.myContext)});
            IResultIterator resultIterator = searchBuilder.createQuery(map, new SearchRuntimeDetails(null, theJobId), null, theParams.getPartitionIdOrAllPartitions());
            try {
                int pidCount = 0;
                while (resultIterator.hasNext()) {
                    if (pidCount % 10000 == 0) {
                        Logs.getBatchTroubleshootingLog().debug("Bulk export job[{}] chunk[{}] has loaded {} pids", new Object[]{theJobId, theChunkId, pidCount});
                    }
                    ++pidCount;
                    pids.add((JpaPid)resultIterator.next());
                }
            }
            finally {
                if (resultIterator == null) continue;
                resultIterator.close();
            }
        }
        return pids;
    }

    private LinkedHashSet<JpaPid> getPidsForGroupStyleExport(ExportPIDIteratorParameters theParams, String theResourceType, RuntimeResourceDefinition theDef) throws IOException {
        LinkedHashSet<JpaPid> pids;
        if (theResourceType.equalsIgnoreCase("Patient")) {
            ourLog.info("Expanding Patients of a Group Bulk Export.");
            pids = this.getExpandedPatientList(theParams);
            ourLog.info("Obtained {} PIDs", (Object)pids.size());
        } else {
            pids = theResourceType.equalsIgnoreCase("Group") ? this.getSingletonGroupList(theParams) : this.getRelatedResourceTypePids(theParams, theDef);
        }
        return pids;
    }

    private LinkedHashSet<JpaPid> getRelatedResourceTypePids(ExportPIDIteratorParameters theParams, RuntimeResourceDefinition theDef) throws IOException {
        LinkedHashSet<JpaPid> pids = new LinkedHashSet<JpaPid>();
        RuntimeSearchParam activeSearchParam = this.getActivePatientSearchParamForCurrentResourceType(theParams.getResourceType());
        if (activeSearchParam != null) {
            Set<JpaPid> expandedMemberResourceIds = this.expandAllPatientPidsFromGroup(theParams);
            assert (!expandedMemberResourceIds.isEmpty());
            Logs.getBatchTroubleshootingLog().debug("{} has been expanded to members:[{}]", (Object)theParams.getGroupId(), expandedMemberResourceIds);
            QueryChunker queryChunker = new QueryChunker();
            queryChunker.chunk(expandedMemberResourceIds, 100, idChunk -> {
                try {
                    this.queryResourceTypeWithReferencesToPatients((Set<JpaPid>)pids, (List<JpaPid>)idChunk, theParams, theDef);
                }
                catch (IOException ex) {
                    ourLog.error("Couldn't close query iterator ", (Throwable)ex);
                    throw new RuntimeException(Msg.code((int)2346) + "Couldn't close query iterator", ex);
                }
            });
        } else {
            ourLog.warn("No active patient compartment search parameter(s) for resource type " + theParams.getResourceType());
        }
        return pids;
    }

    private LinkedHashSet<JpaPid> getSingletonGroupList(ExportPIDIteratorParameters theParams) {
        RequestPartitionId partitionId = theParams.getPartitionIdOrAllPartitions();
        IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(theParams.getGroupId()), (RequestDetails)new SystemRequestDetails().setRequestPartitionId(partitionId));
        JpaPid pidOrNull = (JpaPid)this.myIdHelperService.getPidOrNull(partitionId, group);
        LinkedHashSet<JpaPid> pids = new LinkedHashSet<JpaPid>();
        pids.add(pidOrNull);
        return pids;
    }

    protected ISearchBuilder<JpaPid> getSearchBuilderForResourceType(String theResourceType) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceType);
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResourceType);
        Class typeClass = def.getImplementingClass();
        return this.mySearchBuilderFactory.newSearchBuilder((IDao)dao, theResourceType, typeClass);
    }

    protected RuntimeSearchParam getPatientSearchParamForCurrentResourceType(String theResourceType) {
        RuntimeSearchParam searchParam = null;
        Optional onlyPatientSearchParamForResourceType = SearchParameterUtil.getOnlyPatientSearchParamForResourceType((FhirContext)this.myContext, (String)theResourceType);
        if (onlyPatientSearchParamForResourceType.isPresent()) {
            searchParam = (RuntimeSearchParam)onlyPatientSearchParamForResourceType.get();
        }
        return searchParam;
    }

    public void expandMdmResources(List<IBaseResource> theResources) {
        for (IBaseResource resource : theResources) {
            if (PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(resource.fhirType())) continue;
            this.annotateBackwardsReferences(resource);
        }
    }

    private RuntimeSearchParam validateSearchParametersForPatient(SearchParameterMap expandedSpMap, ExportPIDIteratorParameters theParams) {
        RuntimeSearchParam runtimeSearchParam = this.getPatientSearchParamForCurrentResourceType(theParams.getResourceType());
        if (expandedSpMap.get(runtimeSearchParam.getName()) != null) {
            throw new IllegalArgumentException(Msg.code((int)796) + String.format("Patient Bulk Export manually modifies the Search Parameter called [%s], so you may not include this search parameter in your _typeFilter!", runtimeSearchParam.getName()));
        }
        return runtimeSearchParam;
    }

    private void validateSearchParametersForGroup(SearchParameterMap expandedSpMap, String theResourceType) {
        RuntimeSearchParam runtimeSearchParam;
        if (!PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(theResourceType) && expandedSpMap.get((runtimeSearchParam = this.getPatientSearchParamForCurrentResourceType(theResourceType)).getName()) != null) {
            throw new IllegalArgumentException(Msg.code((int)792) + String.format("Group Bulk Export manually modifies the Search Parameter called [%s], so you may not include this search parameter in your _typeFilter!", runtimeSearchParam.getName()));
        }
    }

    private LinkedHashSet<JpaPid> getExpandedPatientList(ExportPIDIteratorParameters theParameters) throws IOException {
        List<JpaPid> members = this.getMembersFromGroupWithFilter(theParameters, true);
        List ids = members.stream().map(member -> new IdDt("Patient/" + member)).collect(Collectors.toList());
        ourLog.info("While extracting patients from a group, we found {} patients.", (Object)ids.size());
        ourLog.info("Found patients: {}", (Object)ids.stream().map(id -> id.getValue()).collect(Collectors.joining(", ")));
        List<JpaPid> pidsOrThrowException = members;
        LinkedHashSet<JpaPid> patientPidsToExport = new LinkedHashSet<JpaPid>(pidsOrThrowException);
        if (theParameters.isExpandMdm()) {
            RequestPartitionId partitionId = theParameters.getPartitionIdOrAllPartitions();
            SystemRequestDetails srd = new SystemRequestDetails().setRequestPartitionId(partitionId);
            IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(theParameters.getGroupId()), (RequestDetails)srd);
            JpaPid pidOrNull = (JpaPid)this.myIdHelperService.getPidOrNull(partitionId, group);
            List goldenPidSourcePidTuple = this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult((IResourcePersistentId)pidOrNull, MdmMatchResultEnum.MATCH);
            goldenPidSourcePidTuple.forEach(tuple -> {
                patientPidsToExport.add((JpaPid)tuple.getGoldenPid());
                patientPidsToExport.add((JpaPid)tuple.getSourcePid());
            });
            this.populateMdmResourceCache(goldenPidSourcePidTuple);
        }
        return patientPidsToExport;
    }

    private List<JpaPid> getMembersFromGroupWithFilter(ExportPIDIteratorParameters theParameters, boolean theConsiderSince) throws IOException {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition("Patient");
        ArrayList<JpaPid> resPids = new ArrayList<JpaPid>();
        List maps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(def, theParameters, theConsiderSince);
        maps.forEach(map -> this.addMembershipToGroupClause((SearchParameterMap)map, theParameters.getGroupId()));
        for (SearchParameterMap map2 : maps) {
            ISearchBuilder<JpaPid> searchBuilder = this.getSearchBuilderForResourceType("Patient");
            ourLog.debug("Searching for members of group {} with job instance {} with map {}", new Object[]{theParameters.getGroupId(), theParameters.getInstanceId(), map2});
            IResultIterator resultIterator = searchBuilder.createQuery(map2, new SearchRuntimeDetails(null, theParameters.getInstanceId()), null, theParameters.getPartitionIdOrAllPartitions());
            try {
                while (resultIterator.hasNext()) {
                    resPids.add((JpaPid)resultIterator.next());
                }
            }
            finally {
                if (resultIterator == null) continue;
                resultIterator.close();
            }
        }
        return resPids;
    }

    private void addMembershipToGroupClause(SearchParameterMap theMap, String theGroupId) {
        HasOrListParam hasOrListParam = new HasOrListParam();
        hasOrListParam.addOr(new HasParam("Group", "member", "_id", theGroupId));
        theMap.add("_has", (IQueryParameterOr)hasOrListParam);
    }

    private void populateMdmResourceCache(List<MdmPidTuple<JpaPid>> thePidTuples) {
        if (this.myMdmExpansionCacheSvc.hasBeenPopulated()) {
            return;
        }
        HashMap<JpaPid, Set<JpaPid>> goldenResourceToSourcePidMap = new HashMap<JpaPid, Set<JpaPid>>();
        this.extract(thePidTuples, goldenResourceToSourcePidMap);
        HashMap<String, String> sourceResourceIdToGoldenResourceIdMap = new HashMap<String, String>();
        goldenResourceToSourcePidMap.forEach((key, value) -> {
            String goldenResourceId = this.myIdHelperService.translatePidIdToForcedIdWithCache((IResourcePersistentId)key).orElse(key.toString());
            PersistentIdToForcedIdMap pidsToForcedIds = this.myIdHelperService.translatePidsToForcedIds(value);
            Set sourceResourceIds = pidsToForcedIds.getResolvedResourceIds();
            sourceResourceIds.forEach(sourceResourceId -> sourceResourceIdToGoldenResourceIdMap.put((String)sourceResourceId, goldenResourceId));
        });
        this.myMdmExpansionCacheSvc.setCacheContents(sourceResourceIdToGoldenResourceIdMap);
    }

    private void extract(List<MdmPidTuple<JpaPid>> theGoldenPidTargetPidTuples, Map<JpaPid, Set<JpaPid>> theGoldenResourceToSourcePidMap) {
        for (MdmPidTuple<JpaPid> goldenPidTargetPidTuple : theGoldenPidTargetPidTuples) {
            JpaPid goldenPid = (JpaPid)goldenPidTargetPidTuple.getGoldenPid();
            JpaPid sourcePid = (JpaPid)goldenPidTargetPidTuple.getSourcePid();
            theGoldenResourceToSourcePidMap.computeIfAbsent(goldenPid, key -> new HashSet()).add(sourcePid);
        }
    }

    private void queryResourceTypeWithReferencesToPatients(Set<JpaPid> theReadPids, List<JpaPid> thePatientPids, ExportPIDIteratorParameters theParams, RuntimeResourceDefinition theDef) throws IOException {
        HashSet<JpaPid> pidSet = new HashSet<JpaPid>(thePatientPids);
        Set patientIds = this.myIdHelperService.translatePidsToFhirResourceIds(pidSet);
        List expandedSpMaps = this.myBulkExportHelperSvc.createSearchParameterMapsForResourceType(theDef, theParams, true);
        for (SearchParameterMap expandedSpMap : expandedSpMaps) {
            this.validateSearchParametersForGroup(expandedSpMap, theParams.getResourceType());
            ISearchBuilder<JpaPid> searchBuilder = this.getSearchBuilderForResourceType(theParams.getResourceType());
            if (PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(theParams.getResourceType())) {
                this.filterSearchByHasParam(patientIds, expandedSpMap, theParams);
            } else {
                this.filterSearchByResourceIds(patientIds, expandedSpMap, theParams);
            }
            RequestPartitionId partitionId = theParams.getPartitionIdOrAllPartitions();
            try (IResultIterator resultIterator = searchBuilder.createQuery(expandedSpMap, new SearchRuntimeDetails(null, theParams.getInstanceId()), null, partitionId);){
                while (resultIterator.hasNext()) {
                    theReadPids.add((JpaPid)resultIterator.next());
                }
            }
            HashSet<Include> includes = new HashSet<Include>();
            for (String resourceType : theParams.getRequestedResourceTypes()) {
                includes.add(new Include(resourceType + ":*", true));
            }
            SystemRequestDetails requestDetails = new SystemRequestDetails().setRequestPartitionId(partitionId);
            SearchBuilderLoadIncludesParameters loadIncludesParameters = new SearchBuilderLoadIncludesParameters();
            loadIncludesParameters.setFhirContext(this.myContext);
            loadIncludesParameters.setMatches(theReadPids);
            loadIncludesParameters.setEntityManager(this.myEntityManager);
            loadIncludesParameters.setRequestDetails((RequestDetails)requestDetails);
            loadIncludesParameters.setIncludeFilters(includes);
            loadIncludesParameters.setReverseMode(false);
            loadIncludesParameters.setLastUpdated(expandedSpMap.getLastUpdated());
            loadIncludesParameters.setSearchIdOrDescription(theParams.getInstanceId());
            loadIncludesParameters.setDesiredResourceTypes(theParams.getRequestedResourceTypes());
            Set includeIds = searchBuilder.loadIncludes(loadIncludesParameters);
            theReadPids.addAll(includeIds.stream().filter(id -> !id.getResourceType().equals("Patient")).collect(Collectors.toSet()));
        }
    }

    private RuntimeSearchParam getActivePatientSearchParamForCurrentResourceType(String theResourceType) {
        String activeSearchParamName = "";
        String resourceToCheck = theResourceType;
        if (!PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(theResourceType)) {
            activeSearchParamName = this.getPatientSearchParamForCurrentResourceType(theResourceType).getName();
        } else if ("Practitioner".equalsIgnoreCase(theResourceType)) {
            resourceToCheck = "Patient";
            activeSearchParamName = "general-practitioner";
        } else if ("Organization".equalsIgnoreCase(theResourceType)) {
            resourceToCheck = "Patient";
            activeSearchParamName = "organization";
        }
        return this.mySearchParamRegistry.getActiveSearchParam(resourceToCheck, activeSearchParamName);
    }

    private void filterSearchByResourceIds(Set<String> idChunk, SearchParameterMap expandedSpMap, ExportPIDIteratorParameters theParams) {
        ReferenceOrListParam orList = new ReferenceOrListParam();
        idChunk.forEach(id -> orList.add((IQueryParameterType)new ReferenceParam(id)));
        RuntimeSearchParam patientSearchParamForCurrentResourceType = this.getPatientSearchParamForCurrentResourceType(theParams.getResourceType());
        expandedSpMap.add(patientSearchParamForCurrentResourceType.getName(), (IQueryParameterOr)orList);
    }

    private void filterSearchByHasParam(Set<String> idChunk, SearchParameterMap expandedSpMap, ExportPIDIteratorParameters theParams) {
        HasOrListParam hasOrListParam = new HasOrListParam();
        idChunk.stream().forEach(id -> hasOrListParam.addOr(this.buildHasParam((String)id, theParams.getResourceType())));
        expandedSpMap.add("_has", (IQueryParameterOr)hasOrListParam);
    }

    private HasParam buildHasParam(String theResourceId, String theResourceType) {
        if ("Practitioner".equalsIgnoreCase(theResourceType)) {
            return new HasParam("Patient", "general-practitioner", "_id", theResourceId);
        }
        if ("Organization".equalsIgnoreCase(theResourceType)) {
            return new HasParam("Patient", "organization", "_id", theResourceId);
        }
        throw new IllegalArgumentException(Msg.code((int)2077) + " We can't handle forward references onto type " + theResourceType);
    }

    private Set<JpaPid> expandAllPatientPidsFromGroup(ExportPIDIteratorParameters theParams) throws IOException {
        HashSet<JpaPid> expandedIds = new HashSet<JpaPid>();
        RequestPartitionId partitionId = theParams.getPartitionIdOrAllPartitions();
        SystemRequestDetails requestDetails = new SystemRequestDetails().setRequestPartitionId(partitionId);
        IBaseResource group = this.myDaoRegistry.getResourceDao("Group").read((IIdType)new IdDt(theParams.getGroupId()), (RequestDetails)requestDetails);
        JpaPid pidOrNull = (JpaPid)this.myIdHelperService.getPidOrNull(partitionId, group);
        if (theParams.isExpandMdm()) {
            expandedIds.addAll(this.performMembershipExpansionViaMdmTable(pidOrNull));
        }
        List<JpaPid> membersFromGroupWithFilter = this.getMembersFromGroupWithFilter(theParams, false);
        ourLog.debug("Group with ID [{}] has been expanded to: {}", (Object)theParams.getGroupId(), membersFromGroupWithFilter);
        expandedIds.addAll(membersFromGroupWithFilter);
        return expandedIds;
    }

    private Set<JpaPid> performMembershipExpansionViaMdmTable(JpaPid pidOrNull) {
        List goldenPidTargetPidTuples = this.myMdmLinkDao.expandPidsFromGroupPidGivenMatchResult((IResourcePersistentId)pidOrNull, MdmMatchResultEnum.MATCH);
        HashSet<JpaPid> uniquePids = new HashSet<JpaPid>();
        goldenPidTargetPidTuples.forEach(tuple -> {
            uniquePids.add((JpaPid)tuple.getGoldenPid());
            uniquePids.add((JpaPid)tuple.getSourcePid());
        });
        PersistentIdToForcedIdMap pidToForcedIdMap = this.myIdHelperService.translatePidsToForcedIds(uniquePids);
        HashMap<JpaPid, Set<JpaPid>> goldenResourceToSourcePidMap = new HashMap<JpaPid, Set<JpaPid>>();
        this.extract(goldenPidTargetPidTuples, goldenResourceToSourcePidMap);
        this.populateMdmResourceCache(goldenPidTargetPidTuples);
        return uniquePids;
    }

    private RuntimeSearchParam getRuntimeSearchParam(IBaseResource theResource) {
        Optional oPatientSearchParam = SearchParameterUtil.getOnlyPatientSearchParamForResourceType((FhirContext)this.myContext, (String)theResource.fhirType());
        if (!oPatientSearchParam.isPresent()) {
            String errorMessage = String.format("[%s] has  no search parameters that are for patients, so it is invalid for Group Bulk Export!", theResource.fhirType());
            throw new IllegalArgumentException(Msg.code((int)2242) + errorMessage);
        }
        return (RuntimeSearchParam)oPatientSearchParam.get();
    }

    private void annotateBackwardsReferences(IBaseResource iBaseResource) {
        Optional<String> patientReference = this.getPatientReference(iBaseResource);
        if (patientReference.isPresent()) {
            this.addGoldenResourceExtension(iBaseResource, patientReference.get());
        } else {
            ourLog.error("Failed to find the patient reference information for resource {}. This is a bug, as all resources which can be exported via Group Bulk Export must reference a patient.", (Object)iBaseResource);
        }
    }

    private Optional<String> getPatientReference(IBaseResource iBaseResource) {
        RuntimeSearchParam runtimeSearchParam = this.getRuntimeSearchParam(iBaseResource);
        String fhirPath = this.getPatientFhirPath(runtimeSearchParam);
        if (iBaseResource.fhirType().equalsIgnoreCase("Patient")) {
            return Optional.of(iBaseResource.getIdElement().getIdPart());
        }
        Optional optionalReference = this.getFhirParser().evaluateFirst((IBase)iBaseResource, fhirPath, IBaseReference.class);
        if (optionalReference.isPresent()) {
            return optionalReference.map(theIBaseReference -> theIBaseReference.getReferenceElement().getIdPart());
        }
        return Optional.empty();
    }

    private void addGoldenResourceExtension(IBaseResource iBaseResource, String sourceResourceId) {
        String goldenResourceId = this.myMdmExpansionCacheSvc.getGoldenResourceId(sourceResourceId);
        IBaseExtension extension = ExtensionUtil.getOrCreateExtension((IBase)iBaseResource, (String)"https://hapifhir.org/associated-patient-golden-resource/");
        if (!StringUtils.isBlank((CharSequence)goldenResourceId)) {
            ExtensionUtil.setExtension((FhirContext)this.myContext, (IBaseExtension)extension, (String)"reference", (Object)this.prefixPatient(goldenResourceId));
        }
    }

    private String prefixPatient(String theResourceId) {
        return "Patient/" + theResourceId;
    }

    private IFhirPath getFhirParser() {
        if (this.myFhirPath == null) {
            this.myFhirPath = this.myContext.newFhirPath();
        }
        return this.myFhirPath;
    }

    private String getPatientFhirPath(RuntimeSearchParam theRuntimeParam) {
        String path = theRuntimeParam.getPath();
        if (path.contains(".where")) {
            path = path.substring(0, path.indexOf(".where"));
        }
        return path;
    }
}

